/**
 * 切换聊天
 */
import React, { Component } from 'react';
import { Row, Col, Popover, Tooltip } from "antd";
import IM from '../IM';
import { connect } from "dva";
import { color } from 'echarts';
import '../../Command/command.less';
import eventCenter from "@common/events"; // 引入 EventEmitter'

@connect((state) => ({
  mapStyle: state.command.mapStyle
}))
export default class SwitchChat extends Component {
  constructor(props) {
    super(props);
    this.state = {
      //im数据
      clicked: false,
      imStatus: false,
      conversationID: props.conversationID
    };
  }

  componentDidMount() {
    const that = this;
    eventCenter.addListener('changeImStatus', (result)=>{
      if (result = "change") {
        that.setState({
          imStatus: !that.state.imStatus
        })
      } else {
        that.setState({
          imStatus: result
        })
      }
    });
  }
  componentWillReceiveProps(nextProps) {
    console.log('SwitchChat-render', JSON.stringify(nextProps));
    if (this.state.imStatus != nextProps.imStatus || this.state.conversationID != nextProps.conversationID) {
      this.setState({
        imStatus: nextProps.imStatus || false,
        conversationID: nextProps.conversationID
      });
    }
  }
  handleVisibleChange = imStatus => {
    this.setState({ imStatus });
    this.props.onClick()
  };
  changeSwitchStatus=()=>{
    this.setState({
      imStatus: !this.state.imStatus
    })
  }
  _onClose=()=>{
    const { imStatus, conversationID } = this.state;
    this.setState({ imStatus: !imStatus });
  }
  render() {
    console.log('SwitchChat-render');
    const { mapStyle } = this.props
    const { imStatus, conversationID } = this.state;
    const content = (
      <div>
        {/* im可视化页面 */}
        <IM
          visible={imStatus}
          closeClick={() => {
            // this.setState({ imStatus: !imStatus });
          }}
          conversationID={conversationID}
        ></IM>
      </div>
    );
    return (
      <div className="switch chat">
        <Tooltip title="消息框">
          <div className="layer-btn" onClick={this.changeSwitchStatus}>
            <Popover
                placement="bottom"
                content={content}
                title=""
                trigger="click"
                visible={imStatus}
                onVisibleChange={this.handleVisibleChange}
                overlayClassName={mapStyle+'-im-popover'}
              >
              <img
                className="layer-img"
                src={
                  imStatus
                    ? require("../../../assets/images/prevention/chat-click.png") :
                    mapStyle == 'dark' ? require("../../../assets/images/prevention/chat-white.png")
                      : require("../../../assets/images/prevention/chat.png")
                }
              ></img>
            </Popover>
          </div>
        </Tooltip>
        {/* 由于要先初始化im，才能在打开的时候就已经有会话列表数据了，所以先引用不展示，后续优化 */}
        <div
          style={{ display: 'none' }}>
          <IM
            visible={imStatus}
            closeClick={this._onClose}
            conversationID={conversationID}
          ></IM>
        </div>
      </div>
    );
  }
}
