/**
 * 录制记录弹窗
 */
import React, { PureComponent } from "react";
import { connect } from "dva";
import styles from "./recordList.less";
import { getVideoRoomDetail } from "../../../services/api";
import { Drawer, Tooltip, Modal, Row, Input, Button } from "antd";
import $nModal from "../../../utils/modal/nModal";
const { confirm } = Modal;
@connect((state) => ({}))
export default class RecordDrawer extends PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      visibleDrawer: props.visibleDrawer,
      comVideoRoomId: props.comVideoRoomId,
      detailMessage: "", //具体的详细信息
    };
  }
  componentDidMount() {
    // this.getDetail(this.props.comVideoRoomId);
  }
  componentWillReceiveProps(nextProps) {
    if (nextProps.visibleDrawer !== this.state.visibleDrawer) {
      this.setState({
        visibleDrawer: nextProps.visibleDrawer,
      });
    }
    if (
      nextProps.comVideoRoomId !== this.state.comVideoRoomId &&
      nextProps.visibleDrawer
    ) {
      this.getDetail(nextProps.comVideoRoomId);
    }
  }
  //获取调度记录详细信息
  getDetail(comVideoRoomId) {
    const refuse = []; //拒绝
    const accept = []; //接受
    // const recording = []; //录制
    const notResponding = []; //未响应
    const recordList = []; //录制文件
    getVideoRoomDetail({ comVideoRoomId }).then((res) => {
      //参会状态：0拒绝，1接受，2录制，9未响应
      res.data.plist.map((item) => {
        //用户状态是需要录制的
        // if (item.attendExpoStatus == "2") {
        //   recordList.push({
        //     videoPath: item.videoPath,
        //     name: item.name,
        //   });
        // }
        switch (true) {
          case item.attendExpoStatus == "0":
            refuse.push(item);
            break;
          case item.attendExpoStatus == "1":
            accept.push(item);
            break;
          case item.attendExpoStatus == "2":
            accept.push(item);
            recordList.push({
              videoPath: item.videoPath,
              name: item.name,
            });
            break;
          case item.attendExpoStatus == "9" || item.attendExpoStatus == "":
            notResponding.push(item);
            break;
        }
      });
      this.setState({
        detailMessage: {
          ...res.data,
          refuse,
          accept,
          // recording,
          notResponding,
          recordList,
        },
      });
    });
  }
  itemRender(data) {
    return data.length > 0 ? (
      <div className={styles.photo}>
        {data.map((item, index) => {
          return (
            <div className={styles.gutterRow} key={index}>
              <div className={styles.gutterBox}>
                {item.photoUrl ? (
                  <img className={styles.avator} src={item.photoUrl}></img>
                ) : (
                    // <span className={[styles.avator, styles.spanHeader]}>
                    <span className={styles.spanHeader}>
                      {item.name
                        ? item.name.substring(
                          item.name.length - 2,
                          item.name.length
                        )
                        : ""}
                    </span>
                  )}
                <div className={styles.name}>{item.name}</div>
              </div>
            </div>
          );
        })}
      </div>
    ) : (
        ""
      );
  }
  render() {
    const message = this.state.detailMessage;
    return (
      <Drawer
        title={"调度任务名称："+message.yardmanTaskName}
        placement="right"
        closable={false}
        onClose={() => {
          this.props.changeDrawer(false);
          this.setState({ comVideoRoomId: "" });
        }}
        width={350}
        visible={this.state.visibleDrawer}
        className={styles.task}
      >
        {message && (
          <div className={styles.content}>
            <div>
              <p>
                <span className={styles.title}>创建者：</span>
                {message.plist[0].name}
              </p>
              {/* <p>
                <span className={styles.title}>任务内容：</span>
                {message.yardmanTaskName}
              </p> */}
              <p>
                <span className={styles.title}>任务时间：</span>
                {message.startTime + "~" + message.endTime}
              </p>
              <p>
                <span className={styles.title}>参与人数：</span>
                {message.plist.length}人
              </p>
            </div>
            <div className={styles.gray}>
              <p style={{ padding: "10px 0" }}>参与人员状态</p>
            </div>
            <div>
              <p>
                <span className={styles.title}>已接受：</span>
                {message.accept.length}人{this.itemRender(message.accept)}
              </p>
              <p>
                <span className={styles.title}>已拒绝：</span>
                {message.refuse.length}人 {this.itemRender(message.refuse)}
              </p>
              <p>
                <span className={styles.title}>未响应：</span>
                {message.notResponding.length}人
                {this.itemRender(message.notResponding)}
              </p>
            </div>
            <div>
              <div className={styles.gray}>
                <p style={{ padding: "10px 0" }}>录制文件列表：</p>
              </div>
              <div style={{ margin: "5px 0" }}>
                {message.recordList.length > 0 ? (
                  message.recordList.map((item, index) => {
                    console.log(item)
                    // if (!!item.videoPath) {
                    return (
                      <p key={index}>
                        <span>
                          文件{index + 1}（{item.name}）
                          </span>
                        <span style={{ float: "right",marginRight:'10px' }}>
                          {
                            !!item.videoPath ?
                              <a
                                style={{ marginRight: "5px" }}
                                href={item.videoPath}
                              >
                                下载
                            </a> : <span>暂无录制文件</span>}
                          {/* <a
                              style={{ marginRight: "5px" }}
                              // href={item.videoPath}
                              onClick={() => {
                                $nModal({
                                  width: 800,
                                  title: `文件${index + 1}（${item.name}）预览`,
                                  content: (
                                    <video
                                      style={{ width: "100%" }}
                                      className="video-js"
                                      controls
                                      name="media"
                                    >
                                      <source src={item.videoPath} />
                                      您的浏览器不支持 video 标签。
                                    </video>
                                  ),
                                  footer: null,
                                  // okText: "关闭",
                                  // cancelText: "取消",
                                  onOk: (close) => {
                                    close();
                                  },
                                });
                              }}
                            >
                              预览
                            </a> */}
                          {/* <a
                            href="#"
                            onClick={() => {
                              confirm({
                                title: "确定删除该录屏文件?",
                                okText: "确定",
                                cancelText: "取消",
                                onOk() {
                                  console.log("OK");
                                },
                                onCancel() {
                                  console.log("Cancel");
                                },
                              });
                            }}
                          >
                            删除
                          </a> */}
                        </span>
                      </p>
                    );
                  })
                ) : (
                    <p style={{ color: "#c5c4c4" }}>暂无录制文件</p>
                  )}
              </div>
            </div>
          </div>
        )}
      </Drawer>
    );
  }
}
