/**
 * 保安服务公司列表子Card
 * UI 组件
 */
import React, { Component } from "react";
import styles from "./index.less";
import classNames from 'classnames';
import { connect } from "dva";

@connect((state) => ({
  //地图数据
  mapStyle: state.command.mapStyle,
  selectComponyList: state.command.selectComponyList,
}))
export default class ComponyItem extends Component {
  constructor(props) {
    super(props);
    this.state = {
      companyList: []
    };
  }
  componentDidMount() {
  }
  onChangeCompony=(item)=>{
    this.props.onChangeCompony && this.props.onChangeCompony(item)
  }
  render() {
    const {  item } = this.props
    const clsString = classNames(styles.list_item, 'list_item');
    return (
      <div className={clsString} onClick={this.onChangeCompony.bind(this, item)}>
        {item.componeyLogo ? (
          <img
            className="img"
            src={item.componeyLogo ? item.componeyLogo : ""}
          ></img>
        ) : (
          <div className="img-span">
            {/* 取后面两位显示 */}
            <span>
              {item.companyName
                ? item.companyName.substring(
                  item.companyName.length - 2,
                  item.companyName.length
                )
                : ""}
            </span>
          </div>
        )}
        <div className={styles.item}>
          <div className={styles.item_company_name}>{item.companyName}</div>
          <div>法人姓名：{item.name}</div>
          <div>联系电话：{item.mobilePhone}</div>
        </div>
      </div>
    );
  }
}
