/**
 * 驻勤点列表子Card
 * UI 组件
 */
import React, { Component } from "react";
import styles from "./index.less";
import classNames from 'classnames';
import { connect } from "dva";

@connect((state) => ({
  //地图数据
  mapStyle: state.command.mapStyle,
  selectComponyList: state.command.selectComponyList,
}))
export default class AttendanceItem extends Component {
  constructor(props) {
    super(props);
    this.state = {
      companyList: []
    };
  }
  componentDidMount() {
  }
  render() {
    const {  item, onChangeAttendance } = this.props
    const clsString = classNames(styles.attendance_item);
    return (
      <div className={clsString} onClick={onChangeAttendance.bind(this, item)}>
        <div className={styles.title}>{item.companyName}</div>
        <div className={styles.name}>
          驻勤点名称:
          <div className={styles.sub_name}>{item.taskName}</div>
        </div>
        <div className={styles.name}>
          驻勤点地址:
          <div className={styles.sub_name}>{item.address+item.taskAddress}</div>
        </div>
      </div>
    );
  }
}
