//按照类型

import React, { Component } from "react";
import { connect } from "dva";
import { Pagination, List, Icon, Input, Button, Tooltip } from "antd";
import { data } from "@constants/TypeData";
import AttendanceItem from "./AttendanceItem";
import {
  getComTaskStationType,
  getComTaskList,
} from "../../../../../services/api";
@connect((state) => ({
  selectedId: state.command.attendanceList.selectedId,
  attendanceList: state.command.attendanceList.list,
  tabIndex2: state.command.tabIndex.attendance.tabIndex2,
  attendanceTypeList: state.command.attendanceList.typeList,
}))
export default class TypeAttendance extends Component {
  constructor(props) {
    super(props);
    this.state = {
      tabKey: "2",
      currentKey: null, //主要用于处理tab页面改变，不让重新请求数据
      comTypeList: [],
      height: null,
      data: data,
      pageSearch: {
        pageNumber: 1,
        pageSize: 100,
      },
      currentAttendanceTypeList: [],
      loadingText: "暂无数据", //类型下的搜索驻勤点的加载状态
      typeLoadingText: "暂无数据", //类型的加载状态
    };
  }
  componentDidMount() {
    const height = document.documentElement.clientHeight - 120 - 130;
    this.setState({ height });
    //获取该公司拥有的驻勤点类型
    this.getCurrentType();
  }
  componentWillReceiveProps(nextProps) {
    if (
      nextProps.tabIndex2 == this.state.tabKey &&
      this.props.attendanceTypeList.length > 0 &&
      nextProps.tabIndex2 !== this.state.currentKey
    ) {
      this.props.dispatch({
        type: "command/fetchAllAttendanceList",
        payload: {
          attendanceList: [...this.props.attendanceTypeList],
        },
      });
      this.setState({
        currentKey: nextProps.tabIndex2,
      });
    }
    if (nextProps.tabIndex2 != this.state.tabKey) {
      this.setState({
        currentKey: null,
      });
    }
  }
  //获取驻勤点类型
  getCurrentType() {
    this.setState({
      typeLoadingText: "正在加载中...",
    });
    getComTaskStationType({}).then((res) => {
      this.setState({
        comTypeList: res.data,
        typeLoadingText: res.data.length > 0 ? "加载完成" : "暂无数据",
      });
      if (res.retType === "0" && res.data.length > 0) {
        const data = this.state.data;
        const comTypeList = res.data;
        for (let i = 0; i < comTypeList.length; i++) {
          comTypeList[i].whetherClick = false;
          for (let j = 0; j < data.length; j++) {
            if (comTypeList[i].taskStationType == data[j].key) {
              //   data[j].whetherHas = true;
              //   data[j].whetherClick = true;
              comTypeList[i].name = data[j].title;
              comTypeList[i].markerIcon = data[j].markerIcon;
              comTypeList[i].clickMarkerIcon = data[j].clickMarkerIcon;
            }
          }
          //如果没有就用默认的值
          if (!comTypeList[i].markerIcon) {
            comTypeList[i].markerIcon = data[data.length - 1].markerIcon;
            comTypeList[i].clickMarkerIcon =
              data[data.length - 1].clickMarkerIcon;
          }
        }
        this.setState({
          comTypeList,
        });
      }
    });
  }
  //获取驻勤点
  getAttendanceList(taskStationType, pageSearch, index) {
    this.setState({
      loadingText: "正在加载中...",
    });
    getComTaskList({
      ...pageSearch,
      taskStationType,
    }).then((res) => {
      if (res.retType === "0" && res.data.data.length > 0) {
        const list = res.data.data;
        const comTypeList = this.state.comTypeList;
        const data = comTypeList[index].attendanceList || [];
        data.push(...list);
        data.forEach((element, i) => {
          data[i].markerIcon = comTypeList[index].markerIcon;
          data[i].clickMarkerIcon = comTypeList[index].clickMarkerIcon;
        });
        comTypeList[index].attendanceList = data;
        this.setState({
          comTypeList,
        });
        if (res.data.total > pageSearch.pageNumber * pageSearch.pageSize) {
          this.getAttendanceList(
            taskStationType,
            {
              pageNumber: pageSearch.pageNumber + 1,
              pageSize: pageSearch.pageSize,
            },
            index
          );
        } else {
          let allAttentanceList = [];
          comTypeList.map((item) => {
            if (item.attendanceList && item.attendanceList.length > 0) {
              allAttentanceList.push(...item.attendanceList);
            }
          });
          this.props.dispatch({
            type: "command/fetchAllAttendanceList",
            payload: {
              // attendanceList: [
              //   ...comTypeList[index].attendanceList,
              //   ...this.props.attendanceTypeList,
              // ],
              attendanceList: comTypeList[index].attendanceList,
            },
          });
          this.props.dispatch({
            type: "command/fetchAllAttendanceTypeList",
            payload:
              //  [
              //   ...comTypeList[index].attendanceList,
              //   ...this.props.attendanceTypeList,
              // ],
              comTypeList[index].attendanceList,
          });
          this.setState({
            loadingText: "加载完成",
          });
        }
      }
    });
  }
  render() {
    return (
      <div className="data-list type-attendance search-list_command">
        <div
          className="list"
          style={{ maxHeight: this.state.height, overflow: "auto" }}
        >
          {this.state.comTypeList.length > 0 ? (
            this.state.comTypeList.map((item, index) => {
              return (
                <div key={index}>
                  <div
                    className="list-item"
                    onClick={() => {
                      let comTypeList = this.state.comTypeList;
                      if (comTypeList[index].whetherClick) {
                        // //如果本来是打开的时候，要关闭
                        comTypeList[index].whetherClick = false;
                        this.props.dispatch({
                          type: "command/fetchAllAttendanceList",
                          payload: {
                            attendanceList: [],
                          },
                        });
                        this.props.dispatch({
                          type: "command/fetchAllAttendanceTypeList",
                          payload: [],
                        });
                      } else {
                        //先把之前的数据清空
                        this.props.dispatch({
                          type: "command/fetchAllAttendanceList",
                          payload: {
                            attendanceList: [],
                          },
                        });
                        this.props.dispatch({
                          type: "command/fetchAllAttendanceTypeList",
                          payload: [],
                        });
                        //本来关闭，要把它打开，先关闭其他人的
                        comTypeList = JSON.parse(
                          JSON.stringify(comTypeList).replace(
                            /whetherClick":true/g,
                            'whetherClick":false'
                          )
                        );
                        comTypeList[index].whetherClick = true;
                        if (item.attendanceList == undefined) {
                          //如果本来没有值，就要请求
                          this.getAttendanceList(
                            item.taskStationType,
                            this.state.pageSearch,
                            index
                          );
                        } else {
                          //否则已经请求过的，就直接从列表中拉出来就可以
                          this.props.dispatch({
                            type: "command/fetchAllAttendanceList",
                            payload: {
                              attendanceList: item.attendanceList,
                            },
                          });
                          this.props.dispatch({
                            type: "command/fetchAllAttendanceTypeList",
                            payload: item.attendanceList,
                          });
                        }
                      }
                      if (this.props.selectedId) {
                        //如果有选中的点，就要关闭
                        this.props.dispatch({
                          type: "command/setSelectIndex",
                          payload: null,
                        });
                        this.props.dispatch({
                          type: "command/clearInfoWindow",
                          payload: true,
                        });
                      }
                      this.setState({
                        comTypeList,
                      });
                    }}
                  >
                    <span>
                      {item.name
                        ? item.name + "(" + item.sl + ")"
                        : "其他(" + item.sl + ")"}
                    </span>
                    <span className="up-down-icon">
                      {item.whetherClick ? (
                        <Icon type="down" style={{ fontSize: "10px" }} />
                      ) : (
                        <Icon type="up" style={{ fontSize: "10px" }} />
                      )}
                    </span>
                  </div>
                  <div className="list-item-child">
                    {item.whetherClick && (
                      // item.attendanceList &&
                      // item.attendanceList.length > 0 &&
                      <AttendanceItem
                        data={item.attendanceList}
                        loadingText={this.state.loadingText}
                      />
                    )}
                  </div>
                </div>
              );
            })
          ) : (
            <div
              style={{
                textAlign: "center",
                fontSize: "14px",
                color: "#afb0b1",
              }}
            >
              {this.state.typeLoadingText}
            </div>
          )}
        </div>
      </div>
    );
  }
}
