/**
 * 保安人员的搜索列表
 */
import React, { Component } from "react";
import "./attendance.less";
import { getPersonList } from "../../../../../services/api";
import PersonItem from "../PersonMessage/PersonItem";
import { message, Button, Icon } from "antd";
import { connect } from "dva";

@connect((state) => ({
  selectedAttenData: state.command.attendanceList.selectedAttenData,
  selectedId: state.command.personList.selectedId,
}))
export default class PersonSearchList extends Component {
  constructor(props) {
    super(props);
    this.state = {
      pageSize: 20,
      comTaskId: props.selectedAttenData.comTaskId,
      total: 0, //搜索总条数
      // selectedAttenData: props.selectedAttenData || null, //传过来选中的驻勤点的信息
      attenPersonList: [], //保安员列表
      height: null, //人员列表的最大高度
    };
  }

  componentDidMount() {
    this.getPersonList(this.props.selectedAttenData.taskName);
    const height = document.documentElement.clientHeight - 120 - 130 - 160 - 63;
    this.setState({ height });
  }
  componentWillReceiveProps(nextProps) {
    if (
      this.props.selectedAttenData.comTaskId !==
      nextProps.selectedAttenData.comTaskId
    ) {
      this.getPersonList(nextProps.selectedAttenData.taskName);
    }
  }
  //获取驻勤点对应的保安员列表
  getPersonList(taskName, pageNumber = 1, pageSize = this.state.pageSize) {
    getPersonList({
      _currpage:pageNumber,
      lines:pageSize
    },{
      search_attendanceSiteName:taskName,//驻勤点名称
    }).then(res=>{
        if (res.data.data.length > 0) {
          let result = res.data.data.map((item) => {
            item.perId = item.id
            delete item.id
            item.name = item.securityName
            delete item.securityName
            let lnglatData =item.item_lonlatjson? JSON.parse(item.item_lonlatjson):''
            item.lnglat =lnglatData? [lnglatData.longitude,lnglatData.latitude]:''
            delete item.item_lonlatjson
            item.idCardNo = item.documentID
            delete item.documentID
            item.mobilePhone = item.phone
            delete item.phone
            return item
          })
          this.setState({
            attenPersonList: result,
            total: res.data.total,
          });
          this.props.dispatch({
            type: "command/fetchPersonList",
            payload: {
              list: result,
            },
          });
        } else {
          message.warning("该驻勤点没有人员");
        }
    });
  }
  clearAttendInfo=()=>{
    this.props.dispatch({
      type: "command/setSelectedAttenData",
      payload: null,
    });
    this.props.dispatch({
      type: "command/fetchPersonList",
      payload: {
        list: [],
      },
    });
    this.props.dispatch({
      type: "command/clearInfoWindow",
      payload: true,
    });
  }
  render() {
    return (
      <div className="attendance-person search-list_command amap_lib_placeSearch">
        <div className="security-personnel">
          <span>
            {this.props.selectedAttenData &&
              this.props.selectedAttenData.taskName}
          </span>
          <Icon onClick={this.clearAttendInfo} className="close" type="left" />
          {/* <span
            className="close"
            onClick={() => {
              this.props.dispatch({
                type: "command/setSelectedAttenData",
                payload: null,
              });
              this.props.dispatch({
                type: "command/fetchPersonList",
                payload: {
                  list: [],
                },
              });
              this.props.dispatch({
                type: 'command/clearInfoWindow',
                payload: true
              })
            }}
          >
            x
          </span> */}
        </div>
        <div className="list">
          <div className="item attendance-detail">
            <div>负责人:{this.props.selectedAttenData.name}</div>
            <div>身份证号:{this.props.selectedAttenData.idCardNo}</div>
            <div>手机号码:{this.props.selectedAttenData.mobilePhone}</div>
            <div>地址:{this.props.selectedAttenData.taskAddress}</div>
            <div>保安员数量:{this.props.selectedAttenData.perNum}名</div>
            <div>
              服务企业类型:
              {this.props.selectedAttenData.serviceObjectTypeName || "-"}
            </div>
          </div>
          <div className="search-list_command">
            <div className="list" style={{ maxHeight: this.state.height }}>
              <PersonItem
                data={this.state.attenPersonList}
              />
            </div>
          </div>
        </div>
        <div
          className="see-more"
          style={{
            display:
              this.state.total > this.state.attenPersonList.length
                ? "block"
                : "none",
          }}
        >
          <span
            onClick={() => {
              this.getPersonList(this.state.comTaskId, 1, this.state.total);
            }}
          >
            查看更多
          </span>
        </div>
      </div>
    );
  }
}
