//按照类型

import React, { Component } from "react";
import { connect } from "dva";
@connect((state) => ({
  selectedId: state.command.attendanceList.selectedId,
}))
export default class AttendanceItem extends Component {
  constructor(props) {
    super(props);
    this.state = {
      data: props.data || [],
      loadingText: props.loadingText,
    };
  }
  componentDidMount() {}
  componentWillReceiveProps(nextProps) {
    this.setState({
      loadingText: nextProps.loadingText,
    });
    if (nextProps.data !== this.state.data) {
      this.setState({
        data: nextProps.data || [],
      });
    }
  }
  render() {
    return (
      <div>
        {this.state.data.length > 0 ? (
          this.state.data.map((item, index) => {
            return (
              <div
                key={index}
                className="item"
                onClick={() => {
                  this.props.dispatch({
                    type: "command/setSelectIndex",
                    // payload: item.comTaskId,
                    payload: index,
                  });
                }}
              >
                <div className="poibox">
                  {/* {this.props.selectedId === item.comTaskId ? ( */}
                  {this.props.selectedId === index ? (
                    <div
                      className="amap_lib_placeSearch_poi mark-icon"
                      style={{
                        background: "url(" + item.clickMarkerIcon + ")",
                        float: "left",
                        marginRight: "10px",
                        left: "0",
                      }}
                    ></div>
                  ) : (
                    <div
                      className="amap_lib_placeSearch_poi mark-icon"
                      style={{
                        background: "url(" + item.markerIcon + ")",
                        float: "left",
                        marginRight: "10px",
                        left: "0",
                      }}
                    ></div>
                  )}

                  <div style={{ marginLeft: 25, marginTop: 2 }}>
                    <div className="name">
                      {item.taskName}({item.perNum}人)
                    </div>
                    <div className="text">
                      地址：
                      <span style={{ width: "100%", overflow: "auto" }}>
                        {item.taskAddress}
                      </span>
                    </div>
                  </div>
                </div>
              </div>
            );
          })
        ) : (
          <div
            style={{ textAlign: "center", fontSize: "14px", color: "#afb0b1" }}
          >
            {this.state.loadingText || "暂无数据"}
          </div>
        )}
      </div>
    );
  }
}
