/**
 *所有驻勤点
 */
import React, { Component } from "react";
import { connect } from "dva";
import { withRouter } from "dva/router";
import { Pagination, message, Icon, Input, Button, Tooltip } from "antd";
import { data } from "@constants/TypeData";
import { getComTaskList,getTaskList } from "../../../../../services/api";
import AttendanceItem from "./AttendanceItem";
@connect((state) => ({
  selectedId: state.command.attendanceList.selectedId,
  tabIndex2: state.command.tabIndex.attendance.tabIndex2,
}))
@withRouter
export default class AllAttendance extends Component {
  constructor(props) {
    super(props);
    console.log(props);
    this.state = {
      tabKey: "1", //tab
      currentKey: null, //主要用于处理tab页面改变，不让重新请求数据
      data: data,
      searchData: {
        //搜索数据
        pageNumber: 1,
        pageSize: 9,
        taskName: "",
      },
      selectedIndex: null, //选中哪个列表
      selectedAttenData: null, //选中的驻勤点的信息
      total: 0, //搜索总页数
      attendanceList: [], //搜索出的驻勤点的数据
      height: null, //搜索列表的最大高度
      loadingText: "暂无数据",
    };
  }

  componentDidMount() {
    const height = document.documentElement.clientHeight - 120 - 130 - 40;
    this.setState({ height });
    this.getAttendanceList(1); //默认页面中是空搜索
  }
  componentWillReceiveProps(nextProps) {
    if (
      nextProps.tabIndex2 == this.state.tabKey &&
      nextProps.tabIndex2 !== this.state.currentKey
    ) {
      this.setState({
        currentKey: nextProps.tabIndex2,
      });
      this.getAttendanceList(this.state.searchData.pageNumber);
    }
    if (nextProps.tabIndex2 != this.state.tabKey) {
      this.setState({
        currentKey: null,
      });
    }
  }
  //获取搜索值
  getAttendanceList(pageNumber) {
    // this.props.attenPersonList([]);
    //先重置分页数据
    this.setState(
      {
        searchData: {
          ...this.state.searchData,
          pageNumber,
        },
        selectedIndex: null, //清空驻勤的点击哪个列表的信息
        selectedAttenData: null,
        loadingText: "正在加载中...",
      },
      () => {
        getTaskList({
          _currpage:this.state.searchData.pageNumber,
          lines:this.state.searchData.pageSize,
        },{
          attendanceSiteName:this.state.searchData.taskName
        }).then(res=>{
          const data = this.state.data;
          const attendanceList = res.data.data;
          this.props.dispatch({
            type: "command/setSelectIndex",
            payload: null,
          });
          this.props.dispatch({
            type: "command/clearInfoWindow",
            payload: true,
          });
          for (let i = 0; i < attendanceList.length; i++) {
            //对数据字段重新组装
            attendanceList[i].lnglat =attendanceList[i].attendanceSiteLongitude? [attendanceList[i].attendanceSiteLongitude,attendanceList[i].attendanceSiteLatitude]:''
            delete attendanceList[i].attendanceSiteLongitude
            delete attendanceList[i].attendanceSiteLatitude
            attendanceList[i].taskName = attendanceList[i].attendanceSiteName
            delete attendanceList[i].attendanceSiteName
            attendanceList[i].name = attendanceList[i].principalName
            delete attendanceList[i].principalName
            attendanceList[i].mobilePhone = attendanceList[i].principalPhoneNo
            delete attendanceList[i].principalPhoneNo
            attendanceList[i].idCardNo = attendanceList[i].principalIdCardNo
            delete attendanceList[i].principalIdCardNo
            attendanceList[i].taskAddress = attendanceList[i].attendanceSiteFullAddress
            delete attendanceList[i].attendanceSiteFullAddress
            attendanceList[i].perNum = attendanceList[i].attendanceSiteNum
            delete attendanceList[i].attendanceSiteNum
            attendanceList[i].serviceObjectTypeName = attendanceList[i].attendanceSiteType
            delete attendanceList[i].attendanceSiteType
            attendanceList[i].comTaskId = attendanceList[i].id
            delete attendanceList[i].id

            for (let j = 0; j < data.length; j++) {
              if (attendanceList[i].serviceObjectTypeName == data[j].title) {
                attendanceList[i].markerIcon = data[j].markerIcon;
                attendanceList[i].clickMarkerIcon = data[j].clickMarkerIcon;
              }
            }
            if (!attendanceList[i].markerIcon) {
              attendanceList[i].markerIcon = data[data.length - 1].markerIcon;
              attendanceList[i].clickMarkerIcon =
                data[data.length - 1].clickMarkerIcon;
            }
          }
          this.setState({
            attendanceList,
            total: res.data.total,
            loadingText: res.data.data.length > 0 ? "加载完成" : "暂无数据",
          });
          this.props.dispatch({
            type: "command/fetchAllAttendanceList",
            payload: {
              attendanceList,
            },
          });
        });
      }
    );
  }
  render() {
    return (
      <div className="data-list">
        <div className="input">
          <Input
            placeholder="请输入驻勤点名称:"
            style={{ width: 270 }}
            onChange={(e) => {
              this.setState({
                searchData: {
                  ...this.state.searchData,
                  taskName: e.target.value.trim(),
                },
              });
            }}
            onPressEnter={() => {
              //按下回车获取列表值
              this.getAttendanceList(1);
            }}
          />
          <Button
            type="primary"
            onClick={() => {
              //获取搜索值
              this.getAttendanceList(1);
            }}
          >
            <Icon type="search" style={{ fontSize: "16px" }} />
          </Button>
        </div>
        <div
          className="security search-list_command amap_lib_placeSearch"
        >
          <div
            className="list"
            style={{ maxHeight: this.state.height, overflow: "auto" }}
          >
            <AttendanceItem
              data={this.state.attendanceList}
              loadingText={this.state.loadingText}
            />
          </div>
          <Pagination
            total={this.state.total}
            size="small"
            onChange={(number) => {
              this.getAttendanceList(number);
            }}
            defaultPageSize={this.state.searchData.pageSize}
            current={this.state.searchData.pageNumber}
            style={{ display: this.state.total > 1 ? "block" : "none" }}
          />
        </div>
      </div>
    );
  }
}
