//渲染每一个人员item
/**
 * 通过搜索获得地图列表(保安人员)
 */
import React, { Component } from "react";
import { connect } from "dva";
import { Pagination, message, Icon, Modal, Button, Tooltip } from "antd";
import { openPersonInfo } from '@mapModule/markMarkers';
import eventCenter from "@common/events"; // 引入 EventEmitter
// import styles from "../../Police/index.less";
import '../../../IM/im.less';
const { confirm } = Modal;
@connect((state) => ({
  policeData: state.command.policeData,
  selectedId: state.command.policeData.selectedId,
  mapStyle: state.command.mapStyle
}))
export default class PersonItem extends Component {
  constructor(props) {
    super(props);
    this.state = {
      data: props.data || [],
      loadingText: props.data,
      propsIndex: props.index,
      // lastSelectedId: null,//上一个选中的id
      // nextSelectedId: null,//下一个选中的id
    };
  }

  componentDidMount() { }
  componentWillReceiveProps(nextProps) {
    this.setState({
      loadingText: nextProps.loadingText,
      propsIndex: nextProps.index
    });
    if (nextProps.data != this.state.data) {
      this.setState({
        data: nextProps.data,
      });
    }
    // if (nextProps.selectedId !== this.state.lastSelectedId) {
    //   this.setState({
    //     nextSelectedId: nextProps.selectedId,
    //     lastSelectedId: this.state.nextSelectedId,
    //   }, () => {
    //     console.log(this.state.lastSelectedId);
    //     console.log(this.state.nextSelectedId);
    //   })
    // }
  }
  render() {
    const { propsIndex, data } = this.state
    const { mapStyle } = this.props
    return (
      <div style={{ marginLeft: 15 }} className='personItem'>
        {
          data && data.length > 0 ? (
            data.map((item, index) => {
              return (
                <div
                  key={item.id + index}
                  className="item"
                  onClick={(e) => {
                    e.stopPropagation()
                    if (item.longitude && item.latitude) {
                      // console.log(this.props.selectedId);
                      let markData = this.props.policeData[this.props.tab][this.props.place]
                      this.props.dispatch({
                        type: "command/setPoliceSelectIndex",
                        payload: item.id,
                      });
                      const thatGIS = this.props._thisGIS
                      markData.map((marker) => {
                        if (marker.w.key === item.id) {//打开当前选中的保安员窗体
                          // openPersonInfo.call(thatGIS, item, marker, 'police')
                          eventCenter.emit('openPersonInfo', {
                            item,
                            marker,
                            type: 'police'
                          });
                          marker.setContent(
                            '<div class="selected" style="background:unset"><div class="amap_lib_placeSearch_poi poibox-icon">' +
                            marker.w.indexText +
                            "</div></div>"
                          );
                        }
                        if (marker.w.key === this.props.selectedId) {//如果上一个选中打点信息存在，先置为原来状态
                          marker.setContent(
                            '<div class="amap_lib_placeSearch_poi poibox-icon">' +
                            marker.w.indexText +
                            "</div>"
                          );
                        }
                      });
                    } else {
                      message.warning("该人员暂未定位");
                    }
                  }}
                >
                  <div
                    className={
                      this.props.selectedId === item.id
                        ? "selected poibox"
                        : "poibox"
                    }
                  >
                    <div
                    // style={{ marginLeft: 15 }}
                    >
                      <div className='name' style={{ height: '31px' }}>
                        {item.longitude && item.latitude && (
                          <span
                            className="amap_lib_placeSearch_poi poibox-icon"
                            style={{
                              display: 'inline-block'
                            }}
                          >
                            {propsIndex ? propsIndex : index}
                          </span>
                        )}
                        <span className='name' style={{ color: mapStyle=='dark'?'#fff':'#5E5E5E' }}>{item.securityName || "---"}</span>
                        <span className="send-header-bar" style={{ float: 'right' }}>
                          <Tooltip placement="bottom" title="文字调度">
                            <Icon
                              type="form"
                              style={{ fontSize: "17px" }}
                              onClick={(e) => {
                                e.stopPropagation(), //合成事件停止冒泡
                                  // this.props.clickTextScheduling(item, "text");
                                  eventCenter.emit('clickTextScheduling', {
                                    item,
                                    type: "text",
                                  });
                              }}
                            />
                          </Tooltip>
                          <Tooltip
                            placement="bottom"
                            title="语音调度"
                            onClick={(e) => {
                              e.stopPropagation(), //合成事件停止冒泡
                                // this.props.clickTextScheduling(item, "voice");
                                eventCenter.emit('clickTextScheduling', {
                                  item,
                                  type: "voice",
                                });
                            }}
                          >
                            <Icon type="audio" style={{ fontSize: "17px" }} />
                          </Tooltip>
                          <Tooltip
                            placement="bottom"
                            title="视频调度"
                            onClick={(e) => {
                              const _this = this
                              e.stopPropagation(), //合成事件停止冒泡
                              eventCenter.emit('clickTextScheduling', {
                                item,
                                type: "video",
                                isNeedRecord: [item.phone]
                              });
                                // confirm({
                                //   title: <><span>是否开启屏幕录制?</span><span onClick={()=>Modal.destroyAll()} style={{position:'absolute',top:'4px',right:'6px',cursor:'pointer',color:'#000000a6'}}>取消</span></>,
                                //   content:
                                //     "开启后，被调度保安员的视频页面将会被录制，调度结束后，可查看录制文件。",
                                //   okText: "开启录制,继续调度",
                                //   cancelText: "不开启录制,继续调度",
                                //   onOk() {
                                //     // _this.props.clickTextScheduling(item, "video", [item.phone]);
                                //     eventCenter.emit('clickTextScheduling', {
                                //       item,
                                //       type: "video",
                                //       isNeedRecord: [item.phone]
                                //     });
                                //   },
                                //   onCancel() {
                                //     // _this.props.clickTextScheduling(item, "video");
                                //     eventCenter.emit('clickTextScheduling', {
                                //       item,
                                //       type: "video",
                                //     });
                                //   },
                                // });
                            }}
                          >
                            <Icon
                              type="video-camera"
                              style={{ fontSize: "17px" }}
                            />
                          </Tooltip>
                        </span>
                      </div>
                    </div>
                  </div>
                </div>
              );
            })
          ) : (
            <div
              style={{ textAlign: "center", fontSize: "14px", color: "#afb0b1" }}
            >
              {this.state.loadingText || "暂无数据"}
            </div>
          )
        }
      </div>
    );
  }
}
