/**
 * 海康的设备视频流
*/
import React, { Component } from "react";
import { Form, message, Spin } from 'antd';
import { connect } from "dva";
import styles from './index.less';
import MouseMovement from "../../../../components/MouseMovement"
// import { throttleAll } from "_lodash-decorators@6.0.1@lodash-decorators";
@Form.create()
@connect((state) => ({
}))
export default class NanNing extends Component {
  constructor(props) {
    super(props);
    this.state = {
      player: null,
      mode: 0,
      isPlay: false,
      currentUrl: ""
    };
  }
  componentDidMount() {
    this.initH5Player()
  }
  componentDidUpdate(prevProps) {
    if (this.props.videoUrl && this.state.currentUrl != this.props.videoUrl ) {
      this.setState({
        currentUrl: this.props.videoUrl
      })
      console.log('this.props.videoUrl',this.props.videoUrl)
      this.realplay()
    }
  }
  initH5Player() {
    const { JSPlugin } = window
    if (!JSPlugin) {
      var script = document.createElement('script');
      script.type = 'text/javascript';
      script.async = true;
      script.src = '/sdk/h5player.min.js';
      document.head.appendChild(script);
      this.loading()
    } else {
      this.initPlayer()
    }
  }
  loading() {
    let _this = this;
    function nextStep() {
      return new Promise((resolve) => {
        setTimeout(() => {
          resolve("JSPlugin" in window);
        }, 500);
      });
    }

    async function ajaxPlay() {
      let ifComplete = false;
      for (var i = 0; i < 10; i++) {
        if (!ifComplete) {
          console.log("没有");
          ifComplete = await nextStep();
        } else {
          if (ifComplete) {
            const { JSPlugin } = window;
            console.log("第" + i + "次加载" + "play。。。");
            console.log(JSPlugin)
            if (!JSPlugin) {
              initH5Player.call(_this);
            } else {
              // initPlayer.call(_this)
              _this.initPlayer()
            }
            break;
          } else {
            message.error("网络超时");
          }
        }
      }
    }
    ajaxPlay();
  }
  initPlayer() {
    let player = new window.JSPlugin({
      szId: 'player',
      szBasePath: "/sdk",
      iMaxSplit: 4,
      iCurrentSplit: 1,
      openDebug: true,
      oStyle: {
         borderSelect: '#000',
      }
    })
    this.setState({
      player
    }, () => {
      // 事件回调绑定
      let _this = this;
      this.state.player.JS_SetWindowControlCallback({
        windowEventSelect: function (iWndIndex) {  //插件选中窗口回调
          console.log('windowSelect callback: ', iWndIndex);
        },
        pluginErrorHandler: function (iWndIndex, iErrorCode, oError) {  //插件错误回调
          console.log("iErrorCode--->", iErrorCode)
          _this.closeVideoPlay()
          switch (iErrorCode) {
            case '0x0190003e':
              console.log(0x0190003e)
              message.info('该车辆未发车');
              break;
            case 11:
              console.log(11)
              message.info('当前信号不佳，请重新播放');
              break;
            default:
              console.log('default')
              message.info('加载失败，请重新播放');
          }
          return;
        },
        windowEventOver: function (iWndIndex) {  //鼠标移过回调
          //console.log(iWndIndex);
        },
        windowEventOut: function (iWndIndex) {  //鼠标移出回调
          //console.log(iWndIndex);
        },
        windowEventUp: function (iWndIndex) {  //鼠标mouseup事件回调
          //console.log(iWndIndex);
        },
        windowFullCcreenChange: function (bFull) {  //全屏切换回调
          console.log('fullScreen callback: ', bFull);
        },
        firstFrameDisplay: function (iWndIndex, iWidth, iHeight) {  //首帧显示回调
          console.log('firstFrame loaded callback: ', iWndIndex, iWidth, iHeight);
        },
        performanceLack: function () {  //性能不足回调
          console.log('performanceLack callback: ');
        }
      });
    })
  }
  /* 视频播放 */
  realplay() {
    const { player, mode, isPlay } = this.state;
    const { videoUrl } = this.props;
    console.log(videoUrl)
    let index = player.currentWindowIndex;
    if (isPlay) {
      player.JS_Stop(index).then(() => {
        player.JS_Play(videoUrl, { playURL: videoUrl, mode }, index).then(
          () => {
            console.log('realplay success');
            this.setState({
              isPlay: true
            })
          },
          e => { console.error(e) }
        )
      })
    } else {
      player.JS_Play(videoUrl, { playURL: videoUrl, mode }, index).then(
        () => {
          console.log('realplay success');
        },
        e => { console.error(e) }
      )
    }
  }
  // 关闭播放器
  closeVideoPlay() {
    // const { player, isPlay } = this.state;
    // if (isPlay) {
    //   player.JS_Stop(player.currentWindowIndex).then(() => {
    //     console.log('stop')
    //     this.props.closeHaikangVideo();
    //   })
    // }else{
    //   console.log("close")
    //   this.props.closeHaikangVideo();
    // }
    this.props.closeHaikangVideo();
  }
  // 全屏
  wholeFullScreen() {
    this.state.player.JS_FullScreenDisplay(true).then(
      () => { 
        console.log(`wholeFullScreen success`)
      },
      e => { console.error(e) }
    )
  }
  render() {
    return (
      <div>
        <div className={styles.fullScreen} onClick={this.wholeFullScreen.bind(this)}></div>
        <div style={{
          position: 'absolute',
          top: '-2px',
          right: '20px',
          fontSize: '16px',
          cursor: 'pointer'
        }} onClick={this.closeVideoPlay.bind(this)}>x</div>
        <div className={styles.hk} id="player"></div>
      </div>
    );
  }
}
