import React, { Component } from "react";
import RreactDom from 'react-dom';
import MouseMovement from '../../../../components/MouseMovement';
import styles from "./index.less";
// 弹窗组件
class NormalModal extends Component {
  constructor(props, context) {
    super(props, context);
    console.log(props)
    this.state = {
      isDown: false,
      className: props.className,
      offsetLeft: 0,
      offsetTop: 0,
    };
  }
  render() {
    return (
      <div>
        <MouseMovement
          isDown={this.state.isDown}
          offsetLeft={this.state.offsetLeft}
          offsetTop={this.state.offsetTop}
        >
          {({ x, y, cursor = 'move' }) => (
            <div>
              <div
                style={{
                  cursor: 'pointer',
                  position: 'absolute',
                  top: y == 0 ? '8' : y,
                  left: x == 0 ? 500 : x + 500,
                  zIndex: '1002'
                }}
                onClick={(e) => {
                  e.preventDefault()
                  // 删除组件
                  setTimeout(() => {
                    const divs = document.getElementsByClassName(this.state.className);
                    Reflect.apply(Array.prototype.forEach, divs, [item => {
                      RreactDom.unmountComponentAtNode(item);
                      document.body.removeChild(item);
                    }]);
                  }, 300);
                }}>X</div>
              <div
                className={styles.map_video + ' video'}
                onMouseDown={e => {
                  this.setState({
                    isDown: true,
                    offsetLeft: document.getElementsByClassName('video')[0].offsetLeft,
                    offsetTop: document.getElementsByClassName('video')[0].offsetTop
                  })
                }}
                style={{
                  cursor: 'move',
                  top: y == 0 ? '8' : y,
                  left: x == 0 ? '16' : x,
                }}>
                <iframe
                  allowFullScreen
                  style={{ width: "100%", height: "100%" }}
                  src="https://wvp.test.baibaodun.cn/#/play/wasm/wss%3A%2F%2Fwvp.test.baibaodun.cn%2Frtp%2Fgb_play_44010200492000000002_34090000001320000001.flv"
                ></iframe>
              </div>
            </div>

          )}
        </MouseMovement>
      </div>
    );
  }
}

// 插入弹窗
export default function showInsuranceModal(props) {
  var calassName = Math.random() * 10 + 'n_openVideo'
  const div = document.createElement('div');
  div.setAttribute('class', calassName);
  document.body.appendChild(div);
  props.className = calassName
  RreactDom.render(<NormalModal {...props} />, div);
}