/**
 * 驻勤点和保安员信息
 */
import React, { Component } from "react";
import { Icon, Pagination, Tabs, Radio } from 'antd';
import { getRootDep, getSubdepartmentList, passDepartIdGetPersonList } from '@services/api';
import styles from "./index.less";
import PersonItem from "../SearchListTab/PersonMessage/PersonItem"
import { connect } from "dva";
import eventCenter from "@common/events"; // 引入 EventEmitter
@connect((state) => ({
  //地图数据
  pictureMarkersList: state.command.pictureMarkersList,
  mapStyle: state.command.mapStyle,
}))
export default class EmployeesList extends Component {
  constructor(props) {
    super(props);
    this.state = {
      height: null, //保安员资源列表的最大高度
      allHeight: null,
      personType: 'B',
      rootDep: {},
      navList: [], // 面包屑层级
      personList: [], // 保安人员列表
      loadingText: '',
      total: 0,
      depList: [],
    };
  }
  componentDidMount() {
    getRootDep({ domainId: this.props.domainId }).then(res => {
      if (res.errcode == 0 && res.data) {
        let data = res.data
        this.setState({
          rootDep: {
            depName: data.name,
            id: data.id,
          }
        })
        this.getDepList(data)
      }
    })
  }
  // 根据企业部门获取保安人员列表
  _getPersonList(item, pageNo = 1) {
    this.setState({
      loadingText: "正在加载中..."
    })

    passDepartIdGetPersonList({
      _currpage: pageNo,
      lines: 100
    }, {
      did: item.id,
      appId: "__ZLuP7RGirprZZ6SCdiX",
      viewId: "__P1bb27ekxYoAiowqVv1",
      opentarget: "detail",
      containTitle: "部门ID查询保安员信息接口"
    }).then(res => {
      const data = res.data.data

      let result = data.map((item)=>{
        console.log('position', item);
        item.perId = item.id
        item.ID = item.id;
        delete item.id
        item.name = item.securityName ? item.securityName : item.principalName
        delete item.securityName
        delete item.principalName
        let lnglatData =item.item_lonlatjson? JSON.parse(item.item_lonlatjson):''
        item.lnglat =lnglatData? [lnglatData.longitude,lnglatData.latitude]:''
        item.location = lnglatData? [lnglatData.longitude,lnglatData.latitude]:''
        item.longitude = lnglatData.longitude;
        item.latitude = lnglatData.latitude;
        // item.lnglat = [118.051982,24.607542]
        delete item.item_lonlatjson
        item.idCardNo = item.documentID ? item.documentID : item.principalIdCardNo
        delete item.documentID
        delete item.principalIdCardNo
        item.mobilePhone = item.phone ? item.phone : item.principalPhoneNo
        delete item.phone
        delete item.principalPhoneNo
        return item
      })
      console.log('passDepartIdGetPersonList', result);
      this.setState({
        personList: result,
        total: res.data.total,
        loadingText: result.length > 0 ? "加载完成" : "暂无数据",
      })
      eventCenter.emit('addPictueMarks', {
        data: {
          data: result
        },
        type: "securityResource"
      });
    })
  }
  changePersonType = (e) => {
    this.setState({
      personType: e.target.value
    })
  }
  getDepList = (item) => {
    console.log('getDepList-item',item);
    const { navList } = this.state;
    if (!item.leaf) {
      getSubdepartmentList({ domainId: this.props.domainId, depId: item.id }).then(res => {
        if (res.errcode == 0 && res.data.length > 0) {
          console.log(res)
          this.setState({
            depList: res.data,
            navList: navList.concat({
              id: item.id,
              name: item.name
            })
          })
        }
      });
    } else {
      this.setState({
        depList: [],
        navList: navList.concat({
          id: item.id,
          name: item.name
        })
      })
    }

    this._getPersonList(item);
  }
  // 部门列表
  _renderDepartment=()=>{
    const { depList, rootDep } = this.state
    return (
      <div className={styles.dep_list}>
          {
            depList.map((item) => {
              return (
                <div key={item.id} className={styles.dep_item}>
                  <div className={styles.dep_name} onClick={this.getDepList.bind(this, item)}>
                    <img src={require("../../../../assets/images/prevention/aPicture/dep.png")} alt="" />
                    <div>{item.name}</div>
                  </div>
                  {item.leaf ? "" :
                    <div className={styles.dep_next} onClick={this.getDepList.bind(this, item)}>
                      <img src={require("../../../../assets/images/prevention/aPicture/nextDep.png")} alt="" />
                      <div>下级</div>
                    </div>
                  }
                </div>
              )
            })
          }
        </div>
    )
  }
  // 面包屑点击事件
  onNavClick=(index)=>{
    console.log('this.state.navList', JSON.stringify(this.state.navList));
    let { navList } = this.state;
    navList = navList.slice(0, index + 1)
    const item = navList[navList.length - 1];
    navList = navList.slice(0, index)
    this.state.navList = navList;
    this.getDepList(item)
  }
  // 面包屑
  _renderNavBar=()=>{
    const { navList } = this.state;
    console.log('navList', navList);
    return (
      <div className={styles.nav_content} ref="navPartment" id="s">
        {navList.map((val, index)=>{
          if (navList.length -1 !== index) {
            return(
              <span
                key={index}
                onClick={this.onNavClick.bind(this, index)}
                className={styles.nav}
              >
                {val.name}
                <Icon type="right" />
              </span>
            )
          }
          return <span className={styles.root_dep} key={index}>{val.name}</span>
        })}
      </div>
    )
  }
  _renderPersonList=()=>{
    return (
      <div className="security search-list_command amap_lib_placeSearch">
          <div
            className="list"
            style={{ maxHeight: this.state.height, overflow: "auto" }}
          >
            <PersonItem
              data={this.state.personList}
              loadingText={this.state.loadingText}
            />
          </div>
        </div>
    )
  }
  // 获取部门
  render() {
    const { domainId } = this.props
    const { depList, rootDep } = this.state
    console.log('depList', depList)
    return (
      <div className={styles.dep_box}>
        {/* 面包屑 */}
        { this._renderNavBar() }
        {/* 部门 */}
        { this._renderDepartment() }
        {/* 人员列表 */}
        { this._renderPersonList() }
      </div>
    );
  }
}
