/**
 * 驻勤点和保安员信息
 */
import React, { Component } from "react";
import { Icon } from 'antd';
import { getAttendance, getSecurityManByAttendanceId, attendanceGetTypeData } from '@services/api';
import styles from "./index.less";
import PersonItem from "../SearchListTab/PersonMessage/PersonItem"
import eventCenter from "@common/events"; // 引入 EventEmitter
import { connect } from "dva";
import { showAttendPointInfo, showAttendList } from '@gis/biz';
import { recordTo, recordBack, recordRemove, recordAdd } from '@common/recordHistory';

@connect((state) => ({
  mapStyle: state.command.mapStyle,
  selectComponeyInfo: state.command.selectComponeyInfo
}))
export default class DutyPersonList extends Component {
  constructor(props) {
    super(props);
    this.state = {
      attendanceList: [],
      navList: [],
      personList: [],
      checkName: '',
      loadingText: ' '
    };
  }
  componentDidMount() {
    this._getAttendance();
  }
  // 根据企业部门获取保安人员列表
  _getPersonList(items) {
    this.setState({
      loadingText: "正在加载中..."
    })
    const checkName = items.item_attendancesitename;
    const attendanceId = items.id;

    getSecurityManByAttendanceId({
      attendanceId: items.id,
    }).then(res => {
      const datas = res.data
      let result = datas.map((item)=>{
        item.perId = item.item_userid
        item.ATTENDANCESITEID = attendanceId
        delete item.item_userid
        item.name = item.item_securityname ? item.item_securityname : item.principalName
        delete item.item_securityname
        delete item.principalName
        let lnglatData =item.item_lonlatjson? JSON.parse(item.item_lonlatjson):''
        item.lnglat =lnglatData? [lnglatData.longitude,lnglatData.latitude]:''
        item.longitude = lnglatData.longitude
        item.latitude = lnglatData.latitude
        // item.lnglat = [118.051982,24.607542]
        delete item.item_lonlatjson
        item.companyName = item.item_companyname
        delete item.item_companyname
        item.ATTENDANCESITENAME = item.item_attendancesitename
        delete item.item_attendancesitename
        item.DeptName = item.item_deptname
        delete item.item_deptname
        item.idCardNo = item.item_documentid ? item.item_documentid : item.principalIdCardNo
        delete item.item_documentid
        delete item.principalIdCardNo
        item.mobilePhone = item.item_phone ? item.item_phone : item.principalPhoneNo
        delete item.item_phone
        delete item.principalPhoneNo
        return item
      })

      this.setState({
        personList: result,
        total: res.data.total,
        loadingText: result.length > 0 ? "加载完成" : "暂无数据",
        attendanceList: [],
        checkName
      })

      this.props.dispatch({
        type: "command/fetchAttendPoliceList",
        payload: {
          list: result,
        },
      });
    })
  }
  _gotoAttend=(item)=>{
    const that = this;
    let { selectComponeyInfo } = this.props
    selectComponeyInfo.clickType = 'attendancePoints';
    showAttendPointInfo({
      aid: item.selectAttendId,
      companyName: item.companyName,
      doMainId: this.props.domainId,
      success: function(result){
        that.props.dispatch({
          type: 'command/setSelectAttendInfo',
          payload: result
        })
      }
    });
    recordAdd({
      from: 'ComponeyInfo',
      to: 'AttendInfo',
      fromData: selectComponeyInfo,
      toID: item.selectAttendId
    });
  }
  // 驻勤点列表
  _renderDepartment=()=>{
    const { attendanceList, rootDep } = this.state
    return (
      <div className={styles.dep_list}>
          {
            attendanceList.map((item) => {
              return (
                <div key={item.id} className={styles.dep_item} data-item={item} onClick={this._gotoAttend.bind(this, item)}>
                  <div className={styles.dep_name}>
                    <img src={require("../../../../assets/images/prevention/aPicture/dep.png")} alt="" />
                    <div>{item.attendName}</div>
                    {/* <div className={styles.dep_next}>
                      <img src={require("../../../../assets/images/prevention/aPicture/nextDep.png")} alt="" />
                      <div>所属人员</div>
                    </div> */}
                  </div>
                </div>
              )
            })
          }
        </div>
    )
  }
  // 获取驻勤点列表
  _getAttendance=()=>{
    this.props.dispatch({
      type: "command/fetchAllAttendanceList",
      payload: {
        attendanceList: [],
      },
    });
    const that = this;
    showAttendList({
      doMainId: this.props.domainId,
      doMainName: this.props.domainName,
      success: function(result){
        that.setState({
          attendanceList: result,
          personList: [],
          checkName: ''
        })
      }
    })
  }
  // 面包屑点击事件
  onNavBack=(index)=>{
    this._getAttendance();
  }
  // 面包屑
  _renderNavBar=()=>{
    const { checkName } = this.state;
    return (
      <div className={styles.nav_content} ref="navPartment" id="s">
        <span
          key={'all'}
          onClick={this.onNavBack.bind(this)}
          className={styles.nav}
        >
          {this.props.domainName}
          { checkName != "" ? <Icon type="right" /> : null}
        </span>
        { checkName != "" ? <span className={styles.root_dep} key={'index'}>{checkName}</span> : null}
      </div>
    )
  }
  _renderPersonList=()=>{
    const { height, personList, loadingText } = this.state;
    return (
      <div className="security search-list_command amap_lib_placeSearch">
          <div
            className="list"
            style={{ maxHeight: height, overflow: "auto" }}
          >
            <PersonItem
              data={personList}
              loadingText={loadingText}
            />
          </div>
        </div>
    )
  }
  // 获取部门
  render() {
    const { domainId } = this.props
    const { attendanceList, rootDep } = this.state
    console.log('depList', attendanceList)
    return (
      <div className={styles.dep_box}>
        {/* 面包屑 */}
        { this._renderNavBar() }
        {/* 驻勤点 */}
        { this._renderDepartment() }
        {/* 人员列表 */}
        {/* { this._renderPersonList() } */}
      </div>
    );
  }
}
