/**
 * 保安服务公司列表
 */
import React, { Component } from "react";
import { Icon, Tabs, Radio } from 'antd';
import styles from "./index.less";
import { connect } from "dva";
import eventCenter from "@common/events"; // 引入 EventEmitter
import { getDomainInfo } from '@services/api';
import ComponyItem from '@gis/components/ComponyItem';
import classNames from 'classnames';
import { showCompanyPointInfo } from '@gis/biz';
const { TabPane } = Tabs;

@connect((state) => ({
  //地图数据
  pictureMarkersList: state.command.pictureMarkersList,
  mapStyle: state.command.mapStyle,
  selectComponyList: state.command.selectComponyList,
}))
export default class ComponyList extends Component {
  constructor(props) {
    super(props);
    this.state = {
      companyList: []
    };
  }
  componentDidMount() {
  }
  // 利用此事件来决定何时需要重新渲染组件。
  // shouldComponentUpdate(nextProps, nextState) {
  // }
  onChangeCompony(item){
    console.log('onChangeCompony');
    const that = this.props;
    showCompanyPointInfo({
      doMainId: item.selectComponeyId,
      success: function(info){
        let data = { data: [info] };
        // TAG: 根据需求 368。点击打开公司办公地点定位，并打开公司信息弹框
        // event 发送器: eventCenter.emit("事件名称", 参数列表);
        // 这样做的好处是，爷传孙，不需要父级组件做承载
        eventCenter.emit('addPictueMarks', {
          data,
          type: "securityCompany"
        });
      }
    })
  }
  onClose=()=>{
    // 关闭
    this.props.dispatch({
      type: 'command/setSelectComponyList',
      payload:  []
    })
    eventCenter.emit('clearMapTag','securityCompany');
    eventCenter.emit('clearMapModal', 'ComponeyInfo');
    eventCenter.emit('APictureChecked', {
      type: 'securityCompanyChecked',
      checked: false
    });
    this.props.onClose && this.props.onClose()
  }
  render() {
    const {  mapStyle,selectComponyList } = this.props
    const clsString = classNames(styles.list_item, 'list_item');
    return (
      <div className={mapStyle}>
        <div className={styles.compony_list}>
          <div className={styles.list_header}>
            <div className={styles.list_close} onClick={this.onClose}>x</div>
            保安服务公司
          </div>
          <div className={styles.list_content}>
            {selectComponyList && selectComponyList.map((item, i)=>{
              return <ComponyItem item={item} onChangeCompony={this.onChangeCompony} />
            })}
          </div>
        </div>
      </div >
    );
  }
}
