import React from 'react';
import { Router, Route, Switch } from 'dva/router';
import { ConfigProvider, 
  // Spin 
} from 'antd';

// import axios from 'axios';
// import zhCN from 'antd/es/locale-provider/zh_CN.js';
import zh_CN from 'antd/lib/locale-provider/zh_CN';
// import dynamic from 'dva/dynamic';
import cloneDeep from 'lodash/cloneDeep';
import { getNavData } from './common/nav';
import { getPlainNode } from './utils/utils';
import moment from 'moment';
import 'moment/locale/zh-cn';
moment.locale('zh-cn');
// import styles from './index.less';


function getRouteData(navData, path) {
  if (
    !navData.some(item => item.layout === path) ||
    !navData.filter(item => item.layout === path)[0].children
  ) {
    return null;
  }
  const route = cloneDeep(navData.filter(item => item.layout === path)[0]);
  const nodeList = getPlainNode(route.children);
  return nodeList;
}

function getLayout(navData, path) {
  // debugger
  if (
    !navData.some(item => item.layout === path) ||
    !navData.filter(item => item.layout === path)[0].children
  ) {
    return null;
  }
  /**
   * iverry remack
   * 获取到对应的配置
   */
  const route = navData.filter(item => item.layout === path)[0];
  return {
    component: route.component,
    layout: route.layout,
    name: route.name,
    path: route.path
  };
}

function RouterConfig({ history, app }) {
  /**
   * iverry remark
   * getNavData返回一个包含所有路由配置的数组
   */
  const navData = getNavData(app);
  /**
   * iverry remark
   * 从路由配置中获取到三大模块的组件
   */
  const UserLayout = getLayout(navData, 'UserLayout').component;
  const BasicLayout = getLayout(navData, 'BasicLayout').component;

  const passProps = {
    app,
    navData,
    getRouteData: path => {
      return getRouteData(navData, path);
    }
  };

  return (
    <ConfigProvider locale={zh_CN}>
      <Router history={history}>
        <Switch>
          <Route
            path='/user'
            render={props => {
              return <UserLayout {...props} {...passProps} />;
            }}
          />
          <Route
            path='/'
            render={props => {
              return <BasicLayout {...props} {...passProps} />;
            }}
          />
        </Switch>
      </Router>
    </ConfigProvider>
  );
}

export default RouterConfig;
