import React, { Component } from "react";
import RreactDom from 'react-dom';
import PropTypes from 'prop-types';
import { Modal } from "antd";
import { findYIncumbencyPerCount } from '../services/api';
// 弹窗组件
class InsuranceModal extends Component {
  constructor(props, context) {
    super(props, context);

    this.state = {
      visible: true
    };
  }
  _toggle = (type) => {
    this.setState({
      visible: !this.state.visible
    }, () => {
      // 点击确定以后
      if (type == 'confirm') {
        this.props.okCallBack && this.props.okCallBack();
      }else {
        this.props.cancelCallBack && this.props.cancelCallBack();
      }
      // 删除组件
      const divs = document.getElementsByClassName('insurance_modal');
      Reflect.apply(Array.prototype.forEach, divs, [item => {
        RreactDom.unmountComponentAtNode(item);
        document.body.removeChild(item);
      }]);
    });
  }
  render() {
    return (
      <Modal
        title={this.props.title}
        maskClosable={false}
        keyboard={false}
        destroyOnClose={true}
        okText="马上办理"
        cancelButtonProps={{ style: { display: 'none' } }}
        visible={this.state.visible}
        onOk={() => {
          this._toggle('confirm');
        }}
        onCancel={() => {
          this._toggle();
        }}
      >
        <p style={{ color: '#ff4d4f', fontSize: 14 }}>{this.props.warningText}</p>
        <p style={{ fontSize: 16 }}>
          {this.props.contentText.split('count')[0]}
          {
            this.props.contentText.split('count')[1] &&
            <span style={{ color: '#ff4d4f' }}>{this.props.count}</span>
          }
          {this.props.contentText.split('count')[1] || ''}
        </p>
      </Modal>
    );
  }
}

InsuranceModal.propTypes = {
  count: PropTypes.number,
  contentText: PropTypes.string,
  title: PropTypes.string,
  warningText: PropTypes.string,
  okCallBack: PropTypes.function,
};

// 插入弹窗
function showInsuranceModal(props) {
  // if (props.count > 0) {
    const div = document.createElement('div');
    div.setAttribute('class', 'insurance_modal');
    document.body.appendChild(div);
    RreactDom.render(<InsuranceModal {...props} />, div);
  // };
}



export default {
  namespace: "insurance",

  state: {
    isShowPlanBook: false,
    // 人员投保管理页面是否弹出模态框提示用户存在在保离职人员(第一次进来的时候需要弹窗)
    isShowQuitModal: true,
  },

  effects: {
    /**
     * @auth lyq
     * 登录后判断离职在保人数是否大于0如果大于0弹出对话框（登录后只弹窗一次）
     */
    *showQuitModal({ payload }, { put, call, select }) {
      const state = yield select(_ => _.insurance);
      const { isShowQuitModal } = state;
      
      console.log(payload.count, 'payload.count>>>>');
      // 减员（减员的时候才会获取已离职未投保的数量去替换字符串中count）
      if(payload.type != 'add') {
        // 获取离职在保人数
        const countRes = yield call(findYIncumbencyPerCount);
        // 如果有传入数量，使用传入的数量
        payload.count = payload.num || countRes.data + '' || 0;
        if(payload.count != 0 && isShowQuitModal) {
          // 设置为false,下次进来的时候不再提示
          yield put({
            type: 'setQuitModal',
            payload: false
          });
          // 调用弹窗
          showInsuranceModal(payload);
        }
      }else {
        // 调用弹窗
        showInsuranceModal(payload);
      }
    }
  },

  reducers: {
    showPlanBook(state, action) {
      return {
        ...state,
        isShowPlanBook: action.payload
      };
    },
    setQuitModal(state, action) {
      return {
        ...state,
        isShowQuitModal: action.payload
      };
    }
  }
};
