import { queryNotices,getTencentImSig } from '../services/api';
import tim from '../utils/im/imInitialize';
const refresh = {
  HomePage: 0,//首页
  Organization: 0,
  enterprise: 0,
  taskmanager: 1,//人事
  meeting:2,//云会议
  insurancemart: 3,//保险商城
  insurancemanagement:3,//团体保险
  linbaoinsurancemanagement:3,//临保保险
  insurancePreservation:3,//保全缴费
  insuranceOfficer:3,//负责人
  // command:4,//防控指挥
  finance:3,//金融钱包
  // command:4,//防控指挥
};
export default {
  namespace: 'global',
  state: {
    collapsed: true,
    menuInfo: [],
    notices: [],
    currentKey:'0',
    fetchingNotices: false,
    companyInfo:{
      "comId":"",
      "authType":"",
      "authStatus":"",
      "comName":"",
      "regProvince":'',
      "regCity":'',
      "regArea":'',
      "regAddress":"",
      "economicType":"",
      "industryType":"",
      "comType":"",
      "institutionType":"",
      "isBranchCom":"",
      "parentComName":"",
      "parentComRep":"",
      "parentComTel":"",
      "legalRepName":"",
      "nationality":"",
      "legalRepPhone":"",
      "idCardType":"",
      "idCardNo":"",
      "regAmount":'',
      "fixedAssets":'',
      "annualTurnover":'',
      "annualProfitTax":'',
      "comCerType":"",
      "comCerUrl":"",
      "comRegId":"",
    },
    imIsLogin:false,
    imSig:null,
    lMenu: false, //是否显示左侧菜单
    tMenu: false,  //是否显示顶部菜单
    footer: false,  //是否显示footer
    isShowSystemNotice:false,//是否显示过系统升级通知
  },

  effects: {
    *fetchNotices(_, { call, put }) {
      yield put({
        type: 'changeNoticeLoading',
        payload: false,
      });
      const data = yield call(queryNotices);
      yield put({
        type: 'saveNotices',
        payload: data.data,
      });
      yield put({
        type: 'user/changeNotifyCount',
        payload: data.length,
      });
    },
    *clearNotices({ payload }, { put, select }) {
      yield put({
        type: 'saveClearedNotices',
        payload,
      });
      const count = yield select(state => state.global.notices.length);
      yield put({
        type: 'user/changeNotifyCount',
        payload: count,
      });
    },
    *companyInfo({ payload }, { put}){
      yield put({
        type: 'getCompanyInfo',
        payload,
      });
    },
     /*获取腾讯IM，并完成IM登录*/
     *imLogin(action, { call,put }) {
      const data = yield call(getTencentImSig, {
        name:action.payload.name,
        mobilePhone:action.payload.username,
        photoUrl:'',
      });
      if(data.data.data){
        tim.login({
          userID:action.payload.username,
          userSig:data.data.data
        }).then(()=>{
          console.log("登录成功")
        })
        // if(data.data){
          yield put({
            type: "changeImLoginStatus",
            payload: data.data
          });
        // }
      }
    },
  },

  reducers: {
    getCompanyInfo(state, { payload }) {
      return {
        ...state,
        companyInfo: payload,
      };
    },
    changeLayoutCollapsed(state, { payload }) {
      return {
        ...state,
        collapsed: payload,
      };
    },
    saveMenuInfo(state, { payload }) {
      return {
        ...state,
        menuInfo: payload,
      };
    },
    saveNotices(state, { payload }) {
      return {
        ...state,
        notices: payload,
        fetchingNotices: false,
      };
    },
    saveClearedNotices(state, { payload }) {
      return {
        ...state,
        notices: state.notices.filter(item => item.type !== payload),
      };
    },
    changeNoticeLoading(state, { payload }) {
      return {
        ...state,
        fetchingNotices: payload,
      };
    },
    menuChange(state, { payload }){
      const currentGroup = refresh[window.location.pathname.split('/')[1]] || 0;
      return {
        ...state,
        currentKey: currentGroup,
      };
    },
    netError(state, { payload }) {
      return {
        ...state,
        netErr: true
      };
    }, 
    changeImLoginStatus(state, { payload }) {
      return {
        ...state,
        imIsLogin: true,
        imSig:payload
      };
    },
    changeLMenu(state, { payload }) {
      return {
        ...state,
        lMenu: payload.lMenu,
      };
    },
    changeTMenu(state, { payload }) {
      return {
        ...state,
        tMenu: payload.tMenu,
      };
    },
    changeFooter(state, { payload }) {
      return {
        ...state,
        footer: payload.footer,
      };
    },
    changeShowSystemNotice(state, { payload }) {
      return {
        ...state,
        isShowSystemNotice: payload,
      };
    },
  },
  
  subscriptions: {
    setup({ history, dispatch }) {
      
      // Subscribe history(url) change, trigger `load` action if pathname is `/`
      return history.listen(({ pathname, search }) => {
        if (typeof window.ga !== 'undefined') {
          window.ga('send', 'pageview', pathname + search);

          // 2020-1-10
          // 顶部菜单的选中
          const currentGroup = refresh[pathname.split('/')[1]] || 0;
          dispatch({
            type: 'menuChange',
            payload: currentGroup
          });
          const prefix = window.location.hostname.split('.')[0]; 
          if(prefix=='localhost'||prefix=='192'){
            dispatch({
              type: 'changeLMenu',
              payload: {
                lMenu: true
              }
            });
            dispatch({
              type: 'changeTMenu',
              payload: {
                tMenu: true
              }
            });
            // dispatch({
            //   type: 'changeFooter',
            //   payload: {
            //     footer: true
            //   }
            // });
          }
          if(pathname == '/salary/service') {
            // 隐藏左侧菜单
            // dispatch({
            //   type: 'changeLMenu',
            //   payload: {
            //     lMenu: false
            //   }
            // });
            //隐藏顶部菜单
            // dispatch({
            //   type: 'changeTMenu',
            //   payload: {
            //     lMenu: false
            //   }
            // });
          }else {
            // dispatch({
            //   type: 'changeLMenu',
            //   payload: {
            //     lMenu: true
            //   }
            // });
            // dispatch({
            //   type: 'changeTMenu',
            //   payload: {
            //     tMenu: true
            //   }
            // });
            // dispatch({
            //   type: 'changeFooter',
            //   payload: {
            //     footer: true
            //   }
            // });
          }
        }
      });
    },
  },
};
