/**
 * 华为云会议
 */
export default {
  namespace: "client",
  state: {
    client: null,
    loginStatus: false,
    meetingToken: null,
    meetingAcount: null,
    meetingPass: null,
    meetingSipName: null,
    attenList: [],
    currentConferID: null, //当前用户进入的会议id
    currentConferTopic: null, //当前用户进入的会议主题
    updateISRefreshMeetingList: false, //会议列表页面，是否重新刷新请求数据
    isKickOut: false, //是否被踢出(被踢出，且没有再次进行初始化，会变成true)
    joinMeetingStatus: false, //加入会议的状态（加入的时候会变成true，成功或者失败的时候变成false）
    isSuccessJoinMeeting: null //加入会议后的状态（成功是'true',失败是'false'）
  },
  effects: {
    //设置华为云sdk的初始化
    *setClient({ payload }, { put }) {
      yield put({
        type: "changeClient",
        payload
      });
    },
    //获取服务器返回的华为会议token
    *setMeetingToken({ payload }, { put }) {
      yield put({
        type: "changeMeetingToken",
        payload
      });
    },
    //设置华为云的登录状态
    *setLogin({ payload }, { put }) {
      yield put({
        type: "changeLogin",
        payload
      });
    },
    //设置会议控制页面会议人员列表数据
    *setAttenList({ payload }, { put }) {
      yield put({
        type: "changeAttenList",
        payload
      });
    },
    //设置用户当前进入的会议是哪个
    *setCurrentConferID({ payload }, { put }) {
      yield put({
        type: "changeCurrentConferID",
        payload
      });
    },
    //会议列表页面是否重新刷新页面
    *setISRefreshMeetingList({ payload }, { put }) {
      yield put({
        type: "changeISRefreshMeetingList",
        payload
      });
    },
    //设置被踢出，还点击取消（没有重新登录）
    *setISKickOut({ payload }, { put }) {
      yield put({
        type: "changeISKickOut",
        payload
      });
    },
    // //监听有会议
    // *setAttenList({ payload }, { put }) {
    //   yield put({
    //     type: "changeAttenList",
    //     payload
    //   });
    // },
    //设置加入会议时候，出现进度条
    *setJoinMeetingStatus({ payload }, { put }) {
      yield put({
        type: "changeJoinMeetingStatus",
        payload
      });
    }
  },

  reducers: {
    changeClient(state, { payload }) {
      return {
        ...state,
        client: payload.client
      };
    },
    changeMeetingToken(state, { payload }) {
      return {
        ...state,
        meetingToken: payload.meetingAcc.accessToken,
        meetingAcount: payload.meetingAcc.huaweiUserName,
        meetingPass: payload.meetingAcc.huaweiPassWord,
        meetingSipName: payload.meetingAcc.huaweiSipName
      };
    },
    changeLogin(state, { payload }) {
      return {
        ...state,
        loginStatus: payload.loginStatus
      };
    },
    changeAttenList(state, { payload }) {
      return {
        ...state,
        attenList: payload.attenList
      };
    },
    changeCurrentConferID(state, { payload }) {
      return {
        ...state,
        currentConferID: payload.currentConferID,
        currentConferTopic: payload.currentConferTopic
      };
    },
    changeISRefreshMeetingList(state, { payload }) {
      return {
        ...state,
        updateISRefreshMeetingList: payload.updateISRefreshMeetingList
      };
    },
    changeISKickOut(state, { payload }) {
      return {
        ...state,
        isKickOut: payload.isKickOut
      };
    },
    changeJoinMeetingStatus(state, { payload }) {
      return {
        ...state,
        joinMeetingStatus: payload.joinMeetingStatus,
        isSuccessJoinMeeting: payload.isSuccessJoinMeeting
      };
    }
  }
};
