/**
* 选择人员弹窗@author Lyq
*/
import React, { Component } from "react";
import { Modal, Icon } from "antd";

import { getPerBaseInfoListByPerids } from '../../../services/api';
import PersonList from './PersonList';
import $loading from '../../../utils/loading';
import "./index.less";

export default class PersonModal extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      visible: true, //是否弹出
      selectedList: [],  //已经被选中的人员
      type: this.props.type || 'checkbox',
      isRequestAll: false  //是否已经请求过所有用户的接口
    };
  }
  componentWillMount() {
    this.__init();
  }
  componentDidMount() {
  }
  componentWillReceiveProps(props) {
    this.__init(props);
  }
  __init = (props) => {
    props = props || this.props;
    this.setState({
      visible: props.visible,
    });
    const type = obj => Object.prototype.toString.call(obj).slice(8, -1);
    const { value } = props;

    if(value) {
      if(type(value) == 'Array') {
        if(type(value[0]) == 'Object') {
          // 直接传入完整的数据的情况
          this.setState({
            selectedList: value.filter(item => item.perId)
          });
        }else if(type(value[0]) == 'String') {
          // 传入的数组是id的集合的情况
          this._getPerBaseInfoListByPerids(value.join(','));
        }
      }else if(type(value) == 'String') {
        // 传入的是字符串的情况，用,分割
        this._getPerBaseInfoListByPerids(value);
      }
    }

  }
  _getPerBaseInfoListByPerids(perIds) {
    getPerBaseInfoListByPerids({perIds}).then(res => {
      this.setState({
        selectedList: res.data
      });
    });
  }
  // _initValue = (cb) => {
  //   if(!this.state.isRequestAll) {
  //     this.setState({
  //       isRequestAll: true
  //     }, () => {
  //       $loading.open('数据请求中...');
  //       // 获取所有部门数据 获取所有人员
  //       getTreeperBydepart({}).then(response => {
  //         this.setState({
  //           allPers: response.data
  //         }, () => {
  //           $loading.close();
  //           cb && cb();
  //         });
  //       }).catch(ex => {
  //         $loading.close();
  //       });
  //     });
  //   }else {
  //     cb && cb();

  //   }
  // }
  // _restructure = valueArray => {
  //   $loading.open('数据处理中...');
  //   const selectedList = [];
  //   const allStr = JSON.stringify(this.state.allPers);
  //   valueArray.forEach(perId => {
  //     if(perId && allStr.indexOf(perId) > 0) {
  //       // 使用正则获取对应的值
  //       // const reg = new RegExp('(.*)(\{.*?\"key\":\"' + perId + '\",.*?\})(.*)');
  //       // 前半部分用key+id分割
  //       const reg = new RegExp('(.*)(\{.*?\"key\":\"' + perId + '\",.*\})(.*)');
  //       // 后半部分用children分割
  //       // const childrenReg = /(.*?,+\"children\":\".*?\".*?\})(.*)/;
  //       // const childrenReg = /,+\"children\":\[.*\]/;
  //       // const itemStr = allStr.replace(reg, '$2').replace(childrenReg, '');
  //       const str = allStr.replace(reg, '$2');
  //       selectedList.push({
  //         perId: str.replace(/(.*?\"key\":\")(.*?\")(.*)/, "$2").slice(0, -1),
  //         name: str.replace(/(.*?\"label\":\")(.*?\")(.*)/, "$2").slice(0, -1),
  //         mobilePhone: str.replace(/(.*?\"mobilePhone\":\")(.*?\")(.*)/, "$2").slice(0, -1),
  //         idCardNo: str.replace(/(.*?\"idCardNo\":\")(.*?\")(.*)/, "$2").slice(0, -1)
  //       });
  //       this.setState({
  //         selectedList
  //       });
  //       // try {
  //       //   // 转成对应的格式
  //       //   // const item = JSON.parse(itemStr);
          
  //       // }catch (ex) {
  //       //   console.log(ex);
  //       // }
  //     }
  //   });
  //   $loading.close();
  // }
  render() {
    // const close = () => {
    //   this.setState({ visible: false });
    // };
    const { selectedList } = this.state;
    return (
      <div>
        <Modal
          title={this.props.title || "选择人员"}
          wrapClassName="PartmentSelect"
          closable={false}
          visible={this.state.visible}
          okText={this.props.okText || '确定'}
          cancelText={this.props.cancelText || '取消'}
          onOk={() => {
            this.props.onOk && this.props.onOk(selectedList);
          }}
          onCancel={() => {
            this.props.onCancel && this.props.onCancel(selectedList);
          }}
          width={700}
        >
          {
            this.state.type == 'checkbox' && this.props.fetchType != 'task' &&
            <p style={{color: '#ff4d4f', marginBottom: 0, marginTop: '-10px'}}>注：勾选部门只能选中该部门层级的人，该部门下级部门的人员需要单独勾选。</p>
          }
          {
            this.state.type == 'checkbox' && this.props.fetchType == 'task' &&
            <p style={{color: '#ff4d4f', marginBottom: 0, marginTop: '-10px'}}>注：勾选部门只能选中该部门层级的人，该部门下级部门的人员需要单独勾选；驻勤人员只能选择普通保安员/武装押运人员。</p>
          }
          <div className="PartmentSelect-title">
            <h2>选择：</h2>
            <h2>已选：</h2>
          </div>
          <div className="PartmentSelect-box">
            {/* 人员列表 */}
            <PersonList
              fetchType={this.props.fetchType}
              type={this.state.type}
              value={selectedList}
              // 选择人员的回调
              onSelect={(result, perList) => {
                let { selectedList, type } = this.state;
                if (type == 'checkbox') {
                  /* 找出当前人员列表中没有选中的内容，判断储存选中项中是否有要删除的内容，并且删除 */
                  // 列表中未选中的项目(反向)
                  let unSelecteds = perList.filter(item => {
                    // 选中项中是否有该项目
                    const has = result.some(resItem => {
                      const info = JSON.parse(resItem);
                      return item.perId == info.perId;
                    });
                    return !has;
                  });
                  // 从储存的列表中删除未选中的项目
                  unSelecteds.forEach(item => {
                    const index = selectedList.findIndex(sItem => {
                      return item.perId == sItem.perId;
                    });
                    // 找到并且删除
                    index >= 0 && selectedList.splice(index, 1);
                  });

                  // 判断当前储存选中项中是否有当前选中项，没有就往里面插入
                  result.forEach(item => {
                    item = JSON.parse(item);
                    if (!selectedList.some(selected => selected.perId == item.perId)) {
                      selectedList.push(item);
                    }
                  });
                } else {
                  // 单选的情况直接替换选中列表
                  selectedList = [JSON.parse(result[0])];
                }
                this.setState({
                  selectedList
                });
              }}
              // 选择部门的回调（添加部门下的人）
              addDepart={departPers => {
                // $loading.open('数据处理中...');
                // 去重
                departPers.forEach(item => {
                  if(!selectedList.some(selected => selected.perId == item.perId)) {
                    selectedList.push(item);
                  }
                });
                this.setState({
                  selectedList
                }, () => {
                  // $loading.close();
                });
              }}
              // 删除部门下的人
              delDepart={departPers => {
                // 从储存的列表中删除未选中的项目
                  departPers.forEach(item => {
                    const index = selectedList.findIndex(sItem => {
                      return item.perId == sItem.perId;
                    });
                    // 找到并且删除
                    index >= 0 && selectedList.splice(index, 1);
                  });
                this.setState({
                  selectedList
                });
              }}
            />

            {/* 选中人员 */}
            <div className="PartmentSelect-wrap PartmentSelect-wrap-selected" style={{ overflow: 'auto' }}>
              {/* {selectedList()} */}
              {
                selectedList.map((val, i) => {
                  return (
                    <div key={val.perId} className="PartmentSelect-list-item">
                      <Icon type="user" /> {val.title || val.name}{val.idCardNo ? '(' + val.idCardNo + ')' : ''}

                      <Icon
                          style={{ cursor: 'pointer' }}
                          onClick={() => {
                            $loading.open('数据处理中...');
                            let { selectedList } = this.state;
                            const index = selectedList.findIndex(sItem => {
                              return val.perId == sItem.perId;
                            });
                            index >= 0 && selectedList.splice(index, 1);
                            this.setState({
                              selectedList
                            });
                            $loading.close();
                          }}
                          type="close-circle-o"
                        />
                      {/* {
                        this.state.type == 'checkbox' &&
                        
                      } */}
                    </div>
                  );
                })
              }
            </div>
          </div>
        </Modal>
      </div>
    );
  }
}
