import React from 'react';
import PropTypes from 'prop-types';
import Drawer from './drawer/drawer';
import style from 'styled-components';
import {Button} from 'antd';

export default class PDrawer extends React.Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      zIndex: 11,
      visible: false,
    }
    this.shade = null;//遮罩层对象
  }

  /******************************生命周期******************************/

  static defaultProps = {
    onOk: new Function,
    onCancel: new Function,
    okText: "确认",
    cancelText: "返回",
    width: 600,//抽屉宽度
    footer: undefined,
    drawer: {}
  }

  static propTypes = {
    onOk: PropTypes.func,//点击确定回调
    onCancel: PropTypes.func,//取消按钮的回调
    zIndex: PropTypes.number,//设置 Draw 的 z-index
    width: PropTypes.number,//设置 Draw 的 z-index
    okText: PropTypes.string,//确认按钮文字,设置为null的时候不加载
    cancelText: PropTypes.string,//取消按钮文字,设置为null的时候不加载
    footer: PropTypes.element,//底部内容，当不需要默认底部按钮时，可以设为null
    footBtns: PropTypes.array,//底部按钮多个按钮设置对象设置
    destroyOnClose: PropTypes.bool,//关闭时销毁 Drawer 里的子元素
    drawer: PropTypes.object,//drawer 配置，参考 drawer插件
  }


  componentWillMount = () => {
    this.init();
  }
  componentDidMount = () => {

  }

  componentWillReceiveProps = (nextProps, newState) => {
    const {zIndex, visible} = nextProps;
    const thisZIndex = this.props.zIndex;
    const thisvisible = this.props.visible;

    if (visible != thisvisible) {
      this.setState({visible}, () => {
        this.switchShadeModel(visible);
      });
    }

  }

  componentWillUnmount = () => {
    const node = document.getElementById('ShadeDrawer');
    if (node) {
      document.body.removeChild(node);
    }
  }
//初始化
  init = () => {
    const {zIndex, visible} = this.props;
    this.buildShade();
    if (zIndex) {
      this.setState({zIndex});
    }
    if (visible) {
      this.setState({visible});
    }
  }

//切换遮罩层模式
  switchShadeModel = (visible) => {
    if (visible) {
      this.showShade();
    } else {
      this.hideShade();
    }
  }

//隐藏遮罩层
  hideShade = () => {
    if (this.shade) {
      this.shade.style.display = "none";
    }
  }
//展示遮罩层
  showShade = () => {
    if (this.shade) {
      this.shade.style.display = "block";
    }
  }

//生成遮罩层
  buildShade = () => {
    const {zIndex} = this.state;
    this.shade = document.getElementById('ShadeDrawer');
    if (this.shade) {
      return;
    } else {
      this.shade = document.createElement('div');
      this.shade.id = "ShadeDrawer";
      this.shade.style.cssText = `width: 100%;height: 100%;position: fixed;top: 0;left: 0;background: rgba(0,0,0,0.3);z-index:${zIndex - 1};display:none`
      document.body.appendChild(this.shade);
    }
  }


  /******************************render******************************/
  renderFooterBtns = () => {
    const {footer} = this.state;
    const {
      onOk,
      onCancel,
      okText,
      cancelText,
    } = this.props;

    if (footer === undefined) {
      return (
        <DrawBottomBtns>
          {cancelText !== null && <Button onClick={onCancel}>{cancelText}</Button>}
          {okText !== null && <Button type="primary" onClick={onOk}>{okText}</Button>}
        </DrawBottomBtns>
      );
    }
    if (footer) {
      return (
        <DrawBottomBtns>
          {footer}
        </DrawBottomBtns>
      );
    }

  }

  render() {
    const {zIndex, visible} = this.state;
    const {
      title,
      width,
      destroyOnClose,
      drawer
    } = this.props;

    const defaultConfig = {
      right: true,
      open: visible,
      width: width,
      className: "drawer-box",
      noTouchOpen: true,
      noTouchClose: true,
      zIndex: zIndex,
    };

    return (
      <div>
        <Drawer
          {...defaultConfig}
          {...drawer}
        >
          {(!destroyOnClose || visible ) && (
            <div>
              {title && <DrawHeader>{title}</DrawHeader>}
              {this.props.children}
              {/*底部按钮*/}
              {this.renderFooterBtns()}
            </div>
          )}

        </Drawer>
      </div>
    );
  }
}


//标题栏
const DrawHeader = style.div`
  font-size: 18px;
  color: #333333;
  line-height: 21px;
  padding:19px;
  border-bottom:1px solid #E9E9E9;
  text-align: center;
`;

//底部按钮
const DrawBottomBtns = style.div`
 height:61px;
 border-top:1px solid #E9E9E9;
 position: fixed;
 bottom: 0px;
 width: 100%;
 display: flex;
 justify-content: flex-start;
 padding-left: 42px;
 justify-items: center;
 align-items: center;
 background:#fff;
 button{
  margin-right:8px
 }
`;
