import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const InsurancePreservation = app => {
  return {
    name: '保全缴费',
    icon: 'wallet',
    path: 'insurancePreservation',
    component: dynamicWrapper(app, ['insurance'], () =>
      import('../routes/Insurance/InsuranceManagement/InsurancePreservation')
    )
  };
};