import React, { Component } from 'react';
import { connect } from 'dva';
import { Button, Drawer, Form, Input, Tooltip, Cascader } from 'antd';
import PSelect from '../../../../components/Pro/PSelect';
import { getBayzgzSbInfoById, getDistrictData, enterpriseComContractGetComContractById, publicCommonFileFilePreview } from '../../../../services/api';
import PFromUpload from '../../../../components/Pro/PFromUpload';
const formItemLayout = {
  labelCol: {
    xs: {
      span: 24
    },
    sm: {
      span: 7
    }
  },
  wrapperCol: {
    xs: {
      span: 24
    },
    sm: {
      span: 20
    },
    md: {
      span: 16
    }
  }
};
@connect(state => ({
  companyInfo: state.global.companyInfo
}))
@Form.create()
export default class NotSubmitted extends Component {
  constructor(props) {
    super(props);
    this.state = {
      comName: this.props.companyInfo.comName,
      openEdit: this.props.visible,
      bayzgzSbId: null,
      perInfo: [], //人员信息
      areas: [], //省市区,
      key: Math.random()
    };
  }
  componentWillMount() {
    // this.__getDistrict();
  }
  componentDidMount() { }
  componentWillReceiveProps(nextProps) {
    this.setState({
      openEdit: nextProps.visible,
      bayzgzSbId: nextProps.value
    });
    // if (this.state.openEdit !== nextProps.visible && this.state.bayzgzSbId !== nextProps.value && nextProps.visible) {
    if (this.state.openEdit !== nextProps.visible && nextProps.visible) {
      //处理事件
      this._getBayzgzSbInfoById(nextProps.value);
    }
  }

  _getBayzgzSbInfoById(bayzgzSbId) {
    getBayzgzSbInfoById({ bayzgzSbId }).then(res => {
      if (res.retType === '0') {
        this.setState(
          {
            perInfo: res.data,
            key: Math.random()
          },
          () => { }
        );
      }
      const { comContractId } = res.data;
      if (!!comContractId) {
        enterpriseComContractGetComContractById({ comContractId }).then(result => {
          if (result.data) {
            if (typeof result.data.effectStartDate == 'string') {
              result.data.effectStartDate = result.data.effectStartDate.split(' ')[0];
            } else {
              result.data.effectStartDate = '';
            }
            if (typeof result.data.effectEndDate == 'string') {
              result.data.effectEndDate = result.data.effectEndDate.split(' ')[0];
            } else {
              result.data.effectEndDate = '';
            }
            this.setState({
              contracInfo: result.data
            });
          }
        });
      }
    });
  }
  render() {
    const { getFieldDecorator } = this.props.form;
    const { contracInfo } = this.state;
    return (
      <Drawer
        title="报名详情"
        width={600}
        closable={false}
        onClick={this.props.close}
        visible={this.state.openEdit}
      >
        {/* form表单 */}
        <Form style={{ marginBottom: '50px' }}>
          <Form.Item {...formItemLayout} label="背景筛查">
            {getFieldDecorator('backgroundScreenStatus', {
              initialValue:
                this.state.perInfo.backgroundScreenStatus === '001'
                  ? '未筛查'
                  : this.state.perInfo.backgroundScreenStatus === '003'
                    ? '筛查通过'
                    : this.state.perInfo.backgroundScreenStatus === '004'
                      ? '筛查不通过'
                      : '未审查'
            })(<Input placeholder="" maxLength={30} disabled={true} />)}
          </Form.Item>
          <Form.Item {...formItemLayout} label="审批状态">
            {getFieldDecorator('approvalStatus', {
              initialValue:
                this.state.perInfo.approvalStatus === '001'
                  ? '未提交'
                  : this.state.perInfo.approvalStatus === '002'
                    ? '待审批'
                    : this.state.perInfo.approvalStatus === '003'
                      ? '审批通过'
                      : this.state.perInfo.approvalStatus === '004'
                        ? '审批不通过'
                        : this.state.perInfo.approvalStatus === '005'
                          ? '审批中'
                          : this.state.perInfo.approvalStatus
            })(<Input placeholder="" maxLength={30} disabled={true} />)}
          </Form.Item>
          <div
            style={{
              display:
                this.state.perInfo.approvalStatus === '004' ? 'block' : 'none'
            }}
          >
            <Form.Item {...formItemLayout} label="审批不通过原因">
              {getFieldDecorator('approvalreason', {
                initialValue: this.state.perInfo.approvalreason
                  ? this.state.perInfo.approvalreason
                  : '-'
              })(<Input placeholder="" maxLength={30} disabled={true} />)}
            </Form.Item>
          </div>
          <Form.Item {...formItemLayout} label="缴费状态">
            {getFieldDecorator('payStatus', {
              initialValue:
                this.state.perInfo.payStatus === '0'
                  ? '未缴费'
                  : this.state.perInfo.payStatus === '1'
                    ? '已缴费'
                    : '未缴费'
            })(<Input placeholder="" maxLength={30} disabled={true} />)}
          </Form.Item>
          <Form.Item {...formItemLayout} label="考试安排">
            {getFieldDecorator('isArrangeExam', {
              initialValue:
                this.state.perInfo.isArrangeExam === '0'
                  ? '未安排'
                  : this.state.perInfo.isArrangeExam === '1'
                    ? '已安排'
                    : '未安排'
            })(<Input placeholder="" maxLength={30} disabled={true} />)}
          </Form.Item>
          <Form.Item {...formItemLayout} label="考试结果">
            {getFieldDecorator('examResult', {
              initialValue:
                this.state.perInfo.examResult === '0'
                  ? '考试不通过'
                  : this.state.perInfo.examResult === '1'
                    ? '考试通过'
                    : '未考试'
            })(<Input placeholder="" maxLength={30} disabled={true} />)}
          </Form.Item>
          <Form.Item {...formItemLayout} label="理论成绩">
            {getFieldDecorator('writtenScore', {
              initialValue: this.state.perInfo.writtenScore
                ? this.state.perInfo.writtenScore
                : '-'
            })(<Input placeholder="" maxLength={30} disabled={true} />)}
          </Form.Item>
          <Form.Item {...formItemLayout} label="实操成绩">
            {getFieldDecorator('operateScore', {
              initialValue: this.state.perInfo.operateScore
                ? this.state.perInfo.operateScore
                : '-'
            })(<Input placeholder="" maxLength={30} disabled={true} />)}
          </Form.Item>
          <h3>报名基础信息</h3>
          <Form.Item {...formItemLayout} label="所属企业">
            {getFieldDecorator('comName', {
              initialValue: this.state.comName
            })(<Input placeholder="" maxLength={30} disabled={true} />)}
          </Form.Item>
          <Form.Item {...formItemLayout} label="姓名">
            {getFieldDecorator('name', {
              initialValue: this.state.perInfo.name
            })(<Input placeholder="" maxLength={30} disabled={true} />)}
          </Form.Item>
          <Form.Item {...formItemLayout} label="手机号码">
            {getFieldDecorator('mobilePhone', {
              initialValue: this.state.perInfo.mobilePhone
            })(<Input placeholder="" maxLength={30} disabled={true} />)}
          </Form.Item>
          <Form.Item {...formItemLayout} label="身份证号">
            {getFieldDecorator('idCardNo', {
              initialValue: this.state.perInfo.idCardNo
            })(<Input placeholder="" maxLength={30} disabled={true} />)}
          </Form.Item>
          <Form.Item {...formItemLayout} label="出生年月">
            {getFieldDecorator('birthday', {
              initialValue: this.state.perInfo.birthday
            })(<Input placeholder="" maxLength={30} disabled={true} />)}
          </Form.Item>
          <Form.Item {...formItemLayout} label="性别">
            {getFieldDecorator('sex', {
              initialValue: this.state.perInfo.sex === '1' ? '男' : '女'
            })(<Input placeholder="" maxLength={30} disabled={true} />)}
          </Form.Item>
          <Form.Item {...formItemLayout} label="身高(cm)">
            {getFieldDecorator('height', {
              initialValue: this.state.perInfo.height
            })(<Input placeholder="" disabled disabled={true} />)}
          </Form.Item>
          <Form.Item {...formItemLayout} label="民族">
            {getFieldDecorator('nation', {
              initialValue: this.state.perInfo.nation
            })(<PSelect type="nation" disabled />)}
          </Form.Item>
          <Form.Item {...formItemLayout} label="文化程度">
            {getFieldDecorator('education', {
              initialValue: this.state.perInfo.education
            })(
              // <Input
              //   placeholder=""
              //   maxLength={30}
              //   disabled={true}
              // />
              <PSelect type="education" disabled />
            )}
          </Form.Item>
          <Form.Item {...formItemLayout} label="户籍地址">
            {getFieldDecorator('residenceFullAddress', {
              initialValue: this.state.perInfo.residenceFullAddress
            })(
              <Tooltip placement="top" title={<span>{this.state.perInfo.residenceFullAddress}</span>}>
                <Input placeholder={this.state.perInfo.residenceFullAddress} disabled={true} />
              </Tooltip>
            )}
          </Form.Item>
          <Form.Item {...formItemLayout} label="现住地址">
            {getFieldDecorator('domicileFullAddress', {
              initialValue: this.state.perInfo.domicileFullAddress
            })(
              // <Cascader
              //   options={this.state.areas}
              //   placeholder=''
              //   disabled
              // />
              <Tooltip placement="top" title={<span>{this.state.perInfo.domicileFullAddress}</span>}>
                <Input placeholder={this.state.perInfo.domicileFullAddress} maxLength={30} disabled={true} />
              </Tooltip>
            )}
          </Form.Item>
          {/* <Form.Item {...formItemLayout} label="办事区域">
            {getFieldDecorator('contractName', {
              // initialValue: this.state.perInfo.contractName,
            })(
              <Input
                placeholder="请输入"
                disabled={this.state.editable}
                maxLength={30}
                disabled={true}
              />
            )}
          </Form.Item> */}
          <div>
            {this.state.perInfo.bayFamilyMemberDtoList &&
              this.state.perInfo.bayFamilyMemberDtoList.map((item, index) => {
                const current = index + 1;
                return (
                  <div>
                    <Form.Item
                      {...formItemLayout}
                      label={'家庭成员' + current + '姓名'}
                    >
                      {getFieldDecorator('name', {
                        initialValue: item.name
                      })(
                        <Input placeholder="" maxLength={30} disabled={true} />
                      )}
                    </Form.Item>
                    <Form.Item
                      {...formItemLayout}
                      label={'家庭成员' + current + '关系'}
                    >
                      {getFieldDecorator('relation', {
                        initialValue: item.relation
                      })(
                        <Input placeholder="" maxLength={30} disabled={true} />
                      )}
                    </Form.Item>
                    <Form.Item
                      {...formItemLayout}
                      label={'家庭成员' + current + '身份证号'}
                    >
                      {getFieldDecorator('idCardNo', {
                        initialValue: item.idCardNo
                      })(
                        <Input placeholder="" maxLength={30} disabled={true} />
                      )}
                    </Form.Item>
                    <Form.Item
                      {...formItemLayout}
                      label={'家庭成员' + current + '手机号码'}
                    >
                      {getFieldDecorator('contactPhone', {
                        initialValue: item.contactPhone
                      })(
                        <Input placeholder="" maxLength={30} disabled={true} />
                      )}
                    </Form.Item>
                  </div>
                );
              })}
          </div>
          <div>
            {this.state.perInfo.bayWorkExperienceDtoList &&
              this.state.perInfo.bayWorkExperienceDtoList.map((item, index) => {
                const current = index + 1;
                return (
                  <div>
                    <Form.Item
                      {...formItemLayout}
                      label={'工作经历' + current + '企业名称'}
                    >
                      {getFieldDecorator('comName', {
                        initialValue: item.comName
                      })(
                        <Tooltip placement="top" title={<span>{item.comName}</span>}>
                          <Input placeholder={item.comName} maxLength={30} disabled={true} />
                        </Tooltip>
                      )}
                    </Form.Item>
                    <Form.Item
                      {...formItemLayout}
                      label={'工作经历' + current + '职务'}
                    >
                      {getFieldDecorator('position', {
                        initialValue: item.position
                      })(
                        <Tooltip placement="top" title={<span>{item.position}</span>}>
                          <Input placeholder={item.position} maxLength={30} disabled={true} />
                        </Tooltip>
                      )}
                    </Form.Item>
                    <Form.Item
                      {...formItemLayout}
                      label={'工作经历' + current + '工作内容'}
                    >
                      {getFieldDecorator('workContent', {
                        initialValue: item.workContent
                      })(
                        <Tooltip placement="top" title={<span>{item.workContent}</span>}>
                          <Input placeholder={item.workContent} maxLength={30} disabled={true} />
                        </Tooltip>
                      )}
                    </Form.Item>
                    <Form.Item
                      {...formItemLayout}
                      label={'工作经历' + current + '入职时间'}
                    >
                      {getFieldDecorator('entryDate', {
                        initialValue: item.entryDate
                      })(
                        <Input placeholder="" maxLength={30} disabled={true} />
                      )}
                    </Form.Item>
                    <Form.Item
                      {...formItemLayout}
                      label={'工作经历' + current + '离职时间'}
                    >
                      {getFieldDecorator('leaveDate', {
                        initialValue: item.leaveDate
                      })(
                        <Input placeholder="" maxLength={30} disabled={true} />
                      )}
                    </Form.Item>
                    <Form.Item
                      {...formItemLayout}
                      label={'工作经历' + current + '离职原因'}
                    >
                      {getFieldDecorator('leaveReason', {
                        initialValue: item.leaveReason
                      })(
                        <Tooltip placement="top" title={<span>{item.leaveReason}</span>}>
                          <Input placeholder={item.leaveReason} maxLength={30} disabled={true} />
                        </Tooltip>
                      )}
                    </Form.Item>
                  </div>
                );
              })}
          </div>
          {
            contracInfo &&
            <>
              <h3>合同信息</h3>
              <Form.Item {...formItemLayout} label="合同名称">
                {getFieldDecorator('contractName', {
                  initialValue: contracInfo.contractName
                })(<Input placeholder="" maxLength={30} disabled={true} />)}
              </Form.Item>
              <Form.Item {...formItemLayout} label="有效期">
                {getFieldDecorator('effectStartDate', {
                  initialValue: `${contracInfo.effectStartDate}~${contracInfo.effectEndDate}`
                })(<Input placeholder="" maxLength={30} disabled={true} />)}
              </Form.Item>
              <Form.Item {...formItemLayout} label="合同文件">
                <a
                  onClick={() => {
                    if (contracInfo.contractUrl) {
                      publicCommonFileFilePreview({
                        url: contracInfo.contractUrl,
                        isLoad: '1'
                      })
                        .then(data => {
                          if (data.data) {
                            window.open(data.data);
                          }
                        });
                    } else {
                      notification.warning({
                        message: '该合同未上传附件！',
                        description: '请先上传合同文件，方可查看。'
                      });
                    }
                  }}
                >
                  点击查看
              </a>
                <a
                  style={{ marginLeft: 15 }}
                  href={contracInfo.contractUrl}
                  target="_blank"
                  download
                >
                  点击下载
              </a>
                {/* {getFieldDecorator('contractUrl' , {
                initialValue: info.contractUrl
              })(
                <PFromUpload
                  key={moment().valueOf()}
                  disabled={true}
                  num={1}
                  disabled
                />
              )} */}
              </Form.Item>
            </>
          }
          <h3>图像信息</h3>
          <Form.Item {...formItemLayout} label="一寸彩色照">
            {getFieldDecorator('colourPhotoUrl', {
              initialValue: this.state.perInfo.colourPhotoUrl
            })(
              <PFromUpload
                key={this.state.key}
                disabled={true}
                num={1}
                disabled
              />
            )}
          </Form.Item>
          <Form.Item {...formItemLayout} label="身份证人像面">
            {getFieldDecorator('idCardFrontUrl', {
              initialValue: this.state.perInfo.idCardFrontUrl
            })(
              <PFromUpload
                key={this.state.key}
                disabled={true}
                num={1}
                disabled
              />
            )}
          </Form.Item>
          <Form.Item {...formItemLayout} label="身份证国徽面">
            {getFieldDecorator('idCardReverseUrl', {
              initialValue: this.state.perInfo.idCardReverseUrl
            })(
              <PFromUpload
                key={this.state.key}
                disabled={true}
                num={1}
                disabled
              />
            )}
          </Form.Item>
          <Form.Item {...formItemLayout} label="初中以上学历证明原件">
            {getFieldDecorator('eduCerUrl', {
              initialValue: this.state.perInfo.eduCerUrl
            })(
              <PFromUpload
                key={this.state.key}
                disabled={true}
                num={1}
                disabled
              />
            )}
          </Form.Item>
          <Form.Item
            {...formItemLayout}
            label={
              <span>
                <div>县级以上医院出具的</div>
                <span>体检证明</span>
              </span>
            }
          >
            {getFieldDecorator('hospitalExamProveUrl', {
              initialValue: this.state.perInfo.hospitalExamProveUrl
            })(<PFromUpload key={this.state.key} disabled={true} />)}
          </Form.Item>
        </Form>

        {/* 底部提交按钮 */}
        <div
          style={{
            position: 'absolute',
            bottom: 0,
            width: '100%',
            borderTop: '1px solid #e8e8e8',
            padding: '10px 16px',
            textAlign: 'right',
            left: 0,
            background: '#fff',
            borderRadius: '0 0 4px 4px'
          }}
        >
          <Button
            style={{
              marginRight: 8
            }}
            onClick={this.props.close}
          >
            返回
          </Button>
        </div>
      </Drawer>
    );
  }
}
