import React, { Component } from "react";
import {
  Button,
  Form,
  Input,
  // Cascader,
  TreeSelect,
  Select
} from "antd";
import { systemComDepartGetTreeDepart } from '../../../../services/api';
const { Option } = Select;
@Form.create()
export default class Messages extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      treeData: [  // 部门数据
        //树
        { title: '', key: '' }
      ],
    };
  }
  componentDidMount() {
    this.props.onSearch(this.props.form.getFieldsValue());
    this._getDepart();
  }
  //获取部门树数据
  _getDepart = (cb) => {
    //获取部门树数据
    systemComDepartGetTreeDepart().then(
      response => {
        // $log(response, 'blue');
        let { data } = response;
        data = JSON.parse(
          JSON.stringify(data).replace(/\"children\":\[\]/g, '"isLeaf":true')
          .replace(/\"label\":/g, '"title":')
        );
        data.unshift({
          title: '全部',
          value: ''
        });
        this.setState({
          treeData: data
        }, () => {
          cb&&cb();
        });
      }
    );
  }
  _search = (e) => {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      // 搜索的时候重置为第一页
      values.pageNumber = 1;
      this.props.onSearch(values);
    });
  }
  _reset = () => {
    this.props.form.resetFields();
    const data = this.props.form.getFieldsValue();
    this.props.onSearch(data);
  }
  render() {
    const { getFieldDecorator } = this.props.form;
    return (
      <Form layout="inline" onSubmit={this._search}>
        <Form.Item label="关键词">
          {getFieldDecorator('keyWord', {
            initialValue: ''
          })(
            <Input placeholder="请输入姓名/手机号码/身份证" />
          )}
        </Form.Item>
        <Form.Item label="部门">
          {getFieldDecorator('departId', {
            initialValue: ''
          })(
            <TreeSelect
              style={{ width: 240 }}
              className="w-400 ipt-h"
              dropdownStyle={{ maxHeight: 250, overflow: 'auto' }}
              treeData={this.state.treeData}
              placeholder="请选择部门"
              treeDefaultExpandAll
              // value={this.state.departId}
              onChange={value => {
                this.setState({
                  departId: value
                });
              }}
            />
          )}
        </Form.Item>
        <Form.Item label="认证状态">
          {getFieldDecorator('authStatus', {
            initialValue: ''
          })(
            <Select
              style={{ width: 120 }}
              placeholder="请选择"
            >
              <Option value="">全部</Option>
              <Option value="0">未认证</Option>
              <Option value="1">已认证</Option>
              <Option value="2">认证中</Option>
              <Option value="3">认证失败</Option>
              {/* <Option value="">全部</Option>
              <Option value="0">未认证</Option>
              <Option value="1">已持证</Option> */}
            </Select>
          )}
        </Form.Item>
        <Form.Item label="合同状态">
          {getFieldDecorator('isRelationContract', {
            initialValue: ''
          })(
            <Select
              style={{ width: 120 }}
              placeholder="请选择"
            >
              <Option value="">全部</Option>
              <Option value="0">未关联</Option>
              <Option value="1">已关联</Option>
            </Select>
          )}
        </Form.Item>
        <Form.Item label="学时状态">
          {getFieldDecorator('isFinishLearn', {
            initialValue: ''
          })(
            <Select
              style={{ width: 120 }}
              placeholder="请选择"
            >
              <Option value="">全部</Option>
              <Option value="0">未完成</Option>
              <Option value="1">已完成</Option>
            </Select>
          )}
        </Form.Item>

        <Form.Item label=" " colon={false}>
          <Button type="primary" onClick={this._search}>搜索</Button>
        </Form.Item>
        <Form.Item label=" " colon={false}>
          <Button onClick={this._reset}>重置</Button>
        </Form.Item>

      </Form>
    );
  }
}
