import React, { Component } from "react";
import { qualify_appealOrg } from '../../../../services/bkt/qualify';

import {
  Input,
  Cascader,
  Form
} from "antd";
const formItemLayout = {
  labelCol: { span: 6 },
  wrapperCol: { span: 14 },
};
@Form.create()
export default class AppealModal extends Component {
  constructor(props) {
    super(props);
    this.state = {
      options: []
    }
  }
  componentWillMount() {
    this._getAppealOrg();
  }
  componentDidMount() {
    this.props.onGetForm && this.props.onGetForm(this.props.form);
  }
  _getAppealOrg = (parentOrgId = '', cb) => {
    const { personApplyId } = this.props;
    qualify_appealOrg({ data: { parentOrgId, personApplyId } }).then(res => {
      if (!parentOrgId) {
        const options = res.data.map(item => {
          return {
            ...item,
            value: `${item.id} ${item.orgName} ${item.areaCode} ${false}`,
            label: item.area,
            isLeaf: false
          };
        });
        this.setState({
          options
        });
      }
      cb && cb(res.data);
    });
  }
  _loadData = selectedOptions => {
    const targetOption = selectedOptions[selectedOptions.length - 1];
    // if(targetOption.isLeaf) {
    //   return;
    // }
    targetOption.loading = true;
    this._getAppealOrg(targetOption.id, children => {
      targetOption.loading = false;
      if (children.length > 0) {
        targetOption.children = children.map(item => {
          let label = ('' + targetOption.areaCode).slice(4) == '00' ? item.area : item.orgName;
          const isLeaf = ('' + targetOption.areaCode).slice(4) != '00';
          return {
            ...item,
            value: `${item.id} ${item.orgName} ${item.areaCode} ${isLeaf}`,
            label,
            isLeaf
          };
        });
      } else {
        targetOption.children = '';
      }
      this.setState({
        options: [...this.state.options],
      });
    });
  }

  render() {
    const { getFieldDecorator } = this.props.form;
    return (
      <Form layout="horizontal" onSubmit={this._search}>
        <Form.Item {...formItemLayout} label="申诉内容">
          {getFieldDecorator('appealContext', {
            initialValue: '',
            rules: [
              {
                required: true,
                message: '请填写申诉内容'
              }
            ]
          })(
            <Input.TextArea rows={3} placeholder="请输入根据政审实际情况填写申诉内容，公安人员会进一步核实情况并处理。" />
          )}
        </Form.Item>
        <Form.Item {...formItemLayout} label="申诉机构">
          {getFieldDecorator('appealInfoArr', {
            initialValue: '',
            rules: [
              {
                required: true,
                message: '请选择申诉机构'
              }
            ]
          })(
            <Cascader
              options={this.state.options}
              loadData={this._loadData}
              changeOnSelect
              placeholder="请选择申诉机构"
              // onChange={(value, selectedOptions) => {
              //   console.log(value, selectedOptions);
                
              //   const values = this.props.form.getFieldsValue();
              //   console.log(values);
              //   this.props.onChangeValue(values);
              // }}
            />
          )}
        </Form.Item>
      </Form>
    );
  }
}
