// 新增报名页面
import React, { Component } from 'react';
import style from 'styled-components';
import moment from 'moment';
import { connect } from 'dva';
import {
  Breadcrumb,
  Alert,
  Form,
  Row,
  Col,
  Input,
  InputNumber,
  Table,
  message,
  Button,
  Modal,
  Select,
  Cascader,
  DatePicker
} from 'antd';
import { Link } from 'dva/router';

import {
  getBayDjzBaseInfo,
  getBayBaseInfo,
} from '../../../../services/api';
import PFromUpload from '../../../../components/Pro/PFromUpload';
import PSelect from '../../../../components/Pro/PSelect';
import { withRouter } from 'dva/router';
import { gup } from '../../../../utils/utils';
import {
  // validateExistsPersonApply,  // 验证保安员是否已经等级证报名【等级证】
  trainGradeApplyPersonApply, // 等级证新增报名
} from '../../../../services/bkt/apis';
import $perModal from '../../../../utils/modal/perModal';
import ImageFormItem from '../../../../components/form/PerImgFormItem';
import OnceButton from '../../../../components/form/OnceButton';
import ContranctModal from '../../../../components/contranct/SelectContactByPerId';
import { formItemLayout, formLayout, formLayout1, formLayout2 } from './formLayout';
import { contranctCol, familyCol, workCol } from './columns';

const { Option } = Select;
const dateFormat = 'YYYY-MM-DD';
const photoItemLayout = {
  labelCol: {
    xl: {
      span: 12
    },
    xxl: {
      span: 8
    }
  },
  wrapperCol: {
    xl: {
      span: 12
    },
    xxl: {
      span: 16
    }
  }
};
@connect(state => ({
  companyInfo: state.global.companyInfo
}))
@Form.create()
@withRouter
export default class AddCertificate extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      isAddOrEdit: true, //编辑或者是新增页面（true是新增，false是编辑，默认是新增页面）
      selectedPersonType: '',  //当前选中人员类型
      perInfo: {},  //saas返回的人员信息（保安资格证信息）
      buttonStatus: false, //提交按钮是否置灰
      clicked: false,  //按钮是否点击，点击以后校验字段
      key: 0, //用来重置图片的路径用
      // contractList: [],
      // 合同更新
      forceUpdate: false,
      // 合同列表模态框
      contractModal: false,
      // 选中的合同id
      comContractList: [],
      perId: '', //选中的人员id

      checked: false,  //是否勾选报名承诺,没有勾选不让提交
    };
  }
  componentWillMount() {
    // let s = Symbol();
    const perId = gup('id');
    if (perId) {
      this.setState({
        isAddOrEdit: false
      });
      this._getPersonInfo(perId);
    }
    this._getAgentInfo();
  }
  componentDidMount() {
    // $perModal({
    //   title:"哈哈",
    //   fetchType: 'task',
    //   // type: 'radio',
    //   value:'620611950023278592,698105805555105792,694854025438298112',
    //   onOk: (value, close) => {
    //     console.log(value);
    //     close();
    //   }
    // });
  }
  //获取人员信息
  _getPersonInfo(perId) {
    return getBayDjzBaseInfo({ perId }).then(res => {
      const setInfo = () => {
        this.setState({
          perInfo: {
            ...this.state.perInfo,
            ...res.data
          },
          perId
        });
      }
      setInfo();
      // 编辑的时候初始化
      // if (init) {
      //   return setInfo();
      // }
      // const { licenceDate } = res.data;
      // const oneYearAfter = moment(''+licenceDate).add(1, 'years').valueOf();
      // const today = moment().valueOf();
      // 发证日期一年以后大于今天，为未满一年.2020-03-13王总说去掉
      // if(oneYearAfter > today) {
      //   this.setState({
      //     visibleuser: false
      //   });
      //   return Modal.error({
      //     title: '保安等级证申报需已持保安资格证满1年及以上才可申报。',
      //     okText: '确定'
      //   });
      // }
      // 验证保安员是否已经等级证报名
      // validateExistsPersonApply({ perId }).then(() => {
      //   setInfo();
      // });
    });
  }

  // 获取代理人信息
  _getAgentInfo = () => {
    return getBayBaseInfo().then(res => {
      this.setState({
        agentInfo: res.data
      });
    })
  }
  //提交（跟提交并添加）
  _submit = (e, type) => {
    this.setState({
      clicked: true
    });
    e && e.preventDefault();
    this.props.form.validateFields((err, values) => {
      if (err) return;

      const { perId } = this.state;
      if (!perId) {
        Modal.error({
          title: '请先选择人员',
          okText: '确定'
        });
        return;
      }
      const { comContractId } = this.state.comContractList[0] || {};
      if (!comContractId) {
        Modal.error({
          title: '需关联一份有效期为1年以上的合同。',
          okText: '确定'
        });
        return;
      }
      values.perCerId = this.state.perInfo.perCerId;
      values.perId = perId;
      values.comContractId = comContractId;
      this.setState({ buttonStatus: true });
      trainGradeApplyPersonApply({ data: values }).then(res => {
        this.setState({
          buttonStatus: false
        });
        // 提交并继续提交
        if (type == 1) {
          Modal.success({
            title: '提交成功！',
            content: '您可以在报名列表查看该人员的报名信息。',
            okText: '继续',
            onOk: () => {
              this.setState({
                comContractList: [],
                perInfo: {},
                perId: ''
              }, () => {
                this.props.form.resetFields();
                this.setState({
                  key: Math.random(),
                  clicked: false
                });
              });
            }
          });
        } else {
          Modal.success({
            title: '提交成功！',
            content: '您可以在报名列表查看该人员的报名信息。',
            okText: '确定',
            onOk: () => {
              this.setState({ clicked: false });
              this.props.history.replace('/PoliceDeclare/grade-certificate');
            }
          });

        }
      }).catch(() => {
        this.setState({
          buttonStatus: false
        });
      });


    });

  }
  //验证手机号码
  _checkPhone = (rule, value, callback) => {
    if (value && !/^1[0-9]{10}$/.test(value)) {
      callback('请输入正确的手机号码！');
    } else {
      callback();
    }
  };
  //验证证件号
  _checkIdCardNo = (rule, value, callback) => {
    const { form } = this.props;
    const cardNoValue = form.getFieldValue('idCardType');
    if (
      cardNoValue === '1' &&
      value &&
      !/(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/.test(value)
    ) {
      callback('请输入正确的身份证号码！');
    } else {
      callback();
    }
  };
  //通过身份证计算出年龄
  _getAge(idCardNo) {
    const len = idCardNo.length;
    if (len == 0) {
      return '';
    } else {
      if ((len != 15) && (len != 18))//身份证号码只能为15位或18位其它不合法
      {
        return '';
      }
    }
    let strBirthday = "";
    if (len == 18)//处理18位的身份证号码从号码中得到生日和性别代码
    {
      strBirthday = idCardNo.substr(6, 4) + "/" + idCardNo.substr(10, 2) + "/" + idCardNo.substr(12, 2);
    }
    if (len == 15) {
      strBirthday = "19" + idCardNo.substr(6, 2) + "/" + idCardNo.substr(8, 2) + "/" + idCardNo.substr(10, 2);
    }
    //时间字符串里，必须是“/”
    var birthDate = new Date(strBirthday);
    var nowDateTime = new Date();
    var age = nowDateTime.getFullYear() - birthDate.getFullYear();
    //再考虑月、天的因素;.getMonth()获取的是从0开始的，这里进行比较，不需要加1
    if (nowDateTime.getMonth() < birthDate.getMonth() || (nowDateTime.getMonth() == birthDate.getMonth() && nowDateTime.getDate() < birthDate.getDate())) {
      age--;
    }
    return age;
    // if(idCardNo){
    //   const date = new Date();
    //   const year = date.getFullYear(); 
    //   const birthday_year = parseInt(idCardNo.substr(6,4));
    //   const userage= year - birthday_year;
    //   return userage
    // }else{
    //   return ''
    // }    
  }
  render() {
    const { getFieldDecorator,
      setFieldsValue,
      getFieldValue
    } = this.props.form;
    const columns = contranctCol.call(this);
    columns.push({
      title: '操作',
      dataIndex: 'op',
      key: 'op',
      render: () => {
        return (
          <a onClick={() => {
            this.setState({
              comContractList: []
            });
          }}>移除关联</a>
        )
      }
    });
    const familyColumns = familyCol.call(this);
    const workColumns = workCol.call(this);
    return (
      <Box style={{ margin: '16px 0 8px 24px' }}>
        <Breadcrumb>
          <Breadcrumb.Item>
            <Link to="/PoliceDeclare/grade-certificate">报名记录</Link>
          </Breadcrumb.Item>
          <Breadcrumb.Item>
            {this.state.isAddOrEdit ? '新增报名' : '修改报名'}
          </Breadcrumb.Item>
        </Breadcrumb>
        <Alert
          message={
            <div style={{ color: '#333' }}>
              <span>
                1、请根据页面提示完成报名信息录入，若报名数量较多的，可通知相应保安员通过App自行报名，减少管理员工作量；
              </span>
              <br />
              <span>
                2、人员若存在待提交/待审批/审批中/审批通过的报名记录，则无法再重新报名；审核不通过的需要重新提交报名申报。
              </span>
            </div>
          }
          type="warning"
          showIcon
          style={{ marginBottom: 15, marginTop: 10 }}
        />
        {/* form表单 */}
        <Form style={{ paddingRight: 15 }}>
          <div className="basic_container">
            <h3>报名基础信息</h3>
            <Row gutter={16}>
              <Col span={7}>
                <Form.Item {...formItemLayout} label="所属企业">
                  <Input
                    placeholder="请输入"
                    // maxLength={30}
                    value={this.props.companyInfo.comName}
                    disabled
                  />
                </Form.Item>
              </Col>
              <Col span={7}>
                {/* <Form.Item {...formItemLayout} label="报考性质">
                  {
                    getFieldDecorator(`xingzhi`, {
                      initialValue: '',
                      rules: [
                        {
                          required: true,
                          message: `请选择补考性质`
                        }
                      ]
                    })(
                      <Select>
                        <Option value="0">补考</Option>
                        <Option value="1">非补考</Option>
                      </Select>
                    )
                  }
                </Form.Item> */}

                <Form.Item
                  style={{ display: getFieldValue('perId') ? 'none' : 'block' }}
                  extra={<span style={{ color: 'orange' }}>
                    请从组织架构选择人员。每人仅可提交一次报名记录。
                    </span>}
                  {...formItemLayout} label={<em style={{ paddingLeft: -10 }}>
                    选择人员</em>}>
                  {getFieldDecorator('perId', {
                    rules: [
                      {
                        required: true,
                        message: '请先选择人员'
                      }
                    ]
                  })(
                    <Input
                      placeholder="点击选择人员"
                      maxLength={30}
                      readOnly
                      onClick={() => {
                        $perModal({
                          type: 'radio',
                          onOk: (values, close) => {
                            setFieldsValue({
                              perId: values[0].perId,
                              name: values[0].name,
                              mobilePhone: values[0].mobilePhone,
                              idCardNo: values[0].idCardNo
                            });
                            close();
                            // const age = this._getAge(values[0].idCardNo + '');
                            // if (age === '') {
                            //   return message.warning("该人员信息不完整");
                            // }
                            // if (age >= 19 && age <= 60) {

                            //   // // 获取保安员等级证申报的基础信息 
                            //   // this._getPersonInfo(values[0].perId).then(() => {

                            //   // });
                            // } else {
                            //   message.error("根据监管要求，保安等级证报名人员年龄要在19~60（含）之间。");
                            // }
                          }
                        });
                      }}
                    />
                  )}
                </Form.Item>
              </Col>
            </Row>

            <div style={{ display: getFieldValue('perId') ? 'block' : 'none' }}>
              <Row gutter={16}>
                <Col span={7}>
                  <Form.Item
                    extra={<span style={{ color: 'orange' }}>
                      注：支持上传1M以内的jpeg|jpg文件
                        </span>}
                    {...photoItemLayout}
                    label="两寸蓝底免冠照片"
                    style={{ marginBottom: 0 }}
                  >
                    {getFieldDecorator(`avatar`, {
                      initialValue: '',
                      rules: [
                        {
                          required: true,
                          message: `请上传一寸免冠彩照`
                        }
                      ]
                    })(
                      <PFromUpload
                        key={this.state.key}
                        num={1}
                        types={['image/jpeg', 'image/jpg']}
                        size={'1'}
                      // onChange={url => {
                      //   this.setState({
                      //     photo: {
                      //       ...this.state.photo,
                      //       colourPhotoUrl: url
                      //     }
                      //   });
                      // }}
                      />
                    )}
                  </Form.Item>
                </Col>
                <Col span={7} >


                  <Form.Item {...formItemLayout} label="姓名">
                    {getFieldDecorator('name', {
                      initialValue: this.state.perInfo.name,
                      rules: [
                        {
                          required: true,
                          message: '请输入姓名'
                        }
                      ]
                    })(<Input placeholder="请输入" disabled={true} />)}
                  </Form.Item>
                  <Form.Item {...formItemLayout} label="身份证号">
                    {getFieldDecorator('idCardNo', {
                      initialValue: this.state.perInfo.idCardNo,
                      rules: [
                        {
                          required: true,
                          message: '请输入身份证号'
                        }
                      ]
                    })(<Input placeholder="请输入" disabled={true} />)}
                  </Form.Item>
                </Col>
              </Row>
              <Row gutter={16}>
                <Col span={7}>
                  <Form.Item {...formItemLayout} label="手机号码">
                    {getFieldDecorator('mobilePhone', {
                      initialValue: this.state.perInfo.mobilePhone,
                      rules: [
                        {
                          required: true,
                          message: '请输入手机号码'
                        }
                      ]
                    })(<Input placeholder="请输入" disabled={true} />)}
                  </Form.Item>
                </Col>
                <Col span={7} >
                  <Form.Item {...formItemLayout} label="出生年月">
                    {getFieldDecorator('birthday', {
                      initialValue: this.state.perInfo.birthday
                        ? moment(this.state.perInfo.birthday, dateFormat)
                        : null,
                      rules: [
                        {
                          required: true,
                          message: '请选择出生年月'
                        }
                      ]
                    })(<DatePicker style={{ width: '100%' }} format={dateFormat} />)}
                  </Form.Item>

                </Col>
              </Row>
            </div>

            <Row gutter={16}>
              <Col span={7}>
                <Form.Item {...formItemLayout} label="性别">
                  {getFieldDecorator('sex', {
                    initialValue: this.state.perInfo.sex,
                    rules: [
                      {
                        required: true,
                        message: '请选择性别'
                      }
                    ]
                  })(
                    <Select>
                      <Option value="1">男</Option>
                      <Option value="2">女</Option>
                    </Select>
                  )}
                </Form.Item>
              </Col>
              <Col span={7} >
                <Form.Item {...formItemLayout} label="身高(cm)">
                  {getFieldDecorator('height', {
                    initialValue: this.state.perInfo.height,
                    rules: [
                      {
                        // required:
                        //   this.state.bayConfigInfo.isHeightRequired === '1'
                        //     ? true
                        //     : false,
                        message: '请输入身高'
                      }
                    ]
                  })(<InputNumber style={{ width: '100%' }} placeholder="请输入" min={1} max={300} />)}
                </Form.Item>
              </Col>

            </Row>

            <Row gutter={16}>
              <Col span={7}>
                <Form.Item {...formItemLayout} label="文化程度">
                  {getFieldDecorator('education', {
                    initialValue: this.state.perInfo.education,
                    rules: [
                      {
                        required: true,
                        message: '请选择文化程度'
                      }
                    ]
                  })(<PSelect style={{ width: '100%' }} type="education" />)}
                </Form.Item>
              </Col>
              <Col span={7} >
                <Form.Item {...formItemLayout} label="民族">
                  {getFieldDecorator('nation', {
                    initialValue: this.state.perInfo.nation,
                    rules: [
                      {
                        // required:
                        // this.state.bayConfigInfo.isNationRequired === '1'
                        //   ? true
                        //   : false,
                        message: '请选择民族'
                      }
                    ]
                  })(
                    <PSelect
                      type="nation"
                      style={{ width: '100%' }}
                    // value={nation}
                    />
                  )}
                </Form.Item>
              </Col>
            </Row>
            <Row gutter={16}>
              <Col span={7}>
                <Form.Item {...formItemLayout} label="户籍所在地">
                  {getFieldDecorator('residentPlaceType', {
                    initialValue: this.state.perInfo.residentPlaceType,
                    rules: [
                      {
                        // required:
                        //   this.state.bayConfigInfo.isResidentPlaceTypeRequired === '1'
                        //     ? true
                        //     : false,
                        message: '请选择户籍所在地'
                      }
                    ]
                  })(
                    <PSelect
                      style={{ width: '100%' }}
                      type="residentPlaceType"
                    // value={nation}
                    />
                  )}
                </Form.Item>
              </Col>
              <Col span={7} >
                <Form.Item {...formItemLayout} label="户籍类型">
                  {getFieldDecorator('residentType', {
                    initialValue: this.state.perInfo.residentType,
                    rules: [
                      {
                        // required:
                        //   this.state.bayConfigInfo.isResidentTypeRequired === '1'
                        //     ? true
                        //     : false,
                        message: '请选择户籍类型'
                      }
                    ]
                  })(
                    <PSelect
                      type="residentType"
                      style={{ width: '100%' }}
                    // value={nation}
                    />
                  )}
                </Form.Item>
              </Col>
            </Row>
            <Row gutter={16}>
              <Col span={7}>
                <Form.Item {...formItemLayout} label="户籍地址">
                  {getFieldDecorator('resident', {
                    initialValue: this.state.perInfo.residentProvince
                      ? [
                        this.state.perInfo.residentProvince,
                        this.state.perInfo.residentCity,
                        this.state.perInfo.residentArea
                      ]
                      : [],
                    rules: [
                      {
                        // required:
                        //   this.state.bayConfigInfo.isResidenceRequired === '1'
                        //     ? true
                        //     : false,
                        message: '请选择您的户籍地址!'
                      }
                    ]
                  })(
                    <Cascader
                      options={this.state.areas}
                      placeholder="请选择"
                    />
                  )}
                </Form.Item>
              </Col>
              <Col span={7} >
                <Form.Item {...formLayout2}>
                  {getFieldDecorator('residenceAddress', {
                    initialValue: this.state.perInfo.residenceAddress,
                    rules: [
                      {
                        // required:
                        //   this.state.bayConfigInfo.isResidenceRequired === '1'
                        //     ? true
                        //     : false,
                        message: '请输入户籍地址街道信息!'
                      }
                    ]
                  })(
                    <Input placeholder="户籍地址街道信息" maxLength={100} />
                  )}
                </Form.Item>
              </Col>
            </Row>
            <Row gutter={16}>
              <Col span={14}>
                <div style={{ marginTop: -20, marginBottom: -30 }}>
                  <Form.Item {...formLayout} colon={false} label=" ">
                    <span style={{ color: 'orange' }}>
                      注：地址信息请勿重复填写省市区，以免证书打印的时候出现重复。
                    </span>
                  </Form.Item>
                </div>
              </Col>
            </Row>
            <Row gutter={16}>
              <Col span={7}>
                <Form.Item {...formItemLayout} label="现住地址">
                  {getFieldDecorator('domicile', {
                    initialValue: this.state.perInfo.domicileProvince
                      ? [
                        this.state.perInfo.domicileProvince,
                        this.state.perInfo.domicileCity,
                        this.state.perInfo.domicileArea
                      ]
                      : [],
                    rules: [
                      {
                        // required:
                        //   this.state.bayConfigInfo.isDomicileRequired === '1'
                        //     ? true
                        //     : false,
                        message: '请选择您的现住地址!'
                      }
                    ]
                  })(
                    <Cascader
                      options={this.state.areas}
                      placeholder="请选择"
                    />
                  )}
                </Form.Item>
              </Col>
              <Col span={7} >
                <Form.Item {...formLayout2}>
                  {getFieldDecorator('domicileAddress', {
                    initialValue: this.state.perInfo.domicileAddress,
                    rules: [
                      {
                        // required:
                        //   this.state.bayConfigInfo.isDomicileRequired === '1'
                        //     ? true
                        //     : false,
                        message: '请输入现住地址街道信息!'
                      }
                    ]
                  })(
                    <Input placeholder="现住地址街道信息" maxLength={100} />
                  )}
                </Form.Item>
              </Col>
            </Row>
            <Row gutter={16}>
              <Col span={14}>
                <div style={{ marginTop: -20, marginBottom: -30 }}>
                  <Form.Item {...formLayout} colon={false} label=" ">
                    <span style={{ color: 'orange' }}>
                      注：地址信息请勿重复填写省市区，以免证书打印的时候出现重复。
                    </span>
                  </Form.Item>
                </div>
              </Col>
            </Row>


            <ContranctModal
              perId={getFieldValue('perId')}
              visibale={this.state.contractModal}
              onSelect={comContractList => {
                this.setState({
                  comContractList
                });
              }}
              onClose={() => {
                this.setState({
                  contractModal: false
                });
              }}
            />
            <Row>
              <Col span={24} className="miniLabelWidth">
                <Form.Item {...formItemLayout} label="合同信息">
                  {
                    getFieldDecorator('bayFamilyMemberDtoList', {
                      // initialValue: this.state.bayFamilyMemberDtoList,
                      rules: [
                        {
                          required: true,
                          message: '请选择合同!'
                        }
                      ]
                    })(
                      <>
                        <Table
                          style={{ marginTop: 10 }}
                          pagination={false}
                          dataSource={this.state.comContractList} footer={null} columns={columns}
                        />
                        <span style={{ color: 'orange', fontSize: 14 }}>
                          请关联一份有效期为1年以上且有效状态的合同；合同附件必须有员工本人亲自签名的页面，对因劳动合同真实性 （如非本人签署）问题导致的补贴申请问题由企业自行承担责任和损失，审计出现问题的追回补贴资金并接受相应处罚。
                        </span>
                        <br />
                        <Button
                          onClick={() => {
                            if (!getFieldValue('perId')) {
                              return Modal.error({ title: '您还没有选择人员！', content: '请选择人员', okText: '确定' });
                            }
                            this.setState({
                              contractModal: true
                            });
                          }}
                          type="primary">关联合同
                        </Button>
                      </>
                    )
                  }
                </Form.Item>
              </Col>
            </Row>

            <Row>
              <Col span={24} className="miniLabelWidth">
                <Form.Item {...formItemLayout} label="家庭成员">
                  {getFieldDecorator('bayFamilyMemberDtoList', {
                    // initialValue: this.state.bayFamilyMemberDtoList,
                    rules: [
                      {
                        // required:
                        //   this.state.bayConfigInfo.isFamilyRequired === '1'
                        //     ? true
                        //     : false,
                        message: '请完善家庭成员!'
                      }
                    ]
                  })(
                    <div>
                      <Table
                        dataSource={this.state.bayFamilyMemberDtoList}
                        columns={familyColumns}
                        pagination={false}
                      />
                      <Button
                        type="primary"
                        onClick={() => {
                          this.$add(
                            'bayFamilyMemberDtoList',
                            'familyMemberId'
                          );
                        }}
                      >
                        + 添加一条记录
                        </Button>
                    </div>
                  )}
                </Form.Item>
              </Col>
              <Col span={24} className="miniLabelWidth">
                <Form.Item {...formItemLayout} label="工作经历">
                  {getFieldDecorator('bayWorkExperienceDtoList', {
                    // initialValue: this.state.bayWorkExperienceDtoList,
                    rules: [
                      {
                        // required:
                        //   this.state.bayConfigInfo.isWorkExpRequired === '1'
                        //     ? true
                        //     : false,
                        message: '请添加工作经历'
                      }
                    ]
                  })(
                    <div>
                      <Table
                        dataSource={this.state.bayWorkExperienceDtoList}
                        columns={workColumns}
                        pagination={false}
                      />
                      <Button
                        type="primary"
                        onClick={() => {
                          this.$add(
                            'bayWorkExperienceDtoList',
                            'workExperienceId'
                          );
                        }}
                      >
                        + 添加一条记录
                        </Button>
                    </div>
                  )}
                </Form.Item>
              </Col>
            </Row>

            {/* <h3>图像材料</h3>
            <ImageFormItem
              formLayout={formLayout2}
              personType={this.state.selectedPersonType}
              form={this.props.form}
            /> */}
            <Row>
              <Col span={24} className="miniLabelWidth">
                <Form.Item {...photoItemLayout} label="图像材料">
                  <span style={{ color: 'orange', fontSize: 14 }}>
                    (每张不超过:8M,格式为:jpg，jpeg，png)
                  </span>
                </Form.Item>
              </Col>
            </Row>
            <Row>
              <Col span={9} offset={2}>
                <Form.Item {...photoItemLayout} label="身份证人像面">
                  {getFieldDecorator(`idCardFrontUrl`, {
                    // initialValue: this.state.photo.idCardFrontUrl,
                    rules: [
                      {
                        // required:
                        //   this.state.bayConfigInfo.isIdCardFrontRequired ===
                        //     '1'
                        //     ? true
                        //     : false,
                        message: `请上传身份证人像面`
                      }
                    ]
                  })(
                    <PFromUpload
                      key={this.state.key}
                      num={1}
                      onChange={url => {
                        this.setState({
                          photo: {
                            ...this.state.photo,
                            idCardFrontUrl: url
                          }
                        });
                      }}
                    />
                  )}
                </Form.Item>
              </Col>
              <Col span={9}>
                <Form.Item {...photoItemLayout} label="身份证国徽面">
                  {getFieldDecorator(`idCardReverseUrl`, {
                    // initialValue: this.state.photo.idCardReverseUrl,
                    rules: [
                      {
                        // required:
                        //   this.state.bayConfigInfo.isIdCardReverseRequired ===
                        //     '1'
                        //     ? true
                        //     : false,
                        message: `请上传身份证国徽面`
                      }
                    ]
                  })(
                    <PFromUpload
                      key={this.state.key}
                      num={1}
                      onChange={url => {
                        this.setState({
                          photo: {
                            ...this.state.photo,
                            idCardReverseUrl: url
                          }
                        });
                      }}
                    />
                  )}
                </Form.Item>

              </Col>
            </Row>
            <Row>
              <Col span={9} offset={2}>
                <Form.Item {...photoItemLayout} label="初中以上学历证明原件">
                  {getFieldDecorator(`eduCerUrl`, {
                    // initialValue: this.state.photo.eduCerUrl,
                    rules: [
                      {
                        // required:
                        //   this.state.bayConfigInfo.isEduProveRequired === '1'
                        //     ? true
                        //     : false,
                        message: `请上传初中以上学历证明原件`
                      }
                    ]
                  })(
                    <PFromUpload
                      key={this.state.key}
                      num={1}
                      onChange={url => {
                        this.setState({
                          photo: {
                            ...this.state.photo,
                            eduCerUrl: url
                          }
                        });
                      }}
                    />
                  )}
                </Form.Item>

              </Col>
              <Col span={9}>

                <Form.Item
                  {...photoItemLayout}
                  label={
                    <span>
                      <em style={{ marginRight: 10 }}>县级以上医院出具的</em>
                      <br />
                      体检证明(最多4张)
                    </span>
                  }
                >
                  {getFieldDecorator(`hospitalExamProveUrl`, {
                    // initialValue: this.state.photo.hospitalExamProveUrl,
                    rules: [
                      {
                        // required:
                        //   this.state.bayConfigInfo.isCheckUpProveRequired ===
                        //     '1'
                        //     ? true
                        //     : false,
                        message: `请上传县级以上医院出具的体检证明`
                      }
                    ]
                  })(
                    <PFromUpload
                      key={this.state.key}
                      num={4}
                      onChange={url => {
                        console.log(url);
                      }}
                    />
                  )}
                </Form.Item>
              </Col>
            </Row>
            {/* 
            <h3>报名承诺</h3>
            <Row gutter={16} style={{ marginBottom: 20 }}>
              <Col span={20}>

                <span style={{
                  color: '#f5222d', marginLeft: '2em',
                  // text-indent  
                }}>*</span>
                <Checkbox onChange={e => {
                  this.setState({
                    checked: e.target.checked
                  });
                }}>
                  我司（ <span style={{ color: '#F59A23' }}>{this.props.companyInfo.comName}</span> ）承诺，由我司报名代理人
              {this.state.agentInfo && getFieldDecorator('agentName', {
                  initialValue: this.state.agentInfo.name || '',
                  rules: [
                    {
                      required: true,
                      message: '请输入姓名'
                    }
                  ]
                })(
                  <Input style={{ width: 150, border: (this.state.clicked && !getFieldValue('agentName')) ? '1px solid #f5222d' : '1px solid #d9d9d9' }} type="text" placeholder="请输入姓名" />
                )}
                （
              {this.state.agentInfo && getFieldDecorator('agentIdCardNo', {
                  initialValue: this.state.agentInfo.idCardNo || '',
                  rules: [
                    {
                      required: true,
                      message: '请输入身份证号'
                    },
                    {
                      validator: this._checkIdCardNo
                    }
                  ]
                })(
                  <Input style={{ width: 200, border: (this.state.clicked && !getFieldValue('agentIdCardNo')) ? '1px solid #f5222d' : '1px solid #d9d9d9' }} type="text" placeholder="请输入身份证号" />
                )}
                ，
              {this.state.agentInfo && getFieldDecorator('agentPhone', {
                  initialValue: this.state.agentInfo.mobilePhone || '',
                  rules: [
                    {
                      required: true,
                      message: '请输入手机号码'
                    },
                    { validator: this._checkPhone }
                  ]
                })(
                  <Input style={{ width: 150, border: (this.state.clicked && !getFieldValue('agentPhone')) ? '1px solid #f5222d' : '1px solid #d9d9d9' }} type="text" placeholder="请输入手机号码" />
                )}
                ）
                提交的报名信息真实有效，对因填报信息错误造成不符合培训及补贴申报条件的，由本企业自行承担相应责任和损失。
                </Checkbox>

              </Col>
            </Row> */}

            <Row gutter={16}>
              <Col span={20}>
                <div className="sumbitButtom" style={{ textAlign: 'center' }}>
                  <OnceButton
                    type="primary"
                    style={{ margin: '0 20px' }}
                    onClick={(e) => {
                      this._submit(e, 1)
                    }}
                  >
                    提交并继续添加
                  </OnceButton>
                  {/* <Button
                    type="primary"
                    style={{ margin: '0 20px' }}
                    disabled={this.state.buttonStatus}
                    onClick={() => {
                      this.setState({
                        buttonStatus: true
                      });
                      this._submit();
                    }}
                  >
                    暂存
                  </Button> */}
                  <OnceButton
                    type="primary"
                    disabled={this.state.buttonStatus || !this.state.checked}
                    style={{ margin: '0 20px' }}
                    onClick={this._submit}
                  >
                    提交
                  </OnceButton>
                </div>
              </Col>
            </Row>
          </div>
        </Form>
      </Box>
    );
  }
}

const Box = style.div`{
.import_salary{
        margin:16px 0 8px 24px;
    }
.miniLabelWidth .ant-form-item-label{
        width:8%;
    }
.noUpload{
.anticon - plus,.ant - upload - text{
        display: none;
    }
  }
}`;