import React, { Component } from "react";
import {
  Button,
  Form,
  Input,
  Select,
  DatePicker
} from "antd";
// import moment from 'moment';
const { RangePicker } = DatePicker;
const { Option } = Select;
const dateFormat = 'YYYY-MM-DD';
@Form.create()
export default class SearchForm extends Component {
  constructor(props) {
    super(props);
    this.state = {
      policeys: [],
      orderId: ''
    }
  }
  componentDidMount() {
    // this.props.onSearch(this.props.form.getFieldsValue());
    this._search();
  }


  _search = (e) => {
    e && e.preventDefault();
    this.props.form.validateFields((err, values) => {
      if(err) return;
      const { applyDate, practiceDate,  payDate } = values;
      // 报名时间
      if(applyDate.length == 2) {
        values.applyStartDate = applyDate[0].format(dateFormat);
        values.applyEndDate = applyDate[1].format(dateFormat);
      }else {
        values.applyStartDate = '';
        values.applyEndDate = '';
      }
      Reflect.deleteProperty(values, 'applyDate');
      // delete values.applyDate;
      // 实操培训时间
      if(practiceDate.length == 2) {
        values.practiceStartDate = practiceDate[0].format(dateFormat);
        values.practiceEndDate = practiceDate[1].format(dateFormat);
      }else {
        values.practiceStartDate = '';
        values.practiceEndDate = '';
      }
      Reflect.deleteProperty(values, 'practiceDate');
      // delete values.practiceDate;
      // 缴费时间
      if(payDate.length == 2) {
        values.payStartDate = payDate[0].format(dateFormat);
        values.payEndDate = payDate[1].format(dateFormat);
      }else {
        values.payStartDate = '';
        values.payEndDate = '';
      }
      // delete values.payDate;
      Reflect.deleteProperty(values, 'payDate');
      console.log(values)
      // // 开班时间
      // if(classDate.length == 2) {
      //   values.classStartDate = classDate[0].format(dateFormat);
      //   values.classEndDate = classDate[1].format(dateFormat);
      // }else {
      //   values.classStartDate = '';
      //   values.classEndDate = '';
      // }
      // // delete values.classDate;
      // Reflect.deleteProperty(values, 'classDate');

      // 搜索的时候重置为第一页
      values.pageNumber = 1;
      // 传递参数
      this.props.onSearch && this.props.onSearch(values);
    });
  }
  _reset = () => {
    this.props.form.resetFields();
    this._search();
    // const data = this.props.form.getFieldsValue();
    // this.props.onSearch(data);
}
  render() {
    const { getFieldDecorator } = this.props.form;
    return (
      <Form layout="inline" onSubmit={this._search}>
        <Form.Item label="关键词">
          {getFieldDecorator('keyword', {
            initialValue: ''
          })(
            <Input style={{width: 200}} placeholder="请输入姓名/手机号码/身份证" />
          )}
        </Form.Item>
        <Form.Item label="是否补考">
          {getFieldDecorator('isMakeUp', {
            initialValue: ''
          })(
            <Select style={{minWidth: 150}} >
              <Option value="">全部</Option>
              <Option value="0">否</Option>
              <Option value="1">是</Option>
            </Select>
          )}
        </Form.Item>
        <Form.Item label="申报状态">
          {getFieldDecorator('applyStatus', {
            initialValue: ''
          })(
            <Select style={{minWidth: 150}} >
              <Option value="">全部</Option>
              <Option value="0">申报中</Option>
              <Option value="1">申报通过</Option>
              <Option value="2">申报不通过</Option>
              <Option value="3">已撤销</Option>
            </Select>
          )}
        </Form.Item>
        <Form.Item label="背景筛查">
          {getFieldDecorator('backgroundStatus', {
            initialValue: ''
          })(
            <Select style={{minWidth: 150}} >
              <Option value="">全部</Option>
              <Option value="0">审查中</Option>
              <Option value="1">正常</Option>
              <Option value="2">关注</Option>
              <Option value="3">申诉通过</Option>
              <Option value="4">申诉不通过</Option>
              <Option value="5">申诉中</Option>
            </Select>
          )}
        </Form.Item>
        {/* <Form.Item label="申诉状态">
          {getFieldDecorator('comInsId', {
            initialValue: ''
          })(
            <Select style={{minWidth: 150}} >
              <Option key={1} value={1}>{1}</Option>
            </Select>
          )}
        </Form.Item> */}
        <Form.Item label="实习状态">
          {getFieldDecorator('internStatus', {
            initialValue: ''
          })(
            <Select style={{minWidth: 150}} >
              <Option value="">全部</Option>
              <Option value="0">实习中</Option>
              <Option value="1">实习完成</Option>
            </Select>
          )}
        </Form.Item>
        <Form.Item label="缴费状态">
          {getFieldDecorator('orderStatus', {
            initialValue: ''
          })(
            <Select style={{minWidth: 150}} >
              <Option value="">全部</Option>
              <Option value="0">未缴费</Option>
              <Option value="1">已缴费</Option>
            </Select>
          )}
        </Form.Item>
        <Form.Item label="材料核对状态">
          {getFieldDecorator('materialApproveStatus', {
            initialValue: ''
          })(
            <Select style={{minWidth: 150}} >
              <Option value="">全部</Option>
              <Option value="0">未核对</Option>
              <Option value="1">核对通过</Option>
              <Option value="2">核对不通过</Option>
            </Select>
          )}
        </Form.Item>
        <Form.Item label="理论学习进度">
          {getFieldDecorator('trackLearnStatus', {
            initialValue: ''
          })(
            <Select style={{minWidth: 150}} >
              <Option value="">全部</Option>
              <Option value="0">未完成</Option>
              <Option value="1">已完成</Option>
            </Select>
          )}
        </Form.Item>
        <Form.Item label="开班安排">
          {getFieldDecorator('classOpenStatus', {
            initialValue: ''
          })(
            <Select style={{minWidth: 150}} >
              <Option value="">全部</Option>
              <Option value="0">未开班</Option>
              <Option value="1">已开班</Option>
            </Select>
          )}
        </Form.Item>
        <Form.Item label="结业考试状态">
          {getFieldDecorator('graduateTestState', {
            initialValue: ''
          })(
            <Select style={{minWidth: 150}} >
              <Option value="">全部</Option>
              <Option value="0">未通过</Option>
              <Option value="1">已通过</Option>
            </Select>
          )}
        </Form.Item>
        <Form.Item label="鉴定考试状态">
          {getFieldDecorator('identifyTestState', {
            initialValue: ''
          })(
            <Select style={{minWidth: 150}} >
              <Option value="">全部</Option>
              <Option value="0">未通过</Option>
              <Option value="1">已通过</Option>
            </Select>
          )}
        </Form.Item>
        <Form.Item label="报名时间">
          {getFieldDecorator('applyDate', {
            initialValue: []
          })(
            <RangePicker
              format={dateFormat}
            />
          )}
        </Form.Item>
        <Form.Item label="部门">
          {getFieldDecorator('departName', {
            initialValue: ''
          })(
            <Input style={{ width: 200 }} placeholder="请输入部门名称" />
          )}
        </Form.Item>
        <br/>
        <Form.Item label="缴费时间">
          {getFieldDecorator('payDate', {
            initialValue: []
          })(
            <RangePicker
              format={dateFormat}
            />
          )}
        </Form.Item>
        <Form.Item label="实操培训开班时间">
          {getFieldDecorator('practiceDate', {
            initialValue: []
          })(
            <RangePicker
              format={dateFormat}
            />
          )}
        </Form.Item>
        {/* <Form.Item label="开班时间">
          {getFieldDecorator('classDate', {
            initialValue: []
          })(
            <RangePicker
              format={dateFormat}
            />
          )}
        </Form.Item> */}
        <Form.Item label=" " colon={false}>
          <Button type="primary" onClick={this._search}>搜索</Button>
        </Form.Item>
        <Form.Item label=" " colon={false}>
          <Button onClick={this._reset}>重置</Button>
        </Form.Item>
      </Form>
    );
  }
}
