import React, { Component } from 'react';
import st from 'styled-components';
import { connect } from 'dva';
import {
  Button,
  Alert,
  Popover,
  Input,
  Select,
  DatePicker
} from 'antd';
import { withRouter } from 'dva/router';
import columnFun from './columns';
import store from 'store';
import SubDrawer from './SubDrawer';
import tablePage from '../../../../utils/hoc/tablePage';

const { RangePicker } = DatePicker;
const { Option } = Select;
const dateFormat = 'YYYY-MM-DD';
@connect(state => ({
  global: state.global
}))
@tablePage({ type: 'bkt' })
@withRouter
export default class Submitted extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      //抽屉
      drawerVisble: false,
      personApplyId: '',  //当前选中的id
    };
  }

  componentDidMount() {

  }
  // 表格渲染
  renderOrderList = () => {
    const columns = columnFun.call(this);
    const { PageTable, isInit } = this.props;
    if (!isInit) return;
    return (
      <PageTable
        columns={columns}
        url="adapt_trainAdaptApplyLearnPage"
        scroll={{ x: '2000px' }}
      />
    );
  };

  render() {
    const { SearchForm, Form } = this.props;
    const { getFieldDecorator } = this.props.form;
    return (
      <div className="tab_inner">
        <Alert
          message={<div style={{ color: '#333' }}>
            <span>本页面为已提交保安岗位适应性培训记录页面，您可以实时查询学员的信息及状态。</span>
            {/* <br /> */}
            {/* <span>本页面为已提交保安等级证报名记录；当报名记录状态为“可报名”时，可访问【培训】-【课程列表】选择保安员等级证。</span> */}
          </div>}
          type="warning"
          showIcon
          style={{ marginBottom: '15px' }}
        />
        <SearchForm
          arrange={values => {
            // values
            const { applyDate,  payDate } = values;
            // 报名时间
            if(applyDate.length == 2) {
              values.applyStartDate = applyDate[0].format(dateFormat);
              values.applyEndDate = applyDate[1].format(dateFormat);
            }else {
              values.applyStartDate = '';
              values.applyEndDate = '';
            }
            Reflect.deleteProperty(values, 'applyDate');

            // 缴费时间
            if(payDate.length == 2) {
              values.payStartDate = payDate[0].format(dateFormat);
              values.payEndDate = payDate[1].format(dateFormat);
            }else {
              values.payStartDate = '';
              values.payEndDate = '';
            }
            Reflect.deleteProperty(values, 'payDate');
            return values;
          }}
        >
          <>
            <Form.Item label="关键词">
              {getFieldDecorator('keyword', {
                initialValue: ''
              })(
                <Input style={{ width: 200 }} placeholder="请输入姓名/手机号码/身份证" />
              )}
            </Form.Item>
            <Form.Item label="申报状态">
              {getFieldDecorator('applyStatus', {
                initialValue: ''
              })(
                <Select style={{ minWidth: 150 }} >
                  <Option value="">全部</Option>
                  <Option value="0">申报中</Option>
                  <Option value="1">申报通过</Option>
                  <Option value="2">申报不通过</Option>
                  <Option value="3">已撤销</Option>
                </Select>
              )}
            </Form.Item>
            <Form.Item label="背景筛查">
              {getFieldDecorator('backgroundStatus', {
                initialValue: ''
              })(
                <Select style={{ minWidth: 150 }} >
                  <Option value="">全部</Option>
                  <Option value="0">审查中</Option>
                  <Option value="1">正常</Option>
                  <Option value="2">关注</Option>
                  <Option value="3">申诉通过</Option>
                  <Option value="4">申诉不通过</Option>
                  <Option value="5">申诉中</Option>
                </Select>
              )}
            </Form.Item>
            <Form.Item label="缴费状态">
              {getFieldDecorator('orderStatus', {
                initialValue: ''
              })(
                <Select style={{ minWidth: 150 }} >
                  <Option value="">全部</Option>
                  <Option value="0">未缴费</Option>
                  <Option value="1">已缴费</Option>
                </Select>
              )}
            </Form.Item>
            <Form.Item label="材料核对状态">
              {getFieldDecorator('materialApproveStatus', {
                initialValue: ''
              })(
                <Select style={{ minWidth: 150 }} >
                  <Option value="">全部</Option>
                  <Option value="0">未核对</Option>
                  <Option value="1">核对通过</Option>
                  <Option value="2">核对不通过</Option>
                </Select>
              )}
            </Form.Item>
            <Form.Item label="学习状态">
              {getFieldDecorator('trackLearnStatus', {
                initialValue: ''
              })(
                <Select style={{ minWidth: 150 }} >
                  <Option value="">全部</Option>
                  <Option value="0">未完成</Option>
                  <Option value="1">已完成</Option>
                </Select>
              )}
            </Form.Item>
            <Form.Item label="报名时间">
              {getFieldDecorator('applyDate', {
                initialValue: []
              })(
                <RangePicker
                  format={dateFormat}
                />
              )}
            </Form.Item>
            <Form.Item label="缴费时间">
              {getFieldDecorator('payDate', {
                initialValue: []
              })(
                <RangePicker
                  format={dateFormat}
                />
              )}
            </Form.Item>
          </>
        </SearchForm>
        <Btns>
          <Button style={{ marginRight: 15 }} onClick={() => {
            this.props.history.push('/PoliceDeclare/adapt/add');
          }} type="primary">新增报名</Button>

          <Popover content={<span style={{ display: 'block', padding: 10 }}>搜索后可导出搜索结果</span>}>
            <Button
              type="primary"
              onClick={() => {
                const { searchData } = this.state;
                let queryStr = '';
                Object.keys(searchData).forEach(key => {
                  queryStr += `${key}=${searchData[key]}&`;
                });
                queryStr = '?' + queryStr.slice(0, -1);
                console.log('/bkt_api/train/adapt/apply/export/learn/apply' + queryStr + '&sessionId=' + store.get('saas')['sessionId']);
                window.open('/bkt_api/train/adapt/apply/export/learn/apply' + queryStr + '&sessionId=' + store.get('saas')['sessionId']);
              }}
            >
              导出数据
            </Button>
          </Popover>
        </Btns>
        {/* 表格 */}
        {this.renderOrderList()}

        {/* 修改弹窗 */}
        <SubDrawer
          personApplyId={this.state.personApplyId}
          onClose={() => {
            this.setState({
              personApplyId: ''
            });
          }}
        />
      </div >
    );
  }
}

const Btns = st.div`
  margin-top: 15px;
  button {
    margin-right: 15px;
  }
`;