/**
 * 我的通知
 */
import React, { Component } from 'react';
// import { connect } from 'dva';
import {
  Input,
  LocaleProvider,
  Modal,
  Alert
} from 'antd';
import zh_CN from 'antd/lib/locale-provider/zh_CN';
moment.locale('zh-cn');
import moment from 'moment';
import tablePage from '../../../utils/hoc/tablePage';
// @connect(state => ({
//   global: state.global,
//   currentUser: state.user.currentUser,
//   fetchingNotices: state.global.fetchingNotices
// }))
@tablePage()
export default class NotifList extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      modalStatue: false,
      value: null
    };

  }
  componentDidMount() {

  }
  // 表格渲染
  renderOrderList = () => {
    const columns = [
      {
        title: '标题',
        dataIndex: 'title',
        key: 'title',
        width: 380
      },
      {
        title: '发布时间',
        dataIndex: 'createTime',
        key: 'createTime'
      },
      {
        title: '操作',
        render: (text, record) => (
          <span style={{
            color: '#108EE9',
            cursor: 'pointer',
            marginRight: '20px'
          }}
            onClick={() => {
              this.setState({
                modalStatue: true,
                value: record
              })
            }}>查看</span>
        )
      }
    ];
    const { PageTable, isInit } = this.props;
    if (!isInit) return;
    return (
      <LocaleProvider locale={zh_CN}>
        <PageTable
          columns={columns}
          url="getConfigUpdateMsgList"
        />
      </LocaleProvider>
    );
  };
  render() {
    const { SearchForm, Form } = this.props;
    const { getFieldDecorator } = this.props.form;
    return (
      <div className="message-receive">
        <Alert style={{marginBottom: 20}} message={(<div>
                注：您可以点击系统页面右上角的“铃铛”-“查看平台通知”重新打开本列表。
              </div>)} type="warning" showIcon/>
        <SearchForm>
          <>
            <Form.Item label="关键词">
              {getFieldDecorator('keyWord', {
                initialValue: ''
              })(
                <Input style={{ width: 200 }} placeholder="请输入标题" />
              )}
            </Form.Item>
          </>
        </SearchForm>
        {/* 表格 */}
        {this.renderOrderList()}

        {
          this.state.modalStatue && <Modal
            title={this.state.value.title}
            visible={this.state.modalStatue}
            footer={null}
            onCancel={() => {
              this.setState({
                modalStatue: false
              })
            }}
          >
            <div dangerouslySetInnerHTML={{
              __html: this.state.value.content
            }} />
          </Modal>
        }
      </div>
    );
  }
}
