import React, { Component } from 'react';
import { connect } from 'dva';
import {
  Input,
  Button,
  Form,
  Select,
  Badge,
  Tabs
} from 'antd';
import './less/devices.less';
import PSelect from "../../../components/Pro/PSelect";
import PTable from "../../../components/Pro/PTable";
import StorageRecordDrawer from "./StorageRecordDrawer";

const { Option } = Select;
const statusMap = ['error', 'success', 'processing', 'warning'];
const status = ['设备出库', '设备归还', '库存新增', '库存损耗'];
const { TabPane } = Tabs;

@connect(state => ({ profile: state.profile }))
@Form.create()

export default class StorageRecord extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      open: false,//出库入库详情
      equipInOutId: 0,//企业设备出入库Id
      forceUpdate: false,
      pageParm: {
        pageSize: "10",
        pageNumber: "1",
        equipName: "",
        equipType: "",
        inOutStockType: "",
        sortOperaNum: "",
        sortOperaDate: "",
      },
      equipName: "",
      equipType: "",
      inOutStockType: "",
      sortOperaNum: "",
      sortOperaDate: "",
    };
  }
  //点击搜索
  search = () => {
    const pageParm = { ...this.state.pageParm };
    const { equipName, equipType, inOutStockType, sortOperaNum, sortOperaDate } = this.state;
    pageParm.equipName = equipName;
    pageParm.equipType = equipType;
    pageParm.inOutStockType = inOutStockType;
    pageParm.sortOperaNum = sortOperaNum;
    pageParm.sortOperaDate = sortOperaDate;
    this.setState({ pageParm, forceUpdate: true }, () => {
      this.setState({ forceUpdate: false });
    });
  };
  //输入框的书写
  inputSerchDevicesChange = (e) => {
    this.setState({ equipName: e.target.value.trim() });
  };
  //抽屉视图处理
  changeDrawer = (record) => {
    this.setState({ open: true });
    this.setState({ equipInOutId: record.equipInOutId });

  };
  //报表类型 change
  pSelectChange = (value, type) => {
    this.setState({ [type]: value });
  };
  //选择框的改变
  handleInOutStockTypeChange = (value) => {
    this.setState({ inOutStockType: value.trim() });
  };
  handleSortOperaDateChange = (value) => {
    this.setState({ sortOperaDate: value.trim() });
  };
  onChangeTable = (pagination, filters, sorter) => {
    if (sorter.columnKey === 'operaDate') {
      const sortOperaDate = (sorter.order === "ascend" ? "ASC" : "DESC");
      this.setState({ sortOperaDate });
    }
    if (sorter.columnKey === 'operaNum') {
      const sortOperaNum = (sorter.order === "ascend" ? "ASC" : "DESC");
      this.setState({ sortOperaNum });
    }
  };

  //表格渲染
  renderTable = () => {

    const columns = [
      {
        title: '设备编号',
        dataIndex: 'equipNo',
        key: 'equipNo'
      }, {
        title: '设备名称',
        dataIndex: 'equipName',
        key: 'equipName'
      }, {
        title: '设备类型',
        dataIndex: 'equipType_name',
        key: 'equipType_name',
        // filters: [
        //   // {
        //   //   text: status[0],
        //   //   value: 0,
        //   // },
        //   // {
        //   //   text: status[1],
        //   //   value: 1,
        //   // },
        //   // {
        //   //   text: status[2],
        //   //   value: 2,
        //   // },
        //   // {
        //   //   text: status[3],
        //   //   value: 3,
        //   // },
        // ],
        // filterMultiple: true,
        // onFilter: (value, record) => record.equipType.indexOf(value) === 0,
        // render(val) {
        //   return <Badge status={statusMap[val-1]} text={status[val-1]} />;
        // },
      }, {
        title: '负责人',
        dataIndex: 'perName',
        key: 'perName'
      }, {
        title: '状态',
        dataIndex: 'inOutStockType',
        key: 'inOutStockType',
        // filters: [
        //   {
        //     text: status[0],
        //     value: 0,
        //   },
        //   {
        //     text: status[1],
        //     value: 1,
        //   },
        //   {
        //     text: status[2],
        //     value: 2,
        //   },
        //   {
        //     text: status[3],
        //     value: 3,
        //   },
        // ],
        // filterMultiple: true,
        // onFilter: (value, record) => record.inOutStockType.indexOf(value) === 0,
        render(val) {
          return <Badge status={statusMap[val - 1]} text={status[val - 1]} />;
        },
      }, {
        title: '操作数量',
        dataIndex: 'operaNum',
        key: 'operaNum',
        sorter: (a, b) => a.operaNum - b.operaNum,
      }, {
        title: '操作后库存',
        key: 'operAfterCurNum',
        render: (text, record) => (
          <span>{record.operAfterCurNum}/{record.operAfterTotalNum}</span>
        )
      }, {
        title: '操作时间',
        dataIndex: 'operaDate',
        key: 'operaDate',
        // sorter: (c, d) => c.operaDate - d.operaDate,
      }, {
        title: '操作',
        key: 'action',
        render: (text, record) => (
          <span className="action">
            <span onClick={this.changeDrawer.bind(this, record)} >查看详情</span>
          </span>
        )
      }
    ];

    return (
      <PTable
        style={{ marginTop: 20 }}
        columns={columns}
        url="enterpriseEquipComEquipInOutListComEquipInOut"
        pageParm={this.state.pageParm}
        //dateChange={this.dateTableChange}
        forceUpdate={this.state.forceUpdate}
        onChange={this.onChangeTable}
      />
    );
  }

  render() {
    // const formItemLayout = {
    //   labelCol: {
    //     xs: {
    //       span: 24
    //     },
    //     sm: {
    //       span: 7
    //     }
    //   },
    //   wrapperCol: {
    //     xs: {
    //       span: 24
    //     },
    //     sm: {
    //       span: 17
    //     },
    //     md: {
    //       span: 17
    //     }
    //   }
    // };

    return (
      <div className="storageRecord">
        <Tabs>
          <TabPane tab="出入库记录" key="1">
            <div className="storageRecord-form" >
              <label>设备类型：
              <PSelect style={{ width: 214, marginRight: 16, color: "#666", marginBottom: '16px' }} placeholder="全部" type="equipType" value={this.state.equipType} onChange={this.pSelectChange} addOption />
              </label>
              <label style={{ marginBottom: '10px' }}>状态：
                  <Select
                  placeholder="全部"
                  style={{ width: 214, marginRight: 16, color: "#666", marginBottom: '16px' }}
                  onChange={this.handleInOutStockTypeChange}
                >
                  <Option value="1"><Badge status={statusMap[0]} text={status[0]} /></Option>
                  <Option value="2"><Badge status={statusMap[1]} text={status[1]} /></Option>
                  <Option value="3"><Badge status={statusMap[2]} text={status[2]} /></Option>
                  <Option value="4"><Badge status={statusMap[3]} text={status[3]} /></Option>
                  <Option value="" style={{marginLeft:13}}>全部</Option>
                </Select>
              </label>
              <label>排序：
                  <Select
                  style={{ width: 214, marginRight: 16, color: "#666", marginBottom: '16px' }}
                  onChange={this.handleSortOperaDateChange}
                >
                  <Option value="DESC">由新到旧</Option>
                  <Option value="ASC">由旧到新</Option>
                </Select>
              </label >
              {/* <div style={{ marginTop: 16 }}> */}
              <label>设备搜索：
                    <Input style={{ marginRight: 16, width: 214, height: 32 }} maxLength={10} onChange={this.inputSerchDevicesChange} placeholder="搜索设备名称" />
              </label>
              <Button style={{ width: 65, height: 31.5, borderRadius: 6 }} onClick={this.search} type="primary">搜索</Button>
              {/* </div> */}
            </div>
            {this.renderTable()}
            <StorageRecordDrawer onChange={(open) => { this.setState({ open }); }} visible={this.state.open} equipInOutId={this.state.equipInOutId} />
          </TabPane>
        </Tabs>
      </div>
    );
  }
}
