import React, { Component } from 'react';
import { connect } from 'dva';
import {
  Input,
  Button,
  Form,
  Icon,
  message,
  Drawer,
  Modal
} from 'antd';
// import Drawer from 'react-motion-drawer';
import PSelect from "../../../components/Pro/PSelect";
import './less/devices.less';
import * as api from "../../../services/api";


const FormItem = Form.Item;

@connect(state => ({ profile: state.profile }))
@Form.create()

export default class EditDevicesDrawer extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      open: this.props.visible,
      curNum: 0,
      comEquipId: 0,
      comEquipList: {
        equipNo: '',//设备编号
        equipName: '',//设备名称
        equipType: '',//设备类型
      },
      visibleModal:false //提示框状态
    };
  }


  //表单提交
  handleEditDeviceSubmit = (e) => {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      values.comEquipId = this.state.comEquipId;
      if (!err) {
        api.enterpriseEquipComEquipUpdateComEquip(values).then((data) => {
          message.success(data.msg);
          this.props.tableUpdate();
          this.setState({
            open: false,
          });
          this.renderDate(this.state.comEquipId);
        }, (err1) => {
          message.error(err1);
        });
      }
    });
  };

  componentWillReceiveProps(nextProps) {
    this.setState({ open: nextProps.visible });
    if (nextProps.comEquipId !== this.state.comEquipId) {
      if (nextProps.comEquipId === 0 || nextProps.comEquipId === undefined) {
        return;
      }
      this.setState({
        comEquipId: nextProps.comEquipId,
        curNum: nextProps.curNum
      });
      this.renderDate(nextProps.comEquipId);
    }
  }

  renderDate = (pro) => {
    api.enterpriseEquipComEquipGetComEquipById({ comEquipId: pro }).then((data) => {
      const { setFieldsValue } = this.props.form;
      setFieldsValue({
        equipNo: data.data.equipNo || '',
        equipName: data.data.equipName || '',
        equipType: data.data.equipType || '',
      });
      this.setState({
        comEquipList: {
          equipNo: data.data.equipNo || '',
          equipName: data.data.equipName || '',
          equipType: data.data.equipType || '',
        },
      });
    }, (err) => {
      console.log(err);
    });
  }

  hideDrawer = () => {
    // this.setState({ open: false });
    const values = this.props.form.getFieldsValue();
    if(values.equipType !== this.state.comEquipList.equipType || values.equipNo !== this.state.comEquipList.equipNo || values.equipName !== this.state.comEquipList.equipName){
      this.setState({
        visibleModal: true,
      });
    } else {
      this.handleModalOk();
    }
  };

  handleModalOk = () => {
    this.setState({
      open:false,
      visibleModal:false
    });
  }

  handleModalCancel = () =>{
    this.setState({
      visibleModal: false
    });
  }

  //校验设备编号
  checkNo = (rule, value, callback) => {
    if (value && (/[\u4e00-\u9fa5]+/).test(value)) {
      callback('设备编号格式不正确');
    } else {
      callback();
    }
  };

  render() {
    const formItemLayout = {
      labelCol: {
        xs: {
          span: 24
        },
        sm: {
          span: 7
        }
      },
      wrapperCol: {
        xs: {
          span: 24
        },
        sm: {
          span: 17
        },
        md: {
          span: 17
        }
      }
    };
    const { getFieldDecorator } = this.props.form;

    return (
      <div>
        <Drawer
          overlayColor="rgba(0, 0, 0,0)"
          placement="right"
          visible={this.state.open}
          destroyOnClose
          title="编辑设备"
          width={600}
          zIndex={11}
          onChange={(open) => {
            this.props.onChange(open);
            this.setState({ open });
          }}
          onClose={this.hideDrawer}
        >
          <div>
            <div>
              <Form onSubmit={this.handleEditDeviceSubmit}>
                <FormItem {...formItemLayout} label="选择设备类型: ">
                  {getFieldDecorator('equipType', {
                    initialValue: this.state.comEquipList.equipType,
                    rules: [
                      {
                        required: true,message:"请选择设备类型"
                      }
                    ]
                  })(
                    <PSelect style={{ width: 294 }} placeholder="请选择" type="equipType" onChange={this.pSelectChange} noAllText={true}/>
                    )}
                </FormItem>
                <FormItem {...formItemLayout} label="输入设备编号：">
                  {getFieldDecorator('equipNo', {
                    initialValue: this.state.comEquipList.equipNo,
                    rules: [
                      {
                        required: true,message:"请输入设备编号"
                      }, {
                        validator: this.checkNo
                      }
                    ]
                  })(<Input style={{ width: 294 }} placeholder="请输入" maxLength={20} />)}
                </FormItem>
                <FormItem {...formItemLayout} label="输入设备名称">
                  {getFieldDecorator('equipName', {
                    initialValue: this.state.comEquipList.equipName,
                    rules: [
                      {
                        required: true,message:"请输入设备名称"
                      }
                    ]
                  })(<Input style={{ width: 294 }} placeholder="请输入" maxLength={10} />)}
                </FormItem>
                <FormItem {...formItemLayout} label="库存数量">
                  {getFieldDecorator('D-storageNumber', {
                    rules: [
                      {
                        required: false
                      }
                    ]
                  })(<span style={{ color: "#D9D9D9" }}><i style={{ color: "#666", fontStyle: 'normal' }}>{this.state.curNum}</i>&nbsp;&nbsp;<Icon type="exclamation-circle" />请通过出库入库操作调整库存数量</span>)}
                </FormItem>
              </Form>
            </div>
            <div style={{
              position: 'absolute',
              bottom: 0,
              width: '100%',
              borderTop: '1px solid #e8e8e8',
              padding: '10px 16px',
              textAlign: 'right',
              left: 0,
              background: '#fff',
              borderRadius: '0 0 4px 4px',
            }}>
              <Button onClick={this.hideDrawer}>取消</Button>
              <Button type="primary" style={{ marginLeft: 8 }} htmlType="submit" onClick={this.handleEditDeviceSubmit}>确定</Button>
            </div>
          </div>
        </Drawer>
        <Modal
          title="提示"
          visible={this.state.visibleModal}
          onOk={this.handleModalOk}
          onCancel={this.handleModalCancel}>
          <p>当前信息未保存，是否确认返回？</p>
        </Modal>
      </div>
    );
  }
}
