import React, { Component } from "react";
import { connect } from "dva";
import { getDateInterval } from "../../../utils/utils";
import {
  Input,
  Button,
  Form,
  Select,
  Radio,
  DatePicker,
  Upload,
  Icon,
  message,
  InputNumber,
  Breadcrumb,
  Table,
  Popconfirm,
  Checkbox,
} from "antd";
import "./less/contract.less";
import { gup } from "../../../utils/utils";
import * as api from "../../../services/api";
import PSelect from "../../../components/Pro/PSelect";
import $perModal from "../../../utils/modal/perModal";
import moment from "moment";
const FormItem = Form.Item;
const { Option } = Select.Option;
const { TextArea } = Input;
const RadioGroup = Radio.Group;
const { RangePicker } = DatePicker;
const dateFormat = "YYYY-MM-DD";
const config = {
  rules: [
    {
      type: "object",
      required: false,
      message: "请选择日期!",
    },
  ],
};
@connect((state) => ({ profile: state.profile }))
@Form.create()
export default class Devices extends Component {
  taskStationArrs = 0;
  constructor(props, context) {
    super(props, context);
    this.state = {
      // contractType: "01",
      contractType: this.props.location.state.type,
      distributionModeList: [], //发放/结算方式
      contractLists: [], //合同类型下拉
      currentRow: {
        contractType: this.props.location.state.type, //合同类型
        contractName: "", //合同名称
        comFileNo: "", //企业档案编号
        comParty: "", //企业所在方
        firstPartyName: "", //甲方名称
        firstPartyTel: "", //甲方联系电话
        secondPartyName: "", //乙方名称
        secondPartyTel: "", //乙方联系电话
        thirdPartyName: "", //丙方名称
        thirdPartyTel: "", //丙方联系电话
        thirdPartyAddress: "", //丙方联系地址
        effectStartDate: null, //生效开始日期
        effectEndDate: null, //生效终止日期
        payAmount: "", //付费金额
        payDate: null, //付费日期
        secondPartyIdCardNo: "", //乙方身份证号码
        workPost: "", //工作岗位
        content: "", //工作/劳务内容
        postSalary: "", //岗位薪资
        periodSalary: "", //试用期工资
        distributionMode: "", //发放/结算方式
        workPlace: "", //工作/劳务地点'
        serviceAmount: "", //劳务费用
        serviceTotalAmount: "", //劳务总金额
        agreementSignDate: null, //协议签订日期
        contractUrl: "", //合同文件url
        remark: "", //备注
        comContractId: "", //合同ID
        period: "", //试用期
      },
      fileList: [],
      fileNumber: 0,
      timeLimit: "",
      radioYiTypeValue: "01", //乙方类型按钮值，默认是"从组织架构选择"
      checkedkeys: [], //选中人员的key值
      chargePerName: "", //选中人员的名字
      chargePerIdCard: "", //选中人员的身份证号码
      chargePerPho: "", //选中人员的联系电话
      perId: "", //人员ID(如果是组织架构选择必须传人员ID)
      taskStationArrs: [],
      Indefinite:'',//合同是否有期限
    };
    //文件上传
    const that = this;

    that.modelUpload = {
      name: "xfile",
      // action: api.uploadUrl,
      action: "/saas_api/public/common/file/upload-file",
      beforeUpload(info) {
        //上传过程中，先判断是否符合上传规则
        // const types = [
        //   "application/pdf",
        //   "application/msword",
        //   "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
        //   "application/x-zip-compressed",
        //   "application/x-rar",
        //   ""
        // ];
        if (
          !(info.name + "")
            .toLocaleLowerCase()
            .match(
              /(\.doc)|(\.docx)|(\.pdf)/
            )
        ) {
          message.error(
            "请上传拓展名为.doc .docx .pdf文件!"
          );
          return false;
        }
        const isLt8M = info.size / 1024 / 1024 < 100;
        // if (types.indexOf(info.type) === -1) {
        //   message.error("只能上传.doc.docx.pdf.zip.rar类型的文件!");
        //   return false;
        // } else
        if (!isLt8M) {
          message.error("文件必须小于100MB!");
          return false;
        }
        //多份上传成功，提示只能上传一份
        const number = that.state.fileNumber === 0;
        if (!number) {
          message.success("上传成功，但只能上传一份合同文件");
        }
        // return number;
      },
      onChange(info) {
        const { setFieldsValue } = that.props.form;
        let { fileList } = info;
        fileList = fileList.slice(-1);
        if (info.file.status) {
          that.setState({ fileList });
        }
        if (info.file.status === "removed") {
          that.setState({
            fileNumber: 0,
          });
        }
        if (info.file.status !== "uploading") {
        }
        if (info.file.status === "done") {
          if (info.file.response.retType !== "0") {
            //上传成功，但服务器返回错误
            message.error(info.file.response.msg);
            that.setState({
              fileList: "",
            });
            setFieldsValue({ contractUrl: "" });
            return;
          }
          message.success(`${info.file.name} 文件上传成功`);
          that.setState({ contractUrl: fileList[0].response.data });
          setFieldsValue({ contractUrl: fileList[0].response.data });
          that.setState({
            fileNumber: 1,
          });
        } else if (info.file.status === "error") {
          message.error(`${info.file.name} 文件上传失败`);
        }
      },
    };
  }
  //生命周期
  componentDidMount = () => {
    this.DistributionModeList();
    this.GetCompanyNameAndPhone();
    if (this.props.location.state && this.props.location.state.value) {
      this.setState({
        perId: this.props.location.state.value.perId,
      });
    }
  };

  // 初始化合同的数据
  GetCompanyNameAndPhone = () => {
    api.enterpriseComContractInitComContract({}).then((data) => {
      if (data.data) {
        // let info = {};
        // const infoStr = gup('info');
        // if(infoStr) {
        //   try{
        //     info = JSON.parse(decodeURIComponent(infoStr));
        //   } catch (ex) {
        //     throw('url详情info字段解析失败')
        //   }
        // }
        const comContractId = gup("comContractId");
        if (comContractId) {
          api
            .enterpriseComContractGetComContractById({ comContractId })
            .then((res) => {
              this.setState({ info: res.data });
            });
        }
        const currentRow = {
          ...this.state.currentRow,
          ...data.data,
          contractType: this.props.location.state.type,
          secondPartyName: this.props.location.state.value
          ? this.props.location.state.value.name
          : data.data.secondPartyName,
          secondPartyTel: this.props.location.state.value
          ? this.props.location.state.value.mobilePhone
          : data.data.secondPartyTel,

        };
        this.setState({
          currentRow,
          changeRadioValue: data.data.comParty || '1', //按钮是甲方还是乙方,默认是甲方
        });
      }
    });
  };

  // 发放/结算方式
  DistributionModeList = () => {
    api
      .publicCommonDictGetDictByCodeTypes({ codeTypes: "distributionMode" })
      .then((data) => {
        //判断获取数据是否为空
        if (data.data) {
          this.setState({
            distributionModeList: data.data.distributionMode,
          });
        }
      });
  };

  //合同有效期-合同期限
  validDeadlineChange = (date, dateString) => {
    this.setState({ timeLimit: getDateInterval(date) });
  };
  //点击移除文件
  onRemoveUrl = () => {
    const { setFieldsValue } = this.props.form;
    setFieldsValue({ contractUrl: "" });
    this.setState({
      fileNumber: 0,
    });
  };

  //报表类型 change
  pSelectChange = (value, type) => {
    // this.setState({ contractType: value });
    this.setState({ [type]: value });
  };

  //甲方乙方按钮切换
  onChangeRadio = (e) => {
    const val = e.target.value;
    const { setFieldsValue, getFieldsValue } = this.props.form;
    let { 
      firstPartyName, firstPartyIdCardNo, firstPartyTel, firstPartyAddress,
      secondPartyName, secondPartyIdCardNo, secondPartyTel, secondPartyAddress,
      thirdPartyName, thirdPartyIdCardNo, thirdPartyTel, thirdPartyAddress
    } = getFieldsValue();
    let { changeRadioValue } = this.state;

    if((val == '1' && changeRadioValue == '2') || (val == '2' && changeRadioValue == '1')) {
      setFieldsValue({
        firstPartyName: secondPartyName,
        firstPartyIdCardNo: secondPartyIdCardNo, 
        firstPartyTel: secondPartyTel, 
        firstPartyAddress: secondPartyAddress,
        secondPartyName: firstPartyName,
        secondPartyIdCardNo: firstPartyIdCardNo, 
        secondPartyTel: firstPartyTel, 
        secondPartyAddress: firstPartyAddress
      });
    }

    if((val == '1' && changeRadioValue == '3') || (val == '3' && changeRadioValue == '1')) {
      setFieldsValue({
        firstPartyName: thirdPartyName,
        firstPartyIdCardNo: thirdPartyIdCardNo, 
        firstPartyTel: thirdPartyTel, 
        firstPartyAddress: thirdPartyAddress,
        thirdPartyName: firstPartyName,
        thirdPartyIdCardNo: firstPartyIdCardNo, 
        thirdPartyTel: firstPartyTel, 
        thirdPartyAddress: firstPartyAddress
      });
    }

    if((val == '2' && changeRadioValue == '3') || (val == '3' && changeRadioValue == '2')) {
      setFieldsValue({
        secondPartyName: thirdPartyName,
        secondPartyIdCardNo: thirdPartyIdCardNo, 
        secondPartyTel: thirdPartyTel, 
        secondPartyAddress: thirdPartyAddress,
        thirdPartyName: secondPartyName,
        thirdPartyIdCardNo: secondPartyIdCardNo, 
        thirdPartyTel: secondPartyTel, 
        thirdPartyAddress: secondPartyAddress
      });
    }
    this.setState({
      changeRadioValue: val
    });
  };
  handleAddContractSubmit = (e) => {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      if (!err) {
        const { setFieldsValue } = this.props.form;
        if (this.state.fileNumber === 0) {
          setFieldsValue({ contractUrl: "" });
          return message.error("请先上传一份合同文件");
        }
        if (
          values.agreementSignDate &&
          values.agreementSignDate !== undefined
        ) {
          values.agreementSignDate = values["agreementSignDate"].format(
            dateFormat
          );
        } else {
          values.agreementSignDate = "";
        }
        // if (values.effectDate && values.effectDate !== undefined) {
        //   values.effectStartDate = values["effectDate"][0].format("YYYY-MM-DD");
        //   values.effectEndDate = values["effectDate"][1].format("YYYY-MM-DD");
        //   delete values.effectDate;
        // } else {
        //   values.effectStartDate = "";
        //   values.effectEndDate = "";
        //   delete values.effectDate;
        // }
        if (
          new Date(values["effectStartDate"].format(dateFormat)) >
          new Date(values["effectEndDate"].format(dateFormat))
        ) {
          return message.warning("结束时间要晚于开始时间");
        }
        values.effectStartDate = values["effectStartDate"].format(dateFormat);
        values.effectEndDate = values["effectEndDate"].format(dateFormat);
        if (values.payDate && values.payDate !== undefined) {
          values.payDate = values["payDate"].format(dateFormat);
        } else {
          values.payDate = "";
        }
        if (this.state.contractType == "01") {
          if (this.state.taskStationArrs.length > 0) {
            //如果信息不完善
            const data = this.state.taskStationArrs;
            for (let i = 0; i < data.length; i++) {
              if (!data[i].stationName || !data[i].stationAddress) {
                message.error("请填写完整驻勤点信息");
                return;
              } else {
                values.taskStationArrs = JSON.stringify(
                  this.state.taskStationArrs
                );
              }
            }
          }
        }

        values.perId = this.state.perId;
        api.enterpriseComContractInsertComContract({ ...values }).then(
          () => {
            // message.success('保存成功！');
            // setTimeout(() => {
            // this.props.history.push(`/contractManagement/contractList`);
            // this.props.history.push(this.props.location.state.url);
            this.returnAfter();
            // }, 1000);
          },
          (err1) => {
            console.log(err1);
          }
        );
      }
    });
  };

  //验证企业档案编号
  checkComFileNo = (rule, value, callback) => {
    if (value && !/^[0-9a-zA-Z]+$/.test(value)) {
      callback("请输入正确的企业档案编号！");
    } else {
      callback();
    }
  };

  //验证手机号码
  checkPhone = (rule, value, callback) => {
    if (value && !/^0\d{2,3}-?\d{7,8}$/.test(value)) {
      callback("请输入正确的联系方式！");
    } else {
      callback();
    }
  };

  //乙方类型按钮切换
  // onChangeyiTypeRadio = e => {
  //   const { setFieldsValue } = this.props.form;
  //   this.setState({
  //     radioYiTypeValue: e.target.value
  //   });
  //   setFieldsValue({
  //     secondPartyName: "",
  //     secondPartyIdCardNo: "",
  //     secondPartyTel: ""
  //   });
  // };
  $add() {
    const newData = this.state.taskStationArrs.map((item) => ({ ...item }));
    newData.push({
      // [idName]: `NEW_TEMP_ID_${this[param]}`,
      id: `NEW_TEMP_ID_${this.taskStationArrs}`,
      stationName: "",
      stationAddress: "",
    });
    this.taskStationArrs += 1;
    this.setState({ taskStationArrs: newData });
  }
  //删除
  $remove(id) {
    const newData = this.state.taskStationArrs.filter((item) => item.id !== id);
    this.setState({ taskStationArrs: newData });
  }
  $handleFieldChange(id, value, name) {
    const newData = this.state.taskStationArrs.map((item) => ({ ...item }));
    const target = this.$getRowByKey(id, newData);
    if (target) {
      target[name] = value;
      this.setState({ taskStationArrs: newData });
    }
  }
  $getRowByKey(id, newData) {
    return (newData || this.state.taskStationArrs).filter(
      (item) => item.id === id
    )[0];
  }
  returnAfter() {
    this.props.history.push({
      pathname: this.props.location.state
        ? this.props.location.state.url
        : `/contractManagement/contractList`,
      state: {
        keyTab: this.props.location.state
          ? this.props.location.state.keyTab
          : "1",
      },
    });
  }
  render() {
    const { info } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: {
          span: 24,
        },
        sm: {
          span: 7,
        },
      },
      wrapperCol: {
        xs: {
          span: 24,
        },
        sm: {
          span: 10,
        },
        md: {
          span: 10,
        },
      },
    };
    const submitFormLayout = {
      wrapperCol: {
        xs: { span: 24, offset: 0 },
        sm: { span: 10, offset: 7 },
      },
    };
    const { getFieldDecorator } = this.props.form;
    const taskColumns = [
      {
        title: "序号",
        dataIndex: "name",
        key: "name",
        width: "100",
        render: (text, record, index) => {
          return <span>{index + 1}</span>;
        },
      },
      {
        title: "驻勤点名称",
        dataIndex: "stationName",
        key: "stationName",
        width: "300",
        render: (text, record) => {
          return (
            <Input
              style={{ width: "100%" }}
              value={text}
              onChange={(e) =>
                this.$handleFieldChange(
                  record.id,
                  e.target.value,
                  "stationName"
                )
              }
              maxLength={50}
              placeholder="请输入驻勤点名称"
            />
          );
        },
      },
      {
        title: "驻勤点地址",
        dataIndex: "stationAddress",
        key: "stationAddress",
        width: "300",
        render: (text, record) => {
          return (
            <Input
              style={{ width: "100%" }}
              value={text}
              onChange={(e) =>
                this.$handleFieldChange(
                  record.id,
                  e.target.value,
                  "stationAddress"
                )
              }
              maxLength={100}
              placeholder="请输入驻勤点地址"
            />
          );
        },
      },
      {
        title: "操作",
        dataIndex: "option",
        key: "option",
        width: "80",
        render: (text, record) => (
          <div>
            <span
              style={{
                color: "#D9001B",
                cursor: "pointer",
                marginRight: "20px",
              }}
            >
              <Popconfirm
                overlayClassName="change-clock-pop "
                title="是否要删除此行？"
                onConfirm={(e) => this.$remove(record.id)}
              >
                <a>删除</a>
              </Popconfirm>
            </span>
          </div>
        ),
      },
    ];
    return (
      <div className="addContract">
        <Breadcrumb
          style={{
            padding: "0px 0px 10px 10px",
            borderBottom: "1px solid #E9E9E9",
          }}
        >
          <Breadcrumb.Item>
            <a
              onClick={() => {
                // this.props.history.push(this.props.location.state?this.props.location.state.url:`/contractManagement/contractList`);
                this.returnAfter();
              }}
            >
              {/* 合同列表 */}
              {this.props.location.state
                ? this.props.location.state.title
                : "合同列表"}
            </a>
          </Breadcrumb.Item>
          <Breadcrumb.Item>添加合同</Breadcrumb.Item>
        </Breadcrumb>
        {/* <div className="bz-title" style={{paddingBottom:'16px',marginLeft:'24px',lineHeight: '1',fontSize: '20px',color: '#333',borderBottom: '1px solid #e9e9e9'}}>添加合同</div> */}
        <div style={{ marginTop: 20 }}>
          <Form
            className="addContract-form"
            onSubmit={this.handleAddContractSubmit}
          >
            <FormItem {...formItemLayout} label="合同类型">
              {getFieldDecorator("contractType", {
                initialValue: this.state.currentRow.contractType,
                // initialValue: "01",
                rules: [
                  {
                    required: true,
                    message: "请选择合同类型",
                  },
                ],
              })(
                <PSelect
                  style={{ width: 400 }}
                  placeholder="请选择"
                  type="contractType"
                  onChange={this.pSelectChange}
                  cache={false}
                  disabled
                />
              )}
            </FormItem>
            <FormItem {...formItemLayout} label="合同名称">
              {getFieldDecorator("contractName", {
                //如果从未签订人员中进来的，合同名称要事项拼接好
                initialValue: this.state.currentRow.secondPartyName ? this.state.currentRow.secondPartyName+"劳动合同":this.state.currentRow.contractName,
                rules: [
                  {
                    required: true,
                    message: "请输入合同名称",
                  },
                ],
              })(<Input disabled={this.state.currentRow.contractType=='02'} placeholder={this.state.currentRow.contractType=='02'?'请先选择人员':'请输入'} maxLength={30} />)}
            </FormItem>
            <FormItem {...formItemLayout} label="企业档案编号">
              {getFieldDecorator("comFileNo", {
                initialValue: this.state.currentRow.comFileNo,
                rules: [
                  {
                    required: true,
                    message: "请输入企业档案编号",
                  },
                  // {
                  //   validator: this.checkComFileNo
                  // }
                ],
              })(<Input placeholder="请输入" maxLength={30} />)}
            </FormItem>
            <FormItem {...formItemLayout} label="我方为">
              {getFieldDecorator("comParty", {
                initialValue: this.state.currentRow.comParty,
                rules: [
                  {
                    required: true,
                    message: "请选择甲方/乙方",
                  },
                ],
              })(
                <RadioGroup
                  style={{ width: 400 }}
                  onChange={this.onChangeRadio}
                >
                  <Radio value={"1"}>甲方</Radio>
                  <Radio value={"2"}>乙方</Radio>
                  {this.state.contractType == "01" && (
                    <Radio value={"3"}>丙方</Radio>
                  )}
                </RadioGroup>
              )}
            </FormItem>
            <FormItem {...formItemLayout} label="甲方名称">
              {getFieldDecorator("firstPartyName", {
                initialValue: this.state.currentRow.firstPartyName,
                rules: [
                  {
                    required: true,
                    message: "请输入",
                  },
                ],
              })(
                <Input
                  placeholder="请选择"
                  disabled={this.props.form.getFieldValue("comParty") === "1"}
                  maxLength={30}
                  onClick={() => {
                    if (
                      this.state.radioYiTypeValue === "01" &&
                      this.state.changeRadioValue === "2"
                    ) {
                      if (
                        this.state.contractType === "02" ||
                        this.state.contractType === "03"
                      ) {
                        $perModal({
                          type: "radio",
                          value: this.state.checkedkeys,
                          onOk: (values, close) => {
                            close();
                            const { setFieldsValue } = this.props.form;
                            this.setState({
                              perId: values[0].perId,
                              checkedkeys: values,
                            });
                            setFieldsValue({
                              firstPartyName: values[0].name,
                              firstPartyIdCardNo: values[0].idCardNo,
                              firstPartyTel: values[0].mobilePhone,
                              contractName: values[0].name+"劳动合同"
                            });
                          },
                        });
                      }
                    }
                  }}
                />
              )}
            </FormItem>
            <FormItem {...formItemLayout} label="甲方联系电话">
              {getFieldDecorator("firstPartyTel", {
                initialValue: this.state.currentRow.firstPartyTel,
                rules: [
                  {
                    required: true,
                    message: "请输入联系电话",
                  },
                  {
                    pattern: /^((0\d{2,3}-\d{7,8})|(1[0-9]{10}))$/,
                    message: "联系电话格式错误！",
                  },
                ],
              })(<Input placeholder="请输入" maxLength={20} />)}
            </FormItem>
            {this.state.contractType == "01" && (
              <FormItem {...formItemLayout} label="甲方办公地址">
                {getFieldDecorator("firstPartyAddress", {
                  initialValue: this.state.currentRow.firstPartyAddress,
                  rules: [
                    {
                      required: true,
                      message: "请输入办公地址",
                    },
                  ],
                })(<Input placeholder="请输入" maxLength={50} />)}
              </FormItem>
            )}
            {/* {this.state.changeRadioValue === "1" ? (
              this.state.contractType === "02" ||
              this.state.contractType === "03" ? (
                // 合同类型=劳动合同/劳务合同-个人时新增字段
                <FormItem {...formItemLayout} label="乙方类型">
                  {getFieldDecorator("yiType", {
                    initialValue: this.state.radioYiTypeValue,
                    rules: [
                      {
                        required: false,
                        message: "请选择从组织架构选择/自行输入"
                      }
                    ]
                  })(
                    <RadioGroup
                      style={{ width: 400 }}
                      onChange={this.onChangeyiTypeRadio}
                    >
                      <Radio value={"01"}>从组织架构选择</Radio>
                      <Radio value={"02"}>自行输入</Radio>
                      <p style={{ color: "#e0ad13", marginBotton: "0px" }}>
                        注：从组织架构中选择人员签订的合同，才能跟人员进行关联，人员操作离职后，合同自动终止。
                      </p>
                    </RadioGroup>
                  )}
                </FormItem>
              ) : (
                ""
              )
            ) : (
              ""
            )} */}
            <FormItem {...formItemLayout} label="乙方名称">
              {getFieldDecorator("secondPartyName", {
                initialValue:this.state.currentRow.secondPartyName,
                rules: [
                  {
                    required: true,
                    message: "请输入",
                  },
                ],
              })(
                <Input
                  placeholder="请选择"
                  disabled={this.props.form.getFieldValue("comParty") === "2"}
                  maxLength={30}
                  onClick={() => {
                    if (
                      this.state.radioYiTypeValue === "01" &&
                      this.state.changeRadioValue === "1"
                    ) {
                      if (
                        this.state.contractType === "02" ||
                        this.state.contractType === "03"
                      ) {
                        $perModal({
                          type: "radio",
                          value: this.state.checkedkeys,
                          onOk: (values, close) => {
                            close();
                            const { setFieldsValue } = this.props.form;
                            this.setState({
                              perId: values[0].perId,
                              checkedkeys: values,
                            });
                            setFieldsValue({
                              secondPartyName: values[0].name,
                              secondPartyIdCardNo: values[0].idCardNo,
                              secondPartyTel: values[0].mobilePhone,
                              contractName: values[0].name+"劳动合同"
                            });
                          },
                        });
                      }
                    }
                  }}
                />
              )}
            </FormItem>
            <FormItem {...formItemLayout} label="乙方联系电话">
              {getFieldDecorator("secondPartyTel", {
                initialValue:this.state.currentRow.secondPartyTel,
                rules: [
                  {
                    required: true,
                    message: "请输入",
                  },
                  {
                    pattern: /^((0\d{2,3}-\d{7,8})|(1[0-9]{10}))$/,
                    message: "联系电话格式错误！",
                  },
                ],
              })(<Input placeholder="请输入" maxLength={20} />)}
            </FormItem>
            {this.state.contractType == "01" && (
              <FormItem {...formItemLayout} label="乙方办公地址">
                {getFieldDecorator("secondPartyAddress", {
                  initialValue: this.state.currentRow.secondPartyAddress,
                  rules: [
                    {
                      required: true,
                      message: "请输入",
                    },
                  ],
                })(<Input placeholder="请输入" maxLength={50} />)}
              </FormItem>
            )}

            
            <div style={{
              display: this.state.contractType == "01" && 
              this.props.form.getFieldValue("comParty") === "3"? 'block': 'none'
            }}>
              <FormItem {...formItemLayout} label="丙方名称">
                  {getFieldDecorator("thirdPartyName", {
                    initialValue:this.state.currentRow.thirdPartyName,
                    rules: [
                      {
                        required: this.state.contractType == "01" && 
                        this.props.form.getFieldValue("comParty") === "3",
                        message: "请输入",
                      },
                    ],
                  })(
                    <Input
                      disabled={this.props.form.getFieldValue("comParty") === "3"}
                      placeholder="请输入"
                      maxLength={30}
                      onFocus={() => {}}
                    />
                  )}
                </FormItem>
                <FormItem {...formItemLayout} label="丙方联系电话">
                  {getFieldDecorator("thirdPartyTel", {
                    initialValue:this.state.currentRow.thirdPartyTel,
                    rules: [
                      {
                        required: this.state.contractType == "01" && 
                        this.props.form.getFieldValue("comParty") === "3",
                        message: "请输入",
                      },
                      {
                        pattern: /^((0\d{2,3}-\d{7,8})|(1[0-9]{10}))$/,
                        message: "联系电话格式错误！",
                      },
                    ],
                  })(<Input placeholder="请输入" maxLength={20} />)}
                </FormItem>
                <FormItem {...formItemLayout} label="丙方办公地址">
                  {getFieldDecorator("thirdPartyAddress", {
                    initialValue: this.state.currentRow.thirdPartyAddress,
                    rules: [
                      {
                        required: this.state.contractType == "01" && 
                        this.props.form.getFieldValue("comParty") === "3",
                        message: "请输入",
                      },
                    ],
                  })(<Input placeholder="请输入" maxLength={50} />)}
                </FormItem>
            </div>

            {/* <FormItem {...formItemLayout} label="合同有效期">
              {getFieldDecorator("effectDate", {
                rules: [
                  {
                    required: true,
                    message: "请选择合同有效期"
                  }
                ]
              })(
                <RangePicker
                  onChange={this.validDeadlineChange}
                  format={dateFormat}
                />
              )}
            </FormItem> */}
            <FormItem
              {...formItemLayout}
              label="合同开始时间"
              extra={
                <Checkbox
                  onChange={(value) => {
                    this.setState({
                      Indefinite:value.target.checked
                    })
                    const { setFieldsValue } = this.props.form;
                    if(!value.target.checked){
                      setFieldsValue({
                        effectEndDate:'',
                      });
                    }else{
                      setFieldsValue({
                        effectEndDate:moment('9999-12-31'),
                      });
                    }
                  }}
                >
                  此合同为无固定期限合同
                </Checkbox>
              }
            >
              {getFieldDecorator("effectStartDate", {
                rules: [
                  {
                    required: true,
                    message: "请选择合同开始时间",
                  },
                ],
              })(<DatePicker format={dateFormat} />)}
            </FormItem>
            <FormItem {...formItemLayout} label="合同结束时间">
              {getFieldDecorator("effectEndDate", {
                rules: [
                  {
                    required: true,
                    message: "请选择合同结束时间",
                  },
                ],
              })(<DatePicker format={dateFormat} disabled={this.state.Indefinite}/>)}
            </FormItem>
            <FormItem {...formItemLayout} label="合同备注信息">
              {getFieldDecorator("remark", {
                initialValue: this.state.currentRow.remark,
              })(
                <TextArea
                  rows={4}
                  placeholder="请输入合同备注信息"
                  maxLength={300}
                />
              )}
            </FormItem>
            <FormItem {...formItemLayout} label="合同电子文件">
              {getFieldDecorator("contractUrl", {
                initialValue: this.state.currentRow.contractUrl,
                rules: [
                  {
                    required: true,
                    message: "请上传文件",
                  },
                ],
              })(
                <div style={{ width: 400 }}>
                  <Upload
                    defaultFileList={[]}
                    fileList={this.state.fileList}
                    {...this.modelUpload}
                    // onRemove={this.onRemoveUrl}
                    onRemove={() => {
                      return false;
                    }}
                    className="remove-no"
                  >
                    <Button style={{ marginRight: "8px" }}>
                      <Icon type="upload" />
                      上传文件
                    </Button>
                    支持扩展名：.doc\.docx\.pdf
                  </Upload>
                </div>
              )}
            </FormItem>
            {this.state.contractType == "01" && (
              <Form.Item {...formItemLayout} label="驻勤点信息">
                {getFieldDecorator("taskStationArrs", {
                  initialValue: this.state.taskStationArrs,
                  rules: [
                    {
                      required: true,
                      message: "请输入驻勤点信息!",
                    },
                  ],
                })(
                  <div>
                    <div style={{ color: "#e0ad13" }}>
                      请填写合同中服务驻勤点信息，便于创建驻勤点值守时进行查询关联合同。
                    </div>
                    <Table
                      dataSource={this.state.taskStationArrs}
                      columns={taskColumns}
                      pagination={false}
                    />
                    <Button
                      type="primary"
                      onClick={() => {
                        this.$add();
                      }}
                    >
                      + 添加一行
                    </Button>
                  </div>
                )}
              </Form.Item>
            )}

            <FormItem {...submitFormLayout} style={{ marginTop: 32 }}>
              <Button
                onClick={() => {
                  this.props.history.go(-1);
                }}
              >
                取消
              </Button>
              <Button
                type="primary"
                style={{ marginLeft: 8 }}
                onClick={this.handleAddContractSubmit}
              >
                保存
              </Button>
            </FormItem>
          </Form>
        </div>
      </div>
    );
  }
}
