import React from 'react';
import PropTypes from 'prop-types';
import { Link, Route } from 'dva/router';
import DocumentTitle from 'react-document-title';
import { Icon } from 'antd';
import GlobalFooter from '../components/GlobalFooter';
import styles from './UserLayout.less';
import { domainConfig } from '../utils/config';
import { connect } from 'dva';
@connect(state => ({
    companyInfo: state.global.companyInfo
}))
class UserLayout extends React.PureComponent {
  static childContextTypes = {
    location: PropTypes.object
  };
  getChildContext() {
    const { location } = this.props;
    return { location };
  }
  getPageTitle() {
    const { getRouteData, location } = this.props;
    const { pathname } = location;
    let title = domainConfig.getName(this.props.companyInfo.regProvince,this.props.companyInfo.regCity);
    getRouteData('UserLayout').forEach(item => {
      if (item.path === pathname) {
        title = `${item.name}`;
      }
    });
    return title;
  }
  render() {
    const { getRouteData } = this.props;

    return (
      <DocumentTitle title={this.getPageTitle()}>
        <div className={styles.UserLayout}>
          {/* <div className={styles.top}>
            <div className={styles.header}>
              <Link to="/">
                <img alt="" className={styles.logo} src="https://gw.alipayobjects.com/zos/rmsportal/NGCCBOENpgTXpBWUIPnI.svg" />
                <span className={styles.title}>Ant Design</span>
              </Link>
            </div>
            <div className={styles.desc}>Ant Design 是西湖区最具影响力的 Web 设计规范</div>
          </div> */}
          {getRouteData('UserLayout').map(item => (
            <Route
              exact={item.exact}
              key={item.path}
              path={item.path}
              component={item.component}
            />
          ))}
          <div id="footer">
             <GlobalFooter style={{ 'padding': '0' }}
            copyright={
              <div>
                Copyright <Icon type="copyright" /> {new Date().getFullYear()}
                百川信（厦门）网络信息服务有限公司
              </div>
            }
          />
          </div>
         
        </div>
      </DocumentTitle>
    );
  }
}

export default UserLayout;
