import store from "@/store.js";
import TextMessageContent from "@/wfc/messages/textMessageContent";
import wfc from "@/wfc/client/wfc";
import Conversation from "@/wfc/model/conversation";
import ConversationType from "@/wfc/model/conversationType";

export const createGroup = ({ memberList, name, schedulingContent }) => {
  console.log("members", memberList);
  const users = memberList.map((x) => {
    const { name, tenantImUserId } = x;
    return {
      uid: tenantImUserId + "",
      displayName: name,
    };
  });
  console.log("group users", users);
  // 创建会话
  store.createConversation(
    users,
    (conversation) => {
      let textMessage = new TextMessageContent(schedulingContent);
      wfc.sendConversationMessage(conversation, textMessage);
    },
    null,
    name
  );
  return Promise.resolve();
};

export const character = (info) => {
  let conversation = new Conversation(ConversationType.Single, info.tencentUserId, 0);
  store.setCurrentConversation(conversation);
  return Promise.resolve();
};
