import Vue from "vue";
import Vuex from "vuex";
import getters from "./getters";
import conversation from "./modules/conversation";
import user from "./modules/user";
import group from "./modules/group";
import video from "./modules/video";
import app from "./modules/app";
import trtc from "@/store/modules/trtc";
import im from "@/store/modules/im";
import { Message } from "element-ui";

Vue.use(Vuex);

export default new Vuex.Store({
  getters,
  state: {
    current: Date.now(), // 当前时间
    intervalID: 0,
    message: undefined,
    placeKeywords: "",
    poiList: [],
    visualVisible: false,
    cachedViews: [],
    visitedViews: [],
    appLoadingMask: null,
    currentLocation: [],
  },
  mutations: {
    SET_APP_LOADING_MASK(state, payload) {
      state.appLoadingMask = payload;
    },
    SET_CURRENT_LOCATION(state, payload) {
      state.currentLocation = payload;
    },
    SET_POI_LIST(state, list) {
      console.log("poiList", list);
      state.poiList = list;
    },
    SET_PLACE_KEYWORDS(state, keywords) {
      state.placeKeywords = keywords;
    },
    startComputeCurrent(state) {
      state.intervalID = setInterval(() => {
        state.current = Date.now();
      }, 500);
    },
    showMessage(state, options) {
      if (state.message) {
        state.message.close();
      }
      state.message = Message({
        message: options.message,
        type: options.type || "success",
        duration: options.duration || 2000,
        offset: 40,
      });
    },
    SET_VISUAL_VISIBLE(state, visible) {
      state.visualVisible = visible;
    },
    ADD_VISITED_VIEWS: (state, view) => {
      if (state.visitedViews.some((v) => v.path === view.path)) return;
      state.visitedViews.push({
        name: view.name,
        path: view.path,
        title: view.meta.title || "no-name",
      });
      if (view.meta?.cache) {
        state.cachedViews.push(view.name);
      }
    },
  },
  actions: {
    addVisitedViews({ commit }, view) {
      return new Promise((resolve) => {
        commit("ADD_VISITED_VIEWS", view);
        resolve();
      });
    },
  },
  modules: {
    conversation,
    user,
    group,
    video,
    app,
    trtc,
    im,
  },
});
