import Single from "@/ui/voip/Single.vue";
import Multi from "@/ui/voip/Multi.vue";
import Conference from "@/ui/voip/conference/Conference.vue";

const children = [
  {
    path: "/dispatch",
    name: "dispatch",
    component: () => import(/* webpackChunkName: "home" */ "../views/dispatch/index.vue"),
    meta: {
      title: "指挥调度",
      cache: true,
      platform: ["*"],
    },
  },
  {
    path: "/resources",
    name: "resources",
    component: () => import(/* webpackChunkName: "resources" */ "../views/resources/index.vue"),
    meta: {
      title: "安保资源",
      cache: true,
      platform: ["1"],
    },
  },
  {
    path: "/business",
    name: "business",
    component: () => import(/* webpackChunkName: "business" */ "../views/business/index.vue"),
    meta: {
      title: "业务管理",
      cache: true,
      platform: ["*"],
    },
  },
];

export default function generateRoutes(platform) {
  return [
    {
      path: "/",
      redirect: "/dispatch",
      component: () => import(/* webpackChunkName: "home" */ "../views/layout/index.vue"),
      children: children.filter((route) => {
        // const sysUserInfo = JSON.parse(userInfo);
        return route.meta.platform.includes("*") || route.meta.platform.includes(platform);
      }),
    },
    {
      path: "/rail",
      name: "rail",
      component: () => import("@/views/rail/index.vue"),
    },
    {
      name: "voip-single",
      path: "/voip/single",
      component: Single,
    },
    {
      name: "voip-multi",
      path: "/voip/multi",
      component: Multi,
    },
    {
      name: "voip-conference",
      path: "/voip/conference",
      component: Conference,
    },
    {
      path: "*", //匹配未定义的路由
      redirect: "/dispatch", //重定向
    },
  ];
}
