/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.common.utils;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class RedisUtil {
    @Resource
    private RedisTemplate<String, Object> redisTemplate;

    public boolean expire(String key, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Long getExpire(String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    public Boolean exists(String key) {
        try {
            return this.redisTemplate.hasKey((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void delete(String ... key) {
        if (key != null && key.length > 0) {
            if (key.length == 1) {
                if (this.exists(key[0]).booleanValue()) {
                    this.redisTemplate.delete((Object)key[0]);
                }
            } else {
                this.redisTemplate.delete((Collection)CollectionUtils.arrayToList((Object)key));
            }
        }
    }

    public <T> T get(String key) {
        return (T)(key == null ? null : this.redisTemplate.opsForValue().get((Object)key));
    }

    public boolean set(String key, Object value) {
        try {
            this.redisTemplate.opsForValue().set((Object)key, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean set(String key, Object value, Long expireTime) {
        try {
            if (expireTime > 0L) {
                this.redisTemplate.opsForValue().set((Object)key, value, expireTime.longValue(), TimeUnit.SECONDS);
            } else {
                this.set(key, value);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean set(String key, Object value, Long expireTime, TimeUnit timeUnit) {
        try {
            this.redisTemplate.opsForValue().set((Object)key, value, expireTime.longValue(), timeUnit);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Long incrAndCreate(String key) {
        if (!this.exists(key).booleanValue()) {
            this.set(key, 1);
            return 1L;
        }
        return this.incr(key, 1L);
    }

    public Long incrAndCreate(String key, long delta) {
        if (!this.exists(key).booleanValue()) {
            this.set(key, delta);
            return delta;
        }
        return this.incr(key, delta);
    }

    public Long incr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, delta);
    }

    public Long decr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, -delta);
    }

    public Object hget(String key, String item) {
        return this.redisTemplate.opsForHash().get((Object)key, (Object)item);
    }

    public Map<Object, Object> hmget(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public boolean hset(String key, String item, Object value) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean hset(String key, String item, Object value, long time) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean hmSet(String key, Map<String, Object> map) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean hmset(String key, Map<String, Object> map, long time) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void hmDelete(String key, Object hashKey) {
        this.redisTemplate.opsForHash().delete((Object)key, new Object[]{hashKey});
    }

    public void hmDelete(String key, Object ... item) {
        this.redisTemplate.opsForHash().delete((Object)key, item);
    }

    public boolean hHasKey(String key, String item) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)item);
    }

    public long hincr(String key, String item, long by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, by);
    }

    public long hdecr(String key, String item, long by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, -by);
    }

    public Long getHashSize(String key) {
        return this.redisTemplate.opsForHash().size((Object)key);
    }

    public boolean lPush(String key, Object value) {
        try {
            this.redisTemplate.opsForList().leftPush((Object)key, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean lSet(String key, Object value, long time) {
        try {
            this.redisTemplate.opsForList().leftPush((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Object getRightPop(String k, Long t) {
        return this.redisTemplate.opsForList().rightPop((Object)k, t.longValue(), TimeUnit.SECONDS);
    }

    public Long getListSize(String key) {
        try {
            return this.redisTemplate.opsForList().size((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public List<Object> lGet(String key, long start, long end) {
        try {
            return this.redisTemplate.opsForList().range((Object)key, start, end);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object lGetIndex(String key, long index) {
        try {
            return this.redisTemplate.opsForList().index((Object)key, index);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean lUpdateIndex(String key, long index, Object value) {
        try {
            this.redisTemplate.opsForList().set((Object)key, index, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Long lRemove(String key, long count, Object value) {
        try {
            return this.redisTemplate.opsForList().remove((Object)key, count, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public Set<Object> sGet(String key) {
        try {
            return this.redisTemplate.opsForSet().members((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Boolean sHasKey(String key, Object value) {
        try {
            return this.redisTemplate.opsForSet().isMember((Object)key, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Long sSet(String key, Object ... values) {
        try {
            return this.redisTemplate.opsForSet().add((Object)key, values);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public Long sSetAndTime(String key, long time, Object ... values) {
        try {
            Long count = this.redisTemplate.opsForSet().add((Object)key, values);
            if (time > 0L) {
                this.expire(key, time);
            }
            return count;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public Long sGetSetSize(String key) {
        try {
            return this.redisTemplate.opsForSet().size((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public Long setRemove(String key, Object ... values) {
        try {
            return this.redisTemplate.opsForSet().remove((Object)key, values);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public void zAdd(String key, Object value, double score) {
        ZSetOperations zset = this.redisTemplate.opsForZSet();
        zset.add((Object)key, value, score);
    }

    public Set<Object> rangeByScore(String key, double score, double score1) {
        ZSetOperations zset = this.redisTemplate.opsForZSet();
        return zset.rangeByScore((Object)key, score, score1);
    }

    public boolean getRedisRepetition(String id) {
        Long count = this.redisTemplate.opsForValue().increment((Object)("repeat_submit:" + id), 1L);
        if (count == 1L) {
            this.redisTemplate.expire((Object)("repeat_submit:" + id), 5L, TimeUnit.SECONDS);
            return true;
        }
        return false;
    }

    public boolean setNx(String key, String value, long timeout) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, timeout, TimeUnit.SECONDS);
    }
}

