/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.common.exception;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.zbkj.common.exception.CrmebException;

public interface Assert {
    public CrmebException newException();

    default public <T> T assertNotNull(T obj) {
        if (ObjectUtil.isEmpty(obj)) {
            throw this.newException();
        }
        return obj;
    }

    default public void assertIsNull(Object obj) {
        if (ObjectUtil.isNotNull((Object)obj)) {
            throw this.newException();
        }
    }

    default public void assertNotEquals(Object obj, Object obj1) {
        if (ObjectUtil.equal((Object)obj, (Object)obj1)) {
            throw this.newException();
        }
    }

    default public void assertNotEmptyStr(String str) {
        if (StrUtil.isBlank((CharSequence)str)) {
            throw this.newException();
        }
    }

    default public void assertEquals(Object obj, Object obj1) {
        if (ObjectUtil.notEqual((Object)obj, (Object)obj1)) {
            throw this.newException();
        }
    }

    default public void assertIsTrue(boolean expression) {
        if (!expression) {
            throw this.newException();
        }
    }

    default public void assertIsFalse(boolean expression) {
        if (expression) {
            throw this.newException();
        }
    }

    default public int assertBetween(int value, int min, int max) {
        if (value >= min && value <= max) {
            return value;
        }
        throw this.newException();
    }

    default public long assertBetween(long value, long min, long max) {
        if (value >= min && value <= max) {
            return value;
        }
        throw this.newException();
    }

    default public double assertBetween(double value, double min, double max) {
        if (value >= min && value <= max) {
            return value;
        }
        throw this.newException();
    }

    default public int assertGreaterThan(int value, int min) {
        if (value <= min) {
            throw this.newException();
        }
        return value;
    }
}

