CREATE TABLE `eb_js_pay_trade` (
                                   `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '账户交易记录主键ID',
                                   `uni_id` varchar(32) NOT NULL DEFAULT '' COMMENT '用户uni_id',
                                   `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
                                   `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
                                   `req_seq_id` varchar(32) DEFAULT NULL COMMENT '请求流水号',
                                   `hf_seq_id` varchar(64) DEFAULT NULL COMMENT '全局流水号',
                                   `income_account_no` varchar(32) DEFAULT NULL COMMENT '入账方商户号',
                                   `outcome_account_no` varchar(32) DEFAULT NULL COMMENT '出账方商户号',
                                   `in_uni_id` varchar(32) DEFAULT NULL COMMENT '入账方用户id（退款）',
                                   `amount` decimal(10,2) DEFAULT NULL COMMENT '金额',
                                   `good_desc` varchar(256) DEFAULT NULL COMMENT '商品描述',
                                   `remark` varchar(256) DEFAULT NULL COMMENT '备注',
                                   `trade_status` varchar(6) DEFAULT NULL COMMENT '交易状态',
                                   `trans_finish_time` timestamp NULL DEFAULT NULL COMMENT '交易完成时间',
                                   `business_partner_seq` varchar(60) DEFAULT NULL COMMENT '业务交易流水号',
                                   `old_business_partner_seq` varchar(60) DEFAULT NULL COMMENT '原业务交易流水号',
                                   `business_code` varchar(20) DEFAULT NULL COMMENT '业务编码',
                                   `trade_type` varchar(255) DEFAULT NULL COMMENT '校验类型',
                                   `error_msg` varchar(255) DEFAULT NULL COMMENT '失败原因',
                                   `wx_data` varchar(1000) DEFAULT NULL COMMENT '聚合正扫微信拓展参数集合JSON',
                                   `alipay_data` varchar(1000) DEFAULT NULL COMMENT '支付宝扩展参数集合',
                                   `pay_info` varchar(1000) DEFAULT NULL COMMENT 'js支付信息',
                                   `qr_code` varchar(500) DEFAULT NULL COMMENT '二维码链接',
                                   PRIMARY KEY (`id`) USING BTREE,
                                   KEY `index_js_pay_trade_user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COMMENT='C端交易记录';
