/*
 Navicat Premium Data Transfer

 Source Server         : bcx_test_qy
 Source Server Type    : MySQL
 Source Server Version : 50731 (5.7.31-log)
 Source Host           : 220.243.148.23:2111
 Source Schema         : crmeb

 Target Server Type    : MySQL
 Target Server Version : 50731 (5.7.31-log)
 File Encoding         : 65001

 Date: 15/08/2023 14:42:09
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for bcx_product_quota
-- ----------------------------
DROP TABLE IF EXISTS `bcx_product_quota`;
CREATE TABLE `bcx_product_quota` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '限购id',
  `product_id` int(11) NOT NULL COMMENT '限购商品id',
  `enabled` tinyint(1) DEFAULT NULL COMMENT '启用限购 1-启用 0其他-不启用',
  `one_quota` int(11) DEFAULT NULL COMMENT '单次限购数量',
  `all_quota` int(11) DEFAULT NULL COMMENT '用户总限购数量',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_index_bcx_product_quota_product_id` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COMMENT='商品限购表';

-- ----------------------------
-- Table structure for bcx_product_rules
-- ----------------------------
DROP TABLE IF EXISTS `bcx_product_rules`;
CREATE TABLE `bcx_product_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '商品可见规则表id',
  `referenceId` varchar(200) NOT NULL COMMENT '外部唯一ID',
  `product_id` int(11) unsigned DEFAULT NULL COMMENT '商品ID',
  `match_type` int(2) DEFAULT NULL COMMENT '规则类型 0: none全部可见 1: organization 指定企业 2: region 指定区域 ',
  `match_value` varchar(255) DEFAULT NULL,
  `industry_code` varchar(200) DEFAULT NULL,
  `institutional_code` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `referenceId` (`referenceId`) USING BTREE,
  UNIQUE KEY `unique_index_bcx_product_rules_reference_id` (`referenceId`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=281 DEFAULT CHARSET=utf8mb4 COMMENT='商品可见规则表';

-- ----------------------------
-- Table structure for bcx_user_relation
-- ----------------------------
DROP TABLE IF EXISTS `bcx_user_relation`;
CREATE TABLE `bcx_user_relation` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户账号关联id',
  `uid` int(11) NOT NULL COMMENT '用户id',
  `sub_uid` int(11) NOT NULL COMMENT '关联用户id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for eb_activity_product
-- ----------------------------
DROP TABLE IF EXISTS `eb_activity_product`;
CREATE TABLE `eb_activity_product` (
  `aid` int(11) NOT NULL COMMENT '活动id',
  `pro_id` int(11) NOT NULL COMMENT '商品id',
  `pro_image` varchar(256) NOT NULL DEFAULT '' COMMENT '活动商品图片',
  `sort` int(5) NOT NULL DEFAULT '999' COMMENT '排序',
  PRIMARY KEY (`aid`,`pro_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='活动商品关联表';

-- ----------------------------
-- Table structure for eb_activity_style
-- ----------------------------
DROP TABLE IF EXISTS `eb_activity_style`;
CREATE TABLE `eb_activity_style` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(255) NOT NULL COMMENT '活动名称',
  `type` bit(1) NOT NULL COMMENT '活动类型0=活动边框，1=活动背景',
  `starttime` datetime NOT NULL COMMENT '开始时间',
  `endtime` datetime NOT NULL COMMENT '结束时间',
  `style` varchar(255) NOT NULL COMMENT '活动边框素材地址',
  `status` bit(1) NOT NULL COMMENT '状态 0=关闭1=开启',
  `method` int(11) DEFAULT NULL COMMENT '商品参与类型 0=全部商品参与，1=指定商品参与，2=指定品牌参与，3=指定商品分类参与,4=指定商户产品',
  `products` varchar(500) DEFAULT NULL COMMENT '参与活动商品',
  `createtime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updatetime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for eb_ali_pay_callback
-- ----------------------------
DROP TABLE IF EXISTS `eb_ali_pay_callback`;
CREATE TABLE `eb_ali_pay_callback` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `notify_type` varchar(64) DEFAULT NULL COMMENT '通知的类型',
  `notify_id` varchar(128) DEFAULT NULL COMMENT '通知校验 ID',
  `app_id` varchar(32) DEFAULT NULL COMMENT '支付宝分配给开发者的应用 ID',
  `charset` varchar(10) DEFAULT NULL COMMENT '编码格式，如 utf-8、gbk、gb2312 等',
  `version` varchar(3) DEFAULT NULL COMMENT '调用的接口版本，固定为：1.0',
  `sign_type` varchar(10) DEFAULT NULL COMMENT '商户生成签名字符串所使用的签名算法类型，目前支持 RSA2 和 RSA，推荐使用 RSA2',
  `sign` varchar(500) DEFAULT NULL COMMENT '签名',
  `trade_no` varchar(64) DEFAULT NULL COMMENT '支付宝交易凭证号',
  `out_trade_no` varchar(64) DEFAULT NULL COMMENT '原支付请求的商户订单号',
  `trade_status` varchar(32) DEFAULT NULL COMMENT '交易目前所处的状态:WAIT_BUYER_PAY-交易创建，等待买家付款,TRADE_CLOSED-未付款交易超时关闭，或支付完成后全额退款,3-交易支付成功,4-交易结束，不可退款',
  `total_amount` decimal(9,2) DEFAULT NULL COMMENT '本次交易支付的订单金额，单位为人民币（元）',
  `receipt_amount` decimal(9,2) DEFAULT NULL COMMENT '商家在交易中实际收到的款项，单位为人民币（元）',
  `refund_fee` decimal(9,2) DEFAULT NULL COMMENT '退款通知中，返回总退款金额，单位为人民币（元），支持两位小数',
  `subject` varchar(256) DEFAULT NULL COMMENT '商品的标题/交易标题/订单标题/订单关键字等，是请求时对应的参数，原样通知回来',
  `body` varchar(400) DEFAULT NULL COMMENT '该订单的备注、描述、明细等。对应请求时的 body 参数，原样通知回来',
  `passback_params` varchar(512) DEFAULT NULL COMMENT '公共回传参数，如果请求时传递了该参数，则返回给商户时会在异步通知时将该参数原样返回。本参数必须进行UrlEncode之后才可以发送给支付宝。',
  `notify_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '通知的发送时间。格式为 yyyy-MM-dd HH:mm:ss',
  `add_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `out_trade_no` (`out_trade_no`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='支付宝回调表';

-- ----------------------------
-- Table structure for eb_ali_pay_info
-- ----------------------------
DROP TABLE IF EXISTS `eb_ali_pay_info`;
CREATE TABLE `eb_ali_pay_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `app_id` varchar(50) DEFAULT NULL COMMENT '支付宝分配给开发者的应用ID',
  `timestamp` varchar(20) DEFAULT NULL COMMENT '发送请求的时间，格式yyyy-MM-dd HH:mm:ss',
  `body` varchar(128) DEFAULT NULL COMMENT '订单描述',
  `subject` varchar(256) DEFAULT NULL COMMENT '订单标题',
  `out_trade_no` varchar(64) DEFAULT NULL COMMENT '商户订单号',
  `timeout_express` varchar(6) DEFAULT NULL COMMENT '订单相对超时时间',
  `time_expire` varchar(32) DEFAULT NULL COMMENT '订单绝对超时时间',
  `total_amount` varchar(9) DEFAULT NULL COMMENT '订单总金额。单位为元，精确到小数点后两位',
  `passback_params` varchar(512) DEFAULT NULL COMMENT '公用回传参数,本参数必须进行UrlEncode之后才可以发送给支付宝',
  `code` varchar(32) DEFAULT NULL COMMENT '网关返回码',
  `msg` varchar(256) DEFAULT NULL COMMENT '网关返回码描述',
  `sub_code` varchar(50) DEFAULT NULL COMMENT '业务返回码',
  `sub_msg` varchar(100) DEFAULT NULL COMMENT '业务返回码描述',
  `sign` varchar(500) DEFAULT NULL COMMENT '签名',
  `trade_no` varchar(64) DEFAULT NULL COMMENT '该交易在支付宝系统中的交易流水号',
  `seller_id` varchar(20) DEFAULT NULL COMMENT '收款支付宝账号对应的支付宝唯一用户号',
  `notify_url` varchar(256) DEFAULT NULL COMMENT '支付宝服务器主动通知商户服务器里指定的页面http/https路径',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `out_trade_no` (`out_trade_no`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='支付宝订单表';

-- ----------------------------
-- Table structure for eb_article
-- ----------------------------
DROP TABLE IF EXISTS `eb_article`;
CREATE TABLE `eb_article` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '文章ID',
  `cid` int(11) NOT NULL DEFAULT '0' COMMENT '分类id',
  `title` varchar(200) NOT NULL DEFAULT '' COMMENT '文章标题',
  `author` varchar(100) NOT NULL DEFAULT '' COMMENT '文章作者',
  `cover` varchar(255) NOT NULL DEFAULT '' COMMENT '文章封面',
  `synopsis` varchar(500) DEFAULT '' COMMENT '文章简介',
  `content` text NOT NULL COMMENT '文章内容',
  `visit` bigint(15) NOT NULL DEFAULT '0' COMMENT '浏览次数',
  `is_hot` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否热门(小程序)',
  `is_banner` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否轮播图(小程序)',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '状态，0-关闭，1-开启',
  `sort` int(6) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `product_id` int(11) NOT NULL DEFAULT '0' COMMENT '商品关联id',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除，0-未删除，1-删除',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `cid` (`cid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='文章管理表';

-- ----------------------------
-- Table structure for eb_article_category
-- ----------------------------
DROP TABLE IF EXISTS `eb_article_category`;
CREATE TABLE `eb_article_category` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '文章分类ID',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '分类名称',
  `icon` varchar(255) NOT NULL DEFAULT '' COMMENT '分类图标',
  `sort` int(6) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '状态，0-关闭，1-开启',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除，0-未删除，1-删除',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='文章分类表';

-- ----------------------------
-- Table structure for eb_bill
-- ----------------------------
DROP TABLE IF EXISTS `eb_bill`;
CREATE TABLE `eb_bill` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '帐单id',
  `uid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户uid',
  `mer_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商户id',
  `link_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '关联id',
  `order_no` varchar(32) NOT NULL DEFAULT '' COMMENT '关联订单',
  `pm` int(2) unsigned NOT NULL DEFAULT '0' COMMENT '0 = 支出 1 = 获得',
  `amount` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '金额',
  `type` varchar(20) NOT NULL DEFAULT '' COMMENT '类型：pay_order-订单支付,refund_order-订单退款，recharge_user-用户充值，yue_pay-余额支付,merchant_collect-商户分账，brokerage-分佣,system-系统',
  `mark` varchar(255) NOT NULL DEFAULT '' COMMENT '备注',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '添加时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `type` (`type`) USING BTREE,
  KEY `pm` (`pm`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=167 DEFAULT CHARSET=utf8mb4 COMMENT='平台帐单表';

-- ----------------------------
-- Table structure for eb_browse_record
-- ----------------------------
DROP TABLE IF EXISTS `eb_browse_record`;
CREATE TABLE `eb_browse_record` (
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `product_id` int(11) NOT NULL DEFAULT '0' COMMENT '商品id',
  `date` varchar(12) NOT NULL DEFAULT '' COMMENT '日期：年-月-日',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`uid`,`product_id`) USING BTREE,
  KEY `date` (`date`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='浏览记录表';

-- ----------------------------
-- Table structure for eb_cart
-- ----------------------------
DROP TABLE IF EXISTS `eb_cart`;
CREATE TABLE `eb_cart` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '购物车表ID',
  `uid` int(11) unsigned NOT NULL COMMENT '用户ID',
  `mer_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商户Id',
  `product_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID',
  `product_attr_unique` int(11) NOT NULL DEFAULT '0' COMMENT '商品规格属性ID',
  `cart_num` int(5) unsigned NOT NULL DEFAULT '0' COMMENT '商品数量',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '购物车状态',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `user_id` (`uid`) USING BTREE,
  KEY `search_id` (`id`,`uid`,`mer_id`,`status`) USING BTREE,
  KEY `product_id` (`product_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='购物车表';

-- ----------------------------
-- Table structure for eb_category
-- ----------------------------
DROP TABLE IF EXISTS `eb_category`;
CREATE TABLE `eb_category` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `path` varchar(255) NOT NULL DEFAULT '/0/' COMMENT '路径',
  `name` varchar(50) NOT NULL COMMENT '分类名称',
  `type` smallint(2) DEFAULT '1' COMMENT '类型，2 附件分类, 4 设置分类， 5 菜单分类，6 配置分类， 7 秒杀配置',
  `url` varchar(255) DEFAULT '' COMMENT '地址',
  `extra` text COMMENT '扩展字段 Jsos格式',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态, 1正常，0失效',
  `sort` int(6) NOT NULL DEFAULT '99999' COMMENT '排序',
  `owner` int(11) NOT NULL DEFAULT '-1' COMMENT '分类所属：-1 - 平台，其他-商户',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `status+pid` (`pid`,`status`) USING BTREE,
  KEY `id+status+url` (`path`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8mb4 COMMENT='分类表';

-- ----------------------------
-- Table structure for eb_city_region
-- ----------------------------
DROP TABLE IF EXISTS `eb_city_region`;
CREATE TABLE `eb_city_region` (
  `region_id` int(11) NOT NULL DEFAULT '0' COMMENT '区域id',
  `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT '父区域id',
  `region_name` varchar(100) NOT NULL DEFAULT '' COMMENT '区域名称',
  `region_type` tinyint(2) NOT NULL DEFAULT '0' COMMENT '区域类型，0-国家、1-省、2-市、3-区、4-街道',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`region_id`) USING BTREE,
  KEY `parent_id` (`parent_id`) USING BTREE,
  KEY `region_type` (`region_type`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='城市区域表';

-- ----------------------------
-- Table structure for eb_community_author_concerned
-- ----------------------------
DROP TABLE IF EXISTS `eb_community_author_concerned`;
CREATE TABLE `eb_community_author_concerned` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `author_id` int(11) unsigned NOT NULL COMMENT '作者ID',
  `uid` int(11) unsigned NOT NULL COMMENT '用户ID',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uniq_data` (`author_id`,`uid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='社区作者关注表';

-- ----------------------------
-- Table structure for eb_community_category
-- ----------------------------
DROP TABLE IF EXISTS `eb_community_category`;
CREATE TABLE `eb_community_category` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `name` varchar(10) NOT NULL DEFAULT '' COMMENT '分类名称',
  `is_show` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否显示：1-显示，0-不显示',
  `sort` int(6) NOT NULL DEFAULT '0' COMMENT '排序',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除，0-未删除，1-删除',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='社区分类表';

-- ----------------------------
-- Table structure for eb_community_notes
-- ----------------------------
DROP TABLE IF EXISTS `eb_community_notes`;
CREATE TABLE `eb_community_notes` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT '' COMMENT '标题',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '笔记类型：1-图文，2-视频',
  `cover` varchar(255) NOT NULL DEFAULT '' COMMENT '封面',
  `image` varchar(2000) NOT NULL DEFAULT '' COMMENT '图片',
  `video` varchar(500) NOT NULL DEFAULT '' COMMENT '视频链接',
  `content` text NOT NULL COMMENT '笔记正文',
  `category_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '社区分类ID',
  `topic_ids` varchar(64) NOT NULL DEFAULT '' COMMENT '话题ID,英文逗号拼接',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `star` tinyint(1) DEFAULT '1' COMMENT '星级排序:1-5',
  `audit_status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '审核状态:0-待审核，1-审核通过，2-审核失败，3-平台关闭',
  `refusal` varchar(255) NOT NULL DEFAULT '' COMMENT '拒绝理由',
  `like_num` int(11) NOT NULL DEFAULT '0' COMMENT '点赞数',
  `reply_num` int(11) NOT NULL DEFAULT '0' COMMENT '评论数',
  `share_num` int(11) NOT NULL DEFAULT '0' COMMENT '分享数',
  `views` int(11) NOT NULL DEFAULT '0' COMMENT '浏览量',
  `sort` int(6) NOT NULL DEFAULT '0' COMMENT '排序',
  `reply_status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否开启评论，1-开启，2-关闭，3-平台关闭',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除，0-未删除，1-删除',
  `operate_time` timestamp NULL DEFAULT NULL COMMENT '操作时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_uid` (`uid`) USING BTREE,
  KEY `idx_front` (`type`,`audit_status`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='社区笔记表';

-- ----------------------------
-- Table structure for eb_community_notes_product
-- ----------------------------
DROP TABLE IF EXISTS `eb_community_notes_product`;
CREATE TABLE `eb_community_notes_product` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '笔记ID',
  `product_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID',
  `is_pay` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否购买：0-未购买，1-已购买',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_note_id` (`note_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='社区笔记商品表';

-- ----------------------------
-- Table structure for eb_community_notes_relation
-- ----------------------------
DROP TABLE IF EXISTS `eb_community_notes_relation`;
CREATE TABLE `eb_community_notes_relation` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` int(11) unsigned NOT NULL COMMENT '笔记ID',
  `author_id` int(11) unsigned NOT NULL COMMENT '笔记作者ID',
  `uid` int(11) unsigned NOT NULL COMMENT '用户ID',
  `type` varchar(10) NOT NULL DEFAULT 'like' COMMENT '关联类型(收藏(collect）、点赞(like))',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uniq_data` (`note_id`,`uid`) USING BTREE,
  KEY `idx_author_id` (`author_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='社区笔记关系表';

-- ----------------------------
-- Table structure for eb_community_reply
-- ----------------------------
DROP TABLE IF EXISTS `eb_community_reply`;
CREATE TABLE `eb_community_reply` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '评论类型：1-评论，2-回复',
  `uid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '发言用户ID',
  `content` varchar(255) NOT NULL DEFAULT '' COMMENT '内容',
  `parent_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '一级评论ID',
  `parent_uid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '一级用户ID',
  `review_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '原评论ID',
  `review_uid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '原评论用户ID',
  `count_start` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '点赞数',
  `count_reply` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '评论数',
  `audit_status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '审核状态:0-待审核，1-审核通过，2-审核失败',
  `refusal` varchar(255) NOT NULL DEFAULT '' COMMENT '拒绝原因',
  `note_id` int(11) NOT NULL DEFAULT '0' COMMENT '笔记id',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除，0-未删除，1-删除',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_uid` (`uid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='社区评论表';

-- ----------------------------
-- Table structure for eb_community_reply_like
-- ----------------------------
DROP TABLE IF EXISTS `eb_community_reply_like`;
CREATE TABLE `eb_community_reply_like` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` int(11) unsigned NOT NULL COMMENT '笔记ID',
  `reply_id` int(11) unsigned NOT NULL COMMENT '评论ID',
  `uid` int(11) unsigned NOT NULL COMMENT '用户ID',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_data` (`note_id`,`uid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='社区评论点赞表';

-- ----------------------------
-- Table structure for eb_community_topic
-- ----------------------------
DROP TABLE IF EXISTS `eb_community_topic`;
CREATE TABLE `eb_community_topic` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(12) NOT NULL DEFAULT '' COMMENT '话题名称',
  `is_hot` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否推荐：1-推荐，0-不推荐',
  `count_use` int(11) unsigned DEFAULT '0' COMMENT '使用次数',
  `count_view` int(11) unsigned DEFAULT '0' COMMENT '浏览量',
  `sort` int(6) NOT NULL DEFAULT '0' COMMENT '排序',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除，0-未删除，1-删除',
  `create_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '创建类型：1-系统创建，2-用户创建',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='社区话题表';

-- ----------------------------
-- Table structure for eb_coupon
-- ----------------------------
DROP TABLE IF EXISTS `eb_coupon`;
CREATE TABLE `eb_coupon` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '优惠券表ID',
  `mer_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商户ID',
  `name` varchar(64) NOT NULL DEFAULT '' COMMENT '优惠券名称',
  `publisher` tinyint(2) unsigned NOT NULL DEFAULT '1' COMMENT '发行方，1-平台，2-商户',
  `category` tinyint(2) NOT NULL DEFAULT '1' COMMENT '类别 1-商家券, 2-商品券, 3-平台券',
  `receive_type` tinyint(2) NOT NULL DEFAULT '1' COMMENT '领取类型 1-手动领取,2-商品赠送券',
  `coupon_type` tinyint(2) NOT NULL DEFAULT '1' COMMENT '优惠券类型 1-满减券,2-折扣券',
  `money` bigint(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠金额',
  `discount` int(3) unsigned NOT NULL DEFAULT '0' COMMENT '折扣',
  `min_price` bigint(11) unsigned NOT NULL DEFAULT '0' COMMENT '最低消费，0代表不限制',
  `is_limited` tinyint(1) DEFAULT '0' COMMENT '是否限量, 默认0 不限量， 1限量',
  `total` int(11) NOT NULL DEFAULT '0' COMMENT '发放总数',
  `last_total` int(11) NOT NULL DEFAULT '0' COMMENT '剩余数量',
  `is_time_receive` tinyint(1) DEFAULT '0' COMMENT '领取是否限时, 默认0-不限时，1-限时',
  `receive_start_time` timestamp NULL DEFAULT NULL COMMENT '可领取开始时间',
  `receive_end_time` timestamp NULL DEFAULT NULL COMMENT '可领取结束时间',
  `is_fixed_time` tinyint(1) DEFAULT '0' COMMENT '是否固定使用时间, 默认0-否，1-使用固定时间',
  `use_start_time` timestamp NULL DEFAULT NULL COMMENT '可使用时间范围 开始时间',
  `use_end_time` timestamp NULL DEFAULT NULL COMMENT '可使用时间范围 结束时间',
  `day` int(4) DEFAULT '0' COMMENT '天数',
  `sort` int(11) unsigned NOT NULL DEFAULT '1' COMMENT '排序',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态（0：关闭，1：开启）',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除 状态（0：否，1：是）',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `mer_id` (`mer_id`) USING BTREE,
  KEY `publisher` (`publisher`) USING BTREE,
  KEY `is_del` (`is_del`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='优惠券表';

-- ----------------------------
-- Table structure for eb_coupon_product
-- ----------------------------
DROP TABLE IF EXISTS `eb_coupon_product`;
CREATE TABLE `eb_coupon_product` (
  `cid` int(11) NOT NULL COMMENT '优惠券id',
  `pid` int(11) NOT NULL COMMENT '商品id',
  PRIMARY KEY (`cid`,`pid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='优惠券商品关联表';

-- ----------------------------
-- Table structure for eb_coupon_user
-- ----------------------------
DROP TABLE IF EXISTS `eb_coupon_user`;
CREATE TABLE `eb_coupon_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `coupon_id` int(11) NOT NULL COMMENT '优惠券id',
  `mer_id` int(11) NOT NULL DEFAULT '0' COMMENT '店铺id，平台为0',
  `uid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `name` varchar(64) NOT NULL DEFAULT '' COMMENT '优惠券名称',
  `publisher` tinyint(2) unsigned NOT NULL DEFAULT '1' COMMENT '发行方，1-平台，2-商户',
  `category` tinyint(2) NOT NULL DEFAULT '1' COMMENT '类别 1-商家券, 2-商品券, 3-平台券',
  `receive_type` tinyint(2) NOT NULL DEFAULT '1' COMMENT '领取类型 1-手动领取,2-商品赠送券',
  `coupon_type` tinyint(2) NOT NULL DEFAULT '1' COMMENT '优惠券类型 1-满减券,2-折扣券',
  `money` bigint(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠金额',
  `discount` int(3) unsigned NOT NULL DEFAULT '0' COMMENT '折扣',
  `min_price` bigint(11) unsigned NOT NULL DEFAULT '0' COMMENT '最低消费，0代表不限制',
  `start_time` timestamp NULL DEFAULT NULL COMMENT '开始使用时间',
  `end_time` timestamp NULL DEFAULT NULL COMMENT '过期时间',
  `use_time` timestamp NULL DEFAULT NULL COMMENT '使用时间',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '状态（0：未使用，1：已使用, 2:已失效）',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `mer_id` (`mer_id`) USING BTREE,
  KEY `uid` (`uid`) USING BTREE,
  KEY `status` (`status`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='用户优惠券表';

-- ----------------------------
-- Table structure for eb_exception_log
-- ----------------------------
DROP TABLE IF EXISTS `eb_exception_log`;
CREATE TABLE `eb_exception_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '异常日志ID',
  `exp_url` varchar(255) DEFAULT NULL COMMENT '异常的url',
  `exp_params` mediumtext COMMENT '异常的参数',
  `exp_type` varchar(255) DEFAULT NULL COMMENT '异常的类型',
  `exp_controller` varchar(255) DEFAULT NULL COMMENT '异常的类名',
  `exp_method` varchar(255) DEFAULT NULL COMMENT '异常的方法名',
  `exp_detail` longtext COMMENT '异常详细信息',
  `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2153 DEFAULT CHARSET=utf8mb4 COMMENT='异常信息表';

-- ----------------------------
-- Table structure for eb_express
-- ----------------------------
DROP TABLE IF EXISTS `eb_express`;
CREATE TABLE `eb_express` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '快递公司id',
  `code` varchar(50) NOT NULL DEFAULT '' COMMENT '快递公司简称',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '快递公司全称',
  `partner_id` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否需要月结账号',
  `partner_key` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否需要月结密码',
  `net` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否需要取件网店',
  `account` varchar(100) NOT NULL DEFAULT '' COMMENT '账号',
  `password` varchar(100) NOT NULL DEFAULT '' COMMENT '密码',
  `net_name` varchar(100) NOT NULL DEFAULT '' COMMENT '网点名称',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `is_show` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否显示',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否可用',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `code` (`code`) USING BTREE,
  KEY `is_show` (`is_show`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1102 DEFAULT CHARSET=utf8mb4 COMMENT='快递公司表';

-- ----------------------------
-- Table structure for eb_marketing_activity
-- ----------------------------
DROP TABLE IF EXISTS `eb_marketing_activity`;
CREATE TABLE `eb_marketing_activity` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '活动ID',
  `name` varchar(50) NOT NULL DEFAULT '0' COMMENT '活动名称',
  `is_open` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否开启：0-未开启，1-已开启',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '活动展示类型：1-轮播列表，2-大小格，3-大图模式',
  `sort` int(5) NOT NULL DEFAULT '999' COMMENT '排序',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '0未删除1已删除',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `banner` varchar(2000) NOT NULL DEFAULT '' COMMENT '活动banner',
  `instruction` varchar(255) NOT NULL DEFAULT '' COMMENT '活动简介',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='营销活动表';

-- ----------------------------
-- Table structure for eb_merchant
-- ----------------------------
DROP TABLE IF EXISTS `eb_merchant`;
CREATE TABLE `eb_merchant` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '商户ID',
  `name` varchar(50) NOT NULL COMMENT '商户名称',
  `category_id` int(11) NOT NULL COMMENT '商户分类ID',
  `type_id` int(11) NOT NULL COMMENT '商户类型ID',
  `real_name` varchar(50) NOT NULL COMMENT '商户姓名',
  `email` varchar(255) NOT NULL DEFAULT '' COMMENT '商户邮箱',
  `phone` varchar(255) NOT NULL DEFAULT '' COMMENT '商户手机号',
  `handling_fee` int(3) NOT NULL COMMENT '手续费(%)',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '商户关键字',
  `province` varchar(64) NOT NULL DEFAULT '' COMMENT '省',
  `city` varchar(64) NOT NULL DEFAULT '' COMMENT '市',
  `district` varchar(64) NOT NULL DEFAULT '' COMMENT '区',
  `address_detail` varchar(255) NOT NULL DEFAULT '' COMMENT '商户详细地址',
  `latitude` varchar(25) NOT NULL DEFAULT '' COMMENT '纬度',
  `longitude` varchar(25) NOT NULL DEFAULT '' COMMENT '经度',
  `is_self` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否自营：0-自营，1-非自营',
  `is_recommend` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否推荐:0-不推荐，1-推荐',
  `is_switch` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '商户开关:0-关闭，1-开启',
  `product_switch` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '商品审核开关:0-关闭，1-开启',
  `is_take_their` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '自提开关:0-关闭，1-开启',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '备注',
  `qualification_picture` varchar(2000) NOT NULL DEFAULT '' COMMENT '资质图片',
  `back_image` varchar(255) NOT NULL DEFAULT '' COMMENT '商户背景图',
  `avatar` varchar(255) NOT NULL DEFAULT '' COMMENT '商户头像',
  `rectangle_logo` varchar(255) NOT NULL DEFAULT '' COMMENT '商户logo（横）',
  `cover_image` varchar(255) NOT NULL DEFAULT '' COMMENT '商户封面图',
  `street_back_image` varchar(255) NOT NULL DEFAULT '' COMMENT '商户街背景图',
  `intro` varchar(255) NOT NULL DEFAULT '' COMMENT '商户简介',
  `copy_product_num` int(11) NOT NULL DEFAULT '0' COMMENT '复制商品数量',
  `balance` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT '商户余额',
  `star_level` int(2) NOT NULL DEFAULT '4' COMMENT '商户星级1-5',
  `pc_banner` varchar(2000) NOT NULL DEFAULT '' COMMENT 'pcBanner',
  `pc_back_image` varchar(500) NOT NULL DEFAULT '' COMMENT 'pc背景图',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `create_type` varchar(255) NOT NULL COMMENT '商户创建类型：admin-管理员创建，apply-商户入驻申请',
  `create_id` int(11) NOT NULL DEFAULT '0' COMMENT '创建商户管理员ID',
  `admin_id` int(11) NOT NULL DEFAULT '0' COMMENT '关联管理账号ID',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `identity_no` varchar(255) DEFAULT NULL COMMENT 'bcx账户联合id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COMMENT='商户表';

-- ----------------------------
-- Table structure for eb_merchant_apply
-- ----------------------------
DROP TABLE IF EXISTS `eb_merchant_apply`;
CREATE TABLE `eb_merchant_apply` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '申请ID',
  `uid` int(11) NOT NULL COMMENT '申请用户ID',
  `name` varchar(50) NOT NULL COMMENT '商户名称',
  `category_id` int(11) NOT NULL COMMENT '商户分类ID',
  `type_id` int(11) NOT NULL COMMENT '商户类型ID',
  `account` varchar(255) NOT NULL DEFAULT '' COMMENT '商户账号',
  `password` varchar(32) NOT NULL DEFAULT '' COMMENT '登录密码',
  `real_name` varchar(50) NOT NULL COMMENT '商户姓名',
  `email` varchar(255) NOT NULL DEFAULT '' COMMENT '商户邮箱',
  `phone` varchar(255) NOT NULL DEFAULT '' COMMENT '商户手机号',
  `handling_fee` int(3) NOT NULL COMMENT '手续费(%)',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '商户关键字',
  `address` varchar(255) NOT NULL DEFAULT '' COMMENT '商户地址',
  `is_self` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否自营：0-自营，1-非自营',
  `is_recommend` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否推荐:0-不推荐，1-推荐',
  `audit_status` int(2) unsigned NOT NULL DEFAULT '1' COMMENT '审核状态：1-待审核，2-审核通过，3-审核拒绝',
  `denial_reason` varchar(255) NOT NULL DEFAULT '' COMMENT '拒绝原因',
  `auditor_id` int(11) NOT NULL DEFAULT '0' COMMENT '审核员ID',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '备注',
  `qualification_picture` varchar(2000) NOT NULL DEFAULT '' COMMENT '资质图片',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商户申请表';

-- ----------------------------
-- Table structure for eb_merchant_bill
-- ----------------------------
DROP TABLE IF EXISTS `eb_merchant_bill`;
CREATE TABLE `eb_merchant_bill` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '帐单id',
  `mer_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商户id',
  `type` varchar(20) NOT NULL DEFAULT '' COMMENT '类型：pay_order-订单支付,refund_order-订单退款,settlement-结算',
  `link_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '关联id',
  `order_no` varchar(32) NOT NULL DEFAULT '' COMMENT '关联单号',
  `uid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户uid,结算类型为0',
  `pm` int(2) unsigned NOT NULL DEFAULT '0' COMMENT '0 = 支出 1 = 获得',
  `amount` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '金额',
  `mark` varchar(255) NOT NULL DEFAULT '' COMMENT '备注',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '添加时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `uid` (`uid`) USING BTREE,
  KEY `mer_id` (`mer_id`) USING BTREE,
  KEY `pm` (`pm`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb4 COMMENT='商户帐单表';

-- ----------------------------
-- Table structure for eb_merchant_category
-- ----------------------------
DROP TABLE IF EXISTS `eb_merchant_category`;
CREATE TABLE `eb_merchant_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `name` varchar(50) NOT NULL COMMENT '分类名称',
  `handling_fee` int(3) NOT NULL COMMENT '手续费(%)',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COMMENT='商户分类表';

-- ----------------------------
-- Table structure for eb_merchant_closing_record
-- ----------------------------
DROP TABLE IF EXISTS `eb_merchant_closing_record`;
CREATE TABLE `eb_merchant_closing_record` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `mer_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商户id',
  `closing_no` varchar(32) NOT NULL COMMENT '结算单号',
  `amount` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '金额',
  `closing_type` varchar(20) NOT NULL DEFAULT 'bank' COMMENT '结算类型:bank-银行卡',
  `closing_name` varchar(50) NOT NULL DEFAULT '' COMMENT '结算姓名',
  `closing_bank` varchar(50) NOT NULL DEFAULT '' COMMENT '结算银行',
  `closing_bank_card` varchar(30) NOT NULL DEFAULT '' COMMENT '结算银行卡号',
  `alipay_account` varchar(64) NOT NULL DEFAULT '' COMMENT '支付宝账号',
  `wechat_no` varchar(15) NOT NULL DEFAULT '' COMMENT '微信号',
  `payment_code` varchar(512) NOT NULL DEFAULT '' COMMENT '收款二维码',
  `account_status` int(2) unsigned NOT NULL DEFAULT '0' COMMENT '到账状态：0-未到账，1-已到账',
  `closing_proof` varchar(1000) NOT NULL DEFAULT '' COMMENT '结算凭证',
  `closing_time` timestamp NULL DEFAULT NULL COMMENT '结算时间',
  `audit_status` int(2) unsigned NOT NULL DEFAULT '0' COMMENT '审核状态：0-待审核，1-通过审核，2-审核失败',
  `refusal_reason` varchar(50) NOT NULL DEFAULT '' COMMENT '拒绝原因',
  `audit_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '审核员id',
  `audit_time` timestamp NULL DEFAULT NULL COMMENT '审核时间',
  `mark` varchar(255) NOT NULL DEFAULT '' COMMENT '商户备注',
  `platform_mark` varchar(255) NOT NULL DEFAULT '' COMMENT '平台备注',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '添加时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `mer_id` (`mer_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商家结算记录表';

-- ----------------------------
-- Table structure for eb_merchant_daily_statement
-- ----------------------------
DROP TABLE IF EXISTS `eb_merchant_daily_statement`;
CREATE TABLE `eb_merchant_daily_statement` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '帐单id',
  `mer_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商户id',
  `order_pay_amount` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '订单支付总金额',
  `order_num` int(10) NOT NULL DEFAULT '0' COMMENT '订单支付笔数',
  `order_income_amount` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '订单收入金额',
  `handling_fee` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '平台手续费',
  `first_brokerage` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '一级佣金金额',
  `second_brokerage` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '二级佣金金额',
  `payout_amount` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '支出总金额',
  `payout_num` int(10) NOT NULL DEFAULT '0' COMMENT '支出笔数',
  `refund_amount` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '平台退款金额',
  `refund_num` int(10) NOT NULL DEFAULT '0' COMMENT '退款笔数',
  `income_expenditure` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '商户日收支',
  `data_date` varchar(12) NOT NULL COMMENT '日期：年-月-日',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `data_date` (`data_date`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=164 DEFAULT CHARSET=utf8mb4 COMMENT='商户日帐单表';

-- ----------------------------
-- Table structure for eb_merchant_day_record
-- ----------------------------
DROP TABLE IF EXISTS `eb_merchant_day_record`;
CREATE TABLE `eb_merchant_day_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` varchar(20) DEFAULT NULL COMMENT '日期，yyyy-MM-dd',
  `mer_id` int(11) DEFAULT NULL COMMENT '商户id',
  `visitors` int(11) DEFAULT NULL COMMENT '访客量',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `date` (`date`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=130 DEFAULT CHARSET=utf8mb4 COMMENT='商户日记录表';

-- ----------------------------
-- Table structure for eb_merchant_info
-- ----------------------------
DROP TABLE IF EXISTS `eb_merchant_info`;
CREATE TABLE `eb_merchant_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '商户信息ID',
  `mer_id` int(11) NOT NULL COMMENT '商户ID',
  `settlement_type` varchar(20) NOT NULL DEFAULT 'bank' COMMENT '结算类型:bank-银行卡,wechat-微信,alipay-支付宝',
  `bank_user_name` varchar(50) NOT NULL DEFAULT '' COMMENT '持卡人姓名',
  `bank_name` varchar(50) NOT NULL DEFAULT '' COMMENT '银行名称',
  `bank_card` varchar(30) NOT NULL DEFAULT '' COMMENT '银行卡号',
  `bank_address` varchar(256) NOT NULL DEFAULT '' COMMENT '开户地址',
  `wechat_code` varchar(15) NOT NULL DEFAULT '' COMMENT '微信号',
  `wechat_qrcode_url` varchar(512) NOT NULL DEFAULT '' COMMENT '微信收款二维码',
  `alipay_code` varchar(64) NOT NULL DEFAULT '' COMMENT '支付宝账号',
  `alipay_qrcode_url` varchar(512) DEFAULT '' COMMENT '支付宝收款二维码',
  `alert_stock` int(5) NOT NULL DEFAULT '0' COMMENT '警戒库存',
  `service_type` varchar(10) NOT NULL DEFAULT '' COMMENT '客服类型：H5-H5链接、phone-电话',
  `service_link` varchar(255) NOT NULL DEFAULT '' COMMENT '客服H5链接',
  `service_phone` varchar(100) NOT NULL DEFAULT '' COMMENT '客服电话',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `real_name` varchar(20) NOT NULL DEFAULT '' COMMENT '真实姓名',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `mer_id` (`mer_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COMMENT='商户信息表';

-- ----------------------------
-- Table structure for eb_merchant_month_statement
-- ----------------------------
DROP TABLE IF EXISTS `eb_merchant_month_statement`;
CREATE TABLE `eb_merchant_month_statement` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '帐单id',
  `mer_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商户id',
  `order_pay_amount` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '订单支付总金额',
  `order_num` int(10) NOT NULL DEFAULT '0' COMMENT '订单支付笔数',
  `order_income_amount` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '订单收入金额',
  `handling_fee` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '平台手续费',
  `first_brokerage` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '一级佣金金额',
  `second_brokerage` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '二级佣金金额',
  `payout_amount` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '支出总金额',
  `payout_num` int(10) NOT NULL DEFAULT '0' COMMENT '支出笔数',
  `refund_amount` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '平台退款金额',
  `refund_num` int(10) NOT NULL DEFAULT '0' COMMENT '退款笔数',
  `income_expenditure` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '商户月收支',
  `data_date` varchar(12) NOT NULL COMMENT '日期：年-月',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `data_date` (`data_date`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COMMENT='商户月帐单表';

-- ----------------------------
-- Table structure for eb_merchant_order
-- ----------------------------
DROP TABLE IF EXISTS `eb_merchant_order`;
CREATE TABLE `eb_merchant_order` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '订单ID',
  `order_no` varchar(32) DEFAULT NULL COMMENT '订单号',
  `mer_id` int(11) unsigned NOT NULL COMMENT '商户ID',
  `uid` int(11) unsigned NOT NULL COMMENT '用户id',
  `real_name` varchar(32) NOT NULL DEFAULT '' COMMENT '收货人姓名',
  `user_phone` varchar(18) NOT NULL DEFAULT '' COMMENT '收货人电话',
  `user_address` varchar(100) NOT NULL DEFAULT '' COMMENT '收货详细地址',
  `total_num` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '订单商品总数',
  `pro_total_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '商品总价',
  `total_postage` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '邮费',
  `total_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '订单总价',
  `pay_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '实际支付金额',
  `pay_postage` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '支付邮费',
  `use_integral` int(11) NOT NULL DEFAULT '0' COMMENT '使用积分',
  `integral_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '积分抵扣金额',
  `coupon_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券id',
  `coupon_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '优惠券金额',
  `pay_type` varchar(20) NOT NULL DEFAULT '' COMMENT '支付方式:weixin,alipay,yue',
  `pay_channel` varchar(20) NOT NULL DEFAULT '' COMMENT '支付渠道：public-公众号,mini-小程序，h5-网页支付,yue-余额，wechatIos-微信Ios，wechatAndroid-微信Android,alipay-支付宝，alipayApp-支付宝App',
  `gain_integral` int(11) NOT NULL DEFAULT '0' COMMENT '赠送积分',
  `user_remark` varchar(255) NOT NULL DEFAULT '' COMMENT '用户备注',
  `merchant_remark` varchar(255) NOT NULL DEFAULT '' COMMENT '商户备注',
  `shipping_type` tinyint(2) NOT NULL DEFAULT '1' COMMENT '配送方式 1=快递 ，2=门店自提',
  `first_brokerage` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '一级返佣金额',
  `second_brokerage` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '二级返佣金额',
  `commission_charge` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '平台手续费',
  `verify_code` varchar(12) NOT NULL DEFAULT '' COMMENT '核销码',
  `delivery_type` varchar(20) NOT NULL DEFAULT 'express' COMMENT '发货类型：express-快递，fictitious：虚拟发货',
  `is_split_delivery` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否拆分发货',
  `seckill_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '秒杀商品ID 0-非砍价商品',
  `bargain_user_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户砍价活动id 0-没有',
  `bargain_id` int(11) unsigned DEFAULT '0' COMMENT '砍价id 0-没有砍价',
  `pink_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '拼团id 0-没有拼团',
  `combination_id` int(11) unsigned DEFAULT '0' COMMENT '拼团商品id 0-一般商品',
  `clerk_id` int(11) NOT NULL DEFAULT '0' COMMENT '核销员id',
  `type` int(2) NOT NULL DEFAULT '0' COMMENT '订单类型:0-普通订单，1-视频号订单',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `order_no` (`order_no`) USING BTREE,
  KEY `uid` (`uid`) USING BTREE,
  KEY `mer_id` (`mer_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=197 DEFAULT CHARSET=utf8mb4 COMMENT='商户订单表';

-- ----------------------------
-- Table structure for eb_merchant_product_category
-- ----------------------------
DROP TABLE IF EXISTS `eb_merchant_product_category`;
CREATE TABLE `eb_merchant_product_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mer_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商户Id',
  `pid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `name` varchar(100) DEFAULT NULL COMMENT '名称',
  `icon` varchar(255) DEFAULT NULL COMMENT 'icon',
  `sort` int(5) NOT NULL DEFAULT '999' COMMENT '排序',
  `is_show` tinyint(1) NOT NULL DEFAULT '1' COMMENT '显示状态',
  `is_del` tinyint(1) unsigned DEFAULT '0' COMMENT '是否删除',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=utf8mb4 COMMENT='商户商品分类表';

-- ----------------------------
-- Table structure for eb_merchant_product_guarantee_group
-- ----------------------------
DROP TABLE IF EXISTS `eb_merchant_product_guarantee_group`;
CREATE TABLE `eb_merchant_product_guarantee_group` (
  `group_id` int(11) NOT NULL COMMENT '组合id',
  `gid` int(11) NOT NULL COMMENT '保障服务id',
  `is_show` tinyint(1) NOT NULL DEFAULT '1' COMMENT '显示状态',
  PRIMARY KEY (`group_id`,`gid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商户商品保障服务组合关联表';

-- ----------------------------
-- Table structure for eb_merchant_type
-- ----------------------------
DROP TABLE IF EXISTS `eb_merchant_type`;
CREATE TABLE `eb_merchant_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `name` varchar(50) NOT NULL COMMENT '类型名称',
  `info` varchar(500) NOT NULL COMMENT '类型要求说明',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COMMENT='商户类型表';

-- ----------------------------
-- Table structure for eb_order
-- ----------------------------
DROP TABLE IF EXISTS `eb_order`;
CREATE TABLE `eb_order` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '订单ID',
  `order_no` varchar(32) NOT NULL COMMENT '订单号',
  `mer_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商户ID,商户订单等级有值',
  `uid` int(11) unsigned NOT NULL COMMENT '用户id',
  `total_num` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '订单商品总数',
  `pro_total_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '商品总价',
  `total_postage` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '邮费',
  `total_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '订单总价',
  `coupon_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '优惠券金额',
  `use_integral` int(11) NOT NULL DEFAULT '0' COMMENT '使用积分',
  `integral_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '积分抵扣金额',
  `pay_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '实际支付金额',
  `pay_postage` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '支付邮费',
  `paid` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '支付状态',
  `pay_time` timestamp NULL DEFAULT NULL COMMENT '支付时间',
  `pay_type` varchar(32) NOT NULL DEFAULT '' COMMENT '支付方式:weixin,alipay,yue',
  `pay_channel` varchar(20) NOT NULL DEFAULT '' COMMENT '支付渠道：public-公众号,mini-小程序，h5-网页支付,yue-余额，wechatIos-微信Ios，wechatAndroid-微信Android,alipay-支付宝，alipayApp-支付宝App',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '订单状态（0：待支付，1：待发货,2：部分发货， 3：待核销，4：待收货,5：已收货,6：已完成，9：已取消）',
  `refund_status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '退款状态：0 未退款 1 申请中 2 部分退款 3 已退款',
  `cancel_status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '取消状态：0-未取消，1-系统取消，2-用户取消',
  `is_user_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '用户是否删除',
  `is_merchant_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '商户是否删除',
  `gain_integral` int(11) NOT NULL DEFAULT '0' COMMENT '赠送积分',
  `out_trade_no` varchar(32) NOT NULL DEFAULT '' COMMENT '商户系统内部的订单号,32个字符内、可包含字母, 其他说明见商户订单号',
  `redirect` varchar(500) NOT NULL DEFAULT '' COMMENT '支付重定向地址',
  `type` int(2) NOT NULL DEFAULT '0' COMMENT '订单类型:0-普通订单，1-视频号订单',
  `level` int(2) NOT NULL DEFAULT '0' COMMENT '订单等级:0-平台订单，1-商户订单',
  `plat_order_no` varchar(32) NOT NULL DEFAULT '' COMMENT '平台订单号',
  `is_del` tinyint(1) unsigned DEFAULT '0' COMMENT '是否删除',
  `receiving_time` timestamp NULL DEFAULT NULL COMMENT '收货时间',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `region_code` varchar(20) DEFAULT NULL COMMENT '区域编码',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `order_no` (`order_no`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=196 DEFAULT CHARSET=utf8mb4 COMMENT='订单表';

-- ----------------------------
-- Table structure for eb_order_detail
-- ----------------------------
DROP TABLE IF EXISTS `eb_order_detail`;
CREATE TABLE `eb_order_detail` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `order_no` varchar(32) DEFAULT NULL COMMENT '订单号',
  `mer_id` int(11) unsigned NOT NULL COMMENT '商户ID',
  `uid` int(11) unsigned NOT NULL COMMENT '用户id',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID',
  `product_name` varchar(128) NOT NULL COMMENT '商品名称',
  `image` varchar(256) NOT NULL COMMENT '商品图片',
  `attr_value_id` int(11) NOT NULL COMMENT '商品规格值 ID',
  `sku` varchar(128) NOT NULL COMMENT '商品sku',
  `price` decimal(8,2) unsigned NOT NULL COMMENT '商品单价',
  `vip_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '会员价格',
  `pay_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '实际支付金额',
  `pay_num` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '购买数量',
  `weight` decimal(8,2) unsigned NOT NULL COMMENT '重量',
  `volume` decimal(8,2) unsigned NOT NULL COMMENT '体积',
  `is_reply` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否评价，0-未评价，1-已评价',
  `is_receipt` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否收货，0-未收货，1-已收货',
  `sub_brokerage_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '分佣类型:0-不参与分佣，1-单独分佣，2-默认分佣',
  `brokerage` int(3) NOT NULL DEFAULT '0' COMMENT '一级返佣比例',
  `brokerage_two` int(3) NOT NULL DEFAULT '0' COMMENT '二级返佣比例',
  `freight_fee` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '运费金额',
  `coupon_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '优惠券金额',
  `use_integral` int(11) NOT NULL DEFAULT '0' COMMENT '使用积分',
  `integral_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '积分抵扣金额',
  `gain_integral` int(11) NOT NULL DEFAULT '0' COMMENT '赠送积分',
  `product_type` int(2) NOT NULL DEFAULT '0' COMMENT '商品类型:0-普通，1-秒杀，2-砍价，3-拼团，4-视频号',
  `first_brokerage_fee` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '一级返佣金额',
  `second_brokerage_fee` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '二级返佣金额',
  `delivery_num` int(11) NOT NULL DEFAULT '0' COMMENT '发货数量',
  `apply_refund_num` int(11) NOT NULL DEFAULT '0' COMMENT '申请退款数量',
  `refund_num` int(11) NOT NULL DEFAULT '0' COMMENT '退款数量',
  `refund_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '退款金额',
  `refund_use_integral` int(11) NOT NULL DEFAULT '0' COMMENT '退使用积分',
  `refund_integral_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '退款积分抵扣金额',
  `refund_gain_integral` int(11) NOT NULL DEFAULT '0' COMMENT '退赠送积分',
  `refund_first_brokerage_fee` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '退一级返佣金额',
  `refund_second_brokerage_fee` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '退二级返佣金额',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `order_no` (`order_no`) USING BTREE,
  KEY `mer_id` (`mer_id`) USING BTREE,
  KEY `uid` (`uid`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=197 DEFAULT CHARSET=utf8mb4 COMMENT='订单详情表';

-- ----------------------------
-- Table structure for eb_order_invoice
-- ----------------------------
DROP TABLE IF EXISTS `eb_order_invoice`;
CREATE TABLE `eb_order_invoice` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `order_no` varchar(32) DEFAULT NULL COMMENT '订单号',
  `mer_id` int(11) unsigned NOT NULL COMMENT '商户ID',
  `uid` int(11) unsigned NOT NULL COMMENT '用户id',
  `tracking_number` varchar(64) NOT NULL DEFAULT '' COMMENT '运单号',
  `express_name` varchar(64) NOT NULL DEFAULT '' COMMENT '快递名称',
  `express_code` varchar(50) NOT NULL DEFAULT '' COMMENT '快递公司简称',
  `total_num` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '发货商品总数',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `order_no` (`order_no`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COMMENT='订单发货单表';

-- ----------------------------
-- Table structure for eb_order_invoice_detail
-- ----------------------------
DROP TABLE IF EXISTS `eb_order_invoice_detail`;
CREATE TABLE `eb_order_invoice_detail` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `invoice_id` int(11) unsigned NOT NULL COMMENT '发货单ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID',
  `product_name` varchar(128) NOT NULL COMMENT '商品名称',
  `image` varchar(256) NOT NULL COMMENT '商品图片',
  `attr_value_id` int(11) NOT NULL COMMENT '商品规格值 ID',
  `sku` varchar(128) NOT NULL COMMENT '商品sku',
  `num` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '发货数量',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `invoice_id` (`invoice_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COMMENT='订单发货单详情表';

-- ----------------------------
-- Table structure for eb_order_profit_sharing
-- ----------------------------
DROP TABLE IF EXISTS `eb_order_profit_sharing`;
CREATE TABLE `eb_order_profit_sharing` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '分账id',
  `order_no` varchar(32) NOT NULL COMMENT '订单号（商户）',
  `mer_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商户ID',
  `order_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '订单付款金额',
  `integral_num` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '消耗积分数量',
  `integral_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '订单积分抵扣金额',
  `profit_sharing_plat_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '平台分账金额',
  `profit_sharing_mer_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '商户分账金额',
  `first_brokerage_fee` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '一级返佣金额',
  `second_brokerage_fee` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '二级返佣金额',
  `profit_sharing_refund` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '退款金额',
  `refund_use_integral` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '退还使用积分',
  `refund_integral_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '退款积分抵扣金额',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `order_no` (`order_no`) USING BTREE,
  KEY `mer_id` (`mer_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb4 COMMENT='订单分账表';

-- ----------------------------
-- Table structure for eb_order_status
-- ----------------------------
DROP TABLE IF EXISTS `eb_order_status`;
CREATE TABLE `eb_order_status` (
  `order_no` varchar(32) NOT NULL COMMENT '订单号',
  `change_type` varchar(32) NOT NULL COMMENT '操作类型:create-创建订单,pay-支付,express-快递,fictitious-虚拟发货,receipt-收货,evaluation-评价订单,fulfilled-完成,edit-编辑,cancel-取消,remove-删除订单',
  `change_message` varchar(256) NOT NULL COMMENT '操作备注',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '操作时间',
  KEY `order_no` (`order_no`) USING BTREE,
  KEY `change_type` (`change_type`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='订单操作记录表';

-- ----------------------------
-- Table structure for eb_pay_component_brand
-- ----------------------------
DROP TABLE IF EXISTS `eb_pay_component_brand`;
CREATE TABLE `eb_pay_component_brand` (
  `brand_id` int(11) unsigned NOT NULL COMMENT '品牌ID',
  `brand_wording` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌名称',
  KEY `brand_id` (`brand_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='组件品牌表';

-- ----------------------------
-- Table structure for eb_pay_component_cat
-- ----------------------------
DROP TABLE IF EXISTS `eb_pay_component_cat`;
CREATE TABLE `eb_pay_component_cat` (
  `third_cat_id` int(11) unsigned NOT NULL COMMENT '类目ID',
  `third_cat_name` varchar(255) NOT NULL DEFAULT '' COMMENT '类目名称',
  `qualification` varchar(500) NOT NULL DEFAULT '' COMMENT '类目资质',
  `qualification_type` int(2) unsigned NOT NULL DEFAULT '0' COMMENT '类目资质类型,0:不需要,1:必填,2:选填',
  `product_qualification` varchar(500) NOT NULL DEFAULT '' COMMENT '商品资质',
  `product_qualification_type` int(2) unsigned NOT NULL DEFAULT '0' COMMENT '商品资质类型,0:不需要,1:必填,2:选填',
  `second_cat_id` int(11) unsigned NOT NULL COMMENT '二级类目ID',
  `second_cat_name` varchar(255) DEFAULT '' COMMENT '二级类目名称',
  `first_cat_id` int(11) unsigned NOT NULL COMMENT '一级类目ID',
  `first_cat_name` varchar(255) DEFAULT '' COMMENT '一级类目名称',
  `audit_id` varchar(255) DEFAULT NULL COMMENT '申请id 有数据证明申请过',
  `status` int(2) unsigned NOT NULL DEFAULT '0' COMMENT 'status  0初始化 1微信侧审核中 2微信侧审核失败 3微信侧审核成功',
  `audit_time` timestamp NULL DEFAULT NULL COMMENT '提审时间',
  `reject_reason` varchar(255) DEFAULT NULL COMMENT '微信侧审核拒绝原因',
  `audit_qualification_req` varchar(500) DEFAULT '' COMMENT '类目审核时提交的资质证明',
  KEY `third_cat_id` (`third_cat_id`) USING BTREE,
  KEY `second_cat_id` (`second_cat_id`) USING BTREE,
  KEY `first_cat_id` (`first_cat_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='组件类目表';

-- ----------------------------
-- Table structure for eb_pay_component_delivery_company
-- ----------------------------
DROP TABLE IF EXISTS `eb_pay_component_delivery_company`;
CREATE TABLE `eb_pay_component_delivery_company` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `delivery_id` varchar(20) NOT NULL COMMENT '快递公司id',
  `delivery_name` varchar(50) NOT NULL COMMENT '快递公司名称',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除 0未删除 1删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='组件快递公司表';

-- ----------------------------
-- Table structure for eb_pay_component_draft_product
-- ----------------------------
DROP TABLE IF EXISTS `eb_pay_component_draft_product`;
CREATE TABLE `eb_pay_component_draft_product` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `product_id` int(11) unsigned DEFAULT NULL COMMENT '商品ID，商家自定义商品ID',
  `primary_product_id` int(11) unsigned DEFAULT NULL COMMENT '主商品ID',
  `component_product_id` int(11) unsigned DEFAULT NULL COMMENT '交易组件平台内部商品ID',
  `title` varchar(255) NOT NULL COMMENT '标题',
  `path` varchar(255) NOT NULL COMMENT '绑定的小程序商品路径',
  `head_img` text NOT NULL COMMENT '轮播图,多张',
  `qualification_pics` text COMMENT '商品资质图片,多张',
  `third_cat_id` int(11) unsigned NOT NULL COMMENT '第三级类目ID',
  `brand_id` int(11) unsigned NOT NULL COMMENT '品牌id',
  `info_version` varchar(255) NOT NULL DEFAULT '' COMMENT '预留字段，用于版本控制',
  `status` int(11) unsigned NOT NULL COMMENT '微信侧状态:0-初始值，5-上架，11-自主下架，13-违规下架/风控系统下架',
  `edit_status` int(11) unsigned NOT NULL COMMENT '微信侧审核状态:1-未审核，2-审核中，3-审核失败，4-审核成功',
  `platform_status` int(11) unsigned NOT NULL COMMENT '平台状态:0初始值 5商家上架 6平台上架 11商家下架 12平台下架',
  `platform_edit_status` int(10) unsigned NOT NULL COMMENT '平台审核状态:1-未审核，2-平台审核中，3-平台审核失败，4-平台审核成功',
  `platform_status_reason` varchar(255) DEFAULT NULL COMMENT '平台自定义状态审核原因',
  `reject_reason` text COMMENT '微信审核结果原因',
  `create_time` varchar(30) DEFAULT NULL COMMENT '创建时间',
  `update_time` varchar(30) DEFAULT NULL COMMENT '更新时间',
  `temp_id` int(11) NOT NULL COMMENT '运费模板ID',
  `stock` int(11) unsigned NOT NULL COMMENT '库存',
  `sales` int(11) unsigned NOT NULL COMMENT '销量',
  `unit_name` varchar(16) NOT NULL COMMENT '单位名称',
  `give_integral` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '反多少积分',
  `spec_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '规格 0单 1多',
  `ficti` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '虚拟销量',
  `desc_info` text COMMENT 'desc详情',
  `sku` text COMMENT 'sku',
  `attr` text COMMENT 'attr(前端用)',
  `attr_value` text COMMENT 'attrValue(前端用)',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除 0未删除 1删除',
  `add_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `mer_id` int(11) DEFAULT NULL COMMENT '商户id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='组件商品草稿表';

-- ----------------------------
-- Table structure for eb_pay_component_order
-- ----------------------------
DROP TABLE IF EXISTS `eb_pay_component_order`;
CREATE TABLE `eb_pay_component_order` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `order_no` varchar(32) NOT NULL COMMENT '订单号,商家自定义订单ID',
  `component_order_id` bigint(64) unsigned DEFAULT NULL COMMENT '微信侧订单id ',
  `openid` varchar(255) NOT NULL COMMENT '用户的openid',
  `path` varchar(255) NOT NULL COMMENT '商家小程序该订单的页面path，用于微信侧订单中心跳转',
  `scene` int(20) unsigned NOT NULL DEFAULT '0' COMMENT '下单时小程序的场景值',
  `out_user_id` int(11) unsigned NOT NULL COMMENT '用户id',
  `pay_method` varchar(255) NOT NULL COMMENT '支付方式，包括：微信支付,货到付款,其他',
  `pay_method_type` int(3) unsigned NOT NULL COMMENT '支付方式，0，微信支付，1: 货到付款，99: 其他（默认0）',
  `prepay_id` varchar(255) DEFAULT '' COMMENT 'TODO 预支付ID',
  `prepay_time` varchar(255) DEFAULT '' COMMENT '预付款时间（拿到prepay_id的时间）',
  `order_price` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '该订单最终的金额（单位：分）',
  `freight` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '运费（单位：分）',
  `discounted_price` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '优惠金额（单位：分）',
  `additional_price` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '附加金额（单位：分）',
  `additional_remarks` varchar(255) DEFAULT NULL COMMENT '附加金额备注',
  `delivery_type` int(2) unsigned NOT NULL COMMENT '发货类型:1: 正常快递, 2: 无需快递, 3: 线下配送, 4: 用户自提 （默认1）',
  `receiver_name` varchar(50) NOT NULL COMMENT '收件人姓名',
  `detailed_address` varchar(255) NOT NULL COMMENT '详细收货地址信息',
  `tel_number` varchar(20) NOT NULL COMMENT '收件人手机号码',
  `country` varchar(20) DEFAULT NULL COMMENT '国家',
  `province` varchar(20) DEFAULT NULL COMMENT '省份',
  `city` varchar(20) DEFAULT NULL COMMENT '城市',
  `town` varchar(20) DEFAULT NULL COMMENT '乡镇',
  `ticket` varchar(100) DEFAULT '0' COMMENT '拉起收银台的ticket 新版本中不需要这个参数',
  `ticket_expire_time` varchar(20) DEFAULT '' COMMENT 'ticket有效截止时间 新版本不需要这个参数也就没有有效期了',
  `final_price` bigint(20) unsigned NOT NULL COMMENT '订单最终价格（单位：分）',
  `status` int(4) unsigned NOT NULL DEFAULT '10' COMMENT '订单状态：10-待付款，11-收银台支付完成（自动流转，对商家来说和10同等对待即可），20-待发货，30-待收货，100-完成，200-全部商品售后之后，订单取消，250-用户主动取消/待付款超时取消/商家取消',
  `finish_all_delivery` int(4) unsigned DEFAULT NULL COMMENT '是否发货完成',
  `delivery_list` text COMMENT '快递数组',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `transaction_id` varchar(32) DEFAULT NULL COMMENT '微信支付订单号',
  `time_end` timestamp NULL DEFAULT NULL COMMENT '订单支付时间，格式为yyyyMMddHHmmss',
  `mer_id` int(11) DEFAULT NULL COMMENT '商户id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='组件订单表';

-- ----------------------------
-- Table structure for eb_pay_component_order_product
-- ----------------------------
DROP TABLE IF EXISTS `eb_pay_component_order_product`;
CREATE TABLE `eb_pay_component_order_product` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `order_no` varchar(32) NOT NULL COMMENT '订单号,商家自定义订单ID',
  `component_order_id` bigint(64) unsigned DEFAULT NULL COMMENT '微信侧订单id ',
  `product_id` int(20) unsigned DEFAULT NULL COMMENT '交易组件平台内部商品ID',
  `out_product_id` varchar(20) NOT NULL COMMENT '商家自定义商品ID',
  `sku_id` int(20) unsigned NOT NULL DEFAULT '0' COMMENT '交易组件平台内部skuID，可填0（如果这个product_id下没有sku）',
  `out_sku_id` varchar(20) NOT NULL COMMENT '商家自定义商品skuID，可填空字符串（如果这个product_id下没有sku）',
  `product_cnt` int(11) unsigned NOT NULL COMMENT '购买的数量',
  `sale_price` bigint(20) unsigned NOT NULL COMMENT '生成这次订单时商品的售卖价（单位：分），可以跟上传商品接口的价格不一致',
  `head_img` text NOT NULL COMMENT '生成订单时商品的头图',
  `title` varchar(255) NOT NULL COMMENT '生成订单时商品的标题',
  `path` varchar(255) NOT NULL COMMENT '绑定的小程序商品路径',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='组件订单详情表';

-- ----------------------------
-- Table structure for eb_pay_component_product
-- ----------------------------
DROP TABLE IF EXISTS `eb_pay_component_product`;
CREATE TABLE `eb_pay_component_product` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键ID，商家自定义商品ID',
  `primary_product_id` int(11) unsigned NOT NULL COMMENT '主商品ID',
  `component_product_id` int(11) unsigned DEFAULT NULL COMMENT '交易组件平台内部商品ID',
  `title` varchar(255) NOT NULL COMMENT '标题',
  `path` varchar(255) DEFAULT NULL COMMENT '绑定的小程序商品路径',
  `head_img` text NOT NULL COMMENT '轮播图,多张',
  `qualification_pics` text COMMENT '商品资质图片,多张',
  `third_cat_id` int(11) unsigned NOT NULL COMMENT '第三级类目ID',
  `brand_id` int(11) unsigned NOT NULL COMMENT '品牌id',
  `info_version` varchar(255) NOT NULL DEFAULT '' COMMENT '预留字段，用于版本控制',
  `status` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '微信侧状态:0-初始值，5-上架，11-自主下架，13-违规下架/风控系统下架',
  `edit_status` int(11) unsigned NOT NULL DEFAULT '1' COMMENT '微信侧审核状态:1-未审核，2-审核中，3-审核失败，4-审核成功',
  `platform_status` int(11) unsigned DEFAULT NULL COMMENT '平台状态:0初始值 5商家上架 6平台上架 11商家下架 12平台下架',
  `platform_edit_status` int(11) unsigned DEFAULT NULL COMMENT '平台审核状态:1-未审核，2-平台审核中，3-平台审核失败，4-平台审核成功',
  `create_time` varchar(30) DEFAULT NULL COMMENT '创建时间',
  `update_time` varchar(30) DEFAULT NULL COMMENT '更新时间',
  `temp_id` int(11) DEFAULT NULL COMMENT '运费模板ID',
  `stock` int(11) NOT NULL DEFAULT '0' COMMENT '库存',
  `sales` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '销量',
  `unit_name` varchar(16) NOT NULL COMMENT '单位名称',
  `give_integral` int(11) NOT NULL DEFAULT '0' COMMENT '反多少积分',
  `spec_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '规格 0单 1多',
  `ficti` int(11) NOT NULL DEFAULT '0' COMMENT '虚拟销量',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除 0未删除 1删除',
  `is_sub` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否单独分佣',
  `mer_id` int(11) DEFAULT NULL COMMENT '商户id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='组件商品表';

-- ----------------------------
-- Table structure for eb_pay_component_product_audit_info
-- ----------------------------
DROP TABLE IF EXISTS `eb_pay_component_product_audit_info`;
CREATE TABLE `eb_pay_component_product_audit_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `product_id` int(11) unsigned NOT NULL COMMENT '商品ID',
  `component_product_id` int(11) unsigned DEFAULT NULL COMMENT '交易组件平台内部商品ID',
  `submit_time` varchar(50) DEFAULT NULL COMMENT '上一次提交时间, yyyy-MM-dd HH:mm:ss',
  `audit_time` varchar(50) DEFAULT NULL COMMENT '上一次审核时间, yyyy-MM-dd HH:mm:ss',
  `reject_reason` varchar(255) DEFAULT NULL COMMENT '拒绝理由，只有edit_status为3时出现',
  `audit_id` varchar(50) DEFAULT NULL COMMENT '审核单id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `product_id` (`product_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='组件商品审核信息表';

-- ----------------------------
-- Table structure for eb_pay_component_product_info
-- ----------------------------
DROP TABLE IF EXISTS `eb_pay_component_product_info`;
CREATE TABLE `eb_pay_component_product_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `product_id` int(11) unsigned NOT NULL COMMENT '商品ID',
  `component_product_id` int(11) unsigned DEFAULT NULL COMMENT '交易组件平台内部商品ID',
  `desc` text NOT NULL COMMENT '商品详情',
  `imgs` text COMMENT '商品详情图片',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除 0未删除 1删除',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `product_id` (`product_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='组件商品详情表';

-- ----------------------------
-- Table structure for eb_pay_component_product_sku
-- ----------------------------
DROP TABLE IF EXISTS `eb_pay_component_product_sku`;
CREATE TABLE `eb_pay_component_product_sku` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键ID，商家自定义skuID',
  `product_id` int(11) unsigned NOT NULL COMMENT '商品ID',
  `component_product_id` int(11) unsigned DEFAULT NULL COMMENT '交易组件平台内部商品ID',
  `sku_id` varchar(20) DEFAULT NULL COMMENT '交易组件平台自定义skuID',
  `thumb_img` varchar(500) NOT NULL COMMENT 'sku小图',
  `sale_price` bigint(20) unsigned NOT NULL COMMENT '售卖价格,以分为单位',
  `market_price` bigint(20) unsigned NOT NULL COMMENT '市场价格,以分为单位',
  `stock_num` int(11) unsigned NOT NULL COMMENT '库存',
  `barcode` varchar(255) DEFAULT NULL COMMENT '条形码',
  `sku_code` varchar(255) DEFAULT NULL COMMENT '商品编码',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除 0未删除 1删除',
  `sku` varchar(128) DEFAULT NULL COMMENT '商品属性索引值 (attr_value|attr_value[|....])',
  `attr_value_id` int(11) unsigned DEFAULT NULL COMMENT '商品规格属性id',
  `version` int(11) DEFAULT '0' COMMENT '并发版本控制',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `product_id` (`product_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='组件商品sku表';

-- ----------------------------
-- Table structure for eb_pay_component_product_sku_attr
-- ----------------------------
DROP TABLE IF EXISTS `eb_pay_component_product_sku_attr`;
CREATE TABLE `eb_pay_component_product_sku_attr` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键ID，商家自定义skuID',
  `sku_id` int(11) unsigned NOT NULL COMMENT 'skuID',
  `component_sku_id` varchar(20) DEFAULT NULL COMMENT '交易组件平台自定义skuID',
  `attr_key` varchar(255) NOT NULL COMMENT '销售属性key（自定义）',
  `attr_value` varchar(255) NOT NULL COMMENT '销售属性value（自定义）',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除 0未删除 1删除',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `sku_id` (`sku_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='组件商品sku属性表';

-- ----------------------------
-- Table structure for eb_pay_component_shop_brand
-- ----------------------------
DROP TABLE IF EXISTS `eb_pay_component_shop_brand`;
CREATE TABLE `eb_pay_component_shop_brand` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `brand_id` int(11) unsigned DEFAULT NULL COMMENT '品牌ID',
  `audit_id` varchar(255) DEFAULT NULL COMMENT '审核单id',
  `license` text COMMENT '营业执照或组织机构代码证，图片url/media_id,逗号分隔',
  `brand_audit_type` int(32) unsigned DEFAULT NULL COMMENT '认证审核类型，1：国内品牌申请-R标，2：国内品牌申请-TM标，3：海外品牌申请-R标，4：海外品牌申请-TM标',
  `trademark_type` varchar(3) DEFAULT NULL COMMENT '商标分类，共有45个分类',
  `brand_management_type` int(32) unsigned DEFAULT NULL COMMENT '选择品牌经营类型：1-自有品牌，2-代理品牌，3-无品牌',
  `commodity_origin_type` int(32) unsigned DEFAULT NULL COMMENT '商品产地是否进口：1-是，2-否',
  `brand_wording` varchar(255) DEFAULT NULL COMMENT '商标/品牌词',
  `sale_authorization` text COMMENT '销售授权书（如商持人为自然人，还需提供有其签名的身份证正反面扫描件)，图片url/media_id,逗号分隔',
  `trademark_registration_certificate` text COMMENT '商标注册证书，图片url/media_id,逗号分隔',
  `trademark_change_certificate` text COMMENT '商标变更证明，图片url/media_id,逗号分隔',
  `trademark_registrant` varchar(500) DEFAULT NULL COMMENT '商标注册人姓名',
  `trademark_registrant_nu` varchar(255) DEFAULT NULL COMMENT '商标注册号/申请号',
  `trademark_authorization_period` varchar(30) DEFAULT NULL COMMENT '商标有效期，yyyy-MM-dd HH:mm:ss',
  `trademark_registration_application` text COMMENT '商标注册申请受理通知书，图片url/media_id,逗号分隔',
  `trademark_applicant` varchar(50) DEFAULT NULL COMMENT '商标申请人姓名',
  `trademark_application_time` varchar(30) DEFAULT NULL COMMENT '商标申请时间, yyyy-MM-dd HH:mm:ss',
  `imported_goods_form` text COMMENT '中华人民共和国海关进口货物报关单，图片url/media_id,逗号分隔',
  `status` int(3) unsigned DEFAULT NULL COMMENT '审核状态, 0：审核中，1：审核成功，9：审核拒绝',
  `reject_reason` varchar(255) DEFAULT NULL COMMENT '如果审核拒绝，返回拒绝原因',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='组件商户品牌表';

-- ----------------------------
-- Table structure for eb_platform_daily_statement
-- ----------------------------
DROP TABLE IF EXISTS `eb_platform_daily_statement`;
CREATE TABLE `eb_platform_daily_statement` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '帐单id',
  `order_pay_amount` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '订单支付总金额',
  `total_order_num` int(10) NOT NULL DEFAULT '0' COMMENT '订单支付笔数',
  `handling_fee` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '日手续费收入',
  `merchant_transfer_amount` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '商户分账金额',
  `merchant_transfer_num` int(10) NOT NULL DEFAULT '0' COMMENT '商户分账笔数',
  `first_brokerage` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '一级佣金金额',
  `second_brokerage` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '二级佣金金额',
  `payout_amount` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '支出总金额',
  `payout_num` int(10) NOT NULL DEFAULT '0' COMMENT '支出笔数',
  `refund_amount` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '平台退款金额',
  `refund_replace_brokerage` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '平台代扣佣金金额',
  `refund_num` int(10) NOT NULL DEFAULT '0' COMMENT '退款笔数',
  `recharge_amount` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '充值金额',
  `recharge_num` int(10) NOT NULL DEFAULT '0' COMMENT '充值笔数',
  `income_expenditure` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '平台日收支',
  `data_date` varchar(12) NOT NULL COMMENT '日期：年-月-日',
  `refund_replace_integral_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '退款平台积分抵扣金额',
  `integral_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '订单积分抵扣金额',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `data_date` (`data_date`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COMMENT='平台日帐单表';

-- ----------------------------
-- Table structure for eb_platform_month_statement
-- ----------------------------
DROP TABLE IF EXISTS `eb_platform_month_statement`;
CREATE TABLE `eb_platform_month_statement` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '帐单id',
  `order_pay_amount` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '订单支付总金额',
  `total_order_num` int(10) NOT NULL DEFAULT '0' COMMENT '订单支付笔数',
  `handling_fee` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '月手续费收入',
  `merchant_transfer_amount` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '商户分账金额',
  `merchant_transfer_num` int(10) NOT NULL DEFAULT '0' COMMENT '商户分账笔数',
  `first_brokerage` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '一级佣金金额',
  `second_brokerage` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '二级佣金金额',
  `payout_amount` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '支出总金额',
  `payout_num` int(10) NOT NULL DEFAULT '0' COMMENT '支出笔数',
  `refund_amount` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '平台退款金额',
  `refund_replace_brokerage` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '平台代扣佣金金额',
  `refund_num` int(10) NOT NULL DEFAULT '0' COMMENT '退款笔数',
  `recharge_amount` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '充值金额',
  `recharge_num` int(10) NOT NULL DEFAULT '0' COMMENT '充值笔数',
  `income_expenditure` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '平台月收支',
  `data_date` varchar(12) NOT NULL COMMENT '日期：年-月',
  `refund_replace_integral_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '退款平台积分抵扣金额',
  `integral_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '订单积分抵扣金额',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `data_date` (`data_date`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COMMENT='平台月帐单表';

-- ----------------------------
-- Table structure for eb_product
-- ----------------------------
DROP TABLE IF EXISTS `eb_product`;
CREATE TABLE `eb_product` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '商品id',
  `mer_id` int(11) NOT NULL DEFAULT '0' COMMENT '商户Id',
  `image` varchar(256) NOT NULL DEFAULT '' COMMENT '商品图片',
  `flat_pattern` varchar(1000) NOT NULL DEFAULT '' COMMENT '展示图',
  `slider_image` varchar(2000) NOT NULL DEFAULT '' COMMENT '轮播图',
  `name` varchar(128) NOT NULL DEFAULT '' COMMENT '商品名称',
  `intro` varchar(256) NOT NULL DEFAULT '' COMMENT '商品简介',
  `keyword` varchar(256) NOT NULL DEFAULT '' COMMENT '关键字,英文逗号拼接',
  `cate_id` varchar(64) NOT NULL DEFAULT '' COMMENT '商户分类id(逗号拼接)',
  `brand_id` int(11) NOT NULL DEFAULT '0' COMMENT '品牌id',
  `category_id` int(11) NOT NULL DEFAULT '0' COMMENT '平台分类id',
  `guarantee_ids` varchar(64) NOT NULL DEFAULT '0' COMMENT '保障服务ids(英文逗号拼接)',
  `price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '商品价格',
  `vip_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '会员价格',
  `ot_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '市场价',
  `unit_name` varchar(32) NOT NULL DEFAULT '' COMMENT '单位名',
  `sales` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '销量',
  `stock` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '库存',
  `cost` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '成本价',
  `ficti` int(11) DEFAULT '0' COMMENT '虚拟销量',
  `browse` int(11) DEFAULT '0' COMMENT '浏览量',
  `code_path` varchar(64) DEFAULT NULL COMMENT '商品二维码地址(用户小程序海报)',
  `soure_link` varchar(255) DEFAULT NULL COMMENT '淘宝京东1688类型',
  `video_link` varchar(255) DEFAULT NULL COMMENT '主图视频链接',
  `temp_id` int(11) NOT NULL DEFAULT '1' COMMENT '运费模板ID',
  `sort` smallint(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `rank` smallint(11) NOT NULL DEFAULT '0' COMMENT '总后台排序',
  `spec_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '规格 0单 1多',
  `is_recycle` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否回收站',
  `is_sub` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否单独分佣',
  `is_show` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态（0：未上架，1：上架）',
  `audit_status` int(2) unsigned NOT NULL DEFAULT '1' COMMENT '审核状态：0-无需审核 1-待审核，2-审核成功，3-审核拒绝',
  `is_audit` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否加入审核，0-正常，1-审核流程中',
  `reason` varchar(100) NOT NULL DEFAULT '' COMMENT '拒绝原因',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `type` int(2) DEFAULT '0' COMMENT '商品类型：0-实体 1-虚拟',
  `show_buy_btn` tinyint(1) DEFAULT NULL COMMENT '显示立即购买按钮 0-不显示 1-显示',
  `show_try_btn` tinyint(1) DEFAULT NULL COMMENT '显示申请试用按钮 0-不显示 1-显示',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `mer_id` (`mer_id`) USING BTREE,
  KEY `is_del` (`is_del`) USING BTREE,
  KEY `is_recycle` (`is_recycle`) USING BTREE,
  KEY `is_show` (`is_show`) USING BTREE,
  KEY `audit_status` (`audit_status`) USING BTREE,
  KEY `sort` (`sort`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=237 DEFAULT CHARSET=utf8mb4 COMMENT='商品表';

-- ----------------------------
-- Table structure for eb_product_attr
-- ----------------------------
DROP TABLE IF EXISTS `eb_product_attr`;
CREATE TABLE `eb_product_attr` (
  `id` mediumint(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID',
  `attr_name` varchar(32) NOT NULL COMMENT '属性名',
  `attr_values` varchar(1000) NOT NULL COMMENT '属性值，英文逗号拼接',
  `type` tinyint(1) DEFAULT '0' COMMENT '商品类型 0=商品，1=秒杀，2=砍价，3=拼团',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否删除,0-否，1-是',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `product_id` (`product_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=509 DEFAULT CHARSET=utf8mb4 COMMENT='商品属性表';

-- ----------------------------
-- Table structure for eb_product_attr_value
-- ----------------------------
DROP TABLE IF EXISTS `eb_product_attr_value`;
CREATE TABLE `eb_product_attr_value` (
  `id` mediumint(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `product_id` int(10) unsigned NOT NULL COMMENT '商品ID',
  `sku` varchar(128) NOT NULL COMMENT '商品属性sku',
  `stock` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '属性对应的库存',
  `sales` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '销量',
  `price` decimal(8,2) unsigned NOT NULL COMMENT '价格',
  `image` varchar(1000) DEFAULT NULL COMMENT '图片',
  `cost` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '成本价',
  `bar_code` varchar(50) NOT NULL DEFAULT '' COMMENT '商品条码',
  `ot_price` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '原价',
  `weight` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '重量',
  `volume` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '体积',
  `brokerage` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '一级返佣',
  `brokerage_two` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '二级返佣',
  `type` tinyint(1) DEFAULT '0' COMMENT '商品类型 0=商品，1=秒杀，2=砍价，3=拼团',
  `quota` int(11) DEFAULT NULL COMMENT '活动限购数量',
  `quota_show` int(11) DEFAULT NULL COMMENT '活动限购数量显示',
  `attr_value` text COMMENT 'attr_values 创建更新时的属性对应',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否删除,0-否，1-是',
  `version` int(11) DEFAULT '0' COMMENT '并发版本控制',
  `master_id` int(11) NOT NULL DEFAULT '0' COMMENT '主商品attrValueID',
  `is_callback` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否回滚库存：0-未回滚，1-已回滚',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `product_id` (`product_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1220 DEFAULT CHARSET=utf8mb4 COMMENT='商品属性值表';

-- ----------------------------
-- Table structure for eb_product_brand
-- ----------------------------
DROP TABLE IF EXISTS `eb_product_brand`;
CREATE TABLE `eb_product_brand` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL COMMENT '名称',
  `icon` varchar(255) DEFAULT NULL COMMENT 'icon',
  `sort` int(5) NOT NULL DEFAULT '999' COMMENT '排序',
  `is_show` tinyint(1) NOT NULL DEFAULT '1' COMMENT '显示状态',
  `is_del` tinyint(1) unsigned DEFAULT '0' COMMENT '是否删除',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COMMENT='商品品牌表';

-- ----------------------------
-- Table structure for eb_product_brand_category
-- ----------------------------
DROP TABLE IF EXISTS `eb_product_brand_category`;
CREATE TABLE `eb_product_brand_category` (
  `bid` int(11) NOT NULL COMMENT '品牌id',
  `cid` int(11) NOT NULL COMMENT '分类id',
  PRIMARY KEY (`bid`,`cid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品品牌分类关联表';

-- ----------------------------
-- Table structure for eb_product_category
-- ----------------------------
DROP TABLE IF EXISTS `eb_product_category`;
CREATE TABLE `eb_product_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `name` varchar(100) DEFAULT NULL COMMENT '名称',
  `icon` varchar(255) DEFAULT NULL COMMENT 'icon',
  `level` int(2) NOT NULL DEFAULT '1' COMMENT '级别:1，2，3',
  `sort` int(5) NOT NULL DEFAULT '999' COMMENT '排序',
  `is_show` tinyint(1) NOT NULL DEFAULT '1' COMMENT '显示状态',
  `is_del` tinyint(1) unsigned DEFAULT '0' COMMENT '是否删除',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=560 DEFAULT CHARSET=utf8mb4 COMMENT='商品分类表';

-- ----------------------------
-- Table structure for eb_product_coupon
-- ----------------------------
DROP TABLE IF EXISTS `eb_product_coupon`;
CREATE TABLE `eb_product_coupon` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `product_id` int(10) NOT NULL DEFAULT '0' COMMENT '商品id',
  `coupon_id` int(10) NOT NULL DEFAULT '0' COMMENT '优惠劵id',
  `add_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品优惠券表';

-- ----------------------------
-- Table structure for eb_product_day_record
-- ----------------------------
DROP TABLE IF EXISTS `eb_product_day_record`;
CREATE TABLE `eb_product_day_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` varchar(20) DEFAULT NULL COMMENT '日期，yyyy-MM-dd',
  `mer_id` int(11) DEFAULT NULL COMMENT '商户id',
  `product_id` int(11) DEFAULT NULL COMMENT '商品id',
  `page_view` int(11) DEFAULT NULL COMMENT '浏览量',
  `collect_num` int(11) DEFAULT NULL COMMENT '收藏量',
  `add_cart_num` int(11) DEFAULT NULL COMMENT '加购件数',
  `order_product_num` int(11) DEFAULT NULL COMMENT '下单商品数（销售件数）',
  `order_success_product_fee` decimal(8,2) DEFAULT NULL COMMENT '销售额',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `date` (`date`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1014 DEFAULT CHARSET=utf8mb4 COMMENT='商品日记录表';

-- ----------------------------
-- Table structure for eb_product_description
-- ----------------------------
DROP TABLE IF EXISTS `eb_product_description`;
CREATE TABLE `eb_product_description` (
  `product_id` int(11) NOT NULL DEFAULT '0' COMMENT '商品ID',
  `description` text NOT NULL COMMENT '商品详情',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '商品类型 0=商品，1=秒杀，2=砍价，3=拼团',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `desc_order` int(11) DEFAULT '0' COMMENT '序号 1-5 每个商品5个详情',
  `is_show` tinyint(1) DEFAULT '1' COMMENT '是否显示 0-不显示 1-显示',
  `name` varchar(255) DEFAULT NULL COMMENT '详情名称',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `product_id` (`product_id`,`type`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=656 DEFAULT CHARSET=utf8mb4 COMMENT='商品描述表';

-- ----------------------------
-- Table structure for eb_product_guarantee
-- ----------------------------
DROP TABLE IF EXISTS `eb_product_guarantee`;
CREATE TABLE `eb_product_guarantee` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT '' COMMENT '保障条款名称',
  `icon` varchar(255) DEFAULT '' COMMENT '图标',
  `content` varchar(255) DEFAULT '' COMMENT '条款内容',
  `sort` int(5) NOT NULL DEFAULT '999' COMMENT '排序',
  `is_show` tinyint(1) NOT NULL DEFAULT '1' COMMENT '显示状态',
  `is_del` tinyint(1) unsigned DEFAULT '0' COMMENT '是否删除',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COMMENT='商品保障服务表';

-- ----------------------------
-- Table structure for eb_product_guarantee_group
-- ----------------------------
DROP TABLE IF EXISTS `eb_product_guarantee_group`;
CREATE TABLE `eb_product_guarantee_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mer_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商户ID',
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '组合名称',
  `is_del` tinyint(1) unsigned DEFAULT '0' COMMENT '是否删除',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COMMENT='商品保障服务组合表';

-- ----------------------------
-- Table structure for eb_product_relation
-- ----------------------------
DROP TABLE IF EXISTS `eb_product_relation`;
CREATE TABLE `eb_product_relation` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `uid` int(10) unsigned NOT NULL COMMENT '用户ID',
  `product_id` int(10) unsigned NOT NULL COMMENT '商品ID',
  `type` varchar(32) NOT NULL COMMENT '关联类型(收藏(collect）、点赞(like))',
  `category` int(2) NOT NULL DEFAULT '0' COMMENT '商品类型 0=商品，1=秒杀，2=砍价，3=拼团',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `uid` (`uid`) USING BTREE,
  KEY `product_id` (`product_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品点赞和收藏表';

-- ----------------------------
-- Table structure for eb_product_reply
-- ----------------------------
DROP TABLE IF EXISTS `eb_product_reply`;
CREATE TABLE `eb_product_reply` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '评论ID',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `mer_id` int(11) NOT NULL DEFAULT '0' COMMENT '店铺id',
  `order_no` varchar(32) NOT NULL DEFAULT '' COMMENT '订单编号',
  `order_detail_id` int(11) NOT NULL DEFAULT '0' COMMENT '订单详情id',
  `product_id` int(11) NOT NULL COMMENT '商品id',
  `attr_value_id` int(11) NOT NULL COMMENT '商品规格属性id',
  `sku` varchar(128) NOT NULL DEFAULT '' COMMENT '商品规格属性值,多个,号隔开',
  `star` tinyint(1) NOT NULL DEFAULT '5' COMMENT '星级',
  `comment` varchar(512) NOT NULL DEFAULT '' COMMENT '评论内容',
  `pics` text COMMENT '评论图片',
  `merchant_reply_content` varchar(300) DEFAULT '' COMMENT '管理员回复内容',
  `merchant_reply_time` timestamp NULL DEFAULT NULL COMMENT '管理员回复时间',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '0未删除1已删除',
  `is_reply` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0未回复1已回复',
  `nickname` varchar(64) NOT NULL DEFAULT '' COMMENT '用户名称',
  `avatar` varchar(255) NOT NULL DEFAULT '' COMMENT '用户头像',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `order_no` (`order_no`) USING BTREE,
  KEY `order_detail_id` (`order_detail_id`) USING BTREE,
  KEY `product_id` (`product_id`) USING BTREE,
  KEY `star` (`star`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COMMENT='评论表';

-- ----------------------------
-- Table structure for eb_product_rule
-- ----------------------------
DROP TABLE IF EXISTS `eb_product_rule`;
CREATE TABLE `eb_product_rule` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `mer_id` int(11) NOT NULL DEFAULT '0' COMMENT '店铺id，平台为0',
  `rule_name` varchar(32) NOT NULL COMMENT '规格名称',
  `rule_value` text NOT NULL COMMENT '规格值',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb4 COMMENT='商品规则值(规格)表';

-- ----------------------------
-- Table structure for eb_recharge_order
-- ----------------------------
DROP TABLE IF EXISTS `eb_recharge_order`;
CREATE TABLE `eb_recharge_order` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) DEFAULT NULL COMMENT '充值用户UID',
  `order_no` varchar(32) NOT NULL DEFAULT '' COMMENT '订单号',
  `price` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '充值金额',
  `give_price` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '购买赠送金额',
  `pay_type` varchar(32) NOT NULL DEFAULT '' COMMENT '支付方式:weixin,alipay',
  `pay_channel` varchar(20) NOT NULL DEFAULT '' COMMENT '支付渠道：public-公众号,mini-小程序，h5-网页支付,wechatIos-微信Ios，wechatAndroid-微信Android,alipay-支付包，alipayApp-支付宝App',
  `paid` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否支付',
  `pay_time` timestamp NULL DEFAULT NULL COMMENT '充值支付时间',
  `out_trade_no` varchar(32) NOT NULL DEFAULT '' COMMENT '支付服务方订单号',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '充值时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `order_no` (`order_no`) USING BTREE,
  KEY `uid` (`uid`) USING BTREE,
  KEY `pay_type` (`pay_type`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='充值订单表';

-- ----------------------------
-- Table structure for eb_refund_order
-- ----------------------------
DROP TABLE IF EXISTS `eb_refund_order`;
CREATE TABLE `eb_refund_order` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '订单ID',
  `refund_order_no` varchar(32) NOT NULL COMMENT '退款订单号',
  `order_no` varchar(32) NOT NULL COMMENT '商户订单号',
  `mer_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商户ID',
  `uid` int(11) unsigned NOT NULL COMMENT '用户id',
  `real_name` varchar(32) NOT NULL COMMENT '收货人姓名',
  `user_phone` varchar(18) NOT NULL COMMENT '收货人电话',
  `user_address` varchar(100) NOT NULL COMMENT '收货人详细地址',
  `total_num` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '退款单商品总数',
  `refund_reason_wap` varchar(255) NOT NULL DEFAULT '' COMMENT '退款原因',
  `refund_reason_wap_img` varchar(5000) NOT NULL DEFAULT '' COMMENT '退款图片',
  `refund_reason_wap_explain` varchar(255) NOT NULL DEFAULT '' COMMENT '退款用户说明',
  `is_all` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否整单退款',
  `refund_status` tinyint(2) unsigned NOT NULL DEFAULT '0' COMMENT '退款状态：0:待审核 1:审核未通过 2：退款中 3:已退款',
  `refund_reason` varchar(255) NOT NULL DEFAULT '' COMMENT '拒绝退款说明',
  `refund_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '退款金额',
  `merchant_refund_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '商家退款金额',
  `platform_refund_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '平台退款金额',
  `refund_first_brokerage_fee` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '退一级返佣金额',
  `refund_second_brokerage_fee` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '退二级返佣金额',
  `is_replace` tinyint(1) unsigned DEFAULT '0' COMMENT '是否平台代扣佣金',
  `refund_use_integral` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '退还使用积分',
  `refund_gain_integral` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '扣除赠送积分',
  `refund_integral_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '退款积分抵扣金额',
  `refund_time` timestamp NULL DEFAULT NULL COMMENT '退款时间',
  `refund_pay_type` varchar(512) NOT NULL DEFAULT '' COMMENT '退款渠道类型:weixin,alipay,yue',
  `mer_remark` varchar(512) NOT NULL DEFAULT '' COMMENT '商户备注',
  `platform_remark` varchar(512) NOT NULL DEFAULT '' COMMENT '平台备注',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `order_no` (`order_no`) USING BTREE,
  KEY `refund_order_no` (`refund_order_no`) USING BTREE,
  KEY `mer_id` (`mer_id`) USING BTREE,
  KEY `uid` (`uid`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COMMENT='退款单表';

-- ----------------------------
-- Table structure for eb_refund_order_info
-- ----------------------------
DROP TABLE IF EXISTS `eb_refund_order_info`;
CREATE TABLE `eb_refund_order_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `refund_order_no` varchar(32) NOT NULL COMMENT '退款订单号',
  `mer_id` int(11) unsigned NOT NULL COMMENT '商户ID',
  `order_detail_id` int(11) unsigned NOT NULL COMMENT '订单商品表ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID',
  `product_name` varchar(128) NOT NULL COMMENT '商品名称',
  `image` varchar(256) NOT NULL COMMENT '商品图片',
  `attr_value_id` int(11) NOT NULL COMMENT '商品规格值 ID',
  `sku` varchar(128) NOT NULL COMMENT '商品sku',
  `price` decimal(8,2) unsigned NOT NULL COMMENT '商品单价',
  `pay_price` decimal(8,2) unsigned NOT NULL COMMENT '支付金额',
  `pay_num` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '购买数量',
  `product_type` int(2) NOT NULL DEFAULT '0' COMMENT '商品类型:0-普通，1-秒杀，2-砍价，3-拼团，4-视频号',
  `apply_refund_num` int(11) unsigned NOT NULL COMMENT '申请退款数量',
  `refund_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '退款金额',
  `merchant_refund_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '商家退款金额',
  `platform_refund_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '平台退款金额',
  `refund_use_integral` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '退还使用积分',
  `refund_integral_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '退款积分抵扣金额',
  `refund_gain_integral` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '扣除赠送积分',
  `refund_first_brokerage_fee` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '退一级返佣金额',
  `refund_second_brokerage_fee` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '退二级返佣金额',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `refund_order_no` (`refund_order_no`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COMMENT='退款订单详情表';

-- ----------------------------
-- Table structure for eb_refund_order_status
-- ----------------------------
DROP TABLE IF EXISTS `eb_refund_order_status`;
CREATE TABLE `eb_refund_order_status` (
  `order_no` varchar(32) NOT NULL COMMENT '订单号',
  `change_type` varchar(32) NOT NULL COMMENT '操作类型：apply-申请退款，refused-拒绝退款，refund-退款',
  `change_message` varchar(256) NOT NULL COMMENT '操作备注',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '操作时间',
  KEY `order_no` (`order_no`) USING BTREE,
  KEY `change_type` (`change_type`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='退款订单操作记录表';

-- ----------------------------
-- Table structure for eb_schedule_job
-- ----------------------------
DROP TABLE IF EXISTS `eb_schedule_job`;
CREATE TABLE `eb_schedule_job` (
  `job_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '任务id',
  `bean_name` varchar(200) DEFAULT NULL COMMENT 'spring bean名称',
  `method_name` varchar(100) DEFAULT NULL COMMENT '方法名',
  `params` varchar(2000) DEFAULT NULL COMMENT '参数',
  `cron_expression` varchar(100) DEFAULT NULL COMMENT 'cron表达式',
  `status` tinyint(4) DEFAULT NULL COMMENT '任务状态  0：正常  1：暂停',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `is_delete` tinyint(1) unsigned DEFAULT '0' COMMENT '是否删除',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`job_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COMMENT='定时任务';

-- ----------------------------
-- Table structure for eb_schedule_job_log
-- ----------------------------
DROP TABLE IF EXISTS `eb_schedule_job_log`;
CREATE TABLE `eb_schedule_job_log` (
  `log_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '任务日志id',
  `job_id` int(11) NOT NULL COMMENT '任务id',
  `bean_name` varchar(200) DEFAULT NULL COMMENT 'spring bean名称',
  `method_name` varchar(100) DEFAULT NULL COMMENT '方法名',
  `params` varchar(2000) DEFAULT NULL COMMENT '参数',
  `status` tinyint(4) NOT NULL COMMENT '任务状态    1：成功    0：失败',
  `error` varchar(2000) DEFAULT NULL COMMENT '失败信息',
  `times` int(11) NOT NULL COMMENT '耗时(单位：毫秒)',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`log_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=259127 DEFAULT CHARSET=utf8mb4 COMMENT='定时任务日志';

-- ----------------------------
-- Table structure for eb_seckill_activity
-- ----------------------------
DROP TABLE IF EXISTS `eb_seckill_activity`;
CREATE TABLE `eb_seckill_activity` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '秒杀活动ID',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '秒杀活动名称',
  `start_date` varchar(20) NOT NULL DEFAULT '' COMMENT '秒杀开始日期',
  `end_date` varchar(20) NOT NULL DEFAULT '' COMMENT '秒杀结束日期',
  `one_quota` int(11) NOT NULL DEFAULT '0' COMMENT '活动期间单笔下单购买数量，0不限制',
  `all_quota` int(11) NOT NULL DEFAULT '0' COMMENT '全部活动期间，用户购买总数限制，0不限制',
  `mer_stars` int(2) NOT NULL DEFAULT '0' COMMENT '商家星级',
  `pro_category` varchar(255) NOT NULL DEFAULT '0' COMMENT '商品类型,英文逗号拼接',
  `is_open` int(2) NOT NULL DEFAULT '0' COMMENT '开启状态: 0=关闭 1=开启',
  `status` int(2) NOT NULL DEFAULT '0' COMMENT '状态:0未开始，1进行中，2已结束',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '删除标记 0=未删除 1=删除',
  `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COMMENT='秒杀活动表';

-- ----------------------------
-- Table structure for eb_seckill_activity_time
-- ----------------------------
DROP TABLE IF EXISTS `eb_seckill_activity_time`;
CREATE TABLE `eb_seckill_activity_time` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `seckill_id` int(11) NOT NULL COMMENT '秒杀id',
  `time_interval_id` int(11) NOT NULL COMMENT '秒杀时段id',
  `start_date` int(11) NOT NULL COMMENT '秒杀开始日期',
  `end_date` int(11) NOT NULL COMMENT '秒杀结束日期',
  `start_time` int(11) NOT NULL COMMENT '秒杀开启时间',
  `end_time` int(11) NOT NULL COMMENT '秒杀结束时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `sekill_id` (`seckill_id`) USING BTREE,
  KEY `time_interval_id` (`time_interval_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COMMENT='秒杀活动时间表';

-- ----------------------------
-- Table structure for eb_seckill_product
-- ----------------------------
DROP TABLE IF EXISTS `eb_seckill_product`;
CREATE TABLE `eb_seckill_product` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '秒杀商品ID',
  `activity_id` int(11) NOT NULL COMMENT '活动id',
  `product_id` int(11) NOT NULL COMMENT '商品id',
  `mer_id` int(11) NOT NULL DEFAULT '0' COMMENT '商户Id',
  `image` varchar(256) NOT NULL DEFAULT '' COMMENT '商品图片',
  `flat_pattern` varchar(1000) NOT NULL DEFAULT '' COMMENT '展示图',
  `slider_image` varchar(2000) NOT NULL DEFAULT '' COMMENT '轮播图',
  `name` varchar(128) NOT NULL DEFAULT '' COMMENT '商品名称',
  `intro` varchar(256) NOT NULL DEFAULT '' COMMENT '商品简介',
  `keyword` varchar(256) NOT NULL DEFAULT '' COMMENT '关键字,英文逗号拼接',
  `brand_id` int(11) NOT NULL DEFAULT '0' COMMENT '品牌id',
  `category_id` int(11) NOT NULL DEFAULT '0' COMMENT '平台分类id',
  `guarantee_ids` varchar(64) NOT NULL DEFAULT '0' COMMENT '保障服务ids(英文逗号拼接)',
  `price` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '商品价格',
  `seckill_price` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '商品价格',
  `unit_name` varchar(32) NOT NULL DEFAULT '' COMMENT '单位名',
  `sales` int(11) NOT NULL DEFAULT '0' COMMENT '销量',
  `temp_id` int(11) NOT NULL DEFAULT '1' COMMENT '运费模板ID',
  `sort` smallint(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `spec_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '规格 0单 1多',
  `is_show` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态（0：未上架，1：上架）',
  `audit_status` int(2) unsigned NOT NULL DEFAULT '1' COMMENT '审核状态：1-待审核，2-审核成功，3-审核拒绝',
  `reason` varchar(100) NOT NULL DEFAULT '' COMMENT '拒绝原因',
  `quota_show` int(10) NOT NULL DEFAULT '0' COMMENT '限购总数显示.不变',
  `quota` int(10) NOT NULL DEFAULT '0' COMMENT '限购总数,随减',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除',
  `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `is_del` (`is_del`) USING BTREE,
  KEY `sort` (`sort`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COMMENT='秒杀商品表';

-- ----------------------------
-- Table structure for eb_seckill_time_interval
-- ----------------------------
DROP TABLE IF EXISTS `eb_seckill_time_interval`;
CREATE TABLE `eb_seckill_time_interval` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '秒杀时段名称',
  `start_time` int(6) NOT NULL COMMENT '秒杀时段开始时间',
  `end_time` int(6) NOT NULL COMMENT '秒杀时段结束时间',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态 0=关闭 1=开启',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '删除标记 0=未删除 1=删除',
  `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COMMENT='秒杀时段表';

-- ----------------------------
-- Table structure for eb_sensitive_method_log
-- ----------------------------
DROP TABLE IF EXISTS `eb_sensitive_method_log`;
CREATE TABLE `eb_sensitive_method_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `mer_id` int(11) NOT NULL COMMENT '商户id，0-平台',
  `admin_id` int(11) NOT NULL COMMENT '管理员id',
  `admin_account` varchar(32) DEFAULT '' COMMENT '管理员账号',
  `description` varchar(50) DEFAULT '' COMMENT '接口描述',
  `method_type` varchar(30) DEFAULT '' COMMENT '业务类型',
  `method` varchar(100) DEFAULT '' COMMENT '方法名称',
  `request_method` varchar(10) DEFAULT '' COMMENT '请求方式',
  `url` varchar(255) DEFAULT '' COMMENT '请求URL',
  `ip` varchar(50) DEFAULT '' COMMENT '主机地址',
  `request_param` varchar(2000) DEFAULT '' COMMENT '请求参数',
  `result` varchar(2000) DEFAULT '' COMMENT '返回参数',
  `status` int(1) DEFAULT '0' COMMENT '操作状态（0正常 1异常）',
  `error_msg` varchar(2000) DEFAULT '' COMMENT '错误消息',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `mer_id` (`mer_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=572 DEFAULT CHARSET=utf8mb4 COMMENT='敏感操作日志表';

-- ----------------------------
-- Table structure for eb_shipping_templates
-- ----------------------------
DROP TABLE IF EXISTS `eb_shipping_templates`;
CREATE TABLE `eb_shipping_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `mer_id` int(11) NOT NULL COMMENT '商户id',
  `name` varchar(255) NOT NULL COMMENT '模板名称',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '计费方式',
  `appoint` tinyint(1) NOT NULL DEFAULT '0' COMMENT '包邮类型：0-全国包邮，1-部分包邮，2-不包邮',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `mer_id` (`mer_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COMMENT='运费模板';

-- ----------------------------
-- Table structure for eb_shipping_templates_free
-- ----------------------------
DROP TABLE IF EXISTS `eb_shipping_templates_free`;
CREATE TABLE `eb_shipping_templates_free` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `temp_id` int(11) NOT NULL DEFAULT '0' COMMENT '模板ID',
  `city_id` int(11) NOT NULL DEFAULT '0' COMMENT '城市ID',
  `title` text COMMENT '描述',
  `number` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '包邮件数',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '包邮金额',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '计费方式',
  `uniqid` varchar(32) NOT NULL DEFAULT '' COMMENT '分组唯一值',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `temp_id` (`temp_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='运费模板包邮';

-- ----------------------------
-- Table structure for eb_shipping_templates_region
-- ----------------------------
DROP TABLE IF EXISTS `eb_shipping_templates_region`;
CREATE TABLE `eb_shipping_templates_region` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `temp_id` int(11) NOT NULL DEFAULT '0' COMMENT '模板ID',
  `city_id` int(11) NOT NULL DEFAULT '0' COMMENT '城市ID',
  `title` text COMMENT '描述',
  `first` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '首件',
  `first_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '首件运费',
  `renewal` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '续件',
  `renewal_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '续件运费',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '计费方式 1按件数 2按重量 3按体积',
  `uniqid` varchar(32) NOT NULL DEFAULT '' COMMENT '分组唯一值',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `temp_id` (`temp_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='运费模板指定区域费用';

-- ----------------------------
-- Table structure for eb_shopping_product_day_record
-- ----------------------------
DROP TABLE IF EXISTS `eb_shopping_product_day_record`;
CREATE TABLE `eb_shopping_product_day_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` varchar(20) DEFAULT NULL COMMENT '日期,yyyy-MM-dd',
  `add_product_num` int(11) DEFAULT NULL COMMENT '新增商品数量',
  `page_view` int(11) DEFAULT NULL COMMENT '浏览量',
  `collect_num` int(11) DEFAULT NULL COMMENT '收藏量',
  `add_cart_num` int(11) DEFAULT NULL COMMENT '加购件数',
  `order_product_num` int(11) DEFAULT NULL COMMENT '下单商品数',
  `order_success_product_num` int(11) DEFAULT NULL COMMENT '交易成功商品数',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `date` (`date`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COMMENT='商城商品日记录表';

-- ----------------------------
-- Table structure for eb_sign_config
-- ----------------------------
DROP TABLE IF EXISTS `eb_sign_config`;
CREATE TABLE `eb_sign_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `day` int(5) NOT NULL DEFAULT '1' COMMENT '连续签到天数，0-每天签到奖励',
  `is_integral` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否奖励积分',
  `integral` int(5) NOT NULL DEFAULT '0' COMMENT '签到积分',
  `is_experience` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否奖励经验',
  `experience` int(5) NOT NULL DEFAULT '0' COMMENT '签到经验',
  `mark` varchar(200) NOT NULL DEFAULT '' COMMENT '备注说明',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否删除',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '添加时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COMMENT='签到设置表';

-- ----------------------------
-- Table structure for eb_sms_template
-- ----------------------------
DROP TABLE IF EXISTS `eb_sms_template`;
CREATE TABLE `eb_sms_template` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `temp_id` varchar(20) NOT NULL DEFAULT '0' COMMENT '短信模板id',
  `temp_type` tinyint(2) NOT NULL DEFAULT '1' COMMENT '模板类型',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '模板说明',
  `type` varchar(20) NOT NULL DEFAULT '' COMMENT '类型',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '状态',
  `content` varchar(500) NOT NULL COMMENT '短息内容',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '添加时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COMMENT='短信模板表';

-- ----------------------------
-- Table structure for eb_system_admin
-- ----------------------------
DROP TABLE IF EXISTS `eb_system_admin`;
CREATE TABLE `eb_system_admin` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '管理员ID',
  `account` varchar(32) NOT NULL COMMENT '管理员账号',
  `pwd` char(32) NOT NULL COMMENT '管理员密码',
  `real_name` varchar(16) NOT NULL COMMENT '管理员姓名',
  `header_image` varchar(255) NOT NULL DEFAULT '' COMMENT '管理员头像',
  `roles` varchar(128) NOT NULL COMMENT '管理员角色(menus_id)',
  `last_ip` varchar(16) DEFAULT NULL COMMENT '管理员最后一次登录ip',
  `login_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '登录次数',
  `level` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '管理员级别',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '管理员状态 1有效，0无效',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除：1-删除',
  `phone` varchar(15) DEFAULT NULL COMMENT '手机号码',
  `is_sms` tinyint(1) unsigned DEFAULT '0' COMMENT '是否接收短信',
  `type` int(2) NOT NULL DEFAULT '1' COMMENT '管理员类型：1= 平台超管, 2=商户超管, 3=系统管理员，4=商户管理员',
  `mer_id` int(11) NOT NULL DEFAULT '0' COMMENT '商户id，0-平台',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '后台管理员添加时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '后台管理员最后一次登录时间',
  `identity_no` varchar(255) DEFAULT NULL COMMENT 'bcx账户联合id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `account` (`account`) USING BTREE,
  KEY `is_del` (`is_del`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COMMENT='系统管理员表';

-- ----------------------------
-- Table structure for eb_system_attachment
-- ----------------------------
DROP TABLE IF EXISTS `eb_system_attachment`;
CREATE TABLE `eb_system_attachment` (
  `att_id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '附件名称',
  `att_dir` varchar(200) NOT NULL DEFAULT '' COMMENT '附件路径',
  `satt_dir` varchar(200) DEFAULT NULL COMMENT '压缩图片路径',
  `att_size` char(30) NOT NULL DEFAULT '' COMMENT '附件大小',
  `att_type` char(30) NOT NULL DEFAULT '' COMMENT '附件类型',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '分类ID0编辑器,1商品图片,2拼团图片,3砍价图片,4秒杀图片,5文章图片,6组合数据图， 7前台用户',
  `image_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '图片上传类型 1本地 2七牛云 3OSS 4COS ',
  `owner` int(11) DEFAULT '-1' COMMENT '资源归属方',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`att_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=868 DEFAULT CHARSET=utf8mb4 COMMENT='附件管理表';

-- ----------------------------
-- Table structure for eb_system_config
-- ----------------------------
DROP TABLE IF EXISTS `eb_system_config`;
CREATE TABLE `eb_system_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '字段名称',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '字段提示文字',
  `form_id` int(10) DEFAULT '0' COMMENT '表单id',
  `value` longtext COMMENT '值',
  `status` tinyint(1) DEFAULT '0' COMMENT '是否隐藏',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `form_name` varchar(100) NOT NULL DEFAULT '' COMMENT '表单名称',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `name` (`name`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1293 DEFAULT CHARSET=utf8mb4 COMMENT='配置表';

-- ----------------------------
-- Table structure for eb_system_form_temp
-- ----------------------------
DROP TABLE IF EXISTS `eb_system_form_temp`;
CREATE TABLE `eb_system_form_temp` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '表单模板id',
  `name` varchar(500) NOT NULL DEFAULT '' COMMENT '表单名称',
  `info` varchar(500) NOT NULL DEFAULT '' COMMENT '表单简介',
  `content` text NOT NULL COMMENT '表单内容',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COMMENT='表单模板';

-- ----------------------------
-- Table structure for eb_system_group
-- ----------------------------
DROP TABLE IF EXISTS `eb_system_group`;
CREATE TABLE `eb_system_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '组合数据ID',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '数据组名称',
  `info` varchar(256) NOT NULL DEFAULT '' COMMENT '简介',
  `form_id` int(11) NOT NULL DEFAULT '0' COMMENT 'form 表单 id',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COMMENT='组合数据表';

-- ----------------------------
-- Table structure for eb_system_group_data
-- ----------------------------
DROP TABLE IF EXISTS `eb_system_group_data`;
CREATE TABLE `eb_system_group_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '组合数据详情ID',
  `gid` int(11) NOT NULL DEFAULT '0' COMMENT '对应的数据组id',
  `value` text NOT NULL COMMENT '数据组对应的数据值（json数据）',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '数据排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态（1：开启；2：关闭；）',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1283 DEFAULT CHARSET=utf8mb4 COMMENT='组合数据详情表';

-- ----------------------------
-- Table structure for eb_system_menu
-- ----------------------------
DROP TABLE IF EXISTS `eb_system_menu`;
CREATE TABLE `eb_system_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `name` varchar(100) DEFAULT NULL COMMENT '名称',
  `icon` varchar(255) DEFAULT NULL COMMENT 'icon',
  `perms` varchar(200) DEFAULT NULL COMMENT '权限标识',
  `component` varchar(200) DEFAULT NULL COMMENT '组件路径',
  `menu_type` varchar(2) DEFAULT 'M' COMMENT '类型，M-目录，C-菜单，A-按钮',
  `sort` int(5) NOT NULL DEFAULT '99999' COMMENT '排序',
  `is_show` tinyint(1) NOT NULL DEFAULT '1' COMMENT '显示状态',
  `is_delte` tinyint(1) unsigned DEFAULT '0' COMMENT '是否删除',
  `type` int(11) NOT NULL COMMENT '系统菜单类型：3-平台,4-商户',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `type` (`type`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=763 DEFAULT CHARSET=utf8mb4 COMMENT='系统菜单表';

-- ----------------------------
-- Table structure for eb_system_notification
-- ----------------------------
DROP TABLE IF EXISTS `eb_system_notification`;
CREATE TABLE `eb_system_notification` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `mark` varchar(50) NOT NULL DEFAULT '' COMMENT '标识',
  `type` varchar(50) NOT NULL DEFAULT '' COMMENT '通知类型',
  `description` varchar(100) NOT NULL DEFAULT '' COMMENT '通知场景说明',
  `is_wechat` tinyint(2) NOT NULL DEFAULT '0' COMMENT '公众号模板消息（0：不存在，1：开启，2：关闭）',
  `wechat_id` int(11) NOT NULL DEFAULT '0' COMMENT '模板消息id',
  `is_routine` tinyint(2) NOT NULL DEFAULT '0' COMMENT '小程序订阅消息（0：不存在，1：开启，2：关闭）',
  `routine_id` int(11) NOT NULL DEFAULT '0' COMMENT '订阅消息id',
  `is_sms` tinyint(2) NOT NULL DEFAULT '0' COMMENT '发送短信（0：不存在，1：开启，2：关闭）',
  `sms_id` int(11) NOT NULL DEFAULT '0' COMMENT '短信id',
  `send_type` tinyint(2) NOT NULL DEFAULT '1' COMMENT '发送类型（1：用户，2：管理员）',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `mark` (`mark`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COMMENT='通知设置表';

-- ----------------------------
-- Table structure for eb_system_role
-- ----------------------------
DROP TABLE IF EXISTS `eb_system_role`;
CREATE TABLE `eb_system_role` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '身份管理id',
  `mer_id` int(11) NOT NULL DEFAULT '0' COMMENT '商户id',
  `role_name` varchar(32) NOT NULL COMMENT '身份管理名称',
  `rules` text NOT NULL COMMENT '身份管理权限(menus_id)',
  `level` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `type` int(11) NOT NULL DEFAULT '0' COMMENT '管理员类型：1= 平台超管, 2=商户超管, 3=系统管理员，4=商户管理员',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `status` (`status`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COMMENT='身份管理表';

-- ----------------------------
-- Table structure for eb_system_role_menu
-- ----------------------------
DROP TABLE IF EXISTS `eb_system_role_menu`;
CREATE TABLE `eb_system_role_menu` (
  `rid` int(11) NOT NULL COMMENT '角色id',
  `menu_id` int(11) NOT NULL COMMENT '权限id',
  PRIMARY KEY (`rid`,`menu_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='角色菜单关联表';

-- ----------------------------
-- Table structure for eb_system_user_level
-- ----------------------------
DROP TABLE IF EXISTS `eb_system_user_level`;
CREATE TABLE `eb_system_user_level` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '会员名称',
  `experience` int(11) NOT NULL DEFAULT '0' COMMENT '达到多少升级经验',
  `is_show` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否显示 1=显示,0=隐藏',
  `grade` int(11) NOT NULL DEFAULT '0' COMMENT '会员等级',
  `discount` int(4) NOT NULL DEFAULT '100' COMMENT '享受折扣',
  `icon` varchar(255) NOT NULL DEFAULT '' COMMENT '会员图标',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否删除.1=删除,0=未删除',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `back_image` varchar(255) NOT NULL DEFAULT '' COMMENT '用户等级背景图',
  `back_color` varchar(15) NOT NULL DEFAULT '' COMMENT '用户等级文字背景色',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COMMENT='普通会员等级';

-- ----------------------------
-- Table structure for eb_template_message
-- ----------------------------
DROP TABLE IF EXISTS `eb_template_message`;
CREATE TABLE `eb_template_message` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '模板id',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0=订阅消息,1=微信模板消息',
  `temp_key` char(50) NOT NULL DEFAULT '' COMMENT '模板编号',
  `name` char(100) NOT NULL COMMENT '模板名',
  `content` varchar(1000) NOT NULL COMMENT '回复内容',
  `temp_id` char(100) DEFAULT NULL COMMENT '模板ID',
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '状态',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '添加时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COMMENT='微信模板';

-- ----------------------------
-- Table structure for eb_trading_day_record
-- ----------------------------
DROP TABLE IF EXISTS `eb_trading_day_record`;
CREATE TABLE `eb_trading_day_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` varchar(20) DEFAULT NULL COMMENT '日期',
  `product_order_num` int(11) DEFAULT NULL COMMENT '订单数量',
  `product_order_pay_num` int(11) DEFAULT NULL COMMENT '订单支付数量',
  `product_order_pay_fee` decimal(8,2) DEFAULT NULL COMMENT '订单支付金额',
  `product_order_refund_num` int(11) DEFAULT NULL COMMENT '订单退款数量',
  `product_order_refund_fee` decimal(8,2) DEFAULT NULL COMMENT '订单退款金额',
  `recharge_order_num` int(11) DEFAULT NULL COMMENT '充值订单数量',
  `recharge_order_fee` decimal(8,2) DEFAULT NULL COMMENT '充值订单金额',
  `balance_pay_fee` decimal(8,2) DEFAULT NULL COMMENT '余额支付金额',
  `brokerage_fee` decimal(8,2) DEFAULT NULL COMMENT '支付佣金金额（用户确认到账佣金）',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `date` (`date`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COMMENT='商城交易日记录表';

-- ----------------------------
-- Table structure for eb_transaction_log
-- ----------------------------
DROP TABLE IF EXISTS `eb_transaction_log`;
CREATE TABLE `eb_transaction_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '交易业务日志ID',
  `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `key_no` varchar(100) DEFAULT NULL COMMENT '关键编码(可以是当次请求的流水号或者订单号等)',
  `trade_type` varchar(255) DEFAULT NULL COMMENT '交易类型',
  `trade_status` varchar(2) DEFAULT NULL COMMENT '交易状态',
  `request_message` longtext COMMENT '请求报文',
  `response_message` longtext COMMENT '返回报文',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1800 DEFAULT CHARSET=utf8mb4 COMMENT='交易业务日志表';

-- ----------------------------
-- Table structure for eb_user
-- ----------------------------
DROP TABLE IF EXISTS `eb_user`;
CREATE TABLE `eb_user` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `account` varchar(255) NOT NULL DEFAULT '' COMMENT '用户账号',
  `pwd` varchar(32) NOT NULL DEFAULT '' COMMENT '用户密码',
  `real_name` varchar(255) NOT NULL DEFAULT '' COMMENT '真实姓名',
  `birthday` varchar(32) NOT NULL DEFAULT '' COMMENT '生日',
  `identity_card_no` varchar(20) NOT NULL DEFAULT '' COMMENT '身份证号码',
  `tag_id` varchar(255) NOT NULL DEFAULT '' COMMENT '标签id,英文逗号分隔',
  `nickname` varchar(255) NOT NULL DEFAULT '' COMMENT '用户昵称',
  `avatar` varchar(256) NOT NULL DEFAULT '' COMMENT '用户头像',
  `phone` varchar(50) NOT NULL DEFAULT '' COMMENT '手机号码',
  `country` varchar(20) NOT NULL DEFAULT 'CN' COMMENT '国家，中国CN，其他OTHER',
  `province` varchar(20) NOT NULL DEFAULT '' COMMENT '省份',
  `city` varchar(20) NOT NULL DEFAULT '' COMMENT '城市',
  `district` varchar(64) NOT NULL DEFAULT '' COMMENT '区',
  `address` varchar(255) NOT NULL DEFAULT '' COMMENT '详细地址',
  `sex` tinyint(2) NOT NULL DEFAULT '1' COMMENT '性别，0未知，1男，2女，3保密',
  `integral` int(11) NOT NULL DEFAULT '0' COMMENT '用户积分',
  `experience` int(11) NOT NULL DEFAULT '0' COMMENT '用户经验',
  `now_money` decimal(16,2) NOT NULL DEFAULT '0.00' COMMENT '用户余额',
  `brokerage_price` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '佣金金额',
  `level` tinyint(2) NOT NULL DEFAULT '0' COMMENT '等级',
  `sign_num` int(11) NOT NULL DEFAULT '0' COMMENT '连续签到天数',
  `is_wechat_public` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否关联公众号',
  `is_wechat_routine` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否关联小程序',
  `pay_count` int(11) NOT NULL DEFAULT '0' COMMENT '用户购买次数',
  `is_promoter` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否为推广员',
  `promoter_time` timestamp NULL DEFAULT NULL COMMENT '成为分销员时间',
  `spread_uid` int(10) NOT NULL DEFAULT '0' COMMENT '上级推广员id',
  `spread_time` timestamp NULL DEFAULT NULL COMMENT '绑定上级推广员时间',
  `spread_count` int(11) NOT NULL DEFAULT '0' COMMENT '下级人数',
  `register_type` varchar(32) NOT NULL DEFAULT '' COMMENT '注册类型：public-公众号，mini-小程序，H5-H5,iosWx-微信ios，androidWx-微信安卓，ios-ios',
  `add_ip` varchar(16) NOT NULL DEFAULT '' COMMENT '创建ip',
  `last_ip` varchar(16) NOT NULL DEFAULT '' COMMENT '最后一次登录ip',
  `last_login_time` timestamp NULL DEFAULT NULL COMMENT '最后一次登录时间',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1为正常，0为禁止',
  `mark` varchar(255) NOT NULL DEFAULT '' COMMENT '备注',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '添加时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `is_logoff` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否注销',
  `logoff_time` timestamp NULL DEFAULT NULL COMMENT '注销时间',
  `is_wechat_ios` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否关联微信ios',
  `is_wechat_android` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否关联微信android',
  `is_binding_ios` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否关联ios',
  `signature` varchar(100) NOT NULL DEFAULT '' COMMENT '用户签名',
  `user_type` int(10) DEFAULT NULL COMMENT '用户类型：0-默认 1-企业 2-职员',
  `region_code` varchar(20) DEFAULT NULL COMMENT '区域编码',
  `industry_code` varchar(255) DEFAULT NULL,
  `institutional_code` varchar(255) DEFAULT NULL,
  `identity_no` varchar(255) DEFAULT NULL COMMENT 'bcx账户联合id',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `unique_index_account_eb_user` (`account`) USING BTREE,
  KEY `spreaduid` (`spread_uid`) USING BTREE,
  KEY `status` (`status`) USING BTREE,
  KEY `is_promoter` (`is_promoter`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=356232 DEFAULT CHARSET=utf8mb4 COMMENT='用户表';

-- ----------------------------
-- Table structure for eb_user_address
-- ----------------------------
DROP TABLE IF EXISTS `eb_user_address`;
CREATE TABLE `eb_user_address` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户地址id',
  `uid` int(11) unsigned NOT NULL COMMENT '用户id',
  `real_name` varchar(32) NOT NULL DEFAULT '' COMMENT '收货人姓名',
  `phone` varchar(16) NOT NULL DEFAULT '' COMMENT '收货人电话',
  `province` varchar(64) NOT NULL DEFAULT '' COMMENT '收货人所在省',
  `province_id` int(11) NOT NULL DEFAULT '0' COMMENT '省份ID',
  `city` varchar(64) NOT NULL DEFAULT '' COMMENT '收货人所在市',
  `city_id` int(11) NOT NULL DEFAULT '0' COMMENT '城市id',
  `district` varchar(64) NOT NULL DEFAULT '' COMMENT '收货人所在区/县',
  `district_id` int(11) NOT NULL DEFAULT '0' COMMENT '区/县id',
  `street` varchar(64) NOT NULL DEFAULT '' COMMENT '收货人所在街道',
  `detail` varchar(256) NOT NULL DEFAULT '' COMMENT '收货人详细地址',
  `post_code` int(10) NOT NULL DEFAULT '0' COMMENT '邮编',
  `longitude` varchar(16) NOT NULL DEFAULT '0' COMMENT '经度',
  `latitude` varchar(16) NOT NULL DEFAULT '0' COMMENT '纬度',
  `is_default` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否默认',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `uid` (`uid`) USING BTREE,
  KEY `is_default` (`is_default`) USING BTREE,
  KEY `is_del` (`is_del`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COMMENT='用户地址表';

-- ----------------------------
-- Table structure for eb_user_balance_record
-- ----------------------------
DROP TABLE IF EXISTS `eb_user_balance_record`;
CREATE TABLE `eb_user_balance_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '记录id',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT '用户uid',
  `link_id` varchar(32) NOT NULL DEFAULT '0' COMMENT '关联id(订单号、充值单号)(system默认为0）',
  `link_type` varchar(32) NOT NULL DEFAULT 'order' COMMENT '关联类型:order-订单,recharge-充值,system-系统,brokerage-佣金转余额',
  `type` int(1) NOT NULL DEFAULT '1' COMMENT '类型：1-增加，2-扣减',
  `amount` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '金额',
  `balance` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '剩余',
  `remark` varchar(100) NOT NULL DEFAULT '' COMMENT '备注',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '添加时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `uid` (`uid`) USING BTREE,
  KEY `link_id` (`link_id`) USING BTREE,
  KEY `link_type` (`link_type`) USING BTREE,
  KEY `type` (`type`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COMMENT='用户余额记录表';

-- ----------------------------
-- Table structure for eb_user_bill
-- ----------------------------
DROP TABLE IF EXISTS `eb_user_bill`;
CREATE TABLE `eb_user_bill` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户账单id',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户uid',
  `link_id` varchar(32) NOT NULL DEFAULT '0' COMMENT '关联id',
  `pm` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '0 = 支出 1 = 获得',
  `title` varchar(64) NOT NULL DEFAULT '' COMMENT '账单标题',
  `category` varchar(64) NOT NULL DEFAULT '' COMMENT '明细种类',
  `type` varchar(64) NOT NULL DEFAULT '' COMMENT '明细类型',
  `number` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '明细数字',
  `balance` decimal(16,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '剩余',
  `mark` varchar(512) NOT NULL DEFAULT '' COMMENT '备注',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '0 = 带确定 1 = 有效 -1 = 无效',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '添加时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `openid` (`uid`) USING BTREE,
  KEY `status` (`status`) USING BTREE,
  KEY `add_time` (`create_time`) USING BTREE,
  KEY `pm` (`pm`) USING BTREE,
  KEY `type` (`category`,`type`,`link_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COMMENT='用户账单表';

-- ----------------------------
-- Table structure for eb_user_brokerage_record
-- ----------------------------
DROP TABLE IF EXISTS `eb_user_brokerage_record`;
CREATE TABLE `eb_user_brokerage_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '记录id',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT '用户uid',
  `sub_uid` int(11) NOT NULL DEFAULT '0' COMMENT '下级uid',
  `link_no` varchar(32) NOT NULL DEFAULT '0' COMMENT '关联单号（订单号、提现单号）',
  `link_type` varchar(32) NOT NULL DEFAULT '0' COMMENT '关联类型（order,withdraw,yue）',
  `type` int(1) NOT NULL DEFAULT '1' COMMENT '类型：1-增加，2-扣减（提现）',
  `title` varchar(64) NOT NULL DEFAULT '' COMMENT '标题',
  `price` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '金额',
  `balance` decimal(16,2) NOT NULL DEFAULT '0.00' COMMENT '剩余',
  `mark` varchar(512) NOT NULL DEFAULT '' COMMENT '备注',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态：1-订单创建，2-冻结期，3-完成，4-失效（订单退款/申请被拒），5-提现申请',
  `frozen_time` int(3) NOT NULL DEFAULT '0' COMMENT '冻结期时间（天）',
  `thaw_time` bigint(14) NOT NULL DEFAULT '0' COMMENT '解冻时间',
  `brokerage_level` int(2) DEFAULT NULL COMMENT '分销等级',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '添加时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `uid` (`uid`) USING BTREE,
  KEY `status` (`status`) USING BTREE,
  KEY `type` (`type`) USING BTREE,
  KEY `link_no` (`link_no`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COMMENT='用户佣金记录表';

-- ----------------------------
-- Table structure for eb_user_closing
-- ----------------------------
DROP TABLE IF EXISTS `eb_user_closing`;
CREATE TABLE `eb_user_closing` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `closing_no` varchar(32) NOT NULL COMMENT '结算单号',
  `uid` int(10) unsigned DEFAULT NULL COMMENT '用户id',
  `closing_type` varchar(32) NOT NULL DEFAULT '' COMMENT '结算类型：bank = 银行卡 alipay = 支付宝 weixin=微信',
  `cardholder` varchar(64) NOT NULL DEFAULT '' COMMENT '银行卡持卡人姓名',
  `bank_card_no` varchar(32) NOT NULL DEFAULT '' COMMENT '银行卡卡号',
  `bank_name` varchar(512) NOT NULL DEFAULT '' COMMENT '银行名称',
  `bank_address` varchar(256) NOT NULL DEFAULT '' COMMENT '开户地址',
  `alipay_account` varchar(64) NOT NULL DEFAULT '' COMMENT '支付宝账号',
  `wechat_no` varchar(15) NOT NULL DEFAULT '' COMMENT '微信号',
  `payment_code` varchar(512) NOT NULL DEFAULT '' COMMENT '微信收款二维码',
  `closing_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '结算金额',
  `balance` decimal(8,2) unsigned DEFAULT '0.00' COMMENT '用户余额',
  `mark` varchar(512) NOT NULL DEFAULT '' COMMENT '备注',
  `audit_status` int(2) unsigned NOT NULL DEFAULT '0' COMMENT '审核状态：0-待审核，1-通过审核，2-审核失败',
  `refusal_reason` varchar(50) NOT NULL DEFAULT '' COMMENT '拒绝原因',
  `audit_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '审核员id',
  `audit_time` timestamp NULL DEFAULT NULL COMMENT '审核时间',
  `account_status` int(2) unsigned NOT NULL DEFAULT '0' COMMENT '到账状态：0-未到账，1-已到账',
  `closing_proof` varchar(1000) NOT NULL DEFAULT '' COMMENT '结算凭证',
  `closing_time` timestamp NULL DEFAULT NULL COMMENT '结算时间',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `real_name` varchar(20) NOT NULL DEFAULT '' COMMENT '真实姓名',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `closing_type` (`closing_type`) USING BTREE,
  KEY `audit_status` (`audit_status`) USING BTREE,
  KEY `uid` (`uid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='用户结算表';

-- ----------------------------
-- Table structure for eb_user_experience_record
-- ----------------------------
DROP TABLE IF EXISTS `eb_user_experience_record`;
CREATE TABLE `eb_user_experience_record` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '记录id',
  `uid` int(10) NOT NULL DEFAULT '0' COMMENT '用户uid',
  `link_id` varchar(32) NOT NULL DEFAULT '0' COMMENT '关联id-orderNo,(sign,system默认为0）',
  `link_type` varchar(32) NOT NULL DEFAULT 'order' COMMENT '关联类型（order,sign,system）',
  `type` int(1) NOT NULL DEFAULT '1' COMMENT '类型：1-增加，2-扣减',
  `title` varchar(64) NOT NULL DEFAULT '' COMMENT '标题',
  `experience` int(11) NOT NULL DEFAULT '0' COMMENT '经验',
  `balance` int(11) NOT NULL DEFAULT '0' COMMENT '剩余',
  `mark` varchar(512) NOT NULL DEFAULT '' COMMENT '备注',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态：1-成功（保留字段）',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '添加时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `uid` (`uid`) USING BTREE,
  KEY `type` (`type`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='用户经验记录表';

-- ----------------------------
-- Table structure for eb_user_integral_record
-- ----------------------------
DROP TABLE IF EXISTS `eb_user_integral_record`;
CREATE TABLE `eb_user_integral_record` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '记录id',
  `uid` int(10) NOT NULL DEFAULT '0' COMMENT '用户uid',
  `link_id` varchar(32) NOT NULL DEFAULT '0' COMMENT '关联id-orderNo,(sign,system默认为0）',
  `link_type` varchar(32) NOT NULL DEFAULT 'order' COMMENT '关联类型（order,sign,system）',
  `type` int(1) NOT NULL DEFAULT '1' COMMENT '类型：1-增加，2-扣减',
  `title` varchar(64) NOT NULL DEFAULT '' COMMENT '标题',
  `integral` int(11) NOT NULL DEFAULT '0' COMMENT '积分',
  `balance` int(11) NOT NULL DEFAULT '0' COMMENT '剩余',
  `mark` varchar(512) NOT NULL DEFAULT '' COMMENT '备注',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态：1-订单创建，2-冻结期，3-完成，4-失效（订单退款）',
  `frozen_time` int(3) NOT NULL DEFAULT '0' COMMENT '冻结期时间（天）',
  `thaw_time` bigint(14) NOT NULL DEFAULT '0' COMMENT '解冻时间',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '添加时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `openid` (`uid`) USING BTREE,
  KEY `status` (`status`) USING BTREE,
  KEY `add_time` (`create_time`) USING BTREE,
  KEY `type` (`type`) USING BTREE,
  KEY `type_link` (`type`,`link_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COMMENT='用户积分记录表';

-- ----------------------------
-- Table structure for eb_user_level
-- ----------------------------
DROP TABLE IF EXISTS `eb_user_level`;
CREATE TABLE `eb_user_level` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT '用户uid',
  `level_id` int(11) NOT NULL DEFAULT '0' COMMENT '等级vip',
  `grade` int(11) NOT NULL DEFAULT '0' COMMENT '会员等级',
  `discount` int(4) NOT NULL DEFAULT '100' COMMENT '享受折扣',
  `mark` varchar(255) NOT NULL DEFAULT '' COMMENT '备注',
  `expired_time` timestamp NULL DEFAULT NULL COMMENT '过期时间',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否删除,0=未删除,1=删除',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `id` (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='用户等级记录表';

-- ----------------------------
-- Table structure for eb_user_merchant_collect
-- ----------------------------
DROP TABLE IF EXISTS `eb_user_merchant_collect`;
CREATE TABLE `eb_user_merchant_collect` (
  `uid` int(11) NOT NULL COMMENT '用户ID',
  `mer_id` int(11) NOT NULL COMMENT '商户ID',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`uid`,`mer_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='用户商户收藏表';

-- ----------------------------
-- Table structure for eb_user_sign
-- ----------------------------
DROP TABLE IF EXISTS `eb_user_sign`;
CREATE TABLE `eb_user_sign` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT '用户uid',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '签到说明',
  `number` int(11) NOT NULL DEFAULT '0' COMMENT '获得',
  `balance` int(11) NOT NULL DEFAULT '0' COMMENT '剩余',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '类型，1积分，2经验',
  `create_day` date NOT NULL COMMENT '签到日期',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '添加时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `uid` (`uid`,`type`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='签到记录表';

-- ----------------------------
-- Table structure for eb_user_sign_record
-- ----------------------------
DROP TABLE IF EXISTS `eb_user_sign_record`;
CREATE TABLE `eb_user_sign_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `integral` int(5) NOT NULL DEFAULT '0' COMMENT '签到积分',
  `experience` int(5) NOT NULL DEFAULT '0' COMMENT '签到经验',
  `day` int(5) NOT NULL DEFAULT '1' COMMENT '连续签到天数',
  `award_integral` int(5) NOT NULL DEFAULT '0' COMMENT '连续签到奖励积分',
  `award_experience` int(5) NOT NULL DEFAULT '0' COMMENT '连续签奖励到经验',
  `date` varchar(20) NOT NULL DEFAULT '' COMMENT '签到日期，yyyy-MM-dd',
  `mark` varchar(200) NOT NULL DEFAULT '' COMMENT '备注说明',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '添加时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `uid` (`uid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='用户签到记录表';

-- ----------------------------
-- Table structure for eb_user_tag
-- ----------------------------
DROP TABLE IF EXISTS `eb_user_tag`;
CREATE TABLE `eb_user_tag` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) DEFAULT NULL COMMENT '标签名称',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='用户标签表';

-- ----------------------------
-- Table structure for eb_user_token
-- ----------------------------
DROP TABLE IF EXISTS `eb_user_token`;
CREATE TABLE `eb_user_token` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL COMMENT '用户 id',
  `token` varchar(255) NOT NULL DEFAULT '' COMMENT 'token',
  `type` tinyint(1) DEFAULT '1' COMMENT '类型，1 公众号， 2 小程序, 3 unionid, 5AppIos,6AppAndroid,7ios',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `expires_time` datetime DEFAULT NULL COMMENT '到期时间',
  `login_ip` varchar(32) DEFAULT NULL COMMENT '登录ip',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否删除',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `type+token` (`type`,`token`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for eb_user_visit_record
-- ----------------------------
DROP TABLE IF EXISTS `eb_user_visit_record`;
CREATE TABLE `eb_user_visit_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '记录id',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT '用户uid',
  `visit_type` int(2) NOT NULL DEFAULT '1' COMMENT '访问类型 1-首页，2-详情页，3-营销活动详情页，4-个人中心',
  `num` int(11) NOT NULL DEFAULT '1' COMMENT '访问数量',
  `date` varchar(20) NOT NULL DEFAULT '' COMMENT '日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `date` (`date`) USING BTREE,
  KEY `visit_type` (`visit_type`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=326 DEFAULT CHARSET=utf8mb4 COMMENT='用户访问记录表';

-- ----------------------------
-- Table structure for eb_wechat_callback
-- ----------------------------
DROP TABLE IF EXISTS `eb_wechat_callback`;
CREATE TABLE `eb_wechat_callback` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `to_user_name` varchar(255) DEFAULT NULL COMMENT '商家小程序名称',
  `from_user_name` varchar(255) DEFAULT NULL COMMENT '微信团队的 OpenID(固定值)',
  `create_time` bigint(50) unsigned DEFAULT NULL COMMENT '事件时间,Unix时间戳',
  `msg_type` varchar(255) DEFAULT NULL COMMENT '消息类型',
  `event` varchar(255) DEFAULT NULL COMMENT '事件类型',
  `content` text COMMENT '内容',
  `add_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='微信回调表';

-- ----------------------------
-- Table structure for eb_wechat_exceptions
-- ----------------------------
DROP TABLE IF EXISTS `eb_wechat_exceptions`;
CREATE TABLE `eb_wechat_exceptions` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `errcode` varchar(64) DEFAULT '' COMMENT '错误码',
  `errmsg` varchar(255) DEFAULT '' COMMENT '错误信息',
  `data` text COMMENT '回复数据',
  `remark` text COMMENT '备注',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8mb4 COMMENT='微信异常表';

-- ----------------------------
-- Table structure for eb_wechat_live_assistant
-- ----------------------------
DROP TABLE IF EXISTS `eb_wechat_live_assistant`;
CREATE TABLE `eb_wechat_live_assistant` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `mer_id` int(11) NOT NULL COMMENT '商户id',
  `wechat` varchar(255) DEFAULT NULL COMMENT '微信号',
  `wechat_nickname` varchar(255) DEFAULT NULL COMMENT '用户微信昵称',
  `headimg` varchar(500) DEFAULT NULL COMMENT '助手微信头像 微信返回',
  `ass_desc` varchar(255) DEFAULT NULL COMMENT '备注',
  `openid` varchar(255) DEFAULT NULL COMMENT '助手openid',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='小程序 直播 小助手';

-- ----------------------------
-- Table structure for eb_wechat_live_goods
-- ----------------------------
DROP TABLE IF EXISTS `eb_wechat_live_goods`;
CREATE TABLE `eb_wechat_live_goods` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `cover_img_url` varchar(500) DEFAULT NULL COMMENT '填入mediaID（mediaID获取后，三天内有效）；图片mediaID的获取，请参考以下文档New_temporary_materials；图片规则：图片尺寸最大300像素*300像素；',
  `cover_img_url_local` varchar(500) DEFAULT NULL COMMENT '对应cover_img_url的本地图片地址',
  `name` varchar(255) NOT NULL COMMENT '商品名称，最长14个汉字，1个汉字相当于2个字符',
  `price_type` int(11) NOT NULL COMMENT '价格类型，1：一口价（只需要传入price，price2不传） 2：价格区间（price字段为左边界，price2字段为右边界，price和price2必传） 3：显示折扣价（price字段为原价，price2字段为现价， price和price2必传）',
  `price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '数字，最多保留两位小数，单位元',
  `price2` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '数字，最多保留两位小数，单位元',
  `url` varchar(255) NOT NULL COMMENT '商品详情页的小程序路径，路径参数存在 url 的，该参数的值需要进行 encode 处理再填入',
  `goods_id` int(11) DEFAULT NULL COMMENT '直播商品id 微信返回的数据',
  `product_id` int(11) DEFAULT NULL COMMENT '直播对应的本地商城商品id',
  `audit_id` int(255) DEFAULT NULL COMMENT '审核单ID',
  `audit_status` int(11) DEFAULT NULL COMMENT '0：未审核，1：审核中，2:审核通过，3审核失败',
  `third_party_appid` varchar(255) DEFAULT NULL COMMENT '当商品为第三方小程序的商品则填写为对应第三方小程序的appid，自身小程序商品则为''''',
  `third_party_tag` int(11) DEFAULT NULL COMMENT '1、2：表示是为 API 添加商品，否则是直播控制台添加的商品',
  `review_status` int(11) DEFAULT NULL COMMENT '0=商户创建/撤回,1=平台待审核/商户重新提交审核，2=平台审核通过/微信审核中，3=平台审核失败,4=微信审核成功，5=微信审核失败',
  `review_reason` varchar(255) DEFAULT NULL COMMENT '审核失败原因',
  `mer_name` varchar(255) NOT NULL COMMENT '商户名称',
  `mer_type` int(11) NOT NULL COMMENT '商户类别',
  `mer_id` int(11) NOT NULL COMMENT '商户id',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='小程序 直播 商品';

-- ----------------------------
-- Table structure for eb_wechat_live_room
-- ----------------------------
DROP TABLE IF EXISTS `eb_wechat_live_room`;
CREATE TABLE `eb_wechat_live_room` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `room_id` int(11) DEFAULT NULL COMMENT '直播间id',
  `cover_img` varchar(500) NOT NULL COMMENT '直播间背景图 MediaId',
  `cover_img_wx` varchar(500) DEFAULT NULL COMMENT '微信返回的直播间背景图',
  `cover_img_local` varchar(500) DEFAULT NULL COMMENT '直播间背景图本地图片',
  `room_name` varchar(255) NOT NULL COMMENT '直播间名称',
  `feeds_img` varchar(500) DEFAULT NULL COMMENT '官方收录封面MediaId',
  `feeds_img_wx` varchar(500) DEFAULT NULL COMMENT '微信返回的 官方收录封面',
  `feeds_img_local` varchar(500) DEFAULT NULL COMMENT '官方收录封面本地图片',
  `share_img` varchar(500) NOT NULL COMMENT '直播间分享图 MediaId',
  `share_img_wx` varchar(500) DEFAULT NULL COMMENT '直播间分享微信返回图片',
  `share_img_local` varchar(500) DEFAULT NULL COMMENT '直播间分享图本地图片',
  `anchor_name` varchar(255) NOT NULL COMMENT '主播昵称',
  `anchor_wechat` varchar(255) NOT NULL COMMENT '主播微信号',
  `sub_anchor_wechat` varchar(255) DEFAULT NULL COMMENT '主播副号微信号',
  `start_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '直播开始时间',
  `end_time` datetime NOT NULL COMMENT '直播预计结束时间',
  `live_status` int(4) DEFAULT NULL COMMENT '直播间状态。101：直播中，102：未开始，103已结束，104禁播，105：暂停，106：异常，107：已过期',
  `store_show` int(11) NOT NULL DEFAULT '1' COMMENT '显示在商城0关闭1开启',
  `type` int(4) NOT NULL COMMENT '直播类型，1 推流 0 手机直播',
  `close_like` int(4) NOT NULL COMMENT '是否关闭点赞 【0：开启，1：关闭】（若关闭，观众端将隐藏点赞按钮，直播开始后不允许开启）',
  `close_goods` int(4) NOT NULL COMMENT '是否关闭货架 【0：开启，1：关闭】（若关闭，观众端将隐藏商品货架，直播开始后不允许开启）',
  `close_comment` int(4) NOT NULL COMMENT '是否关闭评论 【0：开启，1：关闭】（若关闭，观众端将隐藏评论入口，直播开始后不允许开启）',
  `close_kf` int(4) DEFAULT NULL COMMENT '是否关闭客服 【0：开启，1：关闭】 默认关闭客服（直播开始后允许开启）',
  `close_replay` int(4) DEFAULT NULL COMMENT '是否关闭回放 【0：开启，1：关闭】默认关闭回放（直播开始后允许开启）',
  `close_share` int(11) DEFAULT NULL COMMENT '是否关闭分享 【0：开启，1：关闭】默认开启分享（直播开始后不允许修改）',
  `is_feeds_public` int(4) NOT NULL COMMENT '是否开启官方收录，1 开启，0 关闭',
  `creater_openid` varchar(255) DEFAULT NULL COMMENT '创建者openid',
  `creater_wechat` varchar(255) DEFAULT NULL COMMENT '创建者微信号，不传入则此直播间所有成员可见。传入则此房间仅创建者、管理员、超管、直播间主播可见',
  `live_replay` text COMMENT '直播间回放',
  `goods` text COMMENT '直播间商品id集合',
  `goods_json` text COMMENT '同步微信直播间的商品',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `qrcode_url` varchar(500) DEFAULT NULL COMMENT '小程序直播 小程序码',
  `assistant` varchar(255) DEFAULT NULL COMMENT '直播小助手',
  `review_status` int(11) DEFAULT NULL COMMENT '审核:0=商户创建成功平台待审核，1=平台审核失败，2=平台审核成功并提交给微信审核失败，3=平台审核成功并提交给微信审核成功',
  `review_reason` varchar(500) DEFAULT NULL COMMENT '审核错误原因',
  `mer_name` varchar(255) NOT NULL COMMENT '商户名称',
  `mer_type` int(11) NOT NULL COMMENT '商户类型',
  `mer_id` int(11) NOT NULL COMMENT '商户id',
  `star` int(11) NOT NULL DEFAULT '0' COMMENT '推荐星级',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='小程序 直播 直播间';

-- ----------------------------
-- Table structure for eb_wechat_pay_info
-- ----------------------------
DROP TABLE IF EXISTS `eb_wechat_pay_info`;
CREATE TABLE `eb_wechat_pay_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `app_id` varchar(50) DEFAULT NULL COMMENT '公众号唯一标识',
  `mch_id` varchar(50) DEFAULT NULL COMMENT '商户号',
  `device_info` varchar(50) DEFAULT NULL COMMENT '设备号,PC网页或公众号内支付可以传-WEB',
  `open_id` varchar(50) DEFAULT NULL COMMENT '用户的唯一标识',
  `nonce_str` varchar(50) DEFAULT NULL COMMENT '随机字符串',
  `sign` varchar(70) DEFAULT NULL COMMENT '签名',
  `sign_type` varchar(20) DEFAULT 'MD5' COMMENT '签名类型，默认为MD5，支持HMAC-SHA256和MD5',
  `body` varchar(500) DEFAULT NULL COMMENT '商品描述',
  `detail` text COMMENT '商品详细描述，对于使用单品优惠的商户，该字段必须按照规范上传',
  `attach` varchar(255) DEFAULT NULL COMMENT '附加数据，在查询API和支付通知中原样返回，可作为自定义参数使用',
  `out_trade_no` varchar(50) DEFAULT NULL COMMENT '商户订单号,要求32个字符内',
  `fee_type` varchar(50) DEFAULT NULL COMMENT '标价币种：CNY：人民币 GBP：英镑 HKD：港币 USD：美元 JPY：日元 CAD：加拿大元 AUD：澳大利亚元 EUR：欧元 NZD：新西兰元 KRW：韩元 THB：泰铢',
  `total_fee` int(11) DEFAULT NULL COMMENT '标价金额',
  `spbill_create_ip` varchar(64) DEFAULT NULL COMMENT '终端IP',
  `time_start` varchar(20) DEFAULT NULL COMMENT '交易起始时间',
  `time_expire` varchar(20) DEFAULT NULL COMMENT '交易结束时间',
  `notify_url` varchar(300) DEFAULT NULL COMMENT '通知地址',
  `trade_type` varchar(20) DEFAULT NULL COMMENT '交易类型,取值为：JSAPI，NATIVE，APP等',
  `product_id` varchar(32) DEFAULT NULL COMMENT '商品ID',
  `scene_info` varchar(256) DEFAULT NULL COMMENT '场景信息',
  `err_code` varchar(50) DEFAULT NULL COMMENT '错误代码',
  `prepay_id` varchar(100) DEFAULT NULL COMMENT '预支付交易会话标识',
  `code_url` varchar(64) DEFAULT NULL COMMENT '二维码链接',
  `is_subscribe` varchar(2) DEFAULT NULL COMMENT '是否关注公众账号',
  `trade_state` varchar(32) DEFAULT NULL COMMENT '交易状态',
  `bank_type` varchar(20) DEFAULT NULL COMMENT '付款银行',
  `cash_fee` int(11) DEFAULT NULL COMMENT '现金支付金额',
  `coupon_fee` int(11) DEFAULT NULL COMMENT '代金券金额',
  `transaction_id` varchar(50) DEFAULT NULL COMMENT '微信支付订单号',
  `time_end` varchar(20) DEFAULT NULL COMMENT '支付完成时间',
  `trade_state_desc` varchar(256) DEFAULT NULL COMMENT '交易状态描述',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `out_trade_no` (`out_trade_no`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COMMENT='微信订单表';

-- ----------------------------
-- Table structure for eb_wechat_reply
-- ----------------------------
DROP TABLE IF EXISTS `eb_wechat_reply`;
CREATE TABLE `eb_wechat_reply` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '微信关键字回复id',
  `keywords` varchar(64) NOT NULL DEFAULT '' COMMENT '关键字',
  `type` varchar(32) NOT NULL DEFAULT '' COMMENT '回复类型',
  `data` text NOT NULL COMMENT '回复数据',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '回复状态 0=不可用  1 =可用',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `key` (`keywords`) USING BTREE,
  KEY `type` (`type`) USING BTREE,
  KEY `status` (`status`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COMMENT='微信关键字回复表';

-- ----------------------------
-- Table structure for qrtz_blob_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_blob_triggers`;
CREATE TABLE `qrtz_blob_triggers` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `TRIGGER_NAME` varchar(200) NOT NULL,
  `TRIGGER_GROUP` varchar(200) NOT NULL,
  `BLOB_DATA` blob,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `QRTZ_BLOB_TRIGGERS_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for qrtz_calendars
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_calendars`;
CREATE TABLE `qrtz_calendars` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `CALENDAR_NAME` varchar(200) NOT NULL,
  `CALENDAR` blob NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`CALENDAR_NAME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for qrtz_cron_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_cron_triggers`;
CREATE TABLE `qrtz_cron_triggers` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `TRIGGER_NAME` varchar(200) NOT NULL,
  `TRIGGER_GROUP` varchar(200) NOT NULL,
  `CRON_EXPRESSION` varchar(200) NOT NULL,
  `TIME_ZONE_ID` varchar(80) DEFAULT NULL,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `QRTZ_CRON_TRIGGERS_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for qrtz_fired_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_fired_triggers`;
CREATE TABLE `qrtz_fired_triggers` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `ENTRY_ID` varchar(95) NOT NULL,
  `TRIGGER_NAME` varchar(200) NOT NULL,
  `TRIGGER_GROUP` varchar(200) NOT NULL,
  `INSTANCE_NAME` varchar(200) NOT NULL,
  `FIRED_TIME` bigint(13) NOT NULL,
  `SCHED_TIME` bigint(13) NOT NULL,
  `PRIORITY` int(11) NOT NULL,
  `STATE` varchar(16) NOT NULL,
  `JOB_NAME` varchar(200) DEFAULT NULL,
  `JOB_GROUP` varchar(200) DEFAULT NULL,
  `IS_NONCONCURRENT` varchar(1) DEFAULT NULL,
  `REQUESTS_RECOVERY` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`SCHED_NAME`,`ENTRY_ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for qrtz_job_details
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_job_details`;
CREATE TABLE `qrtz_job_details` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `JOB_NAME` varchar(200) NOT NULL,
  `JOB_GROUP` varchar(200) NOT NULL,
  `DESCRIPTION` varchar(250) DEFAULT NULL,
  `JOB_CLASS_NAME` varchar(250) NOT NULL,
  `IS_DURABLE` varchar(1) NOT NULL,
  `IS_NONCONCURRENT` varchar(1) NOT NULL,
  `IS_UPDATE_DATA` varchar(1) NOT NULL,
  `REQUESTS_RECOVERY` varchar(1) NOT NULL,
  `JOB_DATA` blob,
  PRIMARY KEY (`SCHED_NAME`,`JOB_NAME`,`JOB_GROUP`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for qrtz_locks
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_locks`;
CREATE TABLE `qrtz_locks` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `LOCK_NAME` varchar(40) NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`LOCK_NAME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for qrtz_paused_trigger_grps
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_paused_trigger_grps`;
CREATE TABLE `qrtz_paused_trigger_grps` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `TRIGGER_GROUP` varchar(200) NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_GROUP`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for qrtz_scheduler_state
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_scheduler_state`;
CREATE TABLE `qrtz_scheduler_state` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `INSTANCE_NAME` varchar(200) NOT NULL,
  `LAST_CHECKIN_TIME` bigint(13) NOT NULL,
  `CHECKIN_INTERVAL` bigint(13) NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`INSTANCE_NAME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for qrtz_simple_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_simple_triggers`;
CREATE TABLE `qrtz_simple_triggers` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `TRIGGER_NAME` varchar(200) NOT NULL,
  `TRIGGER_GROUP` varchar(200) NOT NULL,
  `REPEAT_COUNT` bigint(7) NOT NULL,
  `REPEAT_INTERVAL` bigint(12) NOT NULL,
  `TIMES_TRIGGERED` bigint(10) NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `QRTZ_SIMPLE_TRIGGERS_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for qrtz_simprop_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_simprop_triggers`;
CREATE TABLE `qrtz_simprop_triggers` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `TRIGGER_NAME` varchar(200) NOT NULL,
  `TRIGGER_GROUP` varchar(200) NOT NULL,
  `STR_PROP_1` varchar(512) DEFAULT NULL,
  `STR_PROP_2` varchar(512) DEFAULT NULL,
  `STR_PROP_3` varchar(512) DEFAULT NULL,
  `INT_PROP_1` int(11) DEFAULT NULL,
  `INT_PROP_2` int(11) DEFAULT NULL,
  `LONG_PROP_1` bigint(20) DEFAULT NULL,
  `LONG_PROP_2` bigint(20) DEFAULT NULL,
  `DEC_PROP_1` decimal(13,4) DEFAULT NULL,
  `DEC_PROP_2` decimal(13,4) DEFAULT NULL,
  `BOOL_PROP_1` varchar(1) DEFAULT NULL,
  `BOOL_PROP_2` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `QRTZ_SIMPROP_TRIGGERS_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for qrtz_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_triggers`;
CREATE TABLE `qrtz_triggers` (
  `SCHED_NAME` varchar(120) NOT NULL,
  `TRIGGER_NAME` varchar(200) NOT NULL,
  `TRIGGER_GROUP` varchar(200) NOT NULL,
  `JOB_NAME` varchar(200) NOT NULL,
  `JOB_GROUP` varchar(200) NOT NULL,
  `DESCRIPTION` varchar(250) DEFAULT NULL,
  `NEXT_FIRE_TIME` bigint(13) DEFAULT NULL,
  `PREV_FIRE_TIME` bigint(13) DEFAULT NULL,
  `PRIORITY` int(11) DEFAULT NULL,
  `TRIGGER_STATE` varchar(16) NOT NULL,
  `TRIGGER_TYPE` varchar(8) NOT NULL,
  `START_TIME` bigint(13) NOT NULL,
  `END_TIME` bigint(13) DEFAULT NULL,
  `CALENDAR_NAME` varchar(200) DEFAULT NULL,
  `MISFIRE_INSTR` smallint(2) DEFAULT NULL,
  `JOB_DATA` blob,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  KEY `SCHED_NAME` (`SCHED_NAME`,`JOB_NAME`,`JOB_GROUP`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

SET FOREIGN_KEY_CHECKS = 1;
