package com.bcxin.ins.utils;

import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.vo.DictConst;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class FeeUtils {
    private static Logger logger = LoggerFactory.getLogger(FeeUtils.class);

    public static BigDecimal calcAmount(BigDecimal amount ,String startDate, String endDate, int menCount, String reviseType, int reviseCount){
        if(DictConst.REVISE_TYPE_T.equals(reviseType)){
            return BigDecimal.ZERO;
        }
        BigDecimal dayAmount = amount.divide(BigDecimal.valueOf(menCount),2, RoundingMode.HALF_UP).divide(new BigDecimal("365"),2, RoundingMode.HALF_UP);
        int days = DateUtil.getDistDates(DateUtil.parseDate(startDate), DateUtil.parseDate(endDate));
        logger.info("calcAmount amount:{},menCount:{},dayAmount:{},days:{}",amount,menCount,dayAmount,days);
        BigDecimal reviseAmount = dayAmount.multiply(new BigDecimal(reviseCount)).multiply(BigDecimal.valueOf(days));
        if(DictConst.REVISE_TYPE_J.equals(reviseType)){
            logger.info("calcAmount minusAmount:{}", reviseAmount);
            return reviseAmount.negate();
        }else if(DictConst.REVISE_TYPE_Z.equals(reviseType)){
            logger.info("calcAmount plusAmount:{}", reviseAmount);
            return reviseAmount;
        }
        return null;
    }


    public static BigDecimal calcPremium(BigDecimal premium ,String startDate, String endDate, int menCount, String reviseType, int reviseCount) {
        if(DictConst.REVISE_TYPE_T.equals(reviseType)){
            return BigDecimal.ZERO;
        }
        BigDecimal dayPremium = premium.divide(BigDecimal.valueOf(menCount),2, RoundingMode.HALF_UP).divide(new BigDecimal("365"),2, RoundingMode.HALF_UP);
        int days = DateUtil.getDistDates(DateUtil.parseDate(startDate), DateUtil.parseDate(endDate));
        logger.info("calcPremium premium:{},menCount:{},dayPremium:{},days:{}",premium,menCount,dayPremium,days);
        BigDecimal revisePremium = dayPremium.multiply(new BigDecimal(reviseCount)).multiply(BigDecimal.valueOf(days));
        if(DictConst.REVISE_TYPE_J.equals(reviseType)){
            logger.info("calcPremium minusPremium:{}", revisePremium);
            return revisePremium.negate();
        }else if(DictConst.REVISE_TYPE_Z.equals(reviseType)){
            logger.info("calcPremium plusPremium:{}", revisePremium);
            return revisePremium;
        }
        return null;
    }
}
