package com.bcxin.ins.third.zzx.pingancai;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.bcxin.ins.util.*;
import com.bcxin.ins.vo.*;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.pingan.esg.sdk.security.AESUtils;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.DateFormat;
import java.util.*;

/**
 *
 * <b>平安财-展责险各类型接口数据组装及解析</b>
 *
 * @author zxf
 * @date 2017年10月11日 上午10:29:46
 * @注意事项 </b>
 * <b>
 */
public class ZZX_PackageMessagePingAnCai {

	/*
	* [18:26:17|INFO |(SDK_MSG_LOG)]=[publicKey:MFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBAOJIF9rY1kpkvk9kgH3DWSDQS5PAXE07SAo8YAxd6fDqOLgtybSjGNxeFvO6a9q5lc6LZOuTKYC/Yx9AHHCW328CAwEAAQ==]
	* [18:26:17|INFO |(SDK_MSG_LOG)]=[privateKey:MIIBVAIBADANBgkqhkiG9w0BAQEFAASCAT4wggE6AgEAAkEA4kgX2tjWSmS+T2SAfcNZINBLk8BcTTtICjxgDF3p8Oo4uC3JtKMY3F4W87pr2rmVzotk65MpgL9jH0AccJbfbwIDAQABAkAqyilAqCp1rPFUABRQM+Whz+HK0eBidmhcDyi2jffUJ4tfkjMzc7jrnqkSgD+MsX6girrPT1eDSs0UWohIc5LhAiEA/sWznQpk+WAxvCjbSYWMvK+sIzbgFfseB2gzgM4XzBECIQDjXz6Fs/6Imb3os5WytFca+Uo7KCW5rCDNnRIsEU1zfwIgVqfCDvEhJR0N7ZTr+VbeZrNN1nBsya0vKo/LrMzslTECIFN3UUJPsu5+UaKs2hVB8n/qZ3+T21VvhJM2R8d5io8NAiEAw+xSQ3P2T4MEZ1/1GDA+pSzhR0VUFOWk8wVSbGs9gJQ=]
	* */

	private static Logger logger = LoggerFactory.getLogger(ZZX_PackageMessagePingAnCai.class);

	private static final String FORMAT = "json";
	private static final String SIGNTYPE = "md5";
	private static final String CHARSET = "utf-8";

	public static String pay_pc(OrderFormVo dto,String url) throws Exception {
		String  key="OPENAPI";

		String returnUrl = GlobalResources.DONOW_PATH+"transaction/common-syntony/"+dto.getOid();
		if(ConstProp.BLB.equals(dto.getWeb_type())){
			returnUrl = GlobalResources.WEB_URL+"/insurance/zzx/transaction/syntony-service/"+dto.getOid();
		}
		HashMap map=new HashMap();
		map.put("dataSource","180");
		map.put("customerName",dto.getApplicant_name());
		map.put("businessNo",dto.getNotice_no());
		map.put("currencyNo","RMB");
		map.put("amount",dto.getGross_premium());
		map.put("documentNo",dto.getPolicy_serial_number());
		map.put("insuredName",dto.getInsured_role());
		//页面跳转地址
		map.put("callBackURL",returnUrl);
		String test = "180"+dto.getApplicant_name()+dto.getNotice_no()+"RMB"+dto.getGross_premium()+dto.getPolicy_serial_number()+key;
		String sign= PAC_MD5Util.sha256Hex(test);
		System.out.println("P-1> test:"+test );
		System.out.println("P-2> sign:"+sign );
		map.put("signMsg",sign);
		//页面form表单地址
		map.put("url",url);
		String data =JSONArray.toJSONString(map);
		System.out.println("P-3> map:"+data );
		return  data;
	}

	public static String pay_app(OrderFormVo dto,String url) throws Exception {
		String  key="OPENAPI";

		String return_url = GlobalResources.DONOW_PATH+"/weixin/product/pay/finish/"+dto.getOid();
		HashMap map=new HashMap();
		map.put("dataSource","180");//数据来源
		map.put("customerName",dto.getApplicant_name());//客户名称
		map.put("businessNo",dto.getNotice_no());//通知单号
		map.put("currencyNo","RMB");//币种
		map.put("amount",dto.getGross_premium());//支付金额
		map.put("productName",dto.getProduct_name());//产品名称
		map.put("callBackUrl",return_url);//页面跳转地址
		String test = String.valueOf(map.get("dataSource"))+String.valueOf(map.get("customerName"))+String.valueOf(map.get("businessNo"))+String.valueOf(map.get("currencyNo"))+String.valueOf(map.get("amount"))+key;
		String sign= PAC_MD5Util.sha256Hex(test);
		System.out.println("P-1> test:"+test );
		System.out.println("P-2> sign:"+sign );
		map.put("signMsg",sign);
		//页面form表单地址
		map.put("url",url);
		String data =JSONArray.toJSONString(map);
		System.out.println("P-3> map:"+data );
		return  data;
	}

	public static String marshal(LOTEPolicyVo vo, OrderFormVo dto, String transType, Map<String,String> map) throws Exception {

		JSONObject jsonHead = new JSONObject();
		//头信息
		//核保
		if(ConstProp.DIGIT_ONE.equals(transType)){
			//合作伙伴用户名（Openapi分配名称，固定值）
			jsonHead.put("partnerName","P_BCXZR_GP");
			//交易流水号，每次提交必须唯一(用于验证重复提交)
			jsonHead.put("transSerialNo",dto.getTrade_serial_number());
			//机构编码，咨询平安业务
			jsonHead.put("departmentCode","23076");

			//投保信息
			JSONObject jsonContract = new JSONObject();
			//投保人
			JSONObject jsonApplicant = new JSONObject();
			doApplicantInfo(vo,dto,jsonApplicant);
			jsonContract.put("applicantInfoList",jsonApplicant);
			//被保险人
			JSONObject jsonInsurant = new JSONObject();
			doInsurantInfo(vo,dto,jsonInsurant);
			jsonContract.put("insurantInfoList",jsonInsurant);
			//保单基本信息
			JSONObject jsonBase = new JSONObject();
			doBaseInfo(vo,dto,jsonBase);
			jsonContract.put("baseInfo",jsonBase);
			//是否见费出单
			JSONObject jsonExtend = new JSONObject();
			//是否见费，0非见费，1见费【传入1】
			jsonExtend.put("isPolicyBeforePayfee",ConstProp.DIGIT_ONE);
			jsonContract.put("extendInfo",jsonExtend);
			//展会信息
			JSONObject jsonRiskGroupInfo = new JSONObject();
			JSONObject jsonRiskProperty = new JSONObject();
			JSONObject jsonRiskPropertyMap = new JSONObject();
			doRiskGroupInfo(vo,dto,jsonRiskPropertyMap);
			jsonRiskProperty.put("riskPropertyMap",jsonRiskPropertyMap);
			jsonRiskGroupInfo.put("riskPropertyInfoList",jsonRiskProperty);
			jsonContract.put("riskGroupInfoList",jsonRiskGroupInfo);
			//附件组
			JSONObject jsonDocumentGroup = new JSONObject();
			jsonDocumentGroup.put("documentGroupId","");
			jsonContract.put("attachmentGroupList",jsonDocumentGroup);

			jsonHead.put("contract",jsonContract);

		}else if (ConstProp.DIGIT_TWO.equals(transType)){//承保
			jsonHead.put("partnerName","P_BCXZR_GP");//合作伙伴用户名（Openapi分配名称，固定值）
			jsonHead.put("transSerialNo",dto.getTrade_serial_number());//交易流水号，每次提交必须唯一(用于验证重复提交)
			JSONObject jsonBase = new JSONObject();
			JSONObject jsonPolicyNo = new JSONObject();
			jsonPolicyNo.put("applyPolicyNo",dto.getPolicy_serial_number());//投保单号
			jsonBase.put("baseInfo",jsonPolicyNo);
			jsonHead.put("contract",jsonBase);

		}else if(ConstProp.DIGIT_THREE.equals(transType)){//电子保单打印
			jsonHead.put("partnerCode","P_BCXZR_GP");//合作伙伴用户名（Openapi分配名称，固定值）
			jsonHead.put("applyPolicyNo",dto.getPolicy_serial_number());//投保单号（打印暂存单、投保单时必传）
			jsonHead.put("policyNo",dto.getExternal_reference());//保单号（打印保单时必传）
			jsonHead.put("documentType",ConstProp.DIGIT_FOUR);//单证类型：1投保单，2暂存单（目前只有货运险有暂存单），4保单
			jsonHead.put("isElectronic",ConstProp.DIGIT_ONE);//是否电子版：0否,1是（一般都为1，货运险套打保单时传入0）
			jsonHead.put("languagePrint",ConstProp.DIGIT_ZERO);//打印语言，0中文打印，1英文打印（一般都为0，目前只有货运险支持英文打印）
		}

		return jsonHead.toString();
	}

	//投保基本信息 doBaseInfo
	private static void doBaseInfo(LOTEPolicyVo vo, OrderFormVo dto,JSONObject json){

		json.put("productCode","MP07000130");//产品编码【展览会责任保险 MP07000130】
		json.put("inputNetworkFlag","internet");//传入“internet”
		json.put("totalInsuredAmount",dto.getInsured_amount());//保险金额
		json.put("amountCurrencyCode","01");//保额/限额币种，01人民币，02港币，03美元，04英镑，05日元，07瑞士法郎，09新加坡元，10加拿大元，12欧元，13澳大利亚元，18澳门元，19丹麦克朗，20挪威克朗，21瑞典克朗，22新西兰元，23韩元
//		json.put("totalActualPremium","340");//总保费 TODO 标记 虚拟数据
		json.put("totalActualPremium",dto.getGross_premium());//总保费
		json.put("premiumCurrencyCode","01");//保费币种，01人民币，02港币，03美元
		json.put("insuranceBeginDate",dto.getInception_date()+ConstProp.DAY_00);//保险起期 yyyy-MM-dd HH:mm:ss或yyyy/MM/dd HH:mm:ss
		json.put("insuranceEndDate",dto.getPlanned_end_date()+ConstProp.DAY_23);//保险止期 yyyy-MM-dd HH:mm:ss或yyyy/MM/dd HH:mm:ss
		json.put("dataSource","");//数据来源【openApi】
		json.put("inputBy","");//录入人

	}

	//展会基本信息 riskGroupInfoList
	private static void doRiskGroupInfo(LOTEPolicyVo vo, OrderFormVo dto,JSONObject json){
		json.put("exhibitionName",vo.getSpecialExhibitionVo().getName());//展会名称
		json.put("exhibitionAddress", RegionUtils.getRegionNameByALLCode(vo.getSpecialExhibitionVo().getEx_province(),vo.getSpecialExhibitionVo().getEx_city(),vo.getSpecialExhibitionVo().getEx_county())+vo.getSpecialExhibitionVo().getEx_address());//展会地点及区域
		DateFormat dateFormat = new java.text.SimpleDateFormat("yyyy-MM-dd");
		json.put("museumDay",String.valueOf(dateFormat.format(DateUtil.convertStringToDate(vo.getSpecialExhibitionVo().getStar_time()).getTime())));//进馆日
		json.put("pavilionDay",String.valueOf(dateFormat.format(DateUtil.convertStringToDate(vo.getSpecialExhibitionVo().getEnd_time()).getTime())));//出馆日
		json.put("exhibitionCostPerMeter","");//展览区域每平方米造价
		json.put("lettableArea",vo.getSpecialExhibitionVo().getEx_acreage());//租用面积
		json.put("chineseEmployee",vo.getSpecialExhibitionVo().getEx_emp_num());//中方雇员人数

	}

	//投保人信息  applicantInfo
	private static void doApplicantInfo(LOTEPolicyVo vo, OrderFormVo dto,JSONObject json){

		for(RoleSubjectVo roleSubjectVo : vo.getRoleSubjectList()){
			if(!ConstProp.DIGIT_ONE.equals(roleSubjectVo.getKind())){
				continue;
			}
			String organizationCode = roleSubjectVo.getOrganization_code();
			if(StringUtils.isNotEmpty(organizationCode) && ConstProp.DIGIT_ONE.equals(roleSubjectVo.getId_type())){
				if(organizationCode.indexOf(ConstProp.MINUS)>-1){
					organizationCode = organizationCode.split(ConstProp.MINUS)[0]+organizationCode.split(ConstProp.MINUS)[1];
				}
			}
			json.put("name",roleSubjectVo.getName_cn());//公司名称 否
			json.put("personnelType","1");//个团标志（1个人，0团体）
			json.put("certificateType",idTypeSet(roleSubjectVo.getId_type()));//证件类型，个人(01：身份证、02：护照、03：军人证、04：港澳通行证，05：驾驶证、06：港澳回乡证或台胞证，07：临时身份证、99：其他)，团体(01：组织机构代码证、02：税务登记证、04：工商营业执照号、99：其他)"
			json.put("certificateNo",organizationCode);//证件号码
			json.put("linkManName",roleSubjectVo.getLink_name());//联系人名称
			String address = RegionUtils.getRegionNameByALLCode(roleSubjectVo.getReg_province(),roleSubjectVo.getReg_city(),roleSubjectVo.getReg_district())+roleSubjectVo.getReg_address();
			json.put("address",address);//地址
			json.put("mobileTelephone",roleSubjectVo.getLink_tel());//联系人手机
		}
	}

	//被保险人信息  doInsurantInfo
	private static void doInsurantInfo(LOTEPolicyVo vo, OrderFormVo dto,JSONObject json){

		for(RoleSubjectVo roleSubjectVo : vo.getRoleSubjectList()){
			if(!ConstProp.DIGIT_TWO.equals(roleSubjectVo.getKind())){
				continue;
			}
			String organizationCode = roleSubjectVo.getOrganization_code();
			if(StringUtils.isNotEmpty(organizationCode) && ConstProp.DIGIT_ONE.equals(roleSubjectVo.getId_type())){
				if(organizationCode.indexOf(ConstProp.MINUS)>-1){
					organizationCode = organizationCode.split(ConstProp.MINUS)[0]+organizationCode.split(ConstProp.MINUS)[1];
				}
			}
			json.put("name",roleSubjectVo.getName_cn());//公司名称 否
			json.put("personnelType","1");//个团标志（1个人，0团体）
			json.put("certificateType",idTypeSet(roleSubjectVo.getId_type()));//证件类型，个人(01：身份证、02：护照、03：军人证、04：港澳通行证，05：驾驶证、06：港澳回乡证或台胞证，07：临时身份证、99：其他)，团体(01：组织机构代码证、02：税务登记证、04：工商营业执照号、99：其他)"
			json.put("certificateNo",organizationCode);//证件号码
			json.put("linkManName",roleSubjectVo.getLink_name());//联系人名称
			String address = RegionUtils.getRegionNameByALLCode(roleSubjectVo.getReg_province(),roleSubjectVo.getReg_city(),roleSubjectVo.getReg_district())+roleSubjectVo.getReg_address();
			json.put("address",address);//地址
			json.put("mobileTelephone",roleSubjectVo.getLink_tel());//联系人手机
		}
	}

	private static String idTypeSet(String value){
		if ("1".equals(value)) {
			return "01";
		}/*else if ("2".equals(value)) {
			return "三证合一统一信用代码";
		}*/else if ("6".equals(value)) {
			return "02";
		}else if ("7".equals(value)) {
			return "04";
		}
		return "99";
	}

	/**
	 *	接口返回字符串解析
	 * @return
	 */
	public static String returnAnalysisJson(String json, String  transType){
		JSONObject jsonHead = JSONObject.fromObject(json);
		if( jsonHead == null ){
			return "300#（APP-PAC-001）未获取到返回数据！";
		}
		if(!"0".equals(jsonHead.get("ret"))){
			return "300#（APP-PAC-"+jsonHead.get("ret")+"）"+jsonHead.get("msg");
		}
		JSONObject jsonDate = JSONObject.fromObject(jsonHead.get("data"));
		JSONObject resultJson = JSONObject.fromObject(jsonDate.get("result"));
		if(transType.equals(ConstProp.DIGIT_ONE)) {
			//核保
			if("999999".equals(jsonDate.get("responseCode"))){
				//200#投保单号#通知单号#保费#保额
				return "200#"+resultJson.get("applyPolicyNo")+ConstProp.POUND_SIGN+resultJson.get("noticeNo")+ConstProp.POUND_SIGN+resultJson.get("totalActualPremium")+ConstProp.POUND_SIGN+resultJson.get("totalInsuredAmount");
			}else{
				return "300#（APP-PAC-"+jsonDate.get("responseCode")+"）"+jsonDate.get("responseMsg");
			}
		}else if(transType.equals(ConstProp.DIGIT_TWO)) {
			//承保   返回值
			if("999999".equals(jsonDate.get("responseCode")) || "888888".equals(jsonDate.get("responseCode"))){
				return "200#"+resultJson.get("policyNo")+ConstProp.POUND_SIGN;
			}else{
				return "300#（APP-PAC-"+jsonDate.get("responseCode")+"）"+jsonDate.get("responseMsg");
			}
		}else if(transType.equals(ConstProp.DIGIT_THREE)) {
			//获取电子保单文件流   返回值
			if(!"999999".equals(jsonDate.get("responseCode"))){
				return "300#（APP-PAC-"+jsonDate.get("responseCode")+"）"+jsonDate.get("responseMsg");
			}
			String policyValue = (String)resultJson.get("policyValue");
			String filePath = uploadFile(policyValue,"/zzx-pac/");
			if(StringUtils.isNotEmpty(filePath)){
				return "200#"+filePath;
			}else{
				return "300#（APP-PAC-002）电子保单打印文件流解析失败！";
			}
		}
		return "300#（APP-PAC-001.1）数据处理失败！";
	}

	/**
	 * 文件上传并返回下载地址
	 * @param fileStr 字符串文件流
	 * @param savePath 文件要保存的文件夹地址（/zzx-pac/）
	 * @return /getResource?path=/policy/1231231.jpg
	 */
	public static String uploadFile(String fileStr, String savePath){

		String result = "";
		if (StringUtils.isNotEmpty(fileStr)) {
			try {
				byte[] bytes = BASE64Util.decryptBASE64Byte(fileStr);
				String files = DateUtil.generatorRadomNumber() + ".pdf";
				result = savePath + files;
				String path = GlobalResources.COM_IMG_RE+savePath;
				FileHelp.byteFile(bytes, path, files);
				result = "/getResource?path="+result;
			} catch (Exception e) {
				e.printStackTrace();
				result = "";
			}
		}
		return result;
	}

	private static String getDate(String doTime,int status){
		String result = "";
		if(StringUtils.isEmpty(doTime)){
			return result;
		}
		try {
			if(status == 0){//常规转换
				result = DateUtil.convertDateToString(DateUtil.parseDate(doTime),DateUtil.FORMAT2);
			}else if(status == 1){//+ 00:00:00
				result = DateUtil.convertDateToString(DateUtil.parseDate(doTime),DateUtil.FORMAT2);
				if(StringUtils.isNotEmpty(result)){
					result = result + ConstProp.DAY_00;
				}
			}else if(status == 2){//+ 23:59:59
				Date beT = DateUtil.parseDate(doTime);
				Calendar cDate = Calendar.getInstance();
				cDate.setTime(beT);
				cDate.set(Calendar.DATE, cDate.get(Calendar.DATE) - 1);
				result = DateUtil.convertDateToString(beT,DateUtil.FORMAT2);
				if(StringUtils.isNotEmpty(result)){
					result = result + ConstProp.DAY_23;
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return result;
	}

	private static String getCityCodeByPro(String pro,String city){
		if("110000".equals(pro)){
			return pro;
		}else if("120000".equals(pro)){
			return pro;
		}else if("500000".equals(pro)){
			return pro;
		}else if("310000".equals(pro)){
			return pro;
		}else if("710000".equals(pro)){
			return pro;
		}else if("810000".equals(pro)){
			return pro;
		}else if("820000".equals(pro)){
			return pro;
		}else{
			return city;
		}
	}








	public static void main(String[] args) throws Exception {
//		doResultCheDan();
//		CommonUtils.generateRSAKeyPair("F:\\D_pan\\ase\\123\\123.txt","F:\\D_pan\\ase\\123\\1234.txt");

		System.out.println(AESUtils.generateKey());//do2MYF9wh50XelwGsAGCbw==
	}

	private static void doResultCheDan() {
		//        String  resultMsg= "{\"header\":{\"transactionCode\":\"TCEGISNBUAPC001\",\"partnerId\":\"PCXM001\",\"requestId\":\"1493874890537\",\"code\":\"NBUERROR_0008\",\"message\":\"{\\\"ReturnFlag\\\":1,\\\"ResponseMsg\\\":\\\"系统生成保益保费之和510元与总单保费390元不符;\\\"}\"},\"body\":null}";
		String   resultMsg="{\"header\":{\"transactionCode\":\"TCEGISNBUWD001\",\"partnerId\":\"PCXM001\",\"requestId\":\"1493865755617\",\"code\":\"CRIGHT_0000\",\"message\":null},\"body\":\"\\\"{\\\\\\\"errorMessage\\\\\\\":\\\\\\\"fail\\\\\\\",\\\\\\\"rcptnoList\\\\\\\":[{\\\\\\\"message\\\\\\\":\\\\\\\"条形码9041K009837424的业务状态不允许进行撤件\\\\\\\",\\\\\\\"no\\\\\\\":\\\\\\\"30000070075776495\\\\\\\"}],\\\\\\\"resultFlag\\\\\\\":\\\\\\\"-1\\\\\\\"}\\\"\"}";
		Map<String, Object> map = null;
		try{
			map = JSON.parseObject(resultMsg,Map.class);
			Map<String, Object> header = JSON.parseObject( map.get("header").toString(),Map.class);
			if(!header.get("code").equals("CRIGHT_0000")){
				logger.info("300#撤单失败");
				return;
			}
			//返回成功
			String  bodyStr= map.get("body").toString();
			bodyStr=bodyStr.replaceFirst("\"","");
			bodyStr=bodyStr.substring(ConstProp.INT_NUMBER_ZERO,bodyStr.lastIndexOf('"'));
			bodyStr = bodyStr.replace("\\", ConstProp.BLANK_CHAR);
			Map<String, Object> body = JSON.parseObject(bodyStr,Map.class);
			if(body.get("resultFlag").toString().equals(ConstProp.DIGIT_ZERO)){
				String errorMessage=body.get("errorMessage").toString();
				logger.info("200#"+errorMessage);
			}else{
			   JSONArray array= JSON.parseArray(body.get("rcptnoList").toString());
				String  result =ConstProp.BLANK_CHAR;
				for(int i=ConstProp.INT_NUMBER_ZERO;i<array.size();i++){
					com.alibaba.fastjson.JSONObject object = (com.alibaba.fastjson.JSONObject) array.get(i);
					result=result+ConstProp.POUND_SIGN+object.get("message")+ConstProp.POUND_SIGN+object.get("no");
				}
				String   errorMessage =body.get("resultFlag").toString();
				logger.info("300"+result);
			}
		}catch(Exception e){
			e.printStackTrace();
		}
 	}

	private static void doResultTouBao() {
		String   resultMsg="{\"header\":{\"transactionCode\":\"TCEGISNBUAPC001\",\"partnerId\":\"PCXM001\",\"requestId\":\"1493866040327\",\"code\":\"CRIGHT_0000\",\"message\":null},\"body\":\"{\\\"barCode\\\":\\\"9041K009837633\\\",\\\"receiptNo\\\":\\\"30000070075777063\\\",\\\"responseMsg\\\":\\\"AMESB接口InsuredAMESBService调用成功！\\\",\\\"returnFlag\\\":\\\"1\\\",\\\"totalPremium\\\":\\\"510\\\"}\"}";
		Map<String, Object> map = null;
		try{
            map = JSON.parseObject(resultMsg,Map.class);
            Map<String, Object> header = JSON.parseObject( map.get("header").toString(),Map.class);
            if(header.get("code").equals("CRIGHT_0000")){
                //返回成功
                Map<String, Object> body = JSON.parseObject( map.get("body").toString(),Map.class);
                String receiptNo=body.get("receiptNo").toString();
                String  totalPremium=body.get("totalPremium").toString();//保费
                logger.info("200#"+receiptNo+ConstProp.POUND_SIGN+totalPremium+ConstProp.POUND_SIGN+"http://www.baidu.com");
            }else{
                //返回失败
                Map<String, Object> message = JSON.parseObject(header.get("message").toString(),Map.class);
                String msg=message.get("ResponseMsg").toString();
                logger.info("300#"+msg);
            }
        }catch(Exception e){

        }
	}
}
