package com.bcxin.ins.third.tyx.taikang;

import com.bcxin.ins.entity.common.LogBusinessrequest;
import com.bcxin.ins.service.order.LogBusinessrequestService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.http.RequestUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.GMRPolicyVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

/**
 * 
 * <b>团意险泰康几块请求</b>
 * 
 * @author zxf
 * @date 2017年4月5日 上午10:29:46
 * @注意事项 </b>
 * <b>
 */
@Service("tKRequestService")
@Transactional
public class TKRequestService {

	private Logger communicatorLog =  LoggerFactory.getLogger("commuLog");

	@Autowired
	private PolicyService policyService;
	@Autowired
	private LogBusinessrequestService logBusinessrequestService;

	/**
	 * 泰康请求方法
	 * 
	 * @return
	 */
	public String requestTK(Long order_id, String transType) {
		String url = GlobalResources.TK_INS_URL;
		OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(order_id);
		GMRPolicyVo vo = null;
		if(StringUtils.isNotEmpty(transType)){
			vo = policyService.accordingToOrderIDToGetGMRPolicyVo(Long.parseLong(dto.getOid()));
		}else{
			return "300#（APP-TK-001）数据丢失！";
		}
		String result = "300#（APP-TK-TYX-001）网络不稳定，请重新请求！";
		LogBusinessrequest lb = null;
		try {
			String data = PackageMessageTK.marshal(vo, dto, transType);
			communicatorLog.info("请求报文："+data);
			communicatorLog.info("request url:"+url);
			Date bTime = new Date();
			String ret = RequestUtil.initHttp().doPost(url, data, "application/json", "UTF-8");
			lb = logBusinessrequestService.initLogBusinessrequest(String.valueOf(order_id),transType,url,data,ret,bTime,new Date(), TransTypeEnum.getAlias(transType));
			communicatorLog.info("返回报文："+ret);
			result = PackageMessageTK.returnAnalysisJson(ret);
			logBusinessrequestService.supplementDecAndSave(lb,result.startsWith(ConstProp.CODE_FAILURE)?1:0,ConstProp.BLANK_CHAR);
		}catch (Exception ex){
			logBusinessrequestService.supplementDecAndSave(lb,2,ex.getMessage());
			ex.printStackTrace();
		}
		return result;
	}


}
