package com.bcxin.ins.third.tyx.renbao;

import com.bcxin.ins.entity.common.LogBusinessrequest;
import com.bcxin.ins.service.order.LogBusinessrequestService;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.http.RequestUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.GMRPolicyVo;
import com.bcxin.ins.vo.InsPreservationRecordVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;


/**
 *
 * <b>人保-雇主责任险险http接口请求业务</b>
 *
 * @author zxf
 * @date 2017年10月11日 上午10:29:46
 * @注意事项 </b>
 * <b>
 */
@Service("rBRequestService")
@Transactional
public class RBRequestService {

	private Logger communicatorLog =  LoggerFactory.getLogger(RBRequestService.class);

	@Autowired
	private PolicyService policyService;
	@Autowired
	private LogBusinessrequestService logBusinessrequestService;


	/**
	 * 人保请求方法
	 * 根据批单申请号获取批单号接口（配置文件key:RB_TYX_GET_PDH_URL）
	 * 正式 http://47.98.105.202:9003/api/getEndorseNo?applyno=DEAC201835020000004432
	 * 测试 http://47.98.105.202:9003/api/endorseNo?applyno=DEAC201835020000004432
	 * @return
	 */
	public String request_rb_tyx(Long order_id, String transType, InsPreservationRecordVo rvo) throws Exception {
		communicatorLog.info("request_rb_tyx：star-----------------------");
		communicatorLog.info("request_rb_tyx：接口编码-"+transType+",订单id-"+order_id+",RecordVo-"+(rvo != null ? rvo.toString() : "null"));
		OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(order_id);
		GMRPolicyVo vo = policyService.accordingToOrderIDToGetGMRPolicyVo(Long.parseLong(dto.getOid()));
		String result = "300#（APP-RB-TYX-001）网络不稳定，请重新请求！";
		LogBusinessrequest lb = null;
		try {
			String json = PackageMessageRB.marshal(vo,dto,transType,rvo);
			communicatorLog.info("请求报文："+json);
			String url = getPath(transType);
			communicatorLog.info("请求地址："+url);
			Date bTime = new Date();
			String ret = RequestUtil.initHttp().doPost(url, json, "text/xml", "UTF-8");
			lb = logBusinessrequestService.initLogBusinessrequest(String.valueOf(order_id),transType,url,json,ret,bTime,new Date(), TransTypeEnum.getAlias(transType));
			communicatorLog.info("返回报文："+ret);
			PackageMessageRB pmrb = new PackageMessageRB();
			result = pmrb.returnAnalysisXML(ret,transType);
			if(TransTypeEnum.PD.getValue().equals(transType) && StringUtils.isNotEmpty(result)) {
				//批单
				result = result.replace("##",ConstProp.POUND_SIGN+dto.getExternal_reference()+ ConstProp.POUND_SIGN);
			}
			communicatorLog.info("返回报文处理："+result);
			logBusinessrequestService.supplementDecAndSave(lb,result.startsWith(ConstProp.CODE_FAILURE)?1:0,ConstProp.BLANK_CHAR);
		}catch (Exception ex){
			logBusinessrequestService.supplementDecAndSave(lb,2,ex.getMessage());
			ex.printStackTrace();
		}
		communicatorLog.info("request_rb_tyx：end-----------------------");
		return result;
	}

	private String getPath(String tt){
		if(TransTypeEnum.HB.getValue().equals(tt)){
			return GlobalResources.map.get("RB_TYX_INS_URL");
		}else if(TransTypeEnum.PD.getValue().equals(tt)){
			return GlobalResources.map.get("RB_TYX_PD_URL");
		}
		return "";
	}

}
