package com.bcxin.ins.third.tyx.qianhai;

import com.bcxin.ins.entity.common.LogBusinessrequest;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.service.order.LogBusinessrequestService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.http.RequestUtil;
import com.bcxin.ins.vo.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;


/**
 *
 * <b>人保-团意险http接口请求业务</b>
 *
 * @author zxf
 * @date 2017年10月11日 上午10:29:46
 * @注意事项 </b>
 * <b>
 */
@Service("tYX_QHRequestService")
@Transactional
public class TYX_QHRequestService {

	private Logger communicatorLog =  LoggerFactory.getLogger(TYX_QHRequestService.class);

	@Autowired
	private PolicyService policyService;
	@Autowired
	private LogBusinessrequestService logBusinessrequestService;


	/**
	 * 平安请求方法
	 * 核保测试地址：http://47.98.105.202:9003/api/transit
	 * 核保生产地址：http://47.98.105.202:9003/api/transitAdd
	 *
	 * 批单测试地址： http://47.98.105.202:9003/api/endorse
	 * 批单生产地址： http://47.98.105.202:9003/api/endorsePolicy
	 *
	 * 测试地址：http://47.98.105.202:9003/api/paylink
	 * 正式地址：http://47.98.105.202:9003/api/getpaylink
	 *
	 * @return
	 */
	public String request_qh_tyx(Long order_id, String transType, InsPreservationRecordVo rvo) throws Exception {
		communicatorLog.info("request_qh_tyx：star-----------------------");
		communicatorLog.info("request_qh_tyx：接口编码-"+transType+",订单id-"+order_id+",RecordVo-"+(rvo != null ? rvo.toString() : "null"));
		OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(order_id);
		GMRPolicyVo vo = policyService.accordingToOrderIDToGetGMRPolicyVo(Long.parseLong(dto.getOid()));
		String result = "300#（APP-QH-TYX-001）网络不稳定，请重新请求！";
		LogBusinessrequest lb = null;
		try {
			String json = TYX_PackageMessageQianHai.marshal(vo, dto, transType, rvo);
			communicatorLog.info("请求报文："+json);
			String url = getPath(transType);
			communicatorLog.info("请求地址："+url);
			Date bTime = new Date();
			String ret = RequestUtil.initHttp().doPost(url, json, "text/xml", "UTF-8");
			lb = logBusinessrequestService.initLogBusinessrequest(String.valueOf(order_id),transType,url,json,ret,bTime,new Date(), TransTypeEnum.getAlias(transType));
			communicatorLog.info("返回报文："+ret);
			TYX_PackageMessageQianHai gpm = new TYX_PackageMessageQianHai();
			result = gpm.returnAnalysisXML(ret,transType);
			if(result.contains("测试超时异常")){
				result = "300#系统响应超时，请重试";
			}
			communicatorLog.info("返回报文处理："+result);
			logBusinessrequestService.supplementDecAndSave(lb,result.startsWith(ConstProp.CODE_FAILURE)?1:0,ConstProp.BLANK_CHAR);
		}catch (Exception ex){
			logBusinessrequestService.supplementDecAndSave(lb,2,ex.getMessage());
			ex.printStackTrace();
		}
		communicatorLog.info("request_qh_tyx：end-----------------------");
		return result;
	}

	private String getPath(String tt){
		if(TransTypeEnum.HB.getValue().equals(tt)){
//			return "https://intfuat.qhins.com:8443/cip-agent/request/policyOrder_BLB_061001/blbInf.dd";
			return GlobalResources.map.get("QH_TY_INS_URL");
		}else if(TransTypeEnum.PD.getValue().equals(tt)){
			return GlobalResources.map.get("QH_GZ_PG_URL");
		}else if(TransTypeEnum.DZFP.getValue().equals(tt)){
			return GlobalResources.map.get("QH_GZ_FP_URL");
		}else if(TransTypeEnum.ZXPG.getValue().equals(tt)){
			return GlobalResources.map.get("QH_GZ_PGCX_URL");
		}
		return "";
	}
}
