package com.bcxin.ins.third.tyx.pingancai;

import com.bcxin.ins.entity.common.LogBusinessrequest;
import com.bcxin.ins.service.order.LogBusinessrequestService;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.http.RequestUtil;
import com.bcxin.ins.vo.*;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;


/**
 *
 * <b>平安财-公责险http接口请求业务</b>
 *
 * @author zxf
 * @date 2017年10月11日 上午10:29:46
 * @注意事项 </b>
 * <b>
 */
@Service("pACRequestService")
@Transactional
public class PACRequestService {

	private Logger communicatorLog =  LoggerFactory.getLogger(PACRequestService.class);

	@Autowired
	private PolicyService policyService;
	@Autowired
	private LogBusinessrequestService logBusinessrequestService;

	private static final String PARTNERCODE = "P_BCX_GA";

	/**
	 * 平安请求方法
	 * 
	 * @return
	 */
	public String requestPAC(Long order_id, String transType, InsPreservationRecordVo iprVo) throws Exception {
		communicatorLog.info("requestPAC-TYX：star-----------------------");
		communicatorLog.info("requestPAC-TYX：接口编码-"+transType+",订单id-"+order_id+",iprVo-"+(iprVo != null ? iprVo.toString() : "null"));
		OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(order_id);
		GMRPolicyVo vo = policyService.accordingToOrderIDToGetGMRPolicyVo(Long.parseLong(dto.getOid()));
		String result = "300#（APP-PAC-TYX-001）网络不稳定，请重新请求！";
		LogBusinessrequest lb = null;
		try {
			String json = PackageMessagePAC.marshal(vo, dto, transType, iprVo);
			communicatorLog.info("请求报文："+json);
			String url = GlobalResources.PN_INS_URL + "/open/appsvr/property/openapi/"+PARTNERCODE+ ConstProp.SLASH+getUrlByTransType(transType)+"?access_token="+policyService.pnc_access_token();
			communicatorLog.info("请求地址："+url);
			Date bTime = new Date();
			String ret = RequestUtil.initHttp().doPostByAccept(url, json, "application/json", "UTF-8");
			lb = logBusinessrequestService.initLogBusinessrequest(String.valueOf(order_id),transType,url,json,ret,bTime,new Date(), TransTypeEnum.getAlias(transType));
			communicatorLog.info("返回报文："+ret);
			result = PackageMessagePAC.returnAnalysisJson(ret,transType);
			communicatorLog.info("返回报文处理："+result);
			logBusinessrequestService.supplementDecAndSave(lb,result.startsWith(ConstProp.CODE_FAILURE)?1:0,ConstProp.BLANK_CHAR);
		}catch (Exception ex){
			logBusinessrequestService.supplementDecAndSave(lb,2,ex.getMessage());
			ex.printStackTrace();
		}
		communicatorLog.info("requestPAC-TYX：end-----------------------");
		return result;
	}

	private static String getUrlByTransType(String type){
		if(TransTypeEnum.HB.getValue().equals(type)){//核保
			return "applyGA";
		}else if(TransTypeEnum.CBXX.getValue().equals(type)){//承保
			return "acceptGA";
		}else if(TransTypeEnum.DZBD.getValue().equals(type)){//电子保单打印
			return "printGA";
		}else if(TransTypeEnum.DZPD.getValue().equals(type)){//电子批单打印
			return "printGA";
		}else if(TransTypeEnum.ZFDZ.getValue().equals(type)){//获取支付地址
			return "prePayFinance";
		}else if(TransTypeEnum.ZX.getValue().equals(type)){//注销 TODO 未接
			return "cancelGA";
		}else if(TransTypeEnum.TB.getValue().equals(type)){//退保 TODO 未接
			return "refundGA";
		}else if(TransTypeEnum.DZFP.getValue().equals(type)){//电子发票
			return "printInvoice";
		}else if(TransTypeEnum.PD.getValue().equals(type)){//批单
			return "endorseApplyGA";
		}else if(TransTypeEnum.PDQR.getValue().equals(type)){//批单确认
			return "endorseConfirmGA";
		}
		return "";
	}

	/**
	 * <b> 批单确认接口，增减员保费出现变动时调用 </b>
	 * @author ZXF
	 * @create 2019/11/01 0001 16:13
	 * @version
	 * @注意事项 </b>
	 */
	public String pdqr(String transType, String pdResult){
		communicatorLog.info("pdqr-TYX：star-----------------------");
		communicatorLog.info("pdqr-TYX：接口编码-"+transType+",pdResult-"+pdResult);
		if(StringUtils.isNotEmpty(pdResult)) {
			//200#保单号#批单号#保费#批单申请号#批改申请时的流水号
			String[] arr = pdResult.split(ConstProp.POUND_SIGN);
			String result = "300#（APP-PAC-TYX-001）网络不稳定，请重新请求！";
			LogBusinessrequest lb = null;
			try {
				String json = PackageMessagePAC.pdqr_marshal(arr[1], transType, arr[4],arr[3],arr[5]);
				communicatorLog.info("请求报文："+json);
				String url = GlobalResources.PN_INS_URL + "/open/appsvr/property/openapi/"+PARTNERCODE+ ConstProp.SLASH+getUrlByTransType(transType)+"?access_token="+policyService.pnc_access_token();
				communicatorLog.info("请求地址："+url);
				Date bTime = new Date();
				String ret = RequestUtil.initHttp().doPostByAccept(url, json, "application/json", "UTF-8");
				lb = logBusinessrequestService.initLogBusinessrequest(ConstProp.BLANK_CHAR,transType,url,json,ret,bTime,new Date(), TransTypeEnum.getAlias(transType));
				communicatorLog.info("返回报文："+ret);
				result = PackageMessagePAC.returnAnalysisJson(ret,transType);
				communicatorLog.info("返回报文处理："+result);
				logBusinessrequestService.supplementDecAndSave(lb,result.startsWith(ConstProp.CODE_FAILURE)?1:0,ConstProp.BLANK_CHAR);
			}catch (Exception ex){
				logBusinessrequestService.supplementDecAndSave(lb,2,ex.getMessage());
				ex.printStackTrace();
			}
			communicatorLog.info("pdqr-TYX：end-----------------------");
			return result;
		}else{
			return "300#无批改信息！";
		}

	}
}
