package com.bcxin.ins.third.tyx.pingan.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class PaShaUtils {
	private static Logger logger = LogManager.getLogger(PaShaUtils.class.getName());

	public static void main(String[] args) {
		logger.info("TEST");
		logger.info(PaShaUtils.SHA256("20121221"));
		logger.info(PaShaUtils.SHA512("sdfsdf"));
	}


	public static String SHA256(final String strText) {
		return SHA(strText, "SHA-256");
	}

	public static String SHA512(final String strText) {
		return SHA(strText, "SHA-512");
	}

	private static String SHA(final String strText, final String strType) {

		String strResult = null;

		if (strText != null && strText.length() > 0) {
			try {

				MessageDigest messageDigest = MessageDigest
						.getInstance(strType);

				messageDigest.update(strText.getBytes());

				byte byteBuffer[] = messageDigest.digest();

				StringBuffer strHexString = new StringBuffer();
				for (int i = 0; i < byteBuffer.length; i++) {
					String hex = Integer.toHexString(0xff & byteBuffer[i]);
					if (hex.length() == 1) {
						strHexString.append('0');
					}
					strHexString.append(hex);
				}
				strResult = strHexString.toString();
			} catch (NoSuchAlgorithmException e) {
				logger.error(e);
			}
		}

		return strResult;
	}
}