package com.bcxin.ins.third.tyx.pingan;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.bcxin.ins.third.tyx.pingan.util.FileDownload;
import com.bcxin.ins.third.gzx.huatai.MD5Util;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.JSONUtils;
import com.bcxin.ins.util.idcard.IdNumberValidator;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.GMRPolicyVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Maps;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;

/**
 *
 * <b>团意险平安几块请求</b>
 *
 * @author liyognqiang
 * @date 2017年4月19日 上午10:29:46
 * @注意事项 </b>
 * <b>
 */
public class PackageMessagePingAn {


	private static Logger logger = LoggerFactory.getLogger(PackageMessagePingAn.class);

	private static final String FORMAT = "json";
	private static final String SIGNTYPE = "md5";
	private static final String CHARSET = "utf-8";


	public static String  pay(String order_no ,String  order_total_fee,String url,String return_url,String order_detail){
		String  key="e826afad6f8dea21548b3e79a15aa7fe";
		String  channel_id="PCXM001";

		order_total_fee=String.valueOf(new BigDecimal(order_total_fee).multiply(new BigDecimal("100")).intValue());
//		return_url = "www.baidu.com";
		String  notify_url="";//结果通知地址
		//"total_fee":"100","notify_url":"notify_url","order_no":"p00001","channel_id":"PCXM001","return_url":"return_url"
//		String  test="channel_id="+channel_id+"&notify_url="+notify_url+"&order_no="+order_no+"&return_url="+return_url+"&total_fee="+order_total_fee+"&key="+key;
		String  test="channel_id="+channel_id+"&order_detail="+
				order_detail+"&order_no="+order_no+"&return_url="+
				return_url+"&total_fee="+order_total_fee+"&key="+key;

		String sign= MD5Util.MD5Encode(test,CHARSET).toUpperCase();//加密，转成大写
		System.out.println("P-1> "+test );
		System.out.println("P-2> "+sign );
		HashMap map=new HashMap();
		map.put("sign",sign);
		map.put("total_fee",order_total_fee);
		map.put("notify_url",notify_url);
		map.put("order_no",order_no);
		map.put("order_detail",order_detail);// 订单详情
		map.put("channel_id",channel_id);
		map.put("return_url",return_url);//页面跳转地址
		map.put("url",url);//页面跳转地址
		String data =JSONArray.toJSONString(map);//将map转换成json
//		System.out.println(data);
//		try {
//			String ret = RequestUtil.initHttp().doPost(url, data, "application/json", "UTF-8");
//			logger.info(ret);
//			return ret;
//		}catch (Exception ex){
//            ex.printStackTrace();
//		}
		return  data;
	}
/*
*
* 拼接保险公司所需字段
* */
	public static String marshal(GMRPolicyVo vo, OrderFormVo dto,
								 String transType, Map<String,String> map) throws Exception {

		Map<String, Object> mapP = Maps.newHashMap();
		//请求头部
		Map<String, Object> mapHead = Maps.newHashMap();
		doHead(mapHead,vo,dto,transType);
		mapP.put("header",mapHead);
		Map<String, Object> mapBody = Maps.newHashMap();
		if("1".equals(transType)){
			//投保接口
			//请求内容
			//投保基本信息
			Map<String, Object> mapA = Maps.newHashMap();
			doBasicApplicationInfo(vo,dto,mapA);
			JSONObject jsonMapA = JSONObject.fromObject(mapA);
			mapBody.put("basicApplicationInfo",jsonMapA);
			//投保人信息  applicantInfo
			Map<String, Object> mapB = Maps.newHashMap();
			doApplicantInfo(vo,dto,mapB);
			JSONObject jsonMapB = JSONObject.fromObject(mapB);
			mapBody.put("applicantInfo",jsonMapB);
			// 银行账户信息  accountMaintainInfo
//			Map<String, Object> mapC= Maps.newHashMap();
//			doAccountMaintainInfo(vo,dto,mapC);
//			JSONObject jsonMapC = JSONObject.fromObject(mapC);
//			mapBody.put("accountMaintainInfo",jsonMapC);
			// 保障信息  gradeLevelInfo
			Map<String, Object> mapD= Maps.newHashMap();
			doGradeLevelInfo(vo,dto,mapD);
			JSONObject jsonMapD = JSONObject.fromObject(mapD);
			mapBody.put("gradeLevelInfo",jsonMapD);
			// 发票信息  invoiceInfoMap
			Map<String, Object> mapF= Maps.newHashMap();
			doInvoiceInfoMap(vo,dto,mapF);
			JSONObject jsonMapF = JSONObject.fromObject(mapF);
			mapBody.put("invoiceInfoMap",jsonMapF);
			// 被保险人信息  invoiceInfoMap
			Map<String, Object> mapG= Maps.newHashMap();
			doInsuredInfo(vo,dto,mapG);
			JSONObject jsonMapG = JSONObject.fromObject(mapG);
			mapBody.put("insuredInfo",jsonMapG);
			// 服务项目信息  appServiceInfo
			Map<String, Object> mapH= Maps.newHashMap();
			doAppServiceInfo(vo,dto,mapH);
			JSONObject jsonMapH = JSONObject.fromObject(mapH);
			mapBody.put("appServiceInfo",jsonMapH);
			// 业绩分摊信息  commissionProportionInfo
//			Map<String, Object> mapE= Maps.newHashMap();
//			doCommissionProportionInfo(vo,dto,mapE);
//			JSONObject jsonMapE = JSONObject.fromObject(mapE);
//			mapBody.put("commissionProportionInfo",jsonMapE);
		}else if ("2".equals(transType)){
			//核保


		}else if("3".equals(transType)){
			//支付跳转


		}else if("5".equals(transType)){
			//承保接口
//			mapBody.put("bankTradeNo","20170511155001884250276");//银行交易流水	bankTradeNo
//			mapBody.put("tranCode","200103");//交易代码	tranCode
//			mapBody.put("rcptno","30000070075794934");//收据号 rcptno
//			mapBody.put("bankTranDate","2017-05-11");//银行入账日期	bankTranDate YYYY-MM-DD
//			mapBody.put("bankTranTime","15:50:01");//银行交易日期	bankTranTime
//			mapBody.put("bankNo","99033222");//银行代码	bankNo
//			mapBody.put("bankTranChnl","NBU");//银行渠道	bankTranChnl

//			mapBody.put("bankTradeNo","20170511155402558310513");//银行交易流水	bankTradeNo
//			mapBody.put("tranCode","200103");//交易代码	tranCode
//			mapBody.put("rcptno","30000070075797392");//收据号 rcptno
//			mapBody.put("bankTranDate","2017-05-11");//银行入账日期	bankTranDate YYYY-MM-DD
//			mapBody.put("bankTranTime","15:54:02");//银行交易日期	bankTranTime
//			mapBody.put("bankNo","99033222");//银行代码	bankNo
//			mapBody.put("bankTranChnl","NBU");//银行渠道	bankTranChnl
			if(map != null){
				mapBody.put("bankTradeNo",map.get("bankTradeNo"));//银行交易流水	bankTradeNo
				mapBody.put("tranCode",map.get("tranCode"));//交易代码	tranCode
				mapBody.put("rcptno",map.get("rcptno"));//收据号 rcptno
				mapBody.put("bankTranDate",map.get("bankTranDate"));//银行入账日期	bankTranDate YYYY-MM-DD
				mapBody.put("bankTranTime",map.get("bankTranTime"));//银行交易日期	bankTranTime
				mapBody.put("bankNo",map.get("bankNo"));//银行代码	bankNo
				mapBody.put("bankTranChnl",map.get("bankTranChnl"));//银行渠道	bankTranChnl
			}

		}else if("4".equals(transType)){
			String arrs[]= new  String[1];
			arrs[0]="30000070075779077";

			//撤件
			mapBody.put("rcptnoList",doCheDan(arrs));//撤件
		}else if("6".equals(transType)){//查询电子保单
			String rcpno= dto.getExternal_reference();
			mapBody.put("policyNo",rcpno);
		}

		JSONObject jsonObject = JSONObject.fromObject(mapBody);
		mapP.put("body",jsonObject.toString());
		return JSONArray.toJSONString(mapP);
	}


	/**
	 * 投保头部
	 * @param map
	 * @param vo
	 * @param dto
	 * @param transType
	 */
	private   static  void  doHead(Map<String, Object> map,GMRPolicyVo vo, OrderFormVo dto, String transType){
		if(ConstProp.DIGIT_ONE.equals(transType)){
			//核保，返回支付信息以供form表單請求支付接口
			map.put("requestId", System.currentTimeMillis());
			map.put("partnerId","PCXM001");
			map.put("transactionCode","TCEGISNBUAPC001");
		}
		else if(ConstProp.DIGIT_FIVE.equals(transType)){
			//承保
			map.put("transactionCode","TCEGISNBUUW001");
			map.put("partnerId","PCXM001");
			map.put("requestId",System.currentTimeMillis());
		}
		else if(ConstProp.DIGIT_FOUR.equals(transType)){
			//撤单
			map.put("transactionCode","TCEGISNBUWD001");
			map.put("partnerId","PCXM001");
			map.put("requestId",System.currentTimeMillis());
		}
		else if(ConstProp.DIGIT_SIX.equals(transType)){
			//查询电子保单
			map.put("transactionCode","TCEGISNBUEP002");
			map.put("partnerId","PCXM001");
			map.put("requestId",System.currentTimeMillis());
		}else if(ConstProp.DIGIT_TWO.equals(transType)){
			//
//			map.put("transactionCode","TCEGISNBUAPC001");
//			map.put("partnerId","PCXM001");
//			map.put("requestId",System.currentTimeMillis());
		}
		else if(ConstProp.DIGIT_THREE.equals(transType)){
			//
//			map.put("transactionCode","TCEGISNBUAPC001");
//			map.put("partnerId","PCXM001");
//			map.put("requestId",System.currentTimeMillis());
		}

	}


	//投保基本信息 basicApplicationInfo
	private static void doBasicApplicationInfo(GMRPolicyVo vo, OrderFormVo dto,Map<String, Object> map){
		//第一个  是否  判断是否可空
//		条形码		barCode	字符	N/A			是	21	否	否
		map.put("barCode","");
//		主招揽业务员	empno	primaryAgentNo	字符	N/A			否	10	否	否
		map.put("primaryAgentNo","");//有疑问 非空 G011020250、G010701111
//		系统代码	system	systemSourceCode	字符	N/A			否	2	否	否
		map.put("systemSourceCode","16");//有疑问 非空
//		联系业务员		contactAgentNo	字符	N/A			是	10	否	否
		map.put("contactAgentNo","");
//		总保费		totalModalPremium	字符	N/A			是	14	否	否
		map.put("totalModalPremium",dto.getGross_premium());//
//		发票标志		invoiceType	字符	N/A			否	2	否	否		01是普票，02是专票，03是不需要发票
		map.put("invoiceType", ConstProp.DIGIT_ZERO.equals(vo.getMailPolicyVo().getInvoice_type()) ? "01" : "02");
// 	二级系统代码		systemSubSourceCode	字符	N/A			否	2	否	否		001表示h5投保，02表示厦门百川信
		map.put("systemSubSourceCode","02");
//		生效日期		effectiveDate	日期	N/A			否		否	否
		map.put("effectiveDate",dto.getInception_date());
	}

	private static String splitPhone(String phone, int type){
		String result = ConstProp.BLANK_CHAR;
		String[] str = phone.split(ConstProp.MINUS);
		if(type == 1){//获取区号
			if(str[0].length() == 3 || str[0].length() == 4){
				result = str[0];
			}
		}else if(type == 2){//获取电话
			if(str.length == 1 && (str[0].length() == 7 || str[0].length() == 8 )){
				result = str[0];
			}
			if(str.length == 2 && (str[1].length() == 7 || str[1].length() == 8)){
				result = str[1];
			}
		}else if(type == 3){//获取分机号
			if(str.length == 2&&(str[0].length() == 7 || str[0].length() == 8)&&(str[1].length() >= 3)){
				result = str[1];
			}
			if(str.length == 3 && str[2].length() >= 3){
				result = str[2];
			}
		}
		return result;
	}

	//投保人信息  applicantInfo
	private static void doApplicantInfo(GMRPolicyVo vo, OrderFormVo dto,Map<String, Object> map){
//		名称	厦门字段名称	NBU字段名称	类型	格式	最大值	最小值	可空

		for(RoleSubjectVo roleSubjectVo : vo.getRoleSubjectList()){
			if("1".equals(roleSubjectVo.getKind())){

				map.put("clientName",roleSubjectVo.getName_cn());//		客户名称		clientName 否
				map.put("county","");//电话国家代码		county  是
				map.put("areaCode",splitPhone(roleSubjectVo.getPhone(),1));//电话区号		areaCode 是
				map.put("phoneNo",splitPhone(roleSubjectVo.getPhone(),2));//		电话号码		phoneNo 是
				map.put("phoneExtNo",splitPhone(roleSubjectVo.getPhone(),3));//电话分机号  roleSubjectVo.getPhone()		phoneExtNo
				map.put("countryCode","");
				map.put("provinceCode",roleSubjectVo.getReg_province());//省份代码
				map.put("cityCode",getCityCodeByPro(roleSubjectVo.getReg_province(),roleSubjectVo.getReg_city()));//市代码		cityCode
				map.put("countyCode",roleSubjectVo.getReg_district());//区县代码		countyCode
				map.put("addressDetail",roleSubjectVo.getReg_address());//详细地址		addressDetail  roleSubjectVo.getAddress()+
				map.put("postCode",roleSubjectVo.getZip_code());//邮政编码		postCode   roleSubjectVo.getZipCode()
//		客户代码		gcNo	字符				是
				map.put("gcNo","");
//		客户简称		clientABBR	字符				是
				map.put("clientABBR","");
//		联系人姓名	OrgContactPerson	contaName	字符				否
				map.put("contaName",roleSubjectVo.getLink_name());
//		联系人部门		contaDept	字符				是
				map.put("contaDept",roleSubjectVo.getLink_section());
//		联系电话	mobilePhone	mobile	字符				否
				map.put("mobile",roleSubjectVo.getLink_tel());
//		单位总人数		clientTotalPsns	字符				是
				map.put("clientTotalPsns",roleSubjectVo.getTotal_emp());
//		单位性质		propertyType	单位性质基表				否01-12
//				01	国有
//				02	集体
//				03	私营
//				04	个体
//				05	中外合作
//				06	中外合资
//				07	外商独资
//				08	机关事业社团体
//				09	联营经济
//				10	股份制经济
//				11	港、澳、台投资经济
//				12	其它经济

				map.put("propertyType","".equals(roleSubjectVo.getNature_two()) ? natureLinkageSet(roleSubjectVo.getCom_nature()) : natureLinkageSet(roleSubjectVo.getNature_two()));//roleSubjectVo.getComType()
//		行业类别		industryType	行业类别基表				是
				map.put("industryType","");
//		经营区域		busiRegionType	经营区域基表				是
				map.put("busiRegionType", StringUtils.isNotEmpty(roleSubjectVo.getBusiness_area()) ? roleSubjectVo.getBusiness_area() : "");//01	当地  02	全省  03	全国 04	跨国

//		资产规模		assetsScale	字符				是
				map.put("assetsScale","1000");
//		主营业务		majorBusiness	字符				是
				map.put("majorBusiness","安保");
//		联系邮箱		email	字符				是
				map.put("email",roleSubjectVo.getLink_email());
//		证件类型		certificateTypeCode	证件类型基表				是
				map.put("certificateTypeCode","");//roleSubjectVo.getIdType()
//		证件号码		certificateNo	字符				是
				map.put("certificateNo","");//roleSubjectVo.getOrganizationCode()
//		组织机构代码证证件号		organizationCode	字符				是
				String organizationCode = roleSubjectVo.getOrganization_code();
				if(StringUtils.isNotEmpty(organizationCode) && ConstProp.DIGIT_ONE.equals(roleSubjectVo.getId_type())){
					organizationCode = organizationCode.split(ConstProp.MINUS)[0]+organizationCode.split(ConstProp.MINUS)[1];
					map.put("organizationCode",organizationCode);//roleSubjectVo.getOrganizationCode())
				}else{
					map.put("organizationCode","");//roleSubjectVo.getOrganizationCode())
				}
//		组织机构代码证证件有效期始期		orgCodeEff	日期	yyyy-MM-DD			是
				map.put("orgCodeEff",idOption_time("1",roleSubjectVo,0));
//		组织机构代码有效期截止		orgCodeEnd	日期	yyyy-MM-DD			是
				map.put("orgCodeEnd",idOption_time("1",roleSubjectVo,1));
//		工商登记号		busiRegisterId	字符				是
				map.put("busiRegisterId","7".equals(roleSubjectVo.getId_type()) ? roleSubjectVo.getOrganization_code() : "");
//		工商登记件有效期始期		busiRegEffDate	日期	yyyy-MM-DD			是
				map.put("busiRegEffDate",idOption_time("7",roleSubjectVo,0));
//		工商登记证证件有效止期		busiRegEndDate	日期	yyyy-MM-DD			是
				map.put("busiRegEndDate",idOption_time("7",roleSubjectVo,1));
//		税务登记证件号		taxRegisterNo	字符				是
				map.put("taxRegisterNo", "6".equals(roleSubjectVo.getId_type()) ? roleSubjectVo.getOrganization_code() : "");
//		税务登记证证件有效期始期		taxRegEffDate	日期	yyyy-MM-DD			是
				map.put("taxRegEffDate",idOption_time("6",roleSubjectVo,0));
//		税务登记证证件有效期止期		taxRegEndDate	日期	yyyy-MM-DD			是
				map.put("taxRegEndDate",idOption_time("6",roleSubjectVo,1));
//		统一社会信用代码		creditCode	字符				是
				map.put("creditCode","2".equals(roleSubjectVo.getId_type()) ? roleSubjectVo.getOrganization_code() : "");
//		其他证件		otherIdentiyNo	字符				是
				map.put("otherIdentiyNo","");
//		纳税人识别码		taxIdentification	字符				是
				map.put("taxIdentification","");
//		发票标志	(是否需要发票)	invoiceType	字符	N/A			否 01普票，02专票，03不需要发票
				map.put("invoiceType",vo.getMailPolicyVo() != null ? "1".equals(vo.getMailPolicyVo().getNeed_receipt()) ? ConstProp.DIGIT_ZERO.equals(vo.getMailPolicyVo().getInvoice_type()) ? "01"
						: "02"
						: "03"
						: "03");
			}

		}


	}

	/**
	 * 查询证件起止日期
	 * @param idT 要查询的证件类型标识
	 * @param roleSubjectVo 数据
	 * @param type 返回0起期或1止期
	 * @return
	 */
	private static String idOption_time(String idT,RoleSubjectVo roleSubjectVo,int type){

		if(!"1".equals(roleSubjectVo.getId_option())){//如果不是起止日期
			return "";
		}
		if(idT.equals(roleSubjectVo.getId_type())){
			if(type == 0){//起期
				return roleSubjectVo.getId_star_date();
			}else{//止期
				return roleSubjectVo.getId_end_date();
			}
		}else{
			return "";
		}
	}

	private static String idTypeSet(String value){
		if ("1".equals(value)) {
			return "组织机构代码证";
		}else if ("2".equals(value)) {
			return "三证合一统一信用代码";
		}else if ("6".equals(value)) {
			return "税务登记证";
		}else if ("7".equals(value)) {
			return "营业执照";
		}
		return "其他";
	}

	private static String natureLinkageSet(String value){//单位性质
		if ( "0".equals(value) ) {
			return "08";
		} else if ("1".equals(value)) {
			return "08";
		}else if ("2".equals(value)) {
			return "08";
		}else if ("3".equals(value)) {
			return "01";
		}else if ("4".equals(value)) {
			return "12";
		}else if ("5".equals(value)) {
			return "12";
		}else if ("6".equals(value)) {
			return "12";
		}else if ("7".equals(value)) {
			return "12";
		}else if ("8".equals(value)) {
			return "09";
		}else if ("9".equals(value)) {
			return "03";
		}else if ("10".equals(value)) {
			return "12";
		}else if ("11".equals(value)) {
			return "04";
		}else if ("12".equals(value)) {
			return "07";
		}else if ("13".equals(value)) {
			return "06";
		}else if ("14".equals(value)) {
			return "05";
		}
		return "12";
	}


	//银行账户信息accountMaintainInfo    可空 TODO 银行信息待完善
	private static void doAccountMaintainInfo(GMRPolicyVo vo, OrderFormVo dto,Map<String, Object> map){
//		名称	厦门字段名称	NBU字段名称	类型	格式	最大值	最小值	可空
//		银行帐户性质类型		bankCharacter	字符				否
		map.put("bankCharacter","");
//		客户开户行全称		bankName	字符				否
		map.put("bankName",vo.getMailPolicyVo() != null ? vo.getMailPolicyVo().getBank_invoice() : "");
//		银行账号		bankNo	字符				是
		map.put("bankNo",vo.getMailPolicyVo().getBank_account_invoice());
//		银行号		bankCode	银行代码基表				否
		map.put("bankCode","");

	}



	//保障信息 层级信息 gradeLevelInfo
	private static void doGradeLevelInfo(GMRPolicyVo vo, OrderFormVo dto,Map<String, Object> map){

//		层级号		gradeLevel	字符	N/A			6	否
		map.put("gradeLevel","1");
//		层级描述		gradeLevelDescription	字符	N/A			1000	是
		map.put("gradeLevelDescription","1");
//		层级险种		planInfos	层级险种	N/A				否
		map.put("planInfos",doGradeLevelList(vo,dto,map));

	}

	//保障信息 层级险种 gradeLevelList
	private static  List<Map<String, Object>> doGradeLevelList(GMRPolicyVo vo, OrderFormVo dto,Map<String, Object> map){

		List<Map<String, Object>> mapList= new ArrayList<>();
		for(int i=0;i<1;i++){
			Map<String, Object>  mapInfo= Maps.newHashMap();
//		险种		planCode	字符	N/A			10	否
//			mapInfo.put("planCode",dto.getProductType());
			mapInfo.put("planCode",getPlanCode(dto.getProduct_code()));

//		保险期限月		coveragePeriod	整形	N/A				否
			mapInfo.put("period","12");
//		保险期限天		coveragePeriodDays	整形	N/A				否
			mapInfo.put("periodDays","0");
//		份数		coverageUnits	整形	N/A				否
			mapInfo.put("units","1");
//		折扣		discount	字符	N/A				否
			mapInfo.put("discount","1");
			mapList.add(mapInfo);
		}

		return  mapList;
	}

	//根据产品id获取对应产品代码
	private static String getPlanCode(String product_code){
		if(!GlobalResources.IS_TEST_ENVI){
			if(StringUtils.isEmpty(product_code) ? false : "TYX-PAS-1".equals(product_code)){
				return "PT021";
			}else if(StringUtils.isEmpty(product_code) ? false : "TYX-PAS-2".equals(product_code)){
				return "PT022";
			}else if(StringUtils.isEmpty(product_code) ? false : "TYX-PAS-3".equals(product_code)){
				return "PT023";
			}else if(StringUtils.isEmpty(product_code) ? false : "TYX-PAS-4".equals(product_code)){
				return "PT025";
			}else if(StringUtils.isEmpty(product_code) ? false : "TYX-PAS-5".equals(product_code)){
				return "PT026";
			}else{
				return "";
			}
		}else{
			if(StringUtils.isEmpty(product_code) ? false : "TYX-PAS-1".equals(product_code)){
				return "BCX001";
			}else if(StringUtils.isEmpty(product_code) ? false : "TYX-PAS-2".equals(product_code)){
				return "BCX0002";
			}else if(StringUtils.isEmpty(product_code) ? false : "TYX-PAS-3".equals(product_code)){
				return "BCX0003";
			}else if(StringUtils.isEmpty(product_code) ? false : "TYX-PAS-4".equals(product_code)){
				return "BCX0004";
			}else if(StringUtils.isEmpty(product_code) ? false : "TYX-PAS-5".equals(product_code)){
				return "BCX0005";
			}else{
				return "";
			}
		}

	}

	//业绩分摊信息commissionProportionInfo 可空
	private static void doCommissionProportionInfo(GMRPolicyVo vo, OrderFormVo dto,Map<String, Object> map){
//		业务员代码		agentno	字符	N/A			是
		map.put("agentno","");
//		分配比例		commissionProportionRate	字符	N/A			是
		map.put("commissionProportionRate","");
	}



	//发票信息invoiceInfoMap
	private static void doInvoiceInfoMap(GMRPolicyVo vo, OrderFormVo dto,Map<String, Object> map){
//		纳税人识别码		taxIdentification	字符	N/A			否
		map.put("taxIdentification",StringUtils.isEmpty(vo.getMailPolicyVo().getTaxpayer_number_invoice()) ? "" : vo.getMailPolicyVo().getTaxpayer_number_invoice());//vo.getMailPolicyVo().getTaxpayerNumberInvoice()
//		国税登记地址		address	字符	N/A			否
		map.put("address",StringUtils.isEmpty(vo.getMailPolicyVo().getRegister_address_invoice()) ? "" : vo.getMailPolicyVo().getRegister_address_invoice());//vo.getMailPolicyVo().getTakerAddressDetail()
//		国税登记电话		phoneNo	字符	N/A			否
		map.put("phoneNo",StringUtils.isEmpty(vo.getMailPolicyVo().getReceipt_phone()) ? "" : vo.getMailPolicyVo().getReceipt_phone());
//		国税开户行		bankName	字符	N/A			否
		map.put("bankName",StringUtils.isEmpty(vo.getMailPolicyVo().getBank_invoice()) ? "" : vo.getMailPolicyVo().getBank_invoice());
//		国税开户行账号		bankNo	字符	N/A			否
		map.put("bankNo",StringUtils.isEmpty(vo.getMailPolicyVo().getBank_account_invoice()) ? "" : vo.getMailPolicyVo().getBank_account_invoice());
	}

	//被保险人信息InsuredInfo
	private static void doInsuredInfo(GMRPolicyVo vo, OrderFormVo dto,Map<String, Object> map){

//		条形码		barCode	字符	N/A			21	否
		map.put("barCode","");
//		是否清空历史		needReset	字符	N/A			1	否
		map.put("needReset","Y");
//		是否最后一批		isLastBatch	字符	N/A			1	否
		map.put("isLastBatch","Y");
//		处理方式		insuredDealType	字符	N/A			1	否
		map.put("insuredDealType","1");
//		扣款方式		deductFlag	字符	N/A			1	是
		map.put("deductFlag","");
//		被保人信息		appInsured	被保人信息List	N/A				否
		map.put("appInsured",doInsuredList(vo.getRoleSubjectList(), dto));

	}
	//被保险人信息列表insuredList
	private static  List<Map<String, Object>>  doInsuredList(List<RoleSubjectVo> roleList, OrderFormVo dto){


		List<Map<String, Object>> mapList= new ArrayList<>();
		Map<String, Object> map_app = null;

        /*String  nums[]= {"杨速,152326199901016671","钱斯蒂,152326199901018239","李东生,152326199901017535"};


        doPerson(mapList,nums);*/
//		doPerson1(mapList);
//		doPerson2(mapList);
//		doPerson3(mapList);

		for(RoleSubjectVo vo : roleList){
				if("2".equals(vo.getKind())){
					Map<String, Object>  mapInfo= Maps.newHashMap();
					//		被保险人姓名		name	字符				8	是
					mapInfo.put("name",vo.getName_cn());//+i
					//		证件类型		certificateTypeCode	证件类型				20	是
					mapInfo.put("certificateTypeCode",getCard(vo.getId_type()));//getCard(vo.getIdType())
					//		证件号码		certificateNo	证件类型				32	否
					mapInfo.put("certificateNo",vo.getOrganization_code());//vo.getOrganizationCode()
					//		性别		genderCode	字符				1	否
					mapInfo.put("genderCode","1".equals(vo.getSex()) ? "M" : "F");//vo.getSex()
					//		被保人类型		insuredTypeCode	字符				1	否
					mapInfo.put("insuredTypeCode","1");
					//		与主被关系		relationshipCode	字符				1	否
					mapInfo.put("relationshipCode","1");
					//		层级代码		gradeLevel	字符				6	否
					mapInfo.put("gradeLevel","1");
					//		出生日期		birthDate	日期	yyyy-MM-DD				否
					mapInfo.put("birthDate",vo.getBirth_date());//vo.getBirthDate()
					//		职业等级		occupationCode	字符				20	否
					mapInfo.put("occupationCode","1109009");
					//		投保日期		applyingDate	日期	yyyy-MM-DD			8	是
					mapInfo.put("applyingDate",setDates(dto.getStart_time()));
					//		生效日期		effectiveDate	日期	yyyy-MM-DD			8	是
					mapInfo.put("effectiveDate",dto.getInception_date());
					//		受益人信息		appBeneficiary	受益人信息List	N/A				是
					/*mapInfo.put("appBeneficiary","");*/
					mapList.add(mapInfo);
			}

		}

		return  mapList;

	}

	//转换日期格式
	private static String setDates(String doTime){
		String result = "";
		if(StringUtils.isNotEmpty(doTime)){
			result = DateUtil.convertDateToString(DateUtil.convertString2Date(doTime), DateUtil.FORMAT2);
		}
		return result;
	}

    private static void doPerson(List<Map<String, Object>> mapList,String [] nums) {


        for(int i=0;i<nums.length;i++){
            String idcard=nums[i].split(",")[1];
            Map<String, Object>  mapInfo= Maps.newHashMap();
            //		被保险人姓名	字符				8	是
            mapInfo.put("name", nums[i].split(",")[0]);//+i
            //		证件类型		certificateTypeCode	证件类型				20	是
            mapInfo.put("certificateTypeCode","1");//getCard(vo.getIdType()) 1
            //		证件号码		certificateNo	证件类型				32	否
            mapInfo.put("certificateNo",idcard);//vo.getOrganizationCode()
            //		性别		genderCode	字符				1	否

            mapInfo.put("genderCode",IdNumberValidator.getSexFromCard(idcard).getValue());//vo.getSex() M
            //		被保人类型		insuredTypeCode	字符				1	否
            mapInfo.put("insuredTypeCode","1");
            //		与主被关系		relationshipCode	字符				1	否
            mapInfo.put("relationshipCode","1");
            //		层级代码		gradeLevel	字符				6	否
            mapInfo.put("gradeLevel","1");
            //		出生日期		birthDate	日期	yyyy-MM-DD				否
            mapInfo.put("birthDate",DateUtil.convertDateToString(IdNumberValidator.idNumber2BirthDate(idcard),DateUtil.FORMAT2));//vo.getBirthDate()  "1991-10-12"
            //		职业等级		occupationCode	字符				20	否
            mapInfo.put("occupationCode","1109009");
            //		投保日期		applyingDate	日期	yyyy-MM-DD			8	是
            mapInfo.put("applyingDate","");
            //		生效日期		effectiveDate	日期	yyyy-MM-DD			8	是
            mapInfo.put("effectiveDate","");
            mapList.add(mapInfo);
        }


    }


	private static void doPerson1(List<Map<String, Object>> mapList) {
		Map<String, Object>  mapInfo= Maps.newHashMap();
		//		被保险人姓名		name	字符				8	是
		mapInfo.put("name","李勇强");//+i
		//		证件类型		certificateTypeCode	证件类型				20	是
		mapInfo.put("certificateTypeCode","1");//getCard(vo.getIdType())
		//		证件号码		certificateNo	证件类型				32	否
		mapInfo.put("certificateNo","350583199110124979");//vo.getOrganizationCode()
		//		性别		genderCode	字符				1	否
		mapInfo.put("genderCode","M");//vo.getSex()
		//		被保人类型		insuredTypeCode	字符				1	否
		mapInfo.put("insuredTypeCode","1");
		//		与主被关系		relationshipCode	字符				1	否
		mapInfo.put("relationshipCode","1");
		//		层级代码		gradeLevel	字符				6	否
		mapInfo.put("gradeLevel","1");
		//		出生日期		birthDate	日期	yyyy-MM-DD				否
		mapInfo.put("birthDate","1991-10-12");//vo.getBirthDate()
		//		职业等级		occupationCode	字符				20	否
		mapInfo.put("occupationCode","1109009");
		//		投保日期		applyingDate	日期	yyyy-MM-DD			8	是
		mapInfo.put("applyingDate","");
		//		生效日期		effectiveDate	日期	yyyy-MM-DD			8	是
		mapInfo.put("effectiveDate","");
		mapList.add(mapInfo);
	}

	private static void doPerson2(List<Map<String, Object>> mapList) {
		Map<String, Object>  mapInfo= Maps.newHashMap();
		//		被保险人姓名		name	字符				8	是
		mapInfo.put("name","李小欣");//+i
		//		证件类型		certificateTypeCode	证件类型				20	是
		mapInfo.put("certificateTypeCode","1");//getCard(vo.getIdType())
		//		证件号码		certificateNo	证件类型				32	否
		mapInfo.put("certificateNo","12010419990101715X");//vo.getOrganizationCode()
		//		性别		genderCode	字符				1	否
		mapInfo.put("genderCode","M");//vo.getSex()
		//		被保人类型		insuredTypeCode	字符				1	否
		mapInfo.put("insuredTypeCode","1");
		//		与主被关系		relationshipCode	字符				1	否
		mapInfo.put("relationshipCode","1");
		//		层级代码		gradeLevel	字符				6	否
		mapInfo.put("gradeLevel","1");
		//		出生日期		birthDate	日期	yyyy-MM-DD				否
		mapInfo.put("birthDate","1999-01-01");//vo.getBirthDate()
		//		职业等级		occupationCode	字符				20	否
		mapInfo.put("occupationCode","1109009");
		//		投保日期		applyingDate	日期	yyyy-MM-DD			8	是
		mapInfo.put("applyingDate","");
		//		生效日期		effectiveDate	日期	yyyy-MM-DD			8	是
		mapInfo.put("effectiveDate","");
		mapList.add(mapInfo);
	}

	private static void doPerson3(List<Map<String, Object>> mapList) {
		Map<String, Object>  mapInfo= Maps.newHashMap();
		//		被保险人姓名		name	字符				8	是
		mapInfo.put("name","李小花");//+i
		//		证件类型		certificateTypeCode	证件类型				20	是
		mapInfo.put("certificateTypeCode","1");//getCard(vo.getIdType())
		//		证件号码		certificateNo	证件类型				32	否
		mapInfo.put("certificateNo","120104199901012615");//vo.getOrganizationCode()
		//		性别		genderCode	字符				1	否
		mapInfo.put("genderCode","M");//vo.getSex()
		//		被保人类型		insuredTypeCode	字符				1	否
		mapInfo.put("insuredTypeCode","1");
		//		与主被关系		relationshipCode	字符				1	否
		mapInfo.put("relationshipCode","1");
		//		层级代码		gradeLevel	字符				6	否
		mapInfo.put("gradeLevel","1");
		//		出生日期		birthDate	日期	yyyy-MM-DD				否
		mapInfo.put("birthDate","1999-01-01");//vo.getBirthDate()
		//		职业等级		occupationCode	字符				20	否
		mapInfo.put("occupationCode","1109009");
		//		投保日期		applyingDate	日期	yyyy-MM-DD			8	是
		mapInfo.put("applyingDate","");
		//		生效日期		effectiveDate	日期	yyyy-MM-DD			8	是
		mapInfo.put("effectiveDate","");
		mapList.add(mapInfo);
	}

	//受益人信息列表beneficiaryList
	private static  List<Map<String, Object>>  dobeneficiaryList(GMRPolicyVo vo, OrderFormVo dto,Map<String, Object> map){

		List<Map<String, Object>> mapList= new ArrayList<>();
		for(int i=0;i<2;i++){
			Map<String, Object>  mapInfo= Maps.newHashMap();
//			姓名		name	字符	N/A				否
			mapInfo.put("name",vo.getFavoree());
//			受益比例		benefitRate	字符	N/A				否
			mapInfo.put("benefitRate","");
//			与被保险人关系		relationshipCode	字符	N/A				否
			mapInfo.put("relationshipCode","1");
//			性别		genderCode	字符	N/A				否
			mapInfo.put("genderCode","1");
//			生日		birthDate	日期	yyyy-MM-DD				否
			mapInfo.put("birthDate","");
//			证件类型		certificateTypeCode	字符	N/A				否
			mapInfo.put("certificateTypeCode","");
//			证件号码		certificateNo	字符	N/A				否
			mapInfo.put("certificateNo","");
//			受益顺序		benefitSeqNo	整形	N/A				否
			mapInfo.put("benefitSeqNo","");
//			联系电话		phoneNo	字符	N/A				是
			mapInfo.put("phoneNo","14759781440");
//			联系地址		address	字符	N/A				是
			mapInfo.put("address","test");
			mapList.add(mapInfo);
		}

		return  mapList;


	}



	//服务项目信息appServiceInfo

	private static void doAppServiceInfo(GMRPolicyVo vo, OrderFormVo dto,Map<String, Object> map){
//		获取保单类型		needPaperPolicy	字符	N/A			8	是
//		Y表示纸质保单，N表示电子保单
		map.put("needPaperPolicy","");
	}


	/**
	 * 组装字符串的数组
	 * @param persons
	 * @return
	 */
	private static JSONArray doCheDan(String []persons){

		JSONArray array = new JSONArray();
		for(int i=0;i<persons.length;i++){
			array.add(persons[i]);
		}

		return  array;


	}


	/**
	 *	接口返回字符串解析
	 * @return
	 */
	public static String returnAnalysisJson(String json, String  transType){
		String result = ConstProp.BLANK_CHAR;
		Map<String, Object> map = JSON.parseObject(json,Map.class);
		if(map != null&&map.get("ret") != null&&map.get("ret").toString().startsWith("130")){
			return "300#（APP-PA-"+map.get("ret")+"）"+map.get("msg");
		}
		Map<String, Object> headerMap = JSON.parseObject( map.get("header").toString(),Map.class);
		Map<String, Object> header = JSONUtils.getUpperMap(headerMap);
		if(transType.equals(ConstProp.DIGIT_ONE)){//核保
			result = analysisHB(map, header);
		}
		if(transType.equals(ConstProp.DIGIT_FIVE)){//承保   返回值
			result = analysisCB(result, map, header);
		}
		if(transType.equals(ConstProp.DIGIT_SIX)){//电子保单  返回值
			//{"header":{"transactionCode":"TCEGISNBUUW001","partnerId":"PCXM001","requestId":"1494330839657","code":"CERROR_0002","message":"data:[bankTradeNo], value:[null]is required!data:[tranCode], value:[null]is required!data:[rcptno], value:[null]is required!data:[bankTranDate], value:[null]is required!data:[bankTranTime], value:[null]is required!data:[bankNo], value:[null]is required!data:[bankTranChnl], value:[null]is required!"},"body":null}
			result = analysisDZBD(result, map, header);
		}
		if(transType.equals(ConstProp.DIGIT_FOUR)){//撤单  返回值
			//{"header":{"transactionCode":"TCEGISNBUUW001","partnerId":"PCXM001","requestId":"1494330839657","code":"CERROR_0002","message":"data:[bankTradeNo], value:[null]is required!data:[tranCode], value:[null]is required!data:[rcptno], value:[null]is required!data:[bankTranDate], value:[null]is required!data:[bankTranTime], value:[null]is required!data:[bankNo], value:[null]is required!data:[bankTranChnl], value:[null]is required!"},"body":null}
//			try{
//				if(header.get("CODE").equals("CRIGHT_0000")){
//					//返回成功
//					if(map.get("body") != null){
//						Map<String, Object> bodyMap = JSON.parseObject( map.get("body").toString(),Map.class);
//						Map<String, Object> body = JSONUtils.getUpperMap(bodyMap);;
//						String resultFlag=body.get("RESULTFLAG").toString();
//						String  errorMessage=body.get("ERRORMESSAGE").toString();//保费
//						if(resultFlag.equals("0")){
//
//						}
//					}
//				}else{
//					//返回失败
//					if(header.get("MESSAGE") != null){
//						Map<String, Object> message = JSON.parseObject(header.get("MESSAGE").toString(),Map.class);
//						String msg=message.get("RESPONSEMSG").toString();
//						result="300#（APP-PA-012）"+msg;
//					}else{
//						result="300#（APP-PA-012.1）撤单失败";
//					}
//				}
//			}catch(Exception e){
//				e.printStackTrace();
//				result="300#（APP-PA-009.3）异常错误";
//			}
		}

		return result;
	}

	/**
	 * <b> 电子保单返回报文解析 </b>
	 * @author ZXF
	 * @create 2020/09/27 0027 11:30
	 * @version
	 * @注意事项 </b>
	 */
	private static String analysisDZBD(String result, Map<String, Object> map, Map<String, Object> header) {
		try{
            if(!header.get("CODE").equals("CRIGHT_0000")){
				//返回失败
				if(header.get("MESSAGE") != null){
					return "300#（APP-PA-012）"+header.get("MESSAGE").toString();
				}else{
					return "300#（APP-PA-012.1）电子保单获取失败";
				}
			}
			//返回成功
			if(map.get("body") == null){
				return result;
			}
			Map<String, Object> bodyMap = JSON.parseObject( map.get("body").toString(),Map.class);
			Map<String, Object> body = JSONUtils.getUpperMap(bodyMap);;
			if(body.get("FILEID") == null){
				return "300#（APP-PA-011）"+body.get("RETURNMSG").toString();
			}
			String policyUrl = body.get("FILEID").toString();
			String fileUrl = "";
			if(StringUtils.isEmpty(policyUrl)){
				return "300#（APP-PA-014.2）电子保单fileId获取失败";
			}
			FileDownload fd = new FileDownload();
			fileUrl = fd.getFileAddress(policyUrl);
			if(StringUtils.isNotEmpty(fileUrl)){
				return "200#"+ GlobalResources.WEB_PRO_URL+fileUrl;
			}else{
				return "300#（APP-PA-014.1）电子保单转码失败";
			}
        }catch(Exception e){
            e.printStackTrace();
            result="300#（APP-PA-009.3）异常错误";
        }
		return result;
	}

	/**
	 * <b> 承保返回报文解析 </b>
	 * @author ZXF
	 * @create 2020/09/27 0027 11:30
	 * @version
	 * @注意事项 </b>
	 */
	private static String analysisCB(String result, Map<String, Object> map, Map<String, Object> header) {
		try{
            if(!header.get("CODE").equals("CRIGHT_0000")){
				//返回失败
				if(header.get("body") == null){
					String msg=header.get("MESSAGE").toString();
					return "300#（APP-PA-010）"+msg;
				}
				if(header.get("MESSAGE") != null){
					Map<String, Object> message = JSON.parseObject(header.get("MESSAGE").toString(),Map.class);
					String msg=message.get("RESPONSEMSG").toString();
					return "300#（APP-PA-010）"+msg;
				}else{
					return "300#（APP-PA-010.1）承保失败";
				}
			}
			//返回成功
			if(map.get("body") == null){
				return result;
			}
			Map<String, Object> bodyMap = JSON.parseObject( map.get("body").toString(),Map.class);
			Map<String, Object> body = JSONUtils.getUpperMap(bodyMap);
			String returnFlag=body.get("RETURNFLAG").toString();
			if(returnFlag.equals("0")){
				String p_policy_no=body.get("P_POLICY_NO").toString();
				return "200#"+p_policy_no;
			}else{
				String  returnMsg=body.get("RETURNMSG").toString();
				return "300#（APP-PA-010）"+returnMsg;
			}
        }catch(Exception e){
            e.printStackTrace();
            result="300#（APP-PA-009.2）异常错误";
        }
		return result;
	}

	/**
	 * <b> 核保返回报文解析 </b>
	 * @author ZXF
	 * @create 2020/09/27 0027 11:30
	 * @version
	 * @注意事项 </b>
	 */
	private static String analysisHB(Map<String, Object> map, Map<String, Object> header) {
		String result;
		try{
            if(!header.get("CODE").equals("CRIGHT_0000")){
				//返回失败
				if(header.get("body") == null && header.get("MESSAGE") != null){
					return "300#（APP-PA-008）"+header.get("MESSAGE").toString();
				}else if(header.get("body") == null && header.get("MESSAGE") == null){
					return "300#（APP-PA-007）数据处理过程出现异常！";
				}
				Map<String, Object> bodyMap = JSON.parseObject( map.get("body").toString(),Map.class);
				Map<String, Object> body = JSONUtils.getUpperMap(bodyMap);
				String msg= ConstProp.BLANK_CHAR;
				if(body.get("RESPONSEMSG") != null){
					msg=body.get("RESPONSEMSG").toString();
				}
				return "300#（APP-PA-006）"+msg;
			}
			//返回成功
			if(map.get("body") == null){
				return "300#（APP-PA-005）数据处理异常！";
			}
			Map<String, Object> bodyMap = JSON.parseObject( map.get("body").toString(),Map.class);
			Map<String, Object> body = JSONUtils.getUpperMap(bodyMap);
			if(body.get("RETURNFLAG") == null){
				return "300#（APP-PA-004）数据处理异常！";
			}
			if(ConstProp.DIGIT_ONE.equals(body.get("RETURNFLAG").toString())){
				String receiptNo=body.get("RECEIPTNO").toString();
				String  totalPremium=body.get("TOTALPREMIUM").toString();//保费
				logger.info("200#"+receiptNo+ConstProp.POUND_SIGN+totalPremium+ConstProp.POUND_SIGN+"http://www.baidu.com");
				return "200#"+receiptNo+ConstProp.POUND_SIGN+totalPremium;
			}
			String msg= ConstProp.BLANK_CHAR;
			if(body.get("RESPONSEMSG") != null){
				msg=body.get("RESPONSEMSG").toString();
			}
			return "300#（APP-PA-003）"+msg;
        }catch(Exception e){
            e.printStackTrace();
            result="300#（APP-PA-009.1）异常错误";
        }
		return result;
	}

	private static String getDate(String doTime,int status){
		String result = "";
		if(StringUtils.isEmpty(doTime)){
			return result;
		}
		try {
			if(status == 0){//常规转换
				result = DateUtil.convertDateToString(DateUtil.parseDate(doTime),DateUtil.FORMAT2);
			}else if(status == 1){//+ 00:00:00
				result = DateUtil.convertDateToString(DateUtil.parseDate(doTime),DateUtil.FORMAT2);
				if(StringUtils.isNotEmpty(result)){
					result = result + ConstProp.DAY_00;
				}
			}else if(status == 2){//+ 23:59:59
				Date beT = DateUtil.parseDate(doTime);
				Calendar cDate = Calendar.getInstance();
				cDate.setTime(beT);
				cDate.set(Calendar.DATE, cDate.get(Calendar.DATE) - 1);
				result = DateUtil.convertDateToString(beT,DateUtil.FORMAT2);
				if(StringUtils.isNotEmpty(result)){
					result = result + ConstProp.DAY_23;
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return result;
	}

	/**
	 * 根据我们的证件类型获取平安的证件类型
	 * @param cardType
	 * @return
	 */
	private static String getCard(String cardType){

		// 投保人 1-组织结构代码证,2-税务登记证,3-营业执照,99-其他
//		   被保人  证件类型，当证件类型为“01-居民身份证”时，校验长度为15位或18位，18位可带大写X或者小写x；
//				当证件类型为“02-护照”时，校验证件号2-20个字符；
//				当证件类型为“03-军人证”时，校验证件号为3-5个汉字+6-12个数字；
//				当证件类型为“05-港澳台同胞证”时，校验8-20个字符
//平安的 身份证表
//1	身份证
//2	护照
//3	军人证
//4	少儿证
//5	台胞证
//6	港澳台通行证
//8	转换不详　
//9	其他
//A	出生证
//L	户口本
		if ( "0".equals(cardType) ) {
			return "1";
		}else if ("3".equals(cardType)) {
			return "2";
		}else if ("4".equals(cardType)) {
			return "5";
		}else {
			return "9";
		}
	}

	/**
	 * 我们的性别获取平安的性别
	 * @param sex
	 * @return
	 */
	private  static  String  getSex(int sex){
//		M	男
//		F	女
//		9	未
		if(sex==1){
			return "M";
		}else if(sex==2){
			return "F";
		}else{
			return "9";
		}

	}

	/**被保人类型
	 * @param type
	 * @return
	 */
	private  static  String  getInsuredType(int type){
//			被保人类型代码	被保人类型	厦门代码
//		1	主被保人
//		2	连带被保人
//		9	其他被保人
//		3	投保人
//		4	投保及被保人
		return  "";

	}


	/**
	 *
	 * 主被保险人
	 * @param type
	 * @return
	 */
	private  static  String  getPrincipalInsured(int type){
//		1	主被保险人
//		2	配偶
//		3	子女
//		4	父母
//		5	雇佣
//		6	其他
		return  "";

	}

	/**
	 *
	 * 缴别机表
	 * @param type
	 * @return
	 */
	private  static  String  getPayType(int type){
//		1	趸缴
//		2	月缴
//		3	季缴
//		4	半年缴
//		5	年缴
//		6	趸缴累加
		return  "";

	}


	/**
	 * 撤件理由代码
	 * @param type
	 * @return
	 */
	private  static  String  getReasonsWithdrawal(int type){
		//Reasons for withdrawal
//		撤件理由代码	撤件理由	厦门代码
//		1	客户申请
//		2	保费逾期未缴纳
//		3	问题件逾期未反馈
//		4	内部处理
		return  "";

	}

	private static String getCityCodeByPro(String pro,String city){
		if("110000".equals(pro)){
			return pro;
		}else if("120000".equals(pro)){
			return pro;
		}else if("500000".equals(pro)){
			return pro;
		}else if("310000".equals(pro)){
			return pro;
		}else if("710000".equals(pro)){
			return pro;
		}else if("810000".equals(pro)){
			return pro;
		}else if("820000".equals(pro)){
			return pro;
		}else{
			return city;
		}
	}








	public static void main(String[] args){
		/*PolicyDto dto = exportsPolicyService.accordingToOrderIDToGetPolicyDto(Long.parseLong("847994294684696576"));
		GMRPolicyVo vo = policyCommonService.findGMRPolicyVoById(dto.getOid());
		marshal(vo, dto, "01");*/
//		try{
//			logger.info(marshal(null, null, "1"));//投保
//			logger.info(marshal(null, null, "2"));//承保
//		}catch (Exception ex){
//			ex.printStackTrace();
//		}

//		doResultTouBao();
		doResultCheDan();

	}

	private static void doResultCheDan() {
		//        String  resultMsg= "{\"header\":{\"transactionCode\":\"TCEGISNBUAPC001\",\"partnerId\":\"PCXM001\",\"requestId\":\"1493874890537\",\"code\":\"NBUERROR_0008\",\"message\":\"{\\\"ReturnFlag\\\":1,\\\"ResponseMsg\\\":\\\"系统生成保益保费之和510元与总单保费390元不符;\\\"}\"},\"body\":null}";
		String   resultMsg="{\"header\":{\"transactionCode\":\"TCEGISNBUWD001\",\"partnerId\":\"PCXM001\",\"requestId\":\"1493865755617\",\"code\":\"CRIGHT_0000\",\"message\":null},\"body\":\"\\\"{\\\\\\\"errorMessage\\\\\\\":\\\\\\\"fail\\\\\\\",\\\\\\\"rcptnoList\\\\\\\":[{\\\\\\\"message\\\\\\\":\\\\\\\"条形码9041K009837424的业务状态不允许进行撤件\\\\\\\",\\\\\\\"no\\\\\\\":\\\\\\\"30000070075776495\\\\\\\"}],\\\\\\\"resultFlag\\\\\\\":\\\\\\\"-1\\\\\\\"}\\\"\"}";
		Map<String, Object> map = null;
		try{
			map = JSON.parseObject(resultMsg,Map.class);
			Map<String, Object> header = JSON.parseObject( map.get("header").toString(),Map.class);
			if(!header.get("code").equals("CRIGHT_0000")){
				logger.info("300#撤单失败");
				return;
			}
			//返回成功
			String  bodyStr= map.get("body").toString();
			bodyStr=bodyStr.replaceFirst("\"","");
			bodyStr=bodyStr.substring(ConstProp.INT_NUMBER_ZERO,bodyStr.lastIndexOf('"'));
			bodyStr = bodyStr.replace("\\", "");
			Map<String, Object> body = JSON.parseObject(bodyStr,Map.class);
			if(body.get("resultFlag").toString().equals(ConstProp.DIGIT_ZERO)){
				String errorMessage=body.get("errorMessage").toString();
				logger.info("200#"+errorMessage);
			}else{
			   JSONArray array= JSON.parseArray(body.get("rcptnoList").toString());
				String  result =ConstProp.BLANK_CHAR;
				for(int i=ConstProp.INT_NUMBER_ZERO;i<array.size();i++){
					com.alibaba.fastjson.JSONObject object = (com.alibaba.fastjson.JSONObject) array.get(i);
					result=result+ConstProp.POUND_SIGN+object.get("message")+ConstProp.POUND_SIGN+object.get("no");
				}
				String   errorMessage =body.get("resultFlag").toString();
				logger.info("300"+result);
			}
		}catch(Exception e){
			e.printStackTrace();
		}
 	}

	private static void doResultTouBao() {
		//        String  resultMsg= "{\"header\":{\"transactionCode\":\"TCEGISNBUAPC001\",\"partnerId\":\"PCXM001\",\"requestId\":\"1493874890537\",\"code\":\"NBUERROR_0008\",\"message\":\"{\\\"ReturnFlag\\\":1,\\\"ResponseMsg\\\":\\\"系统生成保益保费之和510元与总单保费390元不符;\\\"}\"},\"body\":null}";
		String   resultMsg="{\"header\":{\"transactionCode\":\"TCEGISNBUAPC001\",\"partnerId\":\"PCXM001\",\"requestId\":\"1493866040327\",\"code\":\"CRIGHT_0000\",\"message\":null},\"body\":\"{\\\"barCode\\\":\\\"9041K009837633\\\",\\\"receiptNo\\\":\\\"30000070075777063\\\",\\\"responseMsg\\\":\\\"AMESB接口InsuredAMESBService调用成功！\\\",\\\"returnFlag\\\":\\\"1\\\",\\\"totalPremium\\\":\\\"510\\\"}\"}";
		Map<String, Object> map = null;
		try{
            map = JSON.parseObject(resultMsg,Map.class);
            Map<String, Object> header = JSON.parseObject( map.get("header").toString(),Map.class);
            if(header.get("code").equals("CRIGHT_0000")){
                //返回成功
                Map<String, Object> body = JSON.parseObject( map.get("body").toString(),Map.class);
                String receiptNo=body.get("receiptNo").toString();
                String  totalPremium=body.get("totalPremium").toString();//保费
                logger.info("200#"+receiptNo+ConstProp.POUND_SIGN+totalPremium+ConstProp.POUND_SIGN+"http://www.baidu.com");
            }else{
                //返回失败
                Map<String, Object> message = JSON.parseObject(header.get("message").toString(),Map.class);
                String msg=message.get("ResponseMsg").toString();
                logger.info("300#"+msg);
            }
        }catch(Exception e){

        }
	}
}
