package com.bcxin.ins.third.gzzrx.zhonghua.security;

import com.bcxin.ins.vo.ConstProp;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Iterator;

/**
 * <b> 中华线下承保回调接口报文信息转换辅助表 </b>
 * @author ZXF
 * @create 2019/10/31 0031 10:17
 * @version
 * @注意事项 </b>
 */
public class ZHOfflineSendInfoVo {

	private static Logger logger = LoggerFactory.getLogger(ZHOfflineSendInfoVo.class);

	protected Document requestDocument;
	protected Element rootElement;

	private String transrno;//交易码
	private String serialnumber;//交易流水号
	private String transrdate;//交易时间
	private String amount;//总保额
	private String premium;//总保费
	private String status;//保单状态
	private String appno;//投保单号
	private String polno;//保单号
	private String eurl;//电子保单下载URL

	public String getTransrno() {
		return transrno;
	}

	public void setTransrno(String transrno) {
		this.transrno = transrno;
	}

	public String getSerialnumber() {
		return serialnumber;
	}

	public void setSerialnumber(String serialnumber) {
		this.serialnumber = serialnumber;
	}

	public String getTransrdate() {
		return transrdate;
	}

	public void setTransrdate(String transrdate) {
		this.transrdate = transrdate;
	}

	public String getAmount() {
		return amount;
	}

	public void setAmount(String amount) {
		this.amount = amount;
	}

	public String getPremium() {
		return premium;
	}

	public void setPremium(String premium) {
		this.premium = premium;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getAppno() {
		return appno;
	}

	public void setAppno(String appno) {
		this.appno = appno;
	}

	public String getPolno() {
		return polno;
	}

	public void setPolno(String polno) {
		this.polno = polno;
	}

	public String getEurl() {
		return eurl;
	}

	public void setEurl(String eurl) {
		this.eurl = eurl;
	}

	/**
	 * 对请求的报文解析
	 * @param originalXML
	 */
	public void analysisXML(String originalXML) {
		try {
			requestDocument = DocumentHelper.parseText(originalXML);
			rootElement = requestDocument.getRootElement();
			for(Iterator i = rootElement.elementIterator(); i.hasNext();){
				Element node = (Element) i.next();
				if("MAIN".equals(node.getName())){
					for(Iterator n = node.elementIterator(); n.hasNext();) {
						Element node_n = (Element) n.next();
						if ("TRANSRNO".equals(node_n.getName())) {
							this.setTransrno(node_n.getText());
						}
						if ("SERIALNUMBER".equals(node_n.getName())) {
							this.setSerialnumber(node_n.getText());
						}
						if ("TRANSRDATE".equals(node_n.getName())) {
							this.setTransrdate(node_n.getText());
						}
					}
				}
				if(!"BODY".equals(node.getName())){
					continue;
				}
				for(Iterator n = node.elementIterator(); n.hasNext();){
					Element node_n = (Element) n.next();
					if(!"BODY_LIST".equals(node_n.getName())){
						continue;
					}
					for(Iterator o = node_n.elementIterator(); o.hasNext();){
						Element node_o = (Element) o.next();
						String name = node_o.getName();
						String value = node_o.getText();
						if(StringUtils.isNotEmpty(value)){
							value = value.replace("<![CDATA[",ConstProp.BLANK_CHAR).replace("]]>",ConstProp.BLANK_CHAR);
						}
						if("APPNO".equals(name)){
							this.setAppno(value);
						}
						if("POLNO".equals(name)){
							this.setPolno(value);
						}
						if("EURL".equals(name)){
							this.setEurl(value);
						}
						if("AMOUNT".equals(name)){
							this.setAmount(value);
						}
						if("PREMIUM".equals(name)){
							if(StringUtils.isNotEmpty(value)){
								value = value.replace(",","");
							}
							this.setPremium(value);
						}
						if("STATUS".equals(name)){
							this.setStatus(value);
						}
					}
				}
			}
		}catch (Exception e){
			logger.info("analysisXML:"+e.getMessage());
			e.printStackTrace();
		}
	}

	/**
	 * <b> 返回接收结果 </b>
	 * @author ZXF
	 * @create 2019/02/22 0022 13:48
	 * @version
	 * @注意事项 </b>
	 */
	public String returnResult(String resultcode, String errinfo){
		String result = "<?xml version=\"1.0\" encoding=\"GBK\"?>\n" +
				"<INSUREQRET>\n" +
				"\t<MAIN>\n" +
				"\t\t<TRANSRNO>2017</TRANSRNO>\n" +
				"\t\t<RESULTCODE>"+resultcode+"</RESULTCODE>\n" +
				"\t\t<ERRINFO>"+errinfo+"</ERRINFO>\n" +
				"\t</MAIN>\n" +
				"</INSUREQRET>";
		return result;
	}

}
