package com.bcxin.ins.third.gzzrx.renbao;

import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.third.gzzrx.renbao.util.Md5Util;
import com.bcxin.ins.util.*;
import com.bcxin.ins.vo.*;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import com.xiaoleilu.hutool.http.HttpUtil;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.*;

/**
 * <b> 人保-雇主责任险各接口请求数据组装 </b>
 * @author ZXF
 * @create 2018/05/24 0024 9:50
 * @version
 * @注意事项 </b>
 */
public class GZZRX_PackageMessageRenBao {
	protected Document requestDocument;
	protected Element rootElement;

	void GZZRX_PackageMessageRenBao(){

	}

	private static Logger logger = LoggerFactory.getLogger(GZZRX_PackageMessageRenBao.class);

	public static void main(String[] args) {
		System.out.println(getPdh("DEAC201935020000012636"));
//		String payPath = "投保单TZBV201935020000012325自动核保通过，需见费转保单!交费通知单号为：3502190619900857,微信交费链接为：<![CDATA[weixin://wxpay/bizpayurl?pr=RNwxq9r]]>";
//		payPath = payPath
//				.replace("<![CDATA[",ConstProp.BLANK_CHAR).replace("]]>",ConstProp.BLANK_CHAR)
//				.replace("&lt;![CDATA[",ConstProp.BLANK_CHAR).replace("]]&gt;",ConstProp.BLANK_CHAR);
//		System.out.println(payPath);
//		String a = "<ReturnInfo>\n" +
//				"  <responsehead>\n" +
//				"    <uuid>d1d0feca-7c13-42c7-b5a6-20d45dd987e6</uuid>\n" +
//				"    <timestamp>2018-08-02 14:28:45</timestamp>\n" +
//				"    <request__type>01020233</request__type>\n" +
//				"    <response__code>1</response__code>\n" +
//				"    <server__version>00000000</server__version>\n" +
//				"    <sender>0102</sender>\n" +
//				"    <error__message></error__message>\n" +
//				"  </responsehead>\n" +
//				"  <policyInfoReturns>\n" +
//				"    <PolicyInfoReturn>\n" +
//				"      <serialNo>1</serialNo>\n" +
//				"      <proposalNo>DZBV201835020000003720</proposalNo>\n" +
//				"      <result>1</result>\n" +
//				"      <message>批单申请号为DZBV201835020000003720自动核批成功,批单号为：EZBV201835020000003569</message>\n" +
//				"      <chgSumPremium>-66.00</chgSumPremium>\n" +
//				"    </PolicyInfoReturn>\n" +
//				"  </policyInfoReturns>\n" +
//				"</ReturnInfo>";
		/*GZZRX_PackageMessageRenBao go = new GZZRX_PackageMessageRenBao();
		System.out.println(go.getRBPDResult(a));;*/
//		String r = "批单申请号为DZBV201835020000003720自动核批成功,批单号为：EZBV201835020000003569";
//		System.out.println(r.split("：")[1]);
		/*String result = "200#TZBV201835020000000673#投保单TZBV201835020000000673自动核保通过，需见费转保单!交费通知单号为：3502180531900004,微信交费链接为：weixin://wxpay/bizpayurl?pr=nr798xV";
		String[] strs = result.split("#");
		String payNo = strs[2].split(",")[0].split("：")[1];
		String payPath = strs[2].split(",")[1].split("：")[1];
		System.out.println("payNo:"+payNo+",payPath:"+payPath);*/
//		String ph = "http://47.98.105.202:9003/api/downloadPolicy?policyNo=5CC38E3460C38DC392C3A74E151CC2AAC2BC0071C38AC3954EC29FC3B41354C3BC03C3AF3F0EC2932C7D75C29DC398&group=0";
//		String pno = "";
//		unloading_bd(pno, ph);
//		test1();
//		System.out.println(System.getProperty("catalina.base"));
//		String a = "批单申请号为DZBV201835020000001871自动核批成功,批单号为：EZBV201835020000001785";
//		System.out.println(a.split(",")[1].split("：")[1]);
		/*GZZRX_PackageMessageRenBao g = new GZZRX_PackageMessageRenBao();
		String a = "<ReturnInfo>\n" +
				"<responsehead>\n" +
				"    <uuid>bc764b51-118b-44cf-ae28-812b9a221926</uuid>\n" +
				"    <timestamp>2018-07-12 15:41:58</timestamp>\n" +
				"    <request_type>01020233</request_type>\n" +
				"    <response_code>1</response_code>\n" +
				"    <server_version>00000000</server_version>\n" +
				"    <sender>0102</sender>\n" +
				"    <error_message></error_message>\n" +
				"  </responsehead>\n" +
				"  <policyInfoReturns>\n" +
				"    <PolicyInfoReturn>\n" +
				"      <serialNo>1</serialNo>\n" +
				"      <proposalNo></proposalNo>\n" +
				"      <result>2</result>\n" +
				"      <message>批改生效时间早于当前时间，无法进行批改！</message>\n" +
				"    </PolicyInfoReturn>\n" +
				"  </policyInfoReturns>\n" +
				"</ReturnInfo>";
		String b = g.getRBPDResult(a);
		System.out.println(b);*/
	}

	public static String test1(){
		SpecialHirelingVo vo = new SpecialHirelingVo();
		vo.setDispute("1");
		vo.setInsured_amount("300000");
		vo.setPremium("2100");
		List<RoleSubjectVo> roleSubjectList = new ArrayList<RoleSubjectVo>();
		for(int i=0;i<2;i++){
			RoleSubjectVo rvo = new RoleSubjectVo();
			rvo.setName_cn("毒贩夫妇鼓捣鼓捣");
			rvo.setId_type("01");
			rvo.setOrganization_code("12345678-9");
			rvo.setLink_email("3840@qq.com");
			rvo.setLink_tel("18965192886");
			roleSubjectList.add(rvo);
		}
		List<HirelingVo> hirelingVoList = new ArrayList<HirelingVo>();
		for(int i=0;i<3;i++){
			HirelingVo hvo = new HirelingVo();
			hvo.setName("水电费");
			hvo.setId_type("01");
			hvo.setId_card("350625192212345612");
			hvo.setSex("1");
			hvo.setAge("22");
			hirelingVoList.add(hvo);
		}
		vo.setRoleSubjectList(roleSubjectList);
		vo.setHirelingVoList(hirelingVoList);
		OrderFormVo dto = new OrderFormVo();
		dto.setStart_time("2018-06-13 15:31:10");
		dto.setInception_date("2018-06-15");
		dto.setPlanned_end_date("2019-06-14");
		dto.setTrade_serial_number("887143801477525504");
		dto.setInsured_amount("300000");
		dto.setGross_premium("3000");

		dto.setExternal_reference("40088652");
		dto.setProduct_code("GZZRX-RB-1");

		InsPreservationRecordVo iprVo = new InsPreservationRecordVo();
		iprVo.setStart_time("2017-02-22");
		iprVo.setInception_date("2017-02-22");
		iprVo.setTotal_premium("50000");
		iprVo.setRevise_type("1");

		List<InsPreservationDetailVo> list = Lists.newArrayList();
		for(int i=0;i<3;i++){
			InsPreservationDetailVo ipdVo = new InsPreservationDetailVo();
			ipdVo.setName("哈哈哈");
			ipdVo.setSex("2");
			ipdVo.setId_card("350582199601313524");
			ipdVo.setId_type("4");
			list.add(ipdVo);
		}
		iprVo.setInsPreservationDetailVoList(list);

		String result = marshal(null, dto, "2", iprVo);
		System.out.println(result);
		return result;
	}
	private static String setMd5Value(String jsonData) throws Exception {
		Document doc = DocumentHelper.parseText(jsonData);
		Element rootElt = doc.getRootElement(); // 获取根节点
		Element generalInfo = rootElt.element("GeneralInfo");//获取GeneralInfo节点
		String uuid = generalInfo.elementText("UUID");//获取UUID节点
		String policyInfos=jsonData.substring(jsonData.indexOf("<PolicyInfo>"),jsonData.indexOf("</PolicyInfos>"));//获取两个节点间的内容
		policyInfos = policyInfos.replaceAll ("\\r\\n", "").replaceAll(" ","").replaceAll ("\\n", "");//替换字符串
		String salt =  uuid.substring(uuid.length()-8,uuid.length());//uuid从第九位开始到结束
		String key="$ohr619LVb6IrwG";
		//第一次加密
		String  MD5Dense = Md5Util.digestByMd5(policyInfos,key);//data = policyInfos+$ohr619LVb6IrwG
		//第二次加密
		String MD5salt = Md5Util.digestByMd5( MD5Dense,salt);//data = (policyInfos+$ohr619LVb6IrwG)+uuid从第九位开始到结束
		System.out.println("MD5salt:"+MD5salt);
		String value =jsonData.substring(jsonData.indexOf("<Md5Value>")+10,jsonData.indexOf("</Md5Value>"));//indexOf找到<Md5Value>之后，substring会将<Md5Value>一起截取进去，所以‘+10’是为了从<Md5Value>后面开始截取
		String result = jsonData.replace(value, MD5salt);//替换
		System.out.println("result:"+result);
		return result;
	}

	/**
	 * 核保数据组装
	 * @param vo 投保详细信息
	 * @param dto 订单基本信息
	 * @param transType 接口类型
	 * @param iprVo 保全申请单
	 * @return
	 */
	public static String marshal(SpecialHirelingVo vo, OrderFormVo dto, String transType, InsPreservationRecordVo iprVo){
		String result = ConstProp.BLANK_CHAR;
		Document requestDocument = DocumentHelper.createDocument();
		requestDocument.setXMLEncoding("GBK");//设置该XML文件的Encoding = "GBK"
		Element apply_info_element = requestDocument.addElement("ApplyInfo");
		try {
			if(TransTypeEnum.HB.getValue().equals(transType)){//核保
				//头
				Element general_info_element = apply_info_element.addElement("GeneralInfo");
				head(general_info_element, dto);
				//内容列
				Element policy_infos_element = apply_info_element.addElement("PolicyInfos");
				//内容
				Element policy_info_element = policy_infos_element.addElement("PolicyInfo");
				policyInfo(policy_info_element, vo, dto);

				//方案代码
				Element ration_plan_element = policy_info_element.addElement("RationPlan");
				rationPlan(ration_plan_element, dto);
				int pNum = vo.getHirelingVoList().size();
				//计划
				Element schemes_element = policy_info_element.addElement("Schemes");
				scheme(schemes_element, vo, dto, pNum);
				//保障
				Element itemkind_limits_element = policy_info_element.addElement("ItemkindLimits");
				itemkindLimits(itemkind_limits_element, dto);
				//保障
				Element prp_cengages_element = policy_info_element.addElement("prpCengages");
				prpCengages(prp_cengages_element, vo, dto);
				//投保人
				Element applicant_element = policy_info_element.addElement("Applicant");
				applicant(applicant_element, vo.getRoleSubjectList().get(0));
				//被保险人
				Element insureds_element = policy_info_element.addElement("Insureds");
				Element insured_element = insureds_element.addElement("Insured");
				insured(insured_element, vo.getRoleSubjectList().get(1));
				//雇员
				Element employees_element = policy_info_element.addElement("Employees");
				employees(employees_element, vo.getHirelingVoList(), vo.getRoleSubjectList().get(0));
				//扩展
				Element extend_infos_element = policy_info_element.addElement("ExtendInfos");
				Element exend_info_element = extend_infos_element.addElement("ExendInfo");
				exendInfo(exend_info_element, vo.getHirelingVoList().size());

				result = setMd5Value(requestDocument.asXML());
			}else if(TransTypeEnum.PD.getValue().equals(transType)){//批单
				//头
				Element request_head_element = apply_info_element.addElement("requesthead");
				request_head(request_head_element, dto);
				//内容列
				Element policy_infos_element = apply_info_element.addElement("policyInfos");
				//内容
				Element policy_info_element = policy_infos_element.addElement("PolicyInfo");
				policy_info(policy_info_element, iprVo, dto);
				//自定义报文列
				Element prp_ptexts_element = policy_info_element.addElement("prpPtexts");
				//自定义报文
				Element prp_ptext_element = prp_ptexts_element.addElement("PrpPtext");
				prp_ptext(prp_ptext_element, iprVo, dto);
				//雇员信息批改
				Element prp_cnames_element = policy_info_element.addElement("prpCnames");
				prp_cname(prp_cnames_element, iprVo, dto);
				result = requestDocument.asXML();
			}else if(TransTypeEnum.ZFDZ.getValue().equals(transType)){//获取支付地址
				//头
				Element general_info_element = apply_info_element.addElement("GeneralInfo");
				head(general_info_element, dto);
				//内容列
				Element policy_infos_element = apply_info_element.addElement("PolicyInfos");
				//内容
				Element policy_info_element = policy_infos_element.addElement("PolicyInfo");
				//投保单号
				policy_info_element.addElement("ProposalNo").setText(dto.getPolicy_serial_number());
				//支付方式 微信
				policy_info_element.addElement("PayType").setText("6");
				//保费
				policy_info_element.addElement("PayPremium").setText(dto.getGross_premium());
				result = setMd5Value(requestDocument.asXML());
			}
//			logger.info("人保接口报文数据组装--getHBOrder："+result);
		}catch (Exception e){
			e.printStackTrace();
		}
		return result;
	}

	//头信息
	private static void head(Element underwrite, OrderFormVo dto) {
		//该值用于报文数据设置后替换成加密后的字符串，这里不能没有值且保证值在报文中唯一，否则之后的替换会出错
		underwrite.addElement("Md5Value").setText("74e3e47a31e0b1de3f0484fd67f931dd");
		//公司名称缩写（拼音或英文）+流水号
		underwrite.addElement("PlateformCode").setText("ECP00008");
		//报文唯一性约束（长度别超过32位，各位开发人员添加uuid密等校验
		underwrite.addElement("UUID").setText(UUID.randomUUID().toString());

	}

	//方案信息
	private static void rationPlan(Element underwrite, OrderFormVo dto) {
		//
		underwrite.addElement("RationType").setText("ZBV0000001");
	}

	//计划信息
	private static void scheme(Element underwrite, SpecialHirelingVo vo, OrderFormVo dto, int pNum) {
		boolean icr = "1".equals(vo.getIs_contain_repo());//是否含三者
		if(dto.getProduct_code().contains("-1")){
			Element scheme_element_1 = underwrite.addElement("Scheme");
			scheme_element_1.addElement("serialNo").setText("1");
			scheme_element_1.addElement("SchemeAmount").setText(String.valueOf((new BigDecimal("300000")).multiply(new BigDecimal(String.valueOf(pNum)))));
			scheme_element_1.addElement("SchemePremium").setText(String.valueOf((new BigDecimal(icr ? "170" : "150")).multiply(new BigDecimal(String.valueOf(pNum)))));
			scheme_element_1.addElement("SchemeQuantity").setText(String.valueOf(pNum));
			scheme_element_1.addElement("SchemeWorkType").setText("999");
			Element scheme_element_2 = underwrite.addElement("Scheme");
			scheme_element_2.addElement("serialNo").setText("2");
			scheme_element_2.addElement("SchemeAmount").setText(String.valueOf((new BigDecimal("30000")).multiply(new BigDecimal(String.valueOf(pNum)))));
			scheme_element_2.addElement("SchemePremium").setText(String.valueOf((new BigDecimal(icr ? "35" : "30")).multiply(new BigDecimal(String.valueOf(pNum)))));
			scheme_element_2.addElement("SchemeQuantity").setText(String.valueOf(pNum));
			scheme_element_2.addElement("SchemeWorkType").setText("999");
		}else if(dto.getProduct_code().contains("-2")){
			Element scheme_element_1 = underwrite.addElement("Scheme");
			scheme_element_1.addElement("serialNo").setText("1");
			scheme_element_1.addElement("SchemeAmount").setText(String.valueOf((new BigDecimal("400000")).multiply(new BigDecimal(String.valueOf(pNum)))));
			scheme_element_1.addElement("SchemePremium").setText(String.valueOf((new BigDecimal(icr ? "228" : "200")).multiply(new BigDecimal(String.valueOf(pNum)))));
			scheme_element_1.addElement("SchemeQuantity").setText(String.valueOf(pNum));
			scheme_element_1.addElement("SchemeWorkType").setText("999");
			Element scheme_element_2 = underwrite.addElement("Scheme");
			scheme_element_2.addElement("serialNo").setText("2");
			scheme_element_2.addElement("SchemeAmount").setText(String.valueOf((new BigDecimal("40000")).multiply(new BigDecimal(String.valueOf(pNum)))));
			scheme_element_2.addElement("SchemePremium").setText(String.valueOf((new BigDecimal(icr ? "47" : "40")).multiply(new BigDecimal(String.valueOf(pNum)))));
			scheme_element_2.addElement("SchemeQuantity").setText(String.valueOf(pNum));
			scheme_element_2.addElement("SchemeWorkType").setText("999");
		}else if(dto.getProduct_code().contains("-3")){
			Element scheme_element_1 = underwrite.addElement("Scheme");
			scheme_element_1.addElement("serialNo").setText("1");
			scheme_element_1.addElement("SchemeAmount").setText(String.valueOf((new BigDecimal("500000")).multiply(new BigDecimal(String.valueOf(pNum)))));
			scheme_element_1.addElement("SchemePremium").setText(String.valueOf((new BigDecimal(icr ? "286" : "250")).multiply(new BigDecimal(String.valueOf(pNum)))));
			scheme_element_1.addElement("SchemeQuantity").setText(String.valueOf(pNum));
			scheme_element_1.addElement("SchemeWorkType").setText("999");
			Element scheme_element_2 = underwrite.addElement("Scheme");
			scheme_element_2.addElement("serialNo").setText("2");
			scheme_element_2.addElement("SchemeAmount").setText(String.valueOf((new BigDecimal("50000")).multiply(new BigDecimal(String.valueOf(pNum)))));
			scheme_element_2.addElement("SchemePremium").setText(String.valueOf((new BigDecimal(icr ? "59" : "50")).multiply(new BigDecimal(String.valueOf(pNum)))));
			scheme_element_2.addElement("SchemeQuantity").setText(String.valueOf(pNum));
			scheme_element_2.addElement("SchemeWorkType").setText("999");
		}else if(dto.getProduct_code().contains("-4")){
			Element scheme_element_1 = underwrite.addElement("Scheme");
			scheme_element_1.addElement("serialNo").setText("1");
			scheme_element_1.addElement("SchemeAmount").setText(String.valueOf((new BigDecimal("600000")).multiply(new BigDecimal(String.valueOf(pNum)))));
			scheme_element_1.addElement("SchemePremium").setText(String.valueOf((new BigDecimal(icr ? "340" : "300")).multiply(new BigDecimal(String.valueOf(pNum)))));
			scheme_element_1.addElement("SchemeQuantity").setText(String.valueOf(pNum));
			scheme_element_1.addElement("SchemeWorkType").setText("999");
			Element scheme_element_2 = underwrite.addElement("Scheme");
			scheme_element_2.addElement("serialNo").setText("2");
			scheme_element_2.addElement("SchemeAmount").setText(String.valueOf((new BigDecimal("60000")).multiply(new BigDecimal(String.valueOf(pNum)))));
			scheme_element_2.addElement("SchemePremium").setText(String.valueOf((new BigDecimal(icr ? "65" : "50")).multiply(new BigDecimal(String.valueOf(pNum)))));
			scheme_element_2.addElement("SchemeQuantity").setText(String.valueOf(pNum));
			scheme_element_2.addElement("SchemeWorkType").setText("999");
		}
	}

	//保障信息
	private static void itemkindLimits(Element underwrite, OrderFormVo dto) {
		if(dto.getProduct_code().contains("-1")){
			Element element_0 = underwrite.addElement("ItemkindLimit");
			element_0.addElement("limitNo").setText("0");
			element_0.addElement("limitType").setText("000113");
			element_0.addElement("iextb1").setText("3000000.00");
			Element element_1 = underwrite.addElement("ItemkindLimit");
			element_1.addElement("limitNo").setText("1");
			element_1.addElement("limitType").setText("000473");
			element_1.addElement("iextb1").setText("300000.00");
			Element element_2 = underwrite.addElement("ItemkindLimit");
			element_2.addElement("limitNo").setText("2");
			element_2.addElement("limitType").setText("000152");
			element_2.addElement("iextb1").setText("30000.00");
		}else if(dto.getProduct_code().contains("-2")){
			Element element_0 = underwrite.addElement("ItemkindLimit");
			element_0.addElement("limitNo").setText("0");
			element_0.addElement("limitType").setText("000113");
			element_0.addElement("iextb1").setText("4000000.00");
			Element element_1 = underwrite.addElement("ItemkindLimit");
			element_1.addElement("limitNo").setText("1");
			element_1.addElement("limitType").setText("000473");
			element_1.addElement("iextb1").setText("400000.00");
			Element element_2 = underwrite.addElement("ItemkindLimit");
			element_2.addElement("limitNo").setText("2");
			element_2.addElement("limitType").setText("000152");
			element_2.addElement("iextb1").setText("40000.00");
		}else if(dto.getProduct_code().contains("-3")){
			Element element_0 = underwrite.addElement("ItemkindLimit");
			element_0.addElement("limitNo").setText("0");
			element_0.addElement("limitType").setText("000113");
			element_0.addElement("iextb1").setText("5000000.00");
			Element element_1 = underwrite.addElement("ItemkindLimit");
			element_1.addElement("limitNo").setText("1");
			element_1.addElement("limitType").setText("000473");
			element_1.addElement("iextb1").setText("500000.00");
			Element element_2 = underwrite.addElement("ItemkindLimit");
			element_2.addElement("limitNo").setText("2");
			element_2.addElement("limitType").setText("000152");
			element_2.addElement("iextb1").setText("50000.00");
		}else if(dto.getProduct_code().contains("-4")){
			Element element_0 = underwrite.addElement("ItemkindLimit");
			element_0.addElement("limitNo").setText("0");
			element_0.addElement("limitType").setText("000113");
			element_0.addElement("iextb1").setText("6000000.00");
			Element element_1 = underwrite.addElement("ItemkindLimit");
			element_1.addElement("limitNo").setText("1");
			element_1.addElement("limitType").setText("000473");
			element_1.addElement("iextb1").setText("600000.00");
			Element element_2 = underwrite.addElement("ItemkindLimit");
			element_2.addElement("limitNo").setText("2");
			element_2.addElement("limitType").setText("000152");
			element_2.addElement("iextb1").setText("60000.00");
		}
	}

	//特别约定信息
	private static void prpCengages(Element underwrite, SpecialHirelingVo vo, OrderFormVo dto) {
		if(dto.getProduct_code().contains("-1")){
			String clauses = "累计法律费用责任限额30万元，每人死亡伤残责任限额为30万，每人医疗费用责任限额为3万；";
			if("1".equals(vo.getIs_contain_repo())){
				clauses += "附加三者责任险每次事故责任限额10万元；附加三者责任险累计责任限额100万元；";
			}
			clauses += "\n2.扩展24小时意外事故（含非因工作）、罢工/暴动/骚乱、核辐射、公务出境等情况的保障；\n3.保安人员牺牲被评定为烈士的，死亡赔偿金为对应每人死亡伤残责任限额的2倍。";
			Element element_1 = underwrite.addElement("PrpCengage");
			element_1.addElement("serialNo").setText("1");
			element_1.addElement("clauseCode").setText("000017");
			element_1.addElement("clauseName").setText("特别约定");
			element_1.addElement("clauses").setText(clauses);
		}else if(dto.getProduct_code().contains("-2")){
			String clauses = "累计法律费用责任限额40万元，每人死亡伤残责任限额为40万，每人医疗费用责任限额为4万；";
			if("1".equals(vo.getIs_contain_repo())){
				clauses += "附加三者责任险每次事故责任限额14万元；附加三者责任险累计责任限额150万元；";
			}
			clauses += "\n2.扩展24小时意外事故（含非因工作）、罢工/暴动/骚乱、核辐射、公务出境等情况的保障；\n3.保安人员牺牲被评定为烈士的，死亡赔偿金为对应每人死亡伤残责任限额的2倍。";
			Element element_1 = underwrite.addElement("PrpCengage");
			element_1.addElement("serialNo").setText("1");
			element_1.addElement("clauseCode").setText("000017");
			element_1.addElement("clauseName").setText("特别约定");
			element_1.addElement("clauses").setText(clauses);
		}else if(dto.getProduct_code().contains("-3")){
			String clauses = "累计法律费用责任限额50万元，每人死亡伤残责任限额为50万，每人医疗费用责任限额为5万";
			if("1".equals(vo.getIs_contain_repo())){
				clauses += "；附加三者责任险每次事故责任限额20万元；附加三者责任险累计责任限额200万元；";
			}
			clauses += "\n2.扩展24小时意外事故（含非因工作）、罢工/暴动/骚乱、核辐射、公务出境等情况的保障；\n3.保安人员牺牲被评定为烈士的，死亡赔偿金为对应每人死亡伤残责任限额的2倍。";
			Element element_1 = underwrite.addElement("PrpCengage");
			element_1.addElement("serialNo").setText("1");
			element_1.addElement("clauseCode").setText("000017");
			element_1.addElement("clauseName").setText("特别约定");
			element_1.addElement("clauses").setText(clauses);
		}else if(dto.getProduct_code().contains("-4")){
			String clauses = "累计法律费用责任限额60万元，每人死亡伤残责任限额为60万，每人医疗费用责任限额为6万";
			if("1".equals(vo.getIs_contain_repo())){
				clauses += "；附加三者责任险每次事故责任限额25万元，附加三者责任险累计责任限额250万元；";
			}
			clauses += "\n2.扩展24小时意外事故（含非因工作）、罢工/暴动/骚乱、核辐射、公务出境等情况的保障；\n3.保安人员牺牲被评定为烈士的，死亡赔偿金为对应每人死亡伤残责任限额的2倍。";
			Element element_1 = underwrite.addElement("PrpCengage");
			element_1.addElement("serialNo").setText("1");
			element_1.addElement("clauseCode").setText("000017");
			element_1.addElement("clauseName").setText("特别约定");
			element_1.addElement("clauses").setText(clauses);
		}
	}

	//保单主信息 policyInfo
	private static void policyInfo(Element policyInfo, SpecialHirelingVo vo, OrderFormVo dto){
		policyInfo.addElement("SerialNo").setText("1");//请求序列号
		policyInfo.addElement("RiskCode").setText("ZBV");//险种代码
		policyInfo.addElement("OperateTimes").setText(dto.getStart_time());//售出保险时间
		policyInfo.addElement("StartDate").setText(dto.getInception_date());//起保日期
		policyInfo.addElement("EndDate").setText(dto.getPlanned_end_date());//终保日期
		policyInfo.addElement("StartHour").setText("0");//起保小时
		policyInfo.addElement("EndHour").setText("24");//终保小时
		policyInfo.addElement("SumAmount").setText(dto.getInsured_amount());//保单总保险金额
		policyInfo.addElement("SumPremium").setText(dto.getGross_premium());//保单总保险费
		policyInfo.addElement("ArguSolution").setText("1");//
		policyInfo.addElement("Quantity").setText("1");//
	}


	//投保人信息  applicant
	private static void applicant(Element holder, RoleSubjectVo roleSubjectVo){
		String organizationCode = roleSubjectVo.getOrganization_code();
		if(StringUtils.isNotEmpty(organizationCode) && ConstProp.DIGIT_ONE.equals(roleSubjectVo.getId_type())){
			if(organizationCode.contains(ConstProp.MINUS)){
				organizationCode = organizationCode.split(ConstProp.MINUS)[0]+organizationCode.split(ConstProp.MINUS)[1];
			}
		}
		holder.addElement("AppliName").setText(roleSubjectVo.getName_cn());//公司名称 否
		holder.addElement("AppliIdType").setText(changeCTypeCom(roleSubjectVo.getId_type()));//证件类型，
		holder.addElement("AppliIdNo").setText(organizationCode);//证件号码
		holder.addElement("SendSMS").setText("N");//发送邮件
		holder.addElement("AppliIdentity").setText("0");//与被保险人的关系
		holder.addElement("AppliIdEmail").setText(roleSubjectVo.getLink_email());//邮箱
		holder.addElement("AppliIdMobile").setText(roleSubjectVo.getLink_tel());//手机
		String address = RegionUtils.getRegionNameByALLCode(roleSubjectVo.getReg_province(),roleSubjectVo.getReg_city(),roleSubjectVo.getReg_district())+roleSubjectVo.getReg_address();
		holder.addElement("AppliAddress").setText(address);//地址
		holder.addElement("AppliLinker").setText(roleSubjectVo.getLink_name());//联系人
		holder.addElement("AppliPhone").setText(roleSubjectVo.getLink_tel());//联系电话
		holder.addElement("AppliPostAddress").setText(address);//联系地址
	}

	//被保险人信息  insured
	private static void insured(Element insured, RoleSubjectVo roleSubjectVo){
		String organizationCode = roleSubjectVo.getOrganization_code();
		if(StringUtils.isNotEmpty(organizationCode) && ConstProp.DIGIT_ONE.equals(roleSubjectVo.getId_type())){
			if(organizationCode.contains(ConstProp.MINUS)){
				organizationCode = organizationCode.split(ConstProp.MINUS)[0]+organizationCode.split(ConstProp.MINUS)[1];
			}
		}
		insured.addElement("InsuredName").setText(roleSubjectVo.getName_cn());//公司名称 否
		insured.addElement("InsuredIdType").setText(changeCTypeCom(roleSubjectVo.getId_type()));//证件类型，
		insured.addElement("InsuredIdNo").setText(organizationCode);//证件号码
		insured.addElement("InsuredSeqNo").setText("1");//序号
		insured.addElement("InsuredIdentity").setText("0");//与被保险人的关系
		insured.addElement("InsuredEmail").setText(roleSubjectVo.getLink_email());//邮箱
		insured.addElement("InsuredIdMobile").setText(roleSubjectVo.getLink_tel());//手机、
		String address = RegionUtils.getRegionNameByALLCode(roleSubjectVo.getReg_province(),roleSubjectVo.getReg_city(),roleSubjectVo.getReg_district())+roleSubjectVo.getReg_address();
		insured.addElement("InsuredAddress").setText(address);//地址
		insured.addElement("InsuredLinker").setText(roleSubjectVo.getLink_name());//联系人
		insured.addElement("InsuredPhone").setText(roleSubjectVo.getLink_tel());//联系电话
		insured.addElement("InsuredPostAddress").setText(address);//联系地址
	}

	//扩展信息  exendInfo
	private static void exendInfo(Element insured, int count){
		insured.addElement("serialNo").setText("1");//序号
		insured.addElement("Eexts5").setText("99");//
		insured.addElement("Eexts6").setText(String.valueOf(count));//
		insured.addElement("Eexts7").setText("083");//
	}

	//雇员信息列信息  employees
	private static void employees(Element employees, List<HirelingVo> hvoList, RoleSubjectVo appliVo){
		int count = 1;
		for(HirelingVo vo : hvoList){
			Element employee = employees.addElement("Employee");
			employee.addElement("serialNo").setText(String.valueOf(count));//序号
//			employee.addElement("jobUnit").setText(appliVo.getName_cn());//工作单位
			employee.addElement("appliName").setText("999");//雇员工种/人员类型名称
			employee.addElement("insuredName").setText(vo.getName());//公司名称 否
			employee.addElement("identifyType").setText(changeCTypePer(vo.getId_type()));//证件类型，
			employee.addElement("identifyNumber").setText(vo.getId_card());//证件号码
			employee.addElement("sex").setText(vo.getSex());//性别
			int age;
			try {
				age = DateUtil.getAge(vo.getBirth_date());
			} catch (Exception e) {
				age = 0;
			}
			employee.addElement("age").setText(String.valueOf(age));//年龄
			employee.addElement("jobTitle").setText("保安");//工种
			count++;
		}
	}

	//企业证件类型编码转换
	private static String changeCTypeCom(String c_t){
		if("1".equals(c_t)){//组织机构代码
			return "31";
		}else if("2".equals(c_t)){//统一社会代码
			return "37";
		}else{//其它
			return "99";
		}
	}

	//个人证件类型编码转换
	private static String changeCTypePer(String c_t){
		if("0".equals(c_t)){//身份证
			return "01";
		}else if("3".equals(c_t)){//护照
			return "03";
		}else if("5".equals(c_t)){//返乡证
			return "06";
		}else if("4".equals(c_t)){//台胞证
			return "26";
		}else{//其它
			return "99";
		}
	}

	//头信息
	private static void request_head(Element underwrite, OrderFormVo dto) {
		//该值用于报文数据设置后替换成加密后的字符串，这里不能没有值且保证值在报文中唯一，否则之后的替换会出错
//		underwrite.addElement("Md5Value").setText("74e3e47a31e0b1de3f0484fd67f931dd");
		//公司名称缩写（拼音或英文）+流水号
		underwrite.addElement("plateformcode").setText("ECP00008");
		//报文唯一性约束（长度别超过32位，各位开发人员添加uuid密等校验
		underwrite.addElement("uuid").setText(UUID.randomUUID().toString());
		//时间戳，记录当前时间，精确到毫秒
		underwrite.addElement("flowintime").setText(DateUtil.getCurrentDateTime());
		//0102非车险承保
		underwrite.addElement("user").setText("0102");
		//在接口管理系统中可查
		underwrite.addElement("request_type").setText("01020233");
		//供后台验证发送者身份用，使用方在接口管理系统中通过申请后获得的申请码
//		underwrite.addElement("password").setText("");
		//服务提供方接口版本号，以接口管理系统中版本为准
		underwrite.addElement("server_version").setText("00000000");
		//使用方系统编号，接口管理系统可查
		underwrite.addElement("sender").setText("0102");
	}

	//保全信息
	private static void policy_info(Element underwrite, InsPreservationRecordVo vo, OrderFormVo dto) {
		//保单号/批单申请号
		underwrite.addElement("modeid").setText(dto.getExternal_reference());
		//
//		underwrite.addElement("modeType").setText("");
		//
//		underwrite.addElement("clientIp").setText("");
		//批改日期 yyyy-MM-dd
		underwrite.addElement("endorDate").setText(vo.getStart_time());
		//批改生效日期 yyyy-MM-dd
		underwrite.addElement("validDate").setText(vo.getInception_date());
		//自定义批文标志（1:表示自定义批文 0：采用系统生成批文 （如果值1但是未传自定义批文，则采用系统生成的批文））
		underwrite.addElement("isPtextFlag").setText("1");
		//是否见费标志（1：表示送见费 0：表示不送见费 （只有在批增业务情况下，该标志位有效。不传则认为送见费））
		underwrite.addElement("sendJfeeFlag").setText("0");//TODO 默认都走不见费（月结）
		//是否自动核保通过（1:表示自动核保通过 0：表示人工核保通过 （该标志位为空时，则认为人工核保通过））
		underwrite.addElement("autoUndWrtFlag").setText("1");//TODO 线上自动核保
		//短期费率方式（3：不计 1:月比例 2：日比例）
		underwrite.addElement("shortRateFlag").setText("2");
		String pn,pp;
		if(ConstProp.DIGIT_THREE.equals(vo.getRevise_type())){
			pn = String.valueOf(vo.getInsPreservationDetailVoList().size()*2);
//			pp = ConstProp.DIGIT_ZERO;
		}else{
			pn = String.valueOf(vo.getInsPreservationDetailVoList().size());
//			pp = vo.getTotal_premium();
		}
		//保全人数
//		underwrite.addElement("personNum").setText(pn);
		//保全金额
//		underwrite.addElement("personPremium").setText(pp);

	}

	//自定义报文
	private static void prp_ptext(Element underwrite, InsPreservationRecordVo vo, OrderFormVo dto) {
		//保单号
		underwrite.addElement("policyNo").setText(dto.getExternal_reference());
		//批文内容
		underwrite.addElement("endorseText").setText("测试");
	}
	//雇员信息批改
	private static void prp_cname(Element underwrite, InsPreservationRecordVo vo, OrderFormVo dto) {
		int count = 1;
		for(InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()){

			if(ConstProp.DIGIT_THREE.equals(vo.getRevise_type())){//替换(将记录拆成2份，一增一减)
				setPrp( underwrite, ipdVo, conventPType("1"), String.valueOf(count));
				count ++;
				setPrp( underwrite, ipdVo.getBusiness_vo(), conventPType("2"), String.valueOf(count));
			}else{
				setPrp( underwrite, ipdVo, conventPType(vo.getRevise_type()), String.valueOf(count));
			}
			count ++;
		}
	}

	private static void setPrp(Element underwrite, InsPreservationDetailVo ipdVo, String tp, String sn){
		Element prp_cname_element = underwrite.addElement("PrpCname");
		Element id_element = prp_cname_element.addElement("id");
		//序列号
		id_element.addElement("serialNo").setText(sn);
		//雇员姓名
		prp_cname_element.addElement("employeeName").setText(ipdVo.getName());
		//性别
		prp_cname_element.addElement("sex").setText(ipdVo.getSex());
		//职业代码
		prp_cname_element.addElement("jobCode").setText("026");
		//证件号码
		prp_cname_element.addElement("identifyNumber").setText(ipdVo.getId_card());
		//批改标志（I:表示批增，U表示修改，D:表示批减）
		prp_cname_element.addElement("flag").setText(tp);
		//证件类型
		prp_cname_element.addElement("kindName").setText(changeCTypePer(ipdVo.getId_type()));
	}

	private static String conventPType(String revise_type){
		String rt = ConstProp.BLANK_CHAR;
		if(ConstProp.DIGIT_ONE.equals(revise_type)){//增员
			rt = "I";
		}else if(ConstProp.DIGIT_TWO.equals(revise_type)){//减员
			rt = "D";
		}/*else if(ConstProp.DIGIT_THREE.equals(revise_type)){//替换
			rt = "";
		}*/
		return rt;
	}

	/**
	 * 获得人保核保接口返回报文解析
	 * @param originalXML
	 * @return
	 * @throws DocumentException
	 */
	private String getRBHBResult(String originalXML) {
		String code = ConstProp.BLANK_CHAR;
		String msg = ConstProp.BLANK_CHAR;
		String pno = ConstProp.BLANK_CHAR;
		try {
			requestDocument = DocumentHelper.parseText(originalXML);//解析XML文件
			rootElement = requestDocument.getRootElement();//获取节点
			for(Iterator i = rootElement.elementIterator(); i.hasNext();){//遍历rootElement直到没有节点时结束
				Element node = (Element) i.next();
				if("GeneralInfoReturn".equals(node.getName())){//获取的节点为GeneralInfoReturn时进行
					for(Iterator r = node.elementIterator(); r.hasNext();){
						Element node_r = (Element) r.next();
						if("ErrorCode".equals(node_r.getName())){//获取的节点为ErrorCode时获取节点的文本内容
							code = node_r.getText();
						}
						if("ErrorMessage".equals(node_r.getName())){//获取的节点为ErrorMessage时获取节点的文本内容
							msg = node_r.getText();
						}
					}
					if(!"00".equals(code)){
						String saveMessage=originalXML.substring(originalXML.indexOf("<SaveMessage>")+13,originalXML.indexOf("</SaveMessage>"));
						if(StringUtils.isNotEmpty(saveMessage)){
							msg = saveMessage.trim();
						}
						return "300#"+msg;
					}
				}
				//获取的节点为PolicyInfoReturns时进行遍历
				if(!"PolicyInfoReturns".equals(node.getName())){
					continue;
				}
				//遍历节点直到结束
				for(Iterator r = node.elementIterator(); r.hasNext();){
					Element node_r = (Element) r.next();
					if(!"PolicyInfoReturn".equals(node_r.getName())){
						continue;
					}
					for(Iterator t = node_r.elementIterator(); t.hasNext();){
						Element node_t = (Element) t.next();
						if("SaveResult".equals(node_t.getName())){
							code = node_t.getText();
						}
						if("SaveMessage".equals(node_t.getName())){
							msg = node_t.getText();
						}
						if("ProposalNo".equals(node_t.getName())){
							pno = node_t.getText();
						}
					}
					if(!"00".equals(code)||StringUtils.isEmpty(pno)){
						if(StringUtils.isEmpty(msg)){
							msg = "解析数据丢失";
						}
						return "300#"+msg;
					}else{
						return "200#"+pno+ConstProp.POUND_SIGN+msg;
					}
				}
			}
		}catch (Exception e){
			logger.info("getRBHBResult:"+e.getMessage());
		}
		return "300#数据解析失败";
	}

	/**
	 * 获得人保批改接口返回报文解析
	 * @param originalXML
	 * @return
	 * @throws DocumentException
	 */
	private String getRBPDResult(String originalXML) {
		String code = ConstProp.BLANK_CHAR;
		String msg = ConstProp.BLANK_CHAR;
		String pno = ConstProp.BLANK_CHAR;
		String batchNumber = ConstProp.BLANK_CHAR;
		String premium = ConstProp.BLANK_CHAR;
		originalXML = originalXML.replace("\n",ConstProp.BLANK_CHAR);
		try {
			//解析XML文件
			requestDocument = DocumentHelper.parseText(originalXML);
			//获取xml文件中的节点
			rootElement = requestDocument.getRootElement();
			//遍历文件中的节点
			for(Iterator i = rootElement.elementIterator(); i.hasNext();){
				Element node = (Element) i.next();
				//获取的节点为responsehead时进行
				if("responsehead".equals(node.getName())){
					for(Iterator r = node.elementIterator(); r.hasNext();){
						Element node_r = (Element) r.next();
						if("response_code".equals(node_r.getName())){
							code = node_r.getText();
						}
						if("error_message".equals(node_r.getName())){
							msg = node_r.getText();
						}
					}
					if(!"0".equals(code)&&!"1".equals(code)){
						return "300#"+msg;
					}
				}
				if(!"policyInfoReturns".equals(node.getName())){
					continue;
				}
				for(Iterator r = node.elementIterator(); r.hasNext();){
					Element node_r = (Element) r.next();
					if(!"PolicyInfoReturn".equals(node_r.getName())){
						continue;
					}
					for(Iterator t = node_r.elementIterator(); t.hasNext();){
						Element node_t = (Element) t.next();
						if("result".equals(node_t.getName())){
							code = node_t.getText();
						}
						if("chgSumPremium".equals(node_t.getName())){
							premium = node_t.getText();
						}
						if("message".equals(node_t.getName())){
							msg = node_t.getText();
						}
						if("policyNo".equals(node_t.getName())){
							pno = node_t.getText();
						}
						if("proposalNo".equals(node_t.getName())){
							batchNumber = getPdh(node_t.getText());
						}
					}
					if(!"0".equals(code)&&!"1".equals(code)){
						if(StringUtils.isEmpty(msg)){
							msg = "解析数据丢失";
						}
						return "300#"+msg;
					}else{
						if(StringUtils.isNotEmpty(msg)&&msg.contains("无法再次进行批改")){
							return "300#"+msg;
						}
						if(StringUtils.isNotEmpty(msg)&&msg.contains("无法删除")){
							return "300#"+msg;
						}
						if(StringUtils.isNotEmpty(msg)&&msg.contains(",批单号为：")){
							batchNumber = msg.split(",批单号为：")[1];
						}
						//200#保单号#批单号#保费
						return "200#"+pno+ConstProp.POUND_SIGN+batchNumber+ConstProp.POUND_SIGN+premium;
					}
				}
			}
		}catch (Exception e){
			logger.info("getRBPDResult:"+e.getMessage());
		}
		return "300#数据解析失败";
	}

	/**
	 * <b> 获取批单号 </b>
	 * @param pdsqh 批单申请号
	 * @author ZXF
	 * @create 2019/12/20 0020 15:05
	 * @version
	 * @注意事项 </b>
	 */
	public static String getPdh(String pdsqh){
		return HttpUtil.get(GlobalResources.map.get("RB_GZ_PDH_URL")+"?applyno="+pdsqh);
	}
	/**
	 * 获得人保支付信息回调报文解析
	 * @param originalXML
	 * @return
	 * @throws DocumentException
	 */
	private String getRBHDCBResult(String originalXML) {
		String code = ConstProp.BLANK_CHAR;
		String msg = ConstProp.BLANK_CHAR;
		String proposalNo = ConstProp.BLANK_CHAR;
		String policyNo = ConstProp.BLANK_CHAR;
		String policyDownUrl = ConstProp.BLANK_CHAR;
		try {
			requestDocument = DocumentHelper.parseText(originalXML);
			rootElement = requestDocument.getRootElement();
			for(Iterator i = rootElement.elementIterator(); i.hasNext();){
				Element node = (Element) i.next();
				if(!"PolicyInfos".equals(node.getName())){
					continue;
				}
				for(Iterator r = node.elementIterator(); r.hasNext();){
					Element node_r = (Element) r.next();
					if(!"PolicyInfo".equals(node_r.getName())){
						continue;
					}
					for(Iterator t = node_r.elementIterator(); t.hasNext();){
						Element node_t = (Element) t.next();
						if("Result".equals(node_t.getName())){
							code = node_t.getText();
						}
						if("PolicyNo".equals(node_t.getName())){
							//保单号
							policyNo = node_t.getText();
						}
						if("Message".equals(node_t.getName())){
							msg = node_t.getText();
						}
						if("ProposalNo".equals(node_t.getName())){
							//投保单号
							proposalNo = node_t.getText();
						}
						if("PolicyDownUrl".equals(node_t.getName())){
							//电子保单地址
							policyDownUrl = node_t.getText();
						}
					}
					if(!"0".equals(code)&&!"1".equals(code)){
						if(StringUtils.isEmpty(msg)){
							msg = "解析数据丢失";
						}
						return "300#"+msg;
					}else{
						//重新保存并生成下载地址（保存原文件到我们平台，生成我们平台的访问地址）
						policyDownUrl = unloading_bd(policyNo, policyDownUrl);
						//200#投保单号#保单号#电子保单地址
						return "200#"+proposalNo+ConstProp.POUND_SIGN+policyNo+ConstProp.POUND_SIGN+policyDownUrl;
					}
				}
			}
		}catch (Exception e){
			logger.info("getRBHDCBResult:"+e.getMessage());
		}
		return "300#数据解析失败";
	}

	/**
	 * 获得人保批改接口返回报文解析
	 * @param originalXML
	 * @return
	 * @throws DocumentException
	 */
	private String getRBHDZFResult(String originalXML) {
		String code = ConstProp.BLANK_CHAR;
		String msg = ConstProp.BLANK_CHAR;
		try {
			requestDocument = DocumentHelper.parseText(originalXML);
			rootElement = requestDocument.getRootElement();
			for(Iterator i = rootElement.elementIterator(); i.hasNext();){
				Element node = (Element) i.next();
				if(!"PolicyInfos".equals(node.getName())){
					continue;
				}
				for(Iterator r = node.elementIterator(); r.hasNext();){
					Element node_r = (Element) r.next();
					if(!"PolicyInfo".equals(node_r.getName())){
						continue;
					}
					for(Iterator t = node_r.elementIterator(); t.hasNext();){
						Element node_t = (Element) t.next();
						if("Result".equals(node_t.getName())){
							code = node_t.getText();
						}
						if("Message".equals(node_t.getName())){
							msg = node_t.getText();
						}
					}
					if(!"0".equals(code)&&!"1".equals(code)){
						if(StringUtils.isEmpty(msg)){
							msg = "解析数据丢失";
						}
						return "300#"+msg;
					}else{
						//200#信息
						return "200#"+msg;
					}
				}
			}
		}catch (Exception e){
			logger.info("getRBHDCBResult:"+e.getMessage());
		}
		return "300#数据解析失败";
	}

	/**
	 * 获得人保支付地址报文解析
	 * @param originalXML
	 * @return
	 * @throws DocumentException
	 */
	private String getRBZFDZResult(String originalXML) {
		String code = ConstProp.BLANK_CHAR;
		String msg = ConstProp.BLANK_CHAR;
		String payLink = ConstProp.BLANK_CHAR;
		String payNo = ConstProp.BLANK_CHAR;
		originalXML = originalXML.replace("\n",ConstProp.BLANK_CHAR);
		try {
			//解析XML文件
			requestDocument = DocumentHelper.parseText(originalXML);
			//获取xml文件中的节点
			rootElement = requestDocument.getRootElement();
			//遍历rootElement直到没有节点时结束
			for(Iterator i = rootElement.elementIterator(); i.hasNext();){
				Element node = (Element) i.next();
				//获取的节点为GeneralInfoReturn时进行
				if("GeneralInfoReturn".equals(node.getName())){
					for(Iterator r = node.elementIterator(); r.hasNext();){
						Element node_r = (Element) r.next();
						//获取的节点为ErrorCode时获取节点的文本内容
						if("ErrorCode".equals(node_r.getName())){
							code = node_r.getText();
						}
						//获取的节点为ErrorMessage时获取节点的文本内容
						if("ErrorMessage".equals(node_r.getName())){
							msg = node_r.getText();
						}
					}
					if(!"00".equals(code)){
						return "300#"+msg;
					}
				}
				//获取的节点为PolicyInfoReturns时进行遍历
				if(!"PolicyInfoReturns".equals(node.getName())){
					continue;
				}
				//遍历节点直到结束
				for(Iterator r = node.elementIterator(); r.hasNext();){
					Element node_r = (Element) r.next();
					if(!"PolicyInfoReturn".equals(node_r.getName())){
						continue;
					}
					for(Iterator t = node_r.elementIterator(); t.hasNext();){
						Element node_t = (Element) t.next();
						if("SaveResult".equals(node_t.getName())){
							code = node_t.getText();
						}
						if("SaveMessage".equals(node_t.getName())){
							msg = node_t.getText();
						}
						if("PayLink".equals(node_t.getName())){
							payLink = node_t.getText();
						}
						if("PayNo".equals(node_t.getName())){
							payNo = node_t.getText();
						}
					}
					if((!"00".equals(code) && !"0".equals(code))||StringUtils.isEmpty(payLink)||StringUtils.isEmpty(payNo)){
						if(StringUtils.isEmpty(msg)){
							msg = "解析数据丢失";
						}
						return "300#"+msg;
					}else{
						payLink = payLink.replace("<![CDATA[",ConstProp.BLANK_CHAR).replace("]]>",ConstProp.BLANK_CHAR)
								.replace("&lt;![CDATA[",ConstProp.BLANK_CHAR).replace("]]&gt;",ConstProp.BLANK_CHAR);
						return "200#"+payNo+ConstProp.POUND_SIGN+payLink;
					}
				}
			}
		}catch (Exception e){
			logger.info("getRBZFDZResult:"+e.getMessage());
		}
		return "300#数据解析失败";
	}

	/**
	 *	核保接口返回字符串解析
	 * @return
	 */
	public String returnAnalysisXML(String xml, String transType){
		if(TransTypeEnum.HB.getValue().equals(transType)) {
			//核保
			return getRBHBResult(xml);
		}else if(TransTypeEnum.PD.getValue().equals(transType)) {
			//批单
			return getRBPDResult(xml);
		}else if(TransTypeEnum.HDCB.getValue().equals(transType)) {
			//承保回调
			return getRBHDCBResult(xml);
		}else if(TransTypeEnum.HDZF.getValue().equals(transType)) {
			//批单支付回调
			return getRBHDZFResult(xml);
		}else if(TransTypeEnum.ZFDZ.getValue().equals(transType)) {
			//获取支付地址
			return getRBZFDZResult(xml);
		}
		return ConstProp.BLANK_CHAR;
	}

	/**
	 * <b>
	 *     根据保险公司电子保单下载地址转存成自己平台的下载地址（该方法暂未用）
	 * </b>
	 * @param pno 保单号
	 * @param rb_url 电子保单下载地址
	 * @author ZXF
	 * @create 2018/06/07 0007 11:01
	 * @version
	 * @注意事项 </b>
	 */
	private static String unloading_bd(String pno, String rb_url){
		String result = rb_url;
		if (StringUtils.isEmpty(rb_url)) {
			return result;
		}
		if(StringUtils.isEmpty(pno)){
			pno = "RBGZ"+System.currentTimeMillis();
		}
		InputStream inStream = null;
		try {
			URL url = new URL(rb_url);
			HttpURLConnection conn = (HttpURLConnection)url.openConnection();
			conn.setRequestMethod("GET");
			conn.setConnectTimeout(5 * 1000);
			inStream = conn.getInputStream();
			String savePath = "/policy/";
			String files = pno + ".pdf";
			result = savePath + files;
			String path = GlobalResources.COM_IMG_RE+savePath;
			FileHelp.isFile(inStream, path, files);
			result = "/getResource?path="+result;
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			if (inStream != null) {
				try {
					inStream.close();
				} catch (IOException e1) {
					e1.printStackTrace();
				}
			}
		}
		return result;
	}

}
