package com.bcxin.ins.third.gzzrx.pingancai;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.util.*;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.*;
import com.bcxin.ins.vo.report_pac.InsClaimInformationVo;
import com.bcxin.ins.vo.report_pac.InsCommonReportVo;
import com.bcxin.ins.vo.report_pac.InsPaymentInfoVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Maps;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

/**
 * <b> 平安财-雇主责任险各接口请求数据组装 </b>
 * @author ZXF
 * @create 2019/11/15 0015 11:06
 * @version
 * @注意事项 </b>
 */
public class GZZRX_PackageMessagePAC {


	private static Logger logger = LoggerFactory.getLogger(GZZRX_PackageMessagePAC.class);

	private static final String FORMAT = "json";
	private static final String SIGNTYPE = "md5";
	private static final String CHARSET = "utf-8";
	private static String DEPARTMENTCODE;
	static {
		if(GlobalResources.IS_TEST_ENVI){
			DEPARTMENTCODE = "20162";
		}else{
			DEPARTMENTCODE = "20126";
		}
	}
	private static final String PARTNERCODE = "P_BCXZR_GP";
	// TODO 测试环境使用
//	private static final String DEPARTMENTCODE = "20162";
	// TODO 生产环境使用（上线前需要切换）
//	private static final String DEPARTMENTCODE = "20126";

	/**
	 * <b> 批改确认报文组装 (在用)</b>
	 * @param policyNo 保单号
	 * @param transType 接口类型
	 * @param endorseApplyNo 批改申请单号
	 * @param actualPremiumChange 保费变化
	 * @param transSerialNo 批改申请时的流水号
	 * @author ZXF
	 * @create 2019/11/01 0001 15:48
	 * @version
	 * @注意事项 </b>
	 */
	public static String pdqr_marshal(String policyNo
			, String transType
			, String endorseApplyNo
			, String actualPremiumChange
			, String transSerialNo) throws Exception {
		JSONObject jsonHead = new JSONObject();
		if(TransTypeEnum.PDQR.getValue().equals(transType)){//批单
			IdWorker idWorker = new IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
			jsonHead.put("requestId",String.valueOf(idWorker.nextId()));//请求标识（该值不可重复，用于定位问题）
			JSONObject moreInfo = new JSONObject();
			moreInfo.put("partnerCode",PARTNERCODE);//合作伙伴编码，平安开发提供
			moreInfo.put("edrSceneCode","18002");//批改场景编码，见附录2
			moreInfo.put("policyNo",policyNo);//保单号
			moreInfo.put("endorseApplyNo",endorseApplyNo);//批改申请单号
			moreInfo.put("actualPremiumChange",actualPremiumChange);//保费变化
			moreInfo.put("confirmEndorse","Y");//"Y"-确认进行本次批改；"N"-取消本次批改
			moreInfo.put("transSerialNo",transSerialNo);//批改申请时的流水号
			moreInfo.put("isSendElectronicEndorse","N");//是否发送电子批单（Y-发送，N-不发送）
			jsonHead.put("endorseInfo",moreInfo);//[非空]
		}

		return jsonHead.toString();
	}

	public static String marshalReport(InsCommonReportVo vo, String transType) throws Exception {
		JSONObject jsonHead = new JSONObject();
		if(TransTypeEnum.BASL.getValue().equals(transType)){//报案受理
//			IdWorker idWorker = new IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
			jsonHead.put("policyNo",vo.getPolicy_no());//保单号【数字且长度不能大于21位】
			jsonHead.put("reporterName",vo.getReporter_name());//报案人姓名
			jsonHead.put("reporterTel",vo.getReporter_tel());//报案人手机
			jsonHead.put("accidentDate",vo.getAccident_date());//出险时间【格式yyyy-mm-dd hh24:mi:ss】
			jsonHead.put("isOverseasAccident","N");//是否境外出险【Y-是 N-否】默认N
			jsonHead.put("accidentProvinceCode",vo.getAccident_province_code());//出险地点省代码【境内出险不能为空】
			jsonHead.put("accidentCityCode",vo.getAccident_city_code());//出险地点城市代码【境内出险不能为空】
			jsonHead.put("accidentCountyCode",vo.getAccident_county_code());//出险地点区/县代码【境内出险不能为空】
			jsonHead.put("accidentPlace",vo.getAccident_place());//出险地点之详细地址【境内出险不能为空】
			jsonHead.put("accidentProcess",vo.getAccident_process());//出险经过
			jsonHead.put("accidentCauseLevel1",vo.getAccident_cause_level_1());//出险原因一级代码
			jsonHead.put("accidentCauseLevel2",vo.getAccident_cause_level_2());//出险原因二级代码
			jsonHead.put("isCargoLoss",vo.getIs_cargo_loss());//是否物损【Y——是,N——否】,默认传N
			jsonHead.put("isInjured",vo.getIs_injured());//是否人伤【Y——是,N——否】,默认传Y
			jsonHead.put("isCarLoss",vo.getIs_carloss());//是否车损【Y——是,N——否】,默认传N
			jsonHead.put("lossType",vo.getLoss_type());//损失类型【1人伤,2物损,3车损】,
			jsonHead.put("injuredDetail",vo.getInjured_detail());//人伤类型（01-门诊，02-住院、伤残，03-死亡）多种类型，以”,”号隔开
			jsonHead.put("outpatientList",vo.getOutpatient_list());//门诊人员姓名列表，以“,”隔开
			jsonHead.put("maimList",vo.getMaim_list());//住院、任务残人员姓名列表，以“,”隔开
			jsonHead.put("demiseList",vo.getDemise_list());//死亡人员姓名列表，以“,”隔开
			jsonHead.put("reportLossSum",vo.getReport_loss_sum());//损失金额【非负数且最长16位】
			jsonHead.put("isSelfClaim","Y");//客户意愿【Y--用户自助理赔,N--非用户自助理赔，默认传Y】
			jsonHead.put("userId","BCX00001");//BCX00001【固定值】
			jsonHead.put("lossCurrencyCode","01");//损失币种【01 人民币02 港元  03 美元,默认传01】
			jsonHead.put("reportMode","F");//报案方式【OPENAPI,默认传F】
			//索赔资料附件 list
			JSONArray claimInformationList = new JSONArray();
			doClaimInformationList(vo.getClaimInformationVoList(),claimInformationList);
			jsonHead.put("claimInformationList",claimInformationList);
			//银行支付信息 map
			Map<String, String> paymentInfoMap = Maps.newHashMap();
			doPaymentInfo(vo.getInsPaymentInfoVo(),paymentInfoMap);
			jsonHead.put("paymentInfo",paymentInfoMap);

		}else if(TransTypeEnum.AJCX.getValue().equals(transType)){//案件查询
			jsonHead.put("reportNo",vo.getReport_no());//报案号
			jsonHead.put("policyNo",vo.getPolicy_no());//保单号
		}else if(TransTypeEnum.CLSC.getValue().equals(transType)){//材料查询
			jsonHead.put("userId","BCX00001");//操作人
			jsonHead.put("reportNo",vo.getReport_no());//报案号
			jsonHead.put("policyNo",vo.getPolicy_no());//保单号
			jsonHead.put("uploadSource","10");//上传来源【默认10】10:  OPENAPI
			jsonHead.put("uploadPersonType","02");//上传人类型【默认02】01：平安人员;02：客户
			//索赔资料附件 list
			JSONArray claimInformationList = new JSONArray();
			doClaimInformationList(vo.getClaimInformationVoList(),claimInformationList);
			jsonHead.put("claimInformationList",claimInformationList);
		}

		return jsonHead.toString();
	}

	//索赔资料附件信息 doClaimInformationList
	private static void doClaimInformationList(List<InsClaimInformationVo> list, JSONArray arr){
		Map<String, String> map = null;
		for(InsClaimInformationVo vo : list){
			if(ConstProp.DIGIT_ZERO.equals(vo.getStatus())){
				map = Maps.newHashMap();
				map.put("fileId",vo.getFile_key());//索赔资料附件(上传附件key)
				map.put("fileName",vo.getFile_name());//文件名(索赔资料名.后缀)
				map.put("bigGroupCode",vo.getBig_group_code());//大类代码
				map.put("shortGroupCode",vo.getShort_group_code());//小类代码
				arr.add(map);
			}
		}
	}

	//银行支付信息 doPaymentInfo
	private static void doPaymentInfo(InsPaymentInfoVo vo, Map<String, String> map){
		map.put("dataSource","F");//数据来源:OPENAPI,默认传F
		map.put("clientName",vo.getClient_name());//开户姓名
		map.put("clientType",vo.getClient_type());//客户类型,传数字编码(01=被保险人,02=受益人,03=受害人,04=法院,05=被委托人,99=其他)
		map.put("clientBankAccount",vo.getClient_bank_account());//开户行账号
		map.put("clientBankCode",vo.getClient_bank_code());//开户行代码(实时支付时为银行大类的Code。详细见附录2.2)
		map.put("clientBankName",vo.getClient_bank_name());//开户行名称(实时支付时为银行大类的名称。详细见附录2.2)
		map.put("collectPayApproach",vo.getCollect_pay_approach());//收付途径【01=柜面,02=实时,03=批量】
		map.put("bankAccountAttribute",vo.getBank_account_attribute());//银行账户类型(1=个人账号,0=公司账号)
		String clientCertificateType = ConstProp.DIGIT_ZERO.equals(vo.getBank_account_attribute())?idTypeSet(vo.getClient_certificate_type())
				:ConstProp.DIGIT_ONE.equals(vo.getBank_account_attribute())?getCard(vo.getClient_certificate_type())
				:ConstProp.BLANK_CHAR;
		map.put("clientCertificateType",clientCertificateType);//证件类型(01-身份证,02-护照,03-军官证,04-港澳通行证,05-驾驶证,06-港澳回乡证或台胞证,07-临时身份证,99-其他)
		map.put("clientCertificateNo",vo.getClient_certificate_no());//证件号码，账户类型为个人时非空
		map.put("remark",vo.getRemark());//备注信息/银行预留信息
		map.put("provinceName",vo.getProvince_name());//省名称
		map.put("cityName",vo.getCity_name());//市名称
		map.put("regionCode",vo.getRegion_code());//市代码
	}

	public static String marshal(SpecialHirelingVo vo, OrderFormVo dto, String transType, InsPreservationRecordVo iprVo) throws Exception {

		JSONObject jsonHead = new JSONObject();
		//头信息
		IdWorker idWorker = new IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
		if(TransTypeEnum.HB.getValue().equals(transType)){//核保
			jsonHead.put("partnerCode",PARTNERCODE);//合作伙伴用户名（Openapi分配名称，固定值）
			jsonHead.put("transSerialNo",dto.getTrade_serial_number());//交易流水号，每次提交必须唯一(用于验证重复提交)
			jsonHead.put("departmentCode",DEPARTMENTCODE);//机构编码，咨询平安业务
			jsonHead.put("transferCode","APPLY");//交易编码(EBCS根据不同交易分配固定值)【APPLY】
			jsonHead.put("quoteMark","1".equals(vo.getIs_contain_repo())?
					getQuoteMark1(dto.getProduct_code()):"2".equals(vo.getIs_contain_repo())?
					getQuoteMark2(dto.getProduct_code()):getQuoteMark(dto.getProduct_code()));//询价单标识
			jsonHead.put("schemeName",getSchemeName(dto.getProduct_code()));//方案名

			//投保信息
			JSONObject jsonContract = new JSONObject();
			//投保人
			JSONArray jsonApplicantArray = new JSONArray();
			JSONObject jsonApplicant = new JSONObject();
			doApplicantInfo(vo,dto,jsonApplicant);
			jsonApplicantArray.add(jsonApplicant);
			jsonContract.put("applicantInfoList",jsonApplicantArray);
			//被保险人
			JSONArray jsonInsurantArray = new JSONArray();
			JSONObject jsonInsurant = new JSONObject();
			doInsurantInfo(vo,dto,jsonInsurant);
			jsonInsurantArray.add(jsonInsurant);
			jsonContract.put("insurantInfoList",jsonInsurantArray);
			//受益人
			JSONArray jsonBeneficaryArray = new JSONArray();
			JSONObject jsonBeneficary = new JSONObject();
			doBeneficaryInfo(vo,dto,jsonBeneficary);
			jsonBeneficaryArray.add(jsonBeneficary);
			jsonContract.put("beneficaryInfoList",jsonBeneficaryArray);
			//保单基本信息
			JSONObject jsonBase = new JSONObject();
			doBaseInfo(vo,dto,jsonBase);
			jsonContract.put("baseInfo",jsonBase);
			//是否见费出单
			JSONObject jsonExtend = new JSONObject();
			jsonExtend.put("isPolicyBeforePayfee",dto.getIs_policy_before_pay_fee());// 是否是见费出单(1-是;0-否)
			jsonContract.put("extendInfo",jsonExtend);
			//团财扩展信息
			Map extendGroup = Maps.newHashMap();
			extendGroup.put("employeesNum",vo.getHirelingVoList().size());// 雇员总人数
			jsonContract.put("extendGroupInfo",extendGroup);
			//标的组信息
			JSONArray jsonRiskPropertyArray = new JSONArray();
			doRiskGroupInfo(vo,dto,jsonRiskPropertyArray);
			jsonContract.put("riskGroupInfoList",jsonRiskPropertyArray);

			jsonHead.put("contract",jsonContract);
		}else if (TransTypeEnum.CBXX.getValue().equals(transType)){//承保
			jsonHead.put("partnerCode",PARTNERCODE);//合作伙伴用户名（Openapi分配名称，固定值）
			jsonHead.put("transSerialNo",String.valueOf(idWorker.nextId()));//交易流水号，每次提交必须唯一(用于验证重复提交)
			jsonHead.put("transferCode","ACCEPT");//交易编码(EBCS根据不同交易分配固定值)【ACCEPT】
			jsonHead.put("tradeSubdivision","MP07110009");//区分业务流程，固定值【MP07110009】
			JSONObject jsonContract = new JSONObject();
			JSONObject baseInfo = new JSONObject();
			baseInfo.put("applyPolicyNo",dto.getPolicy_serial_number());//投保单号
			jsonContract.put("baseInfo",baseInfo);
			jsonHead.put("contract",jsonContract);
		}else if(TransTypeEnum.DZBD.getValue().equals(transType)){//电子保单打印
			jsonHead.put("partnerCode",PARTNERCODE);//合作伙伴用户名（Openapi分配名称，固定值）
			jsonHead.put("transferCode","PRINT");//交易编码(EBCS根据不同交易分配固定值)【PRINT】
			jsonHead.put("applyPolicyNo",dto.getPolicy_serial_number());//投保单号（打印暂存单、投保单时必传）
			jsonHead.put("policyNo",dto.getExternal_reference());//保单号（打印保单时必传）
			jsonHead.put("electronicType","4");//单证类型：1投保单，2暂存单（目前只有货运险有暂存单）,6雇员清单，7批单，4保单，9人员清单 不传默认为4
			jsonHead.put("isElectronic","1");//是否电子版：0否,1是（一般都为1，货运险套打保单时传入0   仅仅打印暂存单和投保单时可用）
			jsonHead.put("languagePrint","0");//打印语言，0中文打印，1英文打印（一般都为0，目前只有货运险支持英文打印   仅仅打印暂存单和投保单时可用）
			jsonHead.put("isPrintCross","1");//是否使用骑缝章（0：否，1：是）
		}else if(TransTypeEnum.ZFDZ.getValue().equals(transType)){//支付接口
			String productCode = "MP07110009";
			jsonHead.put("partnerCode",PARTNERCODE);//合作伙伴用户名（Openapi分配名称，固定值）
			jsonHead.put("partnerName",PARTNERCODE);//投保的合作伙伴用户名
			jsonHead.put("tradeNo",String.valueOf(idWorker.nextId()));//[非空]流水号，要求每次唯一
			jsonHead.put("productCode",productCode);//[非空]产品编码
			jsonHead.put("applyPolicyNo",dto.getPolicy_serial_number());//投保单号
			jsonHead.put("noticeNo",dto.getNotice_no());//[非空]投保返回通知单号
			jsonHead.put("amount",dto.getGross_premium());//[非空]保单保费
			jsonHead.put("customerName",dto.getApplicant_name());//[非空]投保人名称
			jsonHead.put("productName",dto.getProduct_name());//[非空]产品名称
			jsonHead.put("productType","0A");//[非空]商品类别   财产险02, 意健险0A,  车险01
			jsonHead.put("systemType","EBCS");//出单系统(1:PNBS、2:EBCS、3:AHS) TODO ?
			jsonHead.put("signMsg",signMsg_sha256(dto,productCode));//[非空]加密密文，对partnerName+productCode+customerName+amount+noticeNo进行sha256加密，明文案例(P_XXX_GAMP070000000投保人甲100.0011080006000137712169)
			jsonHead.put("returnUrl",GlobalResources.WEB_URL);//[非空]回退地址，用于用户点击后退时展示的页面
			String returnUrl = GlobalResources.WEB_URL+"api/gzzrx/syntony-service/"+dto.getOid();
			if(ConstProp.BLB.equals(dto.getWeb_type())){
				returnUrl = GlobalResources.WEB_URL+"/insurance/gzzrx/transaction/syntony-service/"+dto.getOid();
			}
			jsonHead.put("frontNotifyUrl",returnUrl);//[非空]前台回调地址，用于支付完成后前端展示的页面
		}else if(TransTypeEnum.DZFP.getValue().equals(transType)){//电子发票打印
			jsonHead.put("partnerCode",PARTNERCODE);//合作伙伴用户名（Openapi分配名称，固定值）
			JSONArray invoiceArray = new JSONArray();
			JSONObject jsonInvoice = new JSONObject();
			doInvoice(vo,dto,jsonInvoice);
			invoiceArray.add(jsonInvoice);// [非空]发票信息列表，一次性最多开10张票
			jsonHead.put("invoiceList",invoiceArray);
		}else if(TransTypeEnum.PD.getValue().equals(transType)){//批单
			jsonHead.put("edrSceneCode","70001");//批改场景:70001 记名投保人变更
			jsonHead.put("partnerCode",PARTNERCODE);//合作伙伴用户名（Openapi分配名称，固定值）
			jsonHead.put("updatedBy","BCX00001");//批改人
			jsonHead.put("dataSource","ICORE-PTS");//数据来源，固定填ICORE-PTS
			jsonHead.put("effectiveDate",iprVo.getInception_date()+ConstProp.DAY_00);//生效日期，格式为yyyy-MM-dd
			Map contract = Maps.newHashMap();
			Map baseInfo = Maps.newHashMap();
			baseInfo.put("policyNo",dto.getExternal_reference());//保单号
			contract.put("baseInfo",baseInfo);//保单基本信息
			jsonHead.put("contract",contract);//单证信息
			JSONArray riskPersonArray = new JSONArray();
			doRiskPersonList(iprVo,dto,riskPersonArray);
			jsonHead.put("applyRiskPropsubDTOs",riskPersonArray);//人标的列表,批改被保人，修改被保人时必传
		}else if(TransTypeEnum.DZPD.getValue().equals(transType)){//电子批单打印
			jsonHead.put("partnerCode",PARTNERCODE);//合作伙伴用户名（Openapi分配名称，固定值）
			jsonHead.put("transferCode","PRINT");//交易编码(EBCS根据不同交易分配固定值)【PRINT】
			jsonHead.put("applyPolicyNo",dto.getPolicy_serial_number());//投保单号（打印暂存单、投保单时必传）
			jsonHead.put("policyNo",dto.getExternal_reference());//保单号（打印保单时必传）
			jsonHead.put("endorseNo",iprVo.getRevise_serial_num_ins());//批单号
			jsonHead.put("electronicType","7");//单证类型：1投保单，2暂存单（目前只有货运险有暂存单）,6雇员清单，7批单，4保单，9人员清单 不传默认为4
			jsonHead.put("isElectronic","1");//是否电子版：0否,1是（一般都为1，货运险套打保单时传入0   仅仅打印暂存单和投保单时可用）
			jsonHead.put("languagePrint","0");//打印语言，0中文打印，1英文打印（一般都为0，目前只有货运险支持英文打印   仅仅打印暂存单和投保单时可用）
			jsonHead.put("isPrintCross","1");//是否使用骑缝章（0：否，1：是）
		}

		return jsonHead.toString();
	}

	private static String signInfo_sha256(String policyNo, String productCode, String printTime){
		return PAC_MD5Util.sha256Hex(policyNo+productCode+printTime);
	}
	private static String signMsg_sha256(OrderFormVo dto, String productCode){
		return PAC_MD5Util.sha256Hex(PARTNERCODE+productCode+dto.getApplicant_name()+dto.getGross_premium()+dto.getNotice_no());
	}

	//投保基本信息 doBaseInfo
	private static void doBaseInfo(SpecialHirelingVo vo, OrderFormVo dto,JSONObject json){
		json.put("productCode","MP07110009");//产品编码
		json.put("inputNetworkFlag","internet");//传入“internet”
		json.put("dataSource","openApi");//数据来源【openApi】
		json.put("inputBy",PARTNERCODE);//录入人
		json.put("insuranceBeginDate",dto.getInception_date()+ConstProp.DAY_00);//保险起期 yyyy-MM-dd HH:mm:ss或yyyy/MM/dd HH:mm:ss
	}

	//电子发票信息 doInvoice
	private static void doInvoice(SpecialHirelingVo vo, OrderFormVo dto,JSONObject json){
		JSONArray policyArray = new JSONArray();
		for(RoleSubjectVo roleSubjectVo : vo.getRoleSubjectList()){
			if(!"1".equals(roleSubjectVo.getKind())){
				continue;
			}
			String organizationCode = roleSubjectVo.getOrganization_code();
			if(StringUtils.isNotEmpty(organizationCode) && ConstProp.DIGIT_ONE.equals(roleSubjectVo.getId_type())){
				organizationCode = organizationCode.split(ConstProp.MINUS)[0]+organizationCode.split(ConstProp.MINUS)[1];
			}
			json.put("transactionNo",dto.getTrade_serial_number());//[非空]开票流水号，长度限制32位，要求唯一
			json.put("invoiceCreater",PARTNERCODE); // [非空]开票人，不可以超过15个字符

			if(vo.getMailPolicyVo() != null&&StringUtils.isNotEmpty(vo.getMailPolicyVo().getReceipt_head())){
				json.put("invoiceEmail",roleSubjectVo.getLink_email());// [可空]电子发票接收邮箱
				json.put("invoicePhone",vo.getMailPolicyVo().getTaker_mobile());//[可空]电子发票接收联系电话
				json.put("invoiceOwner",vo.getMailPolicyVo().getReceipt_head());//[可空]发票抬头
				json.put("taxPayerNO",vo.getMailPolicyVo().getTaxpayer_number_invoice());//[非空]发票纳税人编号，要求15、17、18或20位
			}else{
				json.put("invoiceEmail",roleSubjectVo.getLink_email());// [可空]电子发票接收邮箱
				json.put("invoicePhone",roleSubjectVo.getLink_tel());//[可空]电子发票接收联系电话
				json.put("invoiceOwner",roleSubjectVo.getName_cn());//[可空]发票抬头
				json.put("taxPayerNO",organizationCode);//[非空]发票纳税人编号，要求15、17、18或20位
			}
			if(vo.getMailPolicyVo() != null&&ConstProp.DIGIT_ONE.equals(vo.getMailPolicyVo().getNeed_receipt())){
				json.put("taxPayerTel",vo.getMailPolicyVo().getTaker_mobile());//[可空]发票纳税人电话
				json.put("taxPayerAddress",vo.getMailPolicyVo().getRegister_address_invoice());//[可空]发票纳税人地址
				json.put("taxPayerBankName",vo.getMailPolicyVo().getBank_invoice());//[可空]发票纳税人银行
				json.put("taxPayerBankAccount",vo.getMailPolicyVo().getBank_account_invoice());// [可空]发票纳税人帐户
			}
			JSONObject policyInfo = new JSONObject();
			policyInfo.put("policyNo",dto.getExternal_reference()); //[非空]保单号
			policyInfo.put("personnelName",roleSubjectVo.getName_cn()); //[非空]投保人名称
			policyInfo.put("certificateType",idTypeSet(roleSubjectVo.getId_type())); //[非空]证件类型
			policyInfo.put("certificateNo",organizationCode); //[非空]证件号码 (最长20字节)
			policyArray.add(policyInfo);
		}

		json.put("policyList",policyArray);
	}

	//人标的列表,批改被保人，修改被保人时必传
	private static void doRiskPersonList(InsPreservationRecordVo vo, OrderFormVo dto,JSONArray arr){
		JSONObject riskPerson;
		String type;
		for(InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()){
			riskPerson = new JSONObject();
			type = conventPType(vo.getRevise_type());
			riskPerson.put("status",type);// [非空]状态（A-增加，U-更新，D-删除，C-更换）,修改被保人填U，批增填A，批减填D，更换被保人填C(修改被保人不能同时更改被保人姓名和证件号码、更换被保人必须同时更改被保人姓名和证件号码)
			riskPerson.put("fullName",ipdVo.getName());//[非空]新雇员姓名
			riskPerson.put("certificateNo",ipdVo.getId_card());// [非空]证件号码
			riskPerson.put("certificateType",getCard(ipdVo.getId_type())); //[选择性非空]status为D可空,证件类型，见附录1
			riskPerson.put("professionType",getCareerClass(ipdVo.getCareer()));//新工种属性
			riskPerson.put("position",getCareerName(ipdVo.getCareer()));//新岗位名称
			if("U".equals(type)&&ipdVo.getBusiness_vo()!=null){
				riskPerson.put("oldFullName",ipdVo.getBusiness_vo().getName());//原雇员姓名
				riskPerson.put("oldCertificateType",getCard(ipdVo.getBusiness_vo().getId_type()));//原证件类型
				riskPerson.put("oldCertificateNo",ipdVo.getBusiness_vo().getId_card());//[选择性非空]原被保人证件号码，status为U或C时非空
				riskPerson.put("oldProfessionType",getCareerClass(ipdVo.getBusiness_vo().getCareer()));//原工种属性
				riskPerson.put("oldPosition",getCareerName(ipdVo.getBusiness_vo().getCareer()));//原岗位名称
			}
			if("D".equals(type)){
				riskPerson.put("oldFullName",ipdVo.getName());//原雇员姓名
				riskPerson.put("oldCertificateType",getCard(ipdVo.getId_type()));//原证件类型
				riskPerson.put("oldCertificateNo",ipdVo.getId_card());//[选择性非空]原被保人证件号码，status为U或C时非空
				riskPerson.put("oldProfessionType",getCareerClass(ipdVo.getCareer()));//原工种属性
				riskPerson.put("oldPosition",getCareerName(ipdVo.getCareer()));//原岗位名称
			}
			arr.add(riskPerson);
		}

	}

	private static String conventPType(String revise_type){
		String rt = ConstProp.BLANK_CHAR;
		if(ConstProp.DIGIT_ONE.equals(revise_type)){//增员
			rt = "A";
		}else if(ConstProp.DIGIT_TWO.equals(revise_type)){//减员
			rt = "D";
		}else if(ConstProp.DIGIT_THREE.equals(revise_type)){//替换
			rt = "U";
		}
		return rt;
	}

	private static String getCareerName(String career){
		String name = ConstProp.BLANK_CHAR;
		if(ConstProp.DIGIT_ONE.equals(career)){//内勤人员
			name = "内勤人员";
		}else if(ConstProp.DIGIT_TWO.equals(career)){//保安人员
			name = "保安人员";
		}else if(ConstProp.DIGIT_FOUR.equals(career)){//保洁人员
			name = "保洁人员";
		}
		return name;
	}

	private static String getCareerClass(String career){
		String cla = ConstProp.BLANK_CHAR;
		if(ConstProp.DIGIT_ONE.equals(career)){//内勤人员
			cla = "52";
		}else if(ConstProp.DIGIT_TWO.equals(career)){//保安人员
			cla = "53";
		}else if(ConstProp.DIGIT_FOUR.equals(career)){//保洁人员
			cla = "51";
		}/*else if(ConstProp.DIGIT_THREE.equals(career)){//武装押运人员
			cla = "56";
		}*/
		return cla;
	}

	//地址基本信息 riskGroupInfoList
	private static void doRiskGroupInfo(SpecialHirelingVo gvo, OrderFormVo dto,JSONArray arr){
		JSONObject riskPropertyInfoList = new JSONObject();
		JSONArray riskPropertyInfoArray = new JSONArray();
		JSONObject riskPropertyInfoMap = new JSONObject();
		Map map = Maps.newHashMap();
		//1 liabilityExtend Object
		JSONObject liabilityExtend = new JSONObject();
		liabilityExtend.put("isRegistered","1");//是否记名投保 0:否 1:是
		liabilityExtend.put("isInductrialInjury","0");//是否投保工伤 0:否 1:是
		map.put("liabilityExtend",liabilityExtend);
		//2 personnelList List
		//雇员信息列表
		JSONArray personnelList = new JSONArray();
		JSONObject personnel;
		List<HirelingVo> hirelingList = gvo.getHirelingVoList();
		for(HirelingVo vo : hirelingList) {
			personnel = new JSONObject();
			personnel.put("fullName",vo.getName());//[非空]姓名
			personnel.put("certificateNo",vo.getId_card()); // [非空]证件号码 如果是身份证 那么出生日期及年龄,性别联动
			personnel.put("certificateType",getCard(vo.getId_type()));// [非空]证件类型，见附录1
			personnel.put("professionType",getCareerClass(vo.getCareer()));//职业类别
			personnel.put("position",getCareerName(vo.getCareer())); // 岗位名称
			personnelList.add(personnel);
		}
		map.put("personnelList",personnelList);
		//3 riskEmployeeList List
		JSONArray riskEmployeeList = new JSONArray();
		JSONObject riskEmployee = new JSONObject();
		riskEmployee.put("deathLimitAmount",getPlanAmount("deathLimitAmount",dto.getProduct_code()));//每人死亡赔偿限额
		riskEmployee.put("maimLimitAmount",getPlanAmount("maimLimitAmount",dto.getProduct_code()));//每人伤残赔偿限额
		riskEmployee.put("medicalLimitAmount",getPlanAmount("medicalLimitAmount",dto.getProduct_code()));//每人医疗费用赔偿限额
		riskEmployeeList.add(riskEmployee);
		map.put("riskEmployeeList",riskEmployeeList);
		riskPropertyInfoMap.put("riskPropertyMap",map);
		riskPropertyInfoArray.add(riskPropertyInfoMap);
		riskPropertyInfoList.put("riskPropertyInfoList",riskPropertyInfoArray);
		arr.add(riskPropertyInfoList);
	}

	//根据职业编码获取平安财职业代码
	private static String getProfessionCode(String major_group){
		if(!GlobalResources.IS_TEST_ENVI){//生成
			return "3".equals(major_group) ? "N010404" : "N010401";
		}else{//测试
			return "3".equals(major_group) ? "0201002" : "0201002";
		}
	}

	/**
	 * 根据我们的证件类型获取平安的证件类型
	 * @param cardType
	 * @return
	 */
	private static String getCard(String cardType){
		/*
		01	身份证 ,如果身份证中有字母x,必须为大写
		02	护照
		03	军人证
		06	港澳回乡证或台胞证
		*/
		if ( "0".equals(cardType) ) {
			return "01";
		}else if ("3".equals(cardType)) {
			return "02";
		}else if ("4".equals(cardType)) {
			return "06";
		}else {
			return "";
		}
	}

	//根据产品id获取对应产品代码
	private static String getPlanCode(String product_code){
		if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-1".equals(product_code)){
			return "MP07110001";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-2".equals(product_code)){
			return "MP07110002";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-3".equals(product_code)){
			return "MP07110003";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-4".equals(product_code)){
			return "MP07110004";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-5".equals(product_code)){
			return "MP07110005";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-6".equals(product_code)){
			return "MP07110006";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-7".equals(product_code)){
			return "MP07110007";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-8".equals(product_code)){
			return "MP07110008";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-9".equals(product_code)){
			return "MP07110009";
		}else{
			return "";
		}
	}

	private static String getSchemeName(String product_code){
		if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-1".equals(product_code)){
			return "计划一";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-2".equals(product_code)){
			return "计划二";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-3".equals(product_code)){
			return "计划三";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-4".equals(product_code)){
			return "计划四";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-5".equals(product_code)){
			return "计划五";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-6".equals(product_code)){
			return "计划六";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-7".equals(product_code)){
			return "计划七";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-8".equals(product_code)){
			return "计划八";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-9".equals(product_code)){
			return "计划九";
		}else{
			return "";
		}
	}

	private static String getPlanAmount(String name,String product_code){
		String planAmount = "";
		if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-1".equals(product_code)){
			planAmount = "deathLimitAmount".equals(name)?"300000"
					:"maimLimitAmount".equals(name)?"300000"
					:"medicalLimitAmount".equals(name)?"30000"
					:"";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-2".equals(product_code)){
			planAmount = "deathLimitAmount".equals(name)?"400000"
					:"maimLimitAmount".equals(name)?"400000"
					:"medicalLimitAmount".equals(name)?"40000"
					:"";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-3".equals(product_code)){
			planAmount = "deathLimitAmount".equals(name)?"500000"
					:"maimLimitAmount".equals(name)?"500000"
					:"medicalLimitAmount".equals(name)?"50000"
					:"";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-4".equals(product_code)){
			planAmount = "deathLimitAmount".equals(name)?"600000"
					:"maimLimitAmount".equals(name)?"600000"
					:"medicalLimitAmount".equals(name)?"60000"
					:"";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-5".equals(product_code)){
			planAmount = "deathLimitAmount".equals(name)?"700000"
					:"maimLimitAmount".equals(name)?"700000"
					:"medicalLimitAmount".equals(name)?"70000"
					:"";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-6".equals(product_code)){
			planAmount = "deathLimitAmount".equals(name)?"800000"
					:"maimLimitAmount".equals(name)?"800000"
					:"medicalLimitAmount".equals(name)?"80000"
					:"";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-7".equals(product_code)){
			planAmount = "deathLimitAmount".equals(name)?"900000"
					:"maimLimitAmount".equals(name)?"900000"
					:"medicalLimitAmount".equals(name)?"90000"
					:"";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-8".equals(product_code)){
			planAmount = "deathLimitAmount".equals(name)?"1000000"
					:"maimLimitAmount".equals(name)?"1000000"
					:"medicalLimitAmount".equals(name)?"100000"
					:"";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-9".equals(product_code)){
			planAmount = "deathLimitAmount".equals(name)?"1200000"
					:"maimLimitAmount".equals(name)?"1200000"
					:"medicalLimitAmount".equals(name)?"120000"
					:"";
		}
		return planAmount;
	}

	/*
	* 询价单标识
	*/
	private static String getQuoteMark(String product_code){
		if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-1".equals(product_code)){
			return "quotation1";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-2".equals(product_code)){
			return "quotation1";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-3".equals(product_code)){
			return "quotation1";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-4".equals(product_code)){
			return "quotation1";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-5".equals(product_code)){
			return "quotation1";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-6".equals(product_code)){
			return "quotation2";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-7".equals(product_code)){
			return "quotation2";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-8".equals(product_code)){
			return "quotation2";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-9".equals(product_code)){
			return "quotation2";
		}else{
			return "";
		}
	}

	/*
	* 询价单标识1
	*/
	private static String getQuoteMark1(String product_code){
		if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-1".equals(product_code)){
			return "quotation3";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-2".equals(product_code)){
			return "quotation3";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-3".equals(product_code)){
			return "quotation3";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-4".equals(product_code)){
			return "quotation3";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-5".equals(product_code)){
			return "quotation3";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-6".equals(product_code)){
			return "quotation4";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-7".equals(product_code)){
			return "quotation4";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-8".equals(product_code)){
			return "quotation4";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-9".equals(product_code)){
			return "quotation4";
		}else{
			return "";
		}
	}

	/*
	* 询价单标识2
	*/
	private static String getQuoteMark2(String product_code){
		if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-1".equals(product_code)){
			return "quotation5";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-2".equals(product_code)){
			return "quotation5";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-3".equals(product_code)){
			return "quotation5";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-4".equals(product_code)){
			return "quotation5";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-5".equals(product_code)){
			return "quotation5";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-6".equals(product_code)){
			return "quotation6";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-7".equals(product_code)){
			return "quotation6";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-8".equals(product_code)){
			return "quotation6";
		}else if(StringUtils.isEmpty(product_code) ? false : "GZZRX-PAC-9".equals(product_code)){
			return "quotation6";
		}else{
			return "";
		}
	}

	//投保人信息  applicantInfo
	private static void doApplicantInfo(SpecialHirelingVo vo, OrderFormVo dto,JSONObject json){

		for(RoleSubjectVo roleSubjectVo : vo.getRoleSubjectList()){
			if(!"1".equals(roleSubjectVo.getKind())){
				continue;
			}
			String organizationCode = roleSubjectVo.getOrganization_code();
			if(StringUtils.isNotEmpty(organizationCode) && ConstProp.DIGIT_ONE.equals(roleSubjectVo.getId_type())){
				organizationCode = organizationCode.split(ConstProp.MINUS)[0]+organizationCode.split(ConstProp.MINUS)[1];
			}
			json.put("name",roleSubjectVo.getName_cn().replace("（","(").replace("）",")"));//公司名称 否
			json.put("personnelType","0");//个团标志（1个人，0团体）
			json.put("certificateType",idTypeSet(roleSubjectVo.getId_type()));//证件类型
			json.put("certificateNo",organizationCode);//证件号码
			json.put("linkManName",roleSubjectVo.getLink_name());//联系人名称
			String address = RegionUtils.getRegionNameByALLCode(roleSubjectVo.getReg_province(),roleSubjectVo.getReg_city(),roleSubjectVo.getReg_district())+roleSubjectVo.getReg_address();
			json.put("address",address);//地址
			json.put("mobileTelephone",roleSubjectVo.getLink_tel());//联系人手机
			json.put("email",roleSubjectVo.getLink_email());//联系人邮箱
			//需要发票
			if(vo.getMailPolicyVo() != null&&ConstProp.DIGIT_ONE.equals(vo.getMailPolicyVo().getNeed_receipt())){
				json.put("invoicePrintType",ConstProp.DIGIT_ZERO.equals(vo.getMailPolicyVo().getInvoice_type()) ? "01" : "02");// 发票打印类型, 普通增值税发票(01)打印专用增值税发票(02)增值税电子普通发票(05)无需打印(03)
				json.put("billingAddress",vo.getMailPolicyVo().getRegister_address_invoice());//开票地址
				json.put("billingPhone",vo.getMailPolicyVo().getTaker_mobile());//开票电话
				json.put("billingDepositBank",vo.getMailPolicyVo().getBank_invoice());//开票开户银行
				json.put("billingDepositBankAccount",vo.getMailPolicyVo().getBank_account_invoice());//开票开户银行账户
				json.put("taxpayerCertificateType","02");//纳税人证件类型
				json.put("taxpayerCertificateNo",vo.getMailPolicyVo().getTaxpayer_number_invoice());//纳税人证件号码
			}else{
				json.put("invoicePrintType","03");//无需打印(03)
			}
		}
	}

	//被保险人信息  insurantInfo
	private static void doInsurantInfo(SpecialHirelingVo vo, OrderFormVo dto,JSONObject json){
		for(RoleSubjectVo roleSubjectVo : vo.getRoleSubjectList()){
			if(!"2".equals(roleSubjectVo.getKind())){
				continue;
			}
			String organizationCode = roleSubjectVo.getOrganization_code();
			if(StringUtils.isNotEmpty(organizationCode) && ConstProp.DIGIT_ONE.equals(roleSubjectVo.getId_type())){
				organizationCode = organizationCode.split(ConstProp.MINUS)[0]+organizationCode.split(ConstProp.MINUS)[1];
			}
			json.put("name",roleSubjectVo.getName_cn().replace("（","(").replace("）",")"));//公司名称 否
			json.put("personnelType","0");//个团标志（1个人，0团体）
			json.put("certificateType",idTypeSet(roleSubjectVo.getId_type()));//证件类型
			json.put("certificateNo",organizationCode);//证件号码
			json.put("linkManName",roleSubjectVo.getLink_name());//联系人名称
			String address = RegionUtils.getRegionNameByALLCode(roleSubjectVo.getReg_province(),roleSubjectVo.getReg_city(),roleSubjectVo.getReg_district())+roleSubjectVo.getReg_address();
			json.put("address",address);//地址
			json.put("mobileTelephone",roleSubjectVo.getLink_tel());//联系人手机
			json.put("email",roleSubjectVo.getLink_email());//联系人邮箱
		}
	}

	//受益人信息  doBeneficaryInfo
	private static void doBeneficaryInfo(SpecialHirelingVo vo, OrderFormVo dto,JSONObject json){
		for(RoleSubjectVo roleSubjectVo : vo.getRoleSubjectList()){
			if(!"2".equals(roleSubjectVo.getKind())){
				continue;
			}
			String organizationCode = roleSubjectVo.getOrganization_code();
			if(StringUtils.isNotEmpty(organizationCode) && ConstProp.DIGIT_ONE.equals(roleSubjectVo.getId_type())){
				organizationCode = organizationCode.split(ConstProp.MINUS)[0]+organizationCode.split(ConstProp.MINUS)[1];
			}
			json.put("name",roleSubjectVo.getName_cn().replace("（","(").replace("）",")"));//公司名称 否
			json.put("personnelType","0");//个团标志（1个人，0团体）
			json.put("certificateType",idTypeSet(roleSubjectVo.getId_type()));//证件类型
			json.put("certificateNo",organizationCode);//证件号码
			json.put("linkManName",roleSubjectVo.getLink_name());//联系人名称
			String address = RegionUtils.getRegionNameByALLCode(roleSubjectVo.getReg_province(),roleSubjectVo.getReg_city(),roleSubjectVo.getReg_district())+roleSubjectVo.getReg_address();
			json.put("address",address);//地址
			json.put("mobileTelephone",roleSubjectVo.getLink_tel());//联系人手机
			json.put("email",roleSubjectVo.getLink_email());//联系人邮箱
		}
	}

	private static String idTypeSet(String value){
		if ("1".equals(value)) {//组装机构代码
			return "01";
		}else if ("2".equals(value)) {//三证合一统一信用代码
			return "03";
		}else if ("6".equals(value)) {//税务登记证
			return "02";
		}else if ("7".equals(value)) {//营业执照
			return "04";
		}
		return "";
	}

	/**
	 *	接口返回字符串解析
	 * @return
	 */
	public static String returnAnalysisJson(String json, String  transType){
		if(TransTypeEnum.DZFP.getValue().equals(transType)) {//获取电子发票文件流   返回值
			Map map  = JSON.parseObject(json,Map.class);
			if(!ConstProp.DIGIT_ZERO.equals(map.get("ret"))){
				return "300#（APP-PAC-"+map.get("ret")+"）"+map.get("msg");
			}
			List<Map> list = JSONArray.parseArray(map.get("data").toString(),Map.class);
			if(list.size()<=0){
				return "300#（APP-PAC-003）电子发票信息获取异常！";
			}
			Map m = list.get(0);
			if(!"999999".equals(m.get("responseCode").toString())){
				return "300#（APP-PAC-"+m.get("responseCode")+"）"+m.get("responseMsg");
			}
			String filePath = uploadFile(String.valueOf(m.get("invoiceValue")), "pdf","/policy/");
			if(StringUtils.isNotEmpty(filePath)){
				return "200#"+filePath;
			}else{
				return "300#（APP-PAC-002）电子发票打印文件流解析失败！";
			}
		}
		JSONObject jsonHead = JSONObject.fromObject(json);
		if( jsonHead == null ){
			return "300#（APP-PAC-001）未获取到返回数据！";
		}
		if(!ConstProp.DIGIT_ZERO.equals(jsonHead.get("ret"))){
			return "300#（APP-PAC-"+jsonHead.get("ret")+"）"+jsonHead.get("msg");
		}
		JSONObject jsonDate = JSONObject.fromObject(jsonHead.get("data"));
		JSONObject resultJson = JSONObject.fromObject(jsonDate.get("result"));
		if(TransTypeEnum.HB.getValue().equals(transType)) {//核保
			if("999999".equals(jsonDate.get("responseCode"))){
				//200#投保单号#保单号#保费#保额#通知单号
				return "200#"+resultJson.get("applyPolicyNo")+ConstProp.POUND_SIGN+resultJson.get("policyNo")+ConstProp.POUND_SIGN+resultJson.get("totalActualPremium")+ConstProp.POUND_SIGN+resultJson.get("totalInsuredAmount")+ConstProp.POUND_SIGN+resultJson.get("noticeNo");
			}else{
				return "300#（APP-PAC-"+jsonDate.get("responseCode")+"）"+jsonDate.get("responseMsg");
			}
		}else if(TransTypeEnum.CBXX.getValue().equals(transType)) {//承保   返回值888888
			if("999999".equals(jsonDate.get("responseCode")) || "888888".equals(jsonDate.get("responseCode"))){
				//200#保单号#投保单号#保费
				return "200#"+resultJson.get("policyNo")+ConstProp.POUND_SIGN+resultJson.get("applyPolicyNo")+ConstProp.POUND_SIGN+resultJson.get("totalActualPremium");
			}else{
				return "300#（APP-PAC-"+jsonDate.get("responseCode")+"）"+jsonDate.get("responseMsg");
			}
		}else if(TransTypeEnum.DZBD.getValue().equals(transType)) {//获取电子保单文件流   返回值
			if(!"999999".equals(jsonDate.get("responseCode"))){
				return "300#（APP-PAC-"+jsonDate.get("responseCode")+"）"+jsonDate.get("responseMsg");
			}
			String filePath = uploadFile(String.valueOf(jsonDate.get("returnPdfValue")), "pdf","/policy/");
			if(StringUtils.isNotEmpty(filePath)){
				return "200#"+filePath;
			}else{
				return "300#（APP-PAC-002）电子保单打印文件流解析失败！";
			}
		}else if(TransTypeEnum.DZPD.getValue().equals(transType)) {//获取电子批单文件流   返回值
			if(!"999999".equals(jsonDate.get("responseCode"))){
				return "300#（APP-PAC-"+jsonDate.get("responseCode")+"）"+jsonDate.get("responseMsg");
			}
			String filePath = uploadFile(String.valueOf(jsonDate.get("returnPdfValue")), "pdf","/policy/");
			if(StringUtils.isNotEmpty(filePath)){
				return "200#"+filePath;
			}else{
				return "300#（APP-PAC-002）电子批单打印文件流解析失败！";
			}
		}else if(TransTypeEnum.ZFDZ.getValue().equals(transType)) {//支付接口返回
			if("SUCCESS".equals(jsonDate.get("resultCode"))){
				return "200#"+jsonDate.get("tradeNo")+ConstProp.POUND_SIGN+jsonDate.get("payUrl");
			}else{
				return "300#（APP-PAC-"+jsonDate.get("resultCode")+"）"+jsonDate.get("resultMsg");
			}
		}else if(TransTypeEnum.PD.getValue().equals(transType)) {//保单批改
			if("9999".equals(jsonDate.get("responseCode"))){
				//200#保单号#批单号#保费#批单申请号
				return "200#"+resultJson.get("policyNo")+ConstProp.POUND_SIGN+resultJson.get("endorseNo")+ConstProp.POUND_SIGN+resultJson.get("actualPremiumChange")+ConstProp.POUND_SIGN+resultJson.get("endorseApplyNo");
			}else{
				return "300#（APP-PAC-"+jsonDate.get("responseCode")+"）"+jsonDate.get("responseMsg");
			}
		}
		return "300#（APP-PAC-001.1）数据处理失败！";
	}

	/**
	 *	理赔接口返回字符串解析
	 * @return
	 */
	public static String returnAnalysisJson_LP(String json, String  transType){
		JSONObject jsonHead = JSONObject.fromObject(json);
		if( jsonHead == null ){
			return "300#（APP-PAC-001）未获取到返回数据！";
		}
		if(!ConstProp.DIGIT_ZERO.equals(jsonHead.get("ret"))){
			return "300#（APP-PAC-"+jsonHead.get("ret")+"）"+jsonHead.get("msg");
		}
		JSONObject jsonData1 = JSONObject.fromObject(jsonHead.get("data").toString());
		if(TransTypeEnum.CLSC.getValue().equals(transType)) {
			if("888".equals(jsonData1.get("code").toString())){
				return "200#"+jsonData1.get("msg");
			}else{
				return "300#"+jsonData1.get("msg");
			}
		}
		JSONObject jsonResult = JSONObject.fromObject(jsonData1.get("result").toString());
		if(!"Y".equals(jsonResult.get("resultCode"))){
			return "300#"+jsonResult.get("resultMessage");
		}
		if(TransTypeEnum.BASL.getValue().equals(transType)) {
			JSONObject jsonData = JSONObject.fromObject(jsonData1.get("data").toString());
			//200#报案号#通号#报案时间
			return "200#"+jsonData.get("reportNo")+ConstProp.POUND_SIGN+jsonData.get("channelCode")+ConstProp.POUND_SIGN+jsonData.get("reportDate");
		}else if(TransTypeEnum.AJCX.getValue().equals(transType)) {
			//data包含：报案失败案件信息、报案成功案件信息、支付项目信息、案件进展与计划信息
			String data=jsonData1.get("data").toString();
			return "200#"+data;
		}else if(TransTypeEnum.XXAJCX.getValue().equals(transType)) {
			JSONObject jsonData = JSONObject.fromObject(jsonData1.get("data").toString());
			String total=jsonData.get("total")== null?"0":jsonData.get("total").toString();
			String pageCount=jsonData.get("pageCount")== null?"0":jsonData.get("pageCount").toString();
			String data=jsonData.get("reportInfos").toString();
			//200#总记录数#总页数#List<Map>
			return "200#"+total+ConstProp.POUND_SIGN+pageCount+ConstProp.POUND_SIGN+data;
		}else{
			return "200#"+jsonResult.get("resultMessage");
		}
	}

	public static void main(String[] args) {
//		String a = "{\"ret\":\"0\",\"msg\":\"\",\"requestId\":\"null\",\"data\":{\"result\":{\"resultCode\":\"Y\",\"resultMessage\":\"查询信息成功\"},\"data\":{\"caseInfoList\":[{\"accidentCauseLevel2\":\"N0250\",\"accidentCauseLevel3\":\"\",\"caseStatus\":\"0\",\"withdrawReason\":\"\",\"caseScheduleList\":[],\"policyNo\":\"10162003900158627229\",\"remark\":\"\",\"accidentPlace\":\"思明区嘉禾路124号\",\"claimPhone\":\"15960004680\",\"reporterName\":\"还好\",\"caseStatus2\":\"赔款已到账\",\"productName\":\"雇主责任险A版\",\"accidentProvince\":\"福建省\",\"accidentCauseLevel1\":\"A01\",\"accidentCauseLevelName3\":\"\",\"injuryNameList\":[{\"demiseList\":[],\"outpatientList\":[],\"maimList\":[\"还好\"]}],\"caseStatus1\":\"待归档\",\"accidentCauseLevelName1\":\"意外伤害事故\",\"accidentCauseLevelName2\":\"上下班途中\",\"reportDate\":\"2019-11-26 10:45\",\"accidentProcess\":\"被撞了\",\"caseTimes\":\"1\",\"accidentDistrict\":\"\",\"isSelfCase\":\"Y\",\"paymentItemList\":[{\"clientBankAccount\":\"***************8815\",\"clientBankName\":\"v菲达环保\",\"payDate\":\"2019-11-26 17:45:51\"}],\"insuredName\":\"百川信（厦门）网络信息服务有限公司\",\"reportNo\":\"90162004100002020655\",\"indemnityConclusion\":\"1\",\"accidentCity\":\"厦门市\",\"accidentDate\":\"2019-11-26 10:11\",\"claimName\":\"闵锐\",\"orderNo\":\"\",\"endCaseDate\":\"2019-11-26 17:26\",\"caseNo\":\"40162004100003464887\",\"userId\":\"BCX00001\",\"endCaseAmountSum\":\"600\",\"productCode\":\"MP07110009\",\"currencyCode\":\"01\"}],\"details\":[]}}}";
//		String b = returnAnalysisJson_LP(a, TransTypeEnum.AJCX.getValue());
		String n = "百川信（北京）信息服务有限公司";
		System.out.println(n.replace("（","(").replace("）",")"));
	}

	/**
	 * 文件上传并返回下载地址
	 * @param fileStr 字符串文件流
	 * @param savePath 文件要保存的文件夹地址（/zzx-pac/）
	 * @return /getResource?path=/policy/1231231.jpg
	 */
	public static String uploadFile(String fileStr, String fileType, String savePath){
		String result = "";
		if (StringUtils.isEmpty(fileStr)) {
			return result;
		}
		try {
			if(StringUtils.isEmpty(fileType)){
				fileType = "pdf";
			}
			byte[] bytes = BASE64Util.decryptBASE64Byte(fileStr);
			String files = DateUtil.generatorRadomNumber() + ConstProp.DOT +fileType;
			result = savePath + files;
			String path = GlobalResources.COM_IMG_RE+savePath;
			FileHelp.byteFile(bytes, path, files);
			result = "/getResource?path="+result;
		} catch (Exception e) {
			e.printStackTrace();
			result = "";
		}
		return result;
	}

}
